<?php
/**
* @author Andrey Kvasnenskiy, http://www.ordasoft.com
* @email akbet@ordasoft.com
* @version $Id: com_docman.php 83 2009-05-31 root $
* @package Xmap
* @license GNU/GPL
* @description Xmap plugin for Docman component
*/

defined( '_VALID_MOS' ) or defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/** Adds support for Docman categories to Xmap */
class xmap_com_docman {
 

  function isOfType( &$xmap, &$parent ) {
    if( strpos($parent->link, 'option=com_docman') ) {
      return true;
    }
    return false;
  }



  /** Get the content tree for this kind of content */
  function &getTree( &$xmap, &$parent, &$params ) {

    if (defined('JPATH_SITE')) {
      $database = &JFactory::getDBO();
      $mosConfig_absolute_path = JPATH_SITE;
    } else {
      global $database,$mosConfig_absolute_path;
    }

    $tree = array();

    $menu =& JSite::getMenu();
    $doc_params = $menu->getParams($parent->id);

    $link_query = parse_url( $parent->link );
    parse_str( html_entity_decode($link_query['query']), $link_vars);
    $catid = intval(xmap_com_docman::getParam($link_vars,'gid',0));

    if ( !$catid ) {
      $catid = intval($doc_params->get('category_id',0));
    }

    $include_documents = xmap_com_docman::getParam($params,'include_documents',1);
    $include_documents = ( $include_documents == 1
          || ( $include_documents == 2 && $xmap->view == 'xml') 
          || ( $include_documents == 3 && $xmap->view == 'html'));
    $params['include_documents'] = $include_documents;

    $priority = xmap_com_docman::getParam($params,'cat_priority',$parent->priority);
    $changefreq = xmap_com_docman::getParam($params,'cat_changefreq',$parent->changefreq);
    if ($priority  == '-1')
      $priority = $parent->priority;
    if ($changefreq  == '-1')
      $changefreq = $parent->changefreq;

    $params['cat_priority'] = $priority;
    $params['cat_changefreq'] = $changefreq;

    $priority = xmap_com_docman::getParam($params,'doc_priority',$parent->priority);
    $changefreq = xmap_com_docman::getParam($params,'doc_changefreq',$parent->changefreq);
    if ($priority  == '-1')
      $priority = $parent->priority;
    if ($changefreq  == '-1')
      $changefreq = $parent->changefreq;

    $params['doc_priority'] = $priority;
    $params['doc_changefreq'] = $changefreq;


    $task = xmap_com_docman::getParam($params,'doc_task',$parent->task);
    if ($task == '-1')
      $task = $parent->task;

    $params['doc_task'] = $task;


    //DOCMan core interaction API
    include_once( $mosConfig_absolute_path."/administrator/components/com_docman/docman.class.php");
    global $_DOCMAN;
    if(!is_object($_DOCMAN)) {
        $_DOCMAN = new dmMainFrame();
    }
  
    $_DOCMAN->setType(_DM_TYPE_MODULE);
    $_DOCMAN->loadLanguage('modules');
  
    require_once($_DOCMAN->getPath('classes', 'utils'));
    require_once($_DOCMAN->getPath('classes', 'file'));
    require_once($_DOCMAN->getPath('classes', 'model'));
  

    xmap_com_docman::getCategoryTree($xmap, $parent, $params, $catid);
    return true;
  }

  /** Docman support */
  function &getCategoryTree( &$xmap, &$parent,&$params, $catid=0 ) {

    if (defined('JPATH_SITE')) {
      $database = &JFactory::getDBO();
      $mosConfig_absolute_path = JPATH_SITE;
    } else {
      global $database,$mosConfig_absolute_path;
    }
    $list = array();
    $limits = 25;


    $query  ='select id, title, name, parent_id from #__categories where published = \'1\' and section=\'com_docman\' and access<=\'0\' and parent_id=' .$catid . ' order by parent_id,ordering';
    $database->setQuery( $query );

    $rows = $database->loadRowList();

    $xmap->changeLevel(1);
    // Get sub-categories list
    foreach ($rows as $row) {
      $node = new stdclass;
      $node->id = $parent->id;
      $node->uid = $parent->uid.'d'.$row[0];
      $node->name = $row[1];
      $node->browserNav = $parent->browserNav;
      $node->priority = $params['cat_priority'];
      $node->changefreq = $params['cat_changefreq'];
      $node->link = 'index.php?option=com_docman&task=cat_view&gid='.$row[0];
      if ($xmap->printNode($node) !== FALSE) {
        $node->tree = xmap_com_docman::getCategoryTree( $xmap, $parent, $params, $row[0]);
      }
    }
    $xmap->changeLevel(-1);



    if ( $catid > 0 && $params['include_documents']) {

      $rows = DOCMAN_Docs::getDocsByUserAccess($catid, '', '', $limits);
      $xmap->changeLevel(1);
      // Get documents list
      foreach ($rows as $row) {
  
        $node = new stdclass;

        $node->id = $parent->id;
        $node->uid = $parent->uid.'d'.$row->id;
        $node->link = 'index.php?option=com_docman&amp;task='.$params['doc_task'].'&amp;gid='.$row->id. '&amp;Itemid='.$parent->id;
        $node->name = $row->dmname;
        $node->browserNav = $parent->browserNav;
        $node->priority = $params['doc_priority'];
        $node->changefreq = $params['doc_changefreq'];
        $node->type = 'separator';
        $xmap->printNode($node);
      }
      $xmap->changeLevel(-1);
    }


    return $list;
  }

  function &getParam($arr, $name, $def) {
    if ( defined('JPATH_SITE') ) {
      $var = JArrayHelper::getValue( $arr, $name, $def, '' );
    } else {
      $var = xmap_com_docman::getParam( $arr, $name, $def);
    }
    return $var;
  }
}
