<?php
/**
* @author Andrey Kvasnenskiy, http://www.ordasoft.com
* @email akbet@ordasoft.com
* @version $Id: firboard_plugin.php 83 2009-08-31 root $
* @package Xmap
* @license GNU/GPL
* @description Xmap plugin for FireBoard component
*/


defined( '_VALID_MOS' ) or defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

//  // Register with the Xmap Plugin Manager
//  $tmp = new Xmap_fireboard;
//  XmapPlugins::addPlugin($tmp );

/** Handles FireBoard forum structure */
class xmap_com_fireboard
{



   /** Check if we are responsible for this kind of content */
   function isOfType( &$joomla, &$parent )
   {
      if( ( $parent->type === 'component' || $parent->type === 'components' ) &&  strpos($parent->link, 'option=com_fireboard')){
        return true;
      }
      return false;
   }

  function &getTree( &$xmap, &$parent, &$params ) {
    global $mosConfig_absolute_path;

    $list = array();
    if ( strpos($parent->link, 'task=view') ) {
      return $list;
    }
    
    $link_query = parse_url( $parent->link );
    parse_str( html_entity_decode($link_query['query']), $link_vars );
    $catid = JArrayHelper::getValue($link_vars,'catid',0);


    $include_posts = xmap_com_fireboard::getParam($params,'include_posts',1);
    $include_posts = ( $include_posts == 1
          || ( $include_posts == 2 && $xmap->view == 'xml') 
          || ( $include_posts == 3 && $xmap->view == 'html'));
    $params['include_posts'] = $include_posts;

    $priority = xmap_com_fireboard::getParam($params,'cat_priority',$parent->priority);
    $changefreq = xmap_com_fireboard::getParam($params,'cat_changefreq',$parent->changefreq);
    if ($priority  == '-1')
      $priority = $parent->priority;
    if ($changefreq  == '-1')
      $changefreq = $parent->changefreq;

    $params['cat_priority'] = $priority;
    $params['cat_changefreq'] = $changefreq;

    $priority = xmap_com_fireboard::getParam($params,'post_priority',$parent->priority);
    $changefreq = xmap_com_fireboard::getParam($params,'post_changefreq',$parent->changefreq);
    if ($priority  == '-1')
      $priority = $parent->priority;
    if ($changefreq  == '-1')
      $changefreq = $parent->changefreq;

    $params['post_priority'] = $priority;
    $params['post_changefreq'] = $changefreq;


    $list = xmap_com_fireboard::getCategorieTree ( $xmap, $parent, $params,$catid);
    return $list;
  }


/* Return category/forum tree */
function getCategorieTree( &$xmap, &$parent, $params,$parentCat=0 ) 
{


    if (defined('JPATH_SITE')) {
      $database = &JFactory::getDBO();
      $mosConfig_absolute_path = JPATH_SITE;
      $my = &JFactory::getUser();

    } else {
      global $database,$mosConfig_absolute_path,$my;
    }

  $list = array();
  $query = "SELECT id as cat_id, name as cat_title, ordering FROM #__fb_categories WHERE parent=".$parentCat."
   AND published=1 and pub_access<=".$my->gid." ORDER BY name";
  $database->setQuery($query);
  $cats = $database->loadObjectList();    

    $xmap->changeLevel(1);
    // Get sub-categories list
    foreach ($cats as $cat) {
      $node = new stdclass;
      $node->id = $parent->id;
      $node->uid = $parent->uid.'d'.$cat->cat_id;
      $node->name = $cat->cat_title;
      $node->browserNav = $parent->browserNav;
      $node->parent=1;
      $node->browsNav=1;
      $node->ordering=2;
      $node->priority=$params['cat_priority'];
      $node->chansefreq=$params['cat_changefreq'];
      $node->type='component';
      $node->link = $parent->link.'&amp;func=showcat&amp;catid='.$cat->cat_id;;
      if ($xmap->printNode($node) !== FALSE) {
        $node->tree = xmap_com_fireboard::getCategorieTree($xmap,$parent,$params,$cat->cat_id);
      }
    }
    $xmap->changeLevel(-1);  


   if ( $parentCat > 0 && $params['include_posts']  ) {

      $xmap->changeLevel(1);

      $querymsg = "SELECT id as forum_id, catid as cat_id, subject as forum_name, time as modified".
        " FROM #__fb_messages WHERE catid=$parentCat and subject NOT LIKE 'Re:%' ORDER BY ordering ";
    
      $database->setQuery($querymsg);
      $rows = $database->loadObjectList();

      foreach ($rows as $row) {
  
        $node = new stdclass;

        $node->id = $parent->id;
        $node->uid = $parent->uid.'d'.$row->forum_id;
        $node->link = $parent->link.'&amp;func=view&amp;id='.$row->forum_id.'&amp;catid='.$row->cat_id;
        $node->name = $row->forum_name;
        $node->browserNav = $parent->browserNav;
        $node->parent=1;
        $node->browsNav=1;
        $node->ordering=2;
        $node->priority=$params['post_priority'];
        $node->chansefreq=$params['post_changefreq'];
        $node->type='component';
        $node->menutype='mainmenu';
        $xmap->printNode($node);
      }
      $xmap->changeLevel(-1);
    }

  return $list;
}

  function &getParam($arr, $name, $def) {
    if ( defined('JPATH_SITE') ) {
      $var = JArrayHelper::getValue( $arr, $name, $def, '' );
    } else {
      $var = xmap_com_docman::getParam( $arr, $name, $def);
    }
    return $var;
  }

} 
