<?php
/**
 * @version 3.x
 * @package Location Map
 * @copyright OrdaSoft
 * @author Sergey Brovko-OrdaSoft(brovinho@mail.ru)
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @description Location map for Joomla 
*/
defined('_JEXEC') or die;

class modOSLocationHelper
{
  public function __construct() {
      if(defined('ABSPATH')){
          $this->init_scripts();
          $this->init_hooks();
      }
  }
  public static function checkJavaScriptIncluded($name) {
      if(class_exists('JFactory', false)){
        $doc = JFactory::getDocument();

        foreach($doc->_scripts as $script_path=>$value){
          if(strpos( $script_path, $name ) !== false ) return true ;
        }
        return false;
      }else{
          return false;
      }
  }

  public static function getLink(&$params)
  {
    $document = JFactory::getDocument();

    foreach ($document->_links as $link => $value)
    {
      $value = Joomla\Utilities\ArrayHelper::toString($value);
      if (strpos($value, 'application/'.$params->get('format').'+xml'))
      {
        return $link;
      }
    }

  }
  
  private function init_scripts() {
      add_action('admin_enqueue_scripts', array($this, 'init_admin_scripts'));
      add_action( 'wp_enqueue_scripts', array($this,'init_openmap_scripts_wp' ));
  }
  public function init_admin_scripts(){
      wp_enqueue_script('jquery', false);
      wp_enqueue_script('local_map', LOCATION_MAP_PLUGIN_URL . 'assets/js/local_map.js');
  
  }


  private function init_hooks(){
      add_action('admin_menu', function(){
                add_menu_page( __('Location Map Settings', 'location_map'), __('Location Map', 'location_map'), 'manage_options', 'location-map', array( $this, 'location_map_settings' ), 'dashicons-admin-site-alt3', 4 );
        } );

        add_action( 'admin_init', array($this, 'location_map_add_settings') );
        add_action( 'init', array($this, 'location_map_widget_block') );
  }
  
    public function location_map_settings(){
        echo '<h1>Location Map Settings</h1>';
        settings_errors();?>
        <form action="options.php" method="post">
            <?php
                settings_fields('location_map_basic_settings');
                do_settings_sections('location_map_settings');
                submit_button();
            ?>
        </form>
        <?php
    }

    public function location_map_add_settings(){
        register_setting('location_map_basic_settings', 'GeoCodingBy');
        register_setting('location_map_basic_settings', 'latitude');
        register_setting('location_map_basic_settings', 'longitude');
        register_setting('location_map_basic_settings', 'zoom');
        register_setting('location_map_basic_settings', 'messag');
        register_setting('location_map_basic_settings', 'is_percentage');
        register_setting('location_map_basic_settings', 'map_width');
        register_setting('location_map_basic_settings', 'map_height');
        register_setting('location_map_basic_settings', 'menu_map');
        register_setting('location_map_basic_settings', 'control_map');
        register_setting('location_map_basic_settings', 'scroll_wheel');
        register_setting('location_map_basic_settings', 'map_api_key');
        register_setting('location_map_basic_settings', 'layout');
        register_setting('location_map_basic_settings', 'map_customize');
        register_setting('location_map_basic_settings', 'map_marker_file');
        register_setting('location_map_basic_settings', 'marker_width');
        register_setting('location_map_basic_settings', 'marker_height');
        register_setting('location_map_basic_settings', 'map_custom_style');
        

        add_settings_section('location_map_basic_section', __('Location Map', 'location_map'), function(){echo '<p>'.__('Location Map plugin for WordPress The advantage of having the maps in a plugin is that you can copy the plugin in the WordPress backend. Thus you can have many different maps with different configurations on your site. You can then load these plugin in your content pages using {loadposition position}.').'</p>';}, 'location_map_settings');

        add_settings_field('GeoCodingBy', __('Use Geo Coding By Google or OpenMap(Open Layer)', 'location_map'), array($this, 'geo_coding_by_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('latitude', __('Map Center - latitude', 'location_map'), array($this, 'latitude_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('longitude', __('Map Center - longitude', 'location_map'), array($this, 'longitude_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('zoom', __('Zoom Level', 'location_map'), array($this, 'zoom_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('messag', __('Coordinates', 'location_map'), array($this, 'messag_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('is_percentage', __('Width of map Pixels or 100%', 'location_map'), array($this, 'is_percentage_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('map_width', __('Width of map', 'location_map'), array($this, 'map_width_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('map_height', __('Height of map (px)', 'location_map'), array($this, 'map_height_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('menu_map', __('Show Map Type Menu (Map-Satellite-Hybrid)', 'location_map'), array($this, 'menu_map_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('control_map', __('Show Map Controls (Up-Down-Left-Right)', 'location_map'), array($this, 'control_map_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('scroll_wheel', __('Map Controls Menu', 'location_map'), array($this, 'scroll_wheel_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('map_api_key', __('Google map key', 'location_map'), array($this, 'map_api_key_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('map_customize', __('Map Customize', 'location_map'), array($this, 'map_customize_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('map_marker_file', __('Select your map marker', 'location_map'), array($this, 'map_marker_file_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('marker_width', __('Width of marker (px)', 'location_map'), array($this, 'marker_width_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('marker_height', __('Height of marker (px)', 'location_map'), array($this, 'marker_height_field'), 'location_map_settings', 'location_map_basic_section');
        add_settings_field('map_custom_style', __('Enter your map style', 'location_map'), array($this, 'map_custom_style_field'), 'location_map_settings', 'location_map_basic_section');
        
    }

    function geo_coding_by_field(){

        $value = get_option('GeoCodingBy');
        
        if($value == 0){
            $checked_0 = 'checked="checked"';
            $checked_1 = '';
        }else{
            $checked_1 = 'checked="checked"';
            $checked_0 = '';
        }


        echo '<input type="radio" class="" name="GeoCodingBy" id="GeoCodingBy" value="0" '.$checked_0.'>';
        echo '<label for="GeoCodingBy0">Google</label>';
        echo '<input type="radio" class="" name="GeoCodingBy" id="GeoCodingBy" value="1" '.$checked_1.'>';
        echo '<label for="GeoCodingBy1">OpenMap (Open Layer)</label>';
        echo '<p class="description">Use Geo Coding By Google or OpenMap(Open Layer)</p>';
    }
    
    function latitude_field(){

        $value = get_option('latitude', '50');

        
        echo '<input type="number" inputmode="numeric" name="latitude" id="latitude" value="'.$value.'" class="form-control regular-text" max="100" step="1" min="0" aria-invalid="false">';
        echo '<p class="description">Center of your location map - latitude</p>';
    }
    
    function longitude_field(){
        $value = get_option('longitude', '36.26');
        echo '<input type="number" inputmode="numeric" name="longitude" id="longitude" value="'.$value.'" class="form-control regular-text" max="100" step="0.01" min="0" aria-invalid="false">';
        echo '<p class="description">Center of your location map - longitude</p>';
    }
    
    function zoom_field(){
        $value = get_option('zoom', '9');
        echo '<input type="number" inputmode="numeric" name="zoom" id="zoom" value="'.$value.'" class="form-control regular-text" max="20" step="1" min="0" aria-invalid="false">';
        echo '<p class="description">Zoom Level for your location map</p>';
    }
    
    function messag_field(){
        $value = get_option('messag', '50; 36.25; Orda Soft');
        echo '<textarea name="messag" id="messag" cols="30" rows="5" class="form-control regular-text" >'.$value.'</textarea>';
        echo '<p class="description">Enter latitude, longitude, text message for the marker on your location map separated by semicolon (HTML code is supported). Each row is a new coordinate. For example: 50; 36.25; Orda Soft.</p>';
    }
    
    function is_percentage_field(){

        $value = get_option('is_percentage', 'pixels');

        if($value === 'pixels'){
            $checked_0 = 'checked="checked"';
            $checked_1 = '';
        }else{
            $checked_1 = 'checked="checked"';
            $checked_0 = '';
        }


        echo '<input type="radio" class="" name="is_percentage" id="is_percentage" value="pixels" '.$checked_0.'>';
        echo '<label for="is_percentagepixels">pixels</label>';
        echo '<input type="radio" class="" name="is_percentage" id="is_percentage" value="percentage" '.$checked_1.'>';
        echo '<label for="is_percentagepercentage">100%</label>';
        echo '<p class="description">Select map width and height in pixels or percentage</p>';
    }
    
    function map_width_field(){
        $value = get_option('map_width', '500');
        echo '<input type="number" inputmode="numeric" name="map_width" id="map_width" value="'.$value.'" class="form-control regular-text" max="2000" step="1" min="0" aria-invalid="false">';
        echo '<p class="description">The width of your location map (in px)</p>';
    }
    
    function map_height_field(){
        $value = get_option('map_height', '250');
        echo '<input type="number" inputmode="numeric" name="map_height" id="map_height" value="'.$value.'" class="form-control regular-text" max="1500" step="1" min="0" aria-invalid="false">';
        echo '<p class="description">The  height of your location map (in px)</p>';
    }
    
    function menu_map_field(){

        $value = get_option('menu_map', 0);

        if($value === 0){
            $checked_0 = 'checked="checked"';
            $checked_1 = '';
        }else{
            $checked_1 = 'checked="checked"';
            $checked_0 = '';
        }


        echo '<input type="radio" class="" name="menu_map" id="menu_map" value="0" '.$checked_0.'>';
        echo '<label for="menu_map0">Hide</label>';
        echo '<input type="radio" class="" name="menu_map" id="menu_map" value="1" '.$checked_1.'>';
        echo '<label for="menu_map1">Show</label>';
        echo '<p class="description">Show Map Type Menu (Map-Satellite-Hybrid)</p>';
    }
    
    function control_map_field(){

        $value = get_option('control_map', 0);

        if($value === 0){
            $checked_0 = 'checked="checked"';
            $checked_1 = '';
        }else{
            $checked_1 = 'checked="checked"';
            $checked_0 = '';
        }


        echo '<input type="radio" class="" name="control_map" id="control_map" value="0" '.$checked_0.'>';
        echo '<label for="control_map0">Hide</label>';
        echo '<input type="radio" class="" name="control_map" id="control_map" value="1" '.$checked_1.'>';
        echo '<label for="control_map1">Show</label>';
        echo '<p class="description">Show Map Controls (Up-Down-Left-Right)</p>';
    }
    
    function scroll_wheel_field(){

        $value = get_option('scroll_wheel', 0);

        if($value === 0){
            $checked_0 = 'checked="checked"';
            $checked_1 = '';
        }else{
            $checked_1 = 'checked="checked"';
            $checked_0 = '';
        }


        echo '<input type="radio" class="" name="scroll_wheel" id="scroll_wheel" value="0" '.$checked_0.'>';
        echo '<label for="scroll_wheel0">Disable</label>';
        echo '<input type="radio" class="" name="scroll_wheel" id="scroll_wheel" value="1" '.$checked_1.'>';
        echo '<label for="scroll_wheel1">Enable</label>';
        echo '<p class="description">Mouse Scroll Wheel</p>';
    }
    
    function map_api_key_field(){
        $value = get_option('map_api_key', '');
        echo '<input type="text" name="map_api_key" id="map_api_key" value="'.$value.'" class="form-control regular-text" aria-invalid="false">';
        echo '<p class="description">For use plugin, you need add google map key</p>';
    }
    
    function map_customize_field(){

        $value = get_option('map_customize', 0);

        if($value === 0){
            $checked_0 = 'checked="checked"';
            $checked_1 = '';
        }else{
            $checked_1 = 'checked="checked"';
            $checked_0 = '';
        }


        echo '<input type="radio" class="" name="map_customize" id="map_customize" value="0" '.$checked_0.'>';
        echo '<label for="map_customize0">Disable</label>';
        echo '<input type="radio" class="" name="map_customize" id="map_customize" value="1" '.$checked_1.'>';
        echo '<label for="map_customize1">Enable</label>';
        echo '<p class="description">Map Customize</p>';
    }
    
    function map_marker_file_field(){
//        echo 'ToDo';
        $value = get_option('map_marker_file', '');
        echo '<input type="text" name="map_marker_file" id="map_marker_file" value="'.$value.'" class="form-control regular-text" aria-invalid="false">';
        echo '<p class="description">URL file. You can load the file into the Media Library, copy the link, and paste the copied value into this field.</p>';
    }
    
    function marker_width_field(){
        $value = get_option('marker_width', '40');
        echo '<input type="number" inputmode="numeric" name="marker_width" id="marker_width" value="'.$value.'" class="form-control regular-text" max="200" step="1" min="0" aria-invalid="false">';
        echo '<p class="description">The width of your map marker (in px)</p>';
    }
    
    function marker_height_field(){
        $value = get_option('marker_width', '40');
        echo '<input type="number" inputmode="numeric" name="marker_height" id="marker_height" value="'.$value.'" class="form-control regular-text" max="200" step="1" min="0" aria-invalid="false">';
        echo '<p class="description">The Height of your map marker (in px)</p>';
    }
    
    function map_custom_style_field(){
        $value = get_option('map_custom_style', '');
        echo '<textarea name="map_custom_style" id="map_custom_style" cols="30" rows="5" class="form-control regular-text" >'.$value.'</textarea>';
        echo '<p class="description">More Info about customize style on <a  target="_blank" href="https://mapstyle.withgoogle.com/"> mapstyle.withgoogle.com </a> and  <a  target="_blank" href="https://snazzymaps.com/"> snazzymaps.com </a> </p>';
    }
    
    public function location_map_widget_block() {
        if(!function_exists('register_block_type')){
            return;
        }
//        echo '111111111111111';
        
        wp_register_script('location-map-block', plugins_url('assets/js/location_map_block.js', __FILE__), array('wp-blocks', 'wp-element', 'wp-editor'));
        
        wp_register_script('open-map', '//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.js');
        wp_register_style('open-map-style', '//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.css');
        wp_register_style('local-open-map', plugins_url('assets/css/open_map_styles.css', __FILE__));
        
        
//        wp_enqueue_script( 'location_map_block' );
        
//        var_dump(register_block_type('location_map_block_2/location_map_block', array('editor_script' => 'location_map_block',
//                                                            'render_callback' => array($this, 'location_map_block_cb'))));
        //perviy parametr dolgen namespace i imya 4erez /
        //tak ge dolgen sodergat tolko bukvy, cifry i znak -
        //$name_matcher = '/^[a-z0-9-]+\/[a-z0-9-]+$/';
        register_block_type('location-map-block/loc-map-block', array('editor_script' => 'location-map-block',
                                                            'script' => 'open-map',
                                                            
                                                            'style' => array('local-open-map', 'open-map-style'),
//                                                            'style' => 'open-map-style',
                                                            'render_callback' => array($this, 'location_map_block_cb')));
    }
    
    public function location_map_block_cb($block_attributes, $content) {
//        $html = '';
//        ob_start();
        require_once LOCATION_MAP_PLUGIN_DIR . 'tmpl/default.php';
//        $html = ob_get_contents();
//        return $html;
    }
    
    public function get_params($params, $param_name, $default=''){
        if($params == ''){
            return get_option($param_name, $default);
        }else{
            return $params->get($param_name, $default);
        }
        
    }
    
    public function init_openmap_scripts($doc){
        //GeoCodingBy OpenMap
        if($doc != ''){
            $doc->addScript("//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.js");
            $doc->addStyleSheet("//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.css");
            $doc->addStyleSheet(JURI::root() . "modules/mod_location_map/assets/css/open_map_styles.css");
            
        }else{
//            wp_enqueue_style('open-map', '//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.css');
//        wp_enqueue_style('local-open-map', LOCATION_MAP_PLUGIN_URL . 'assets/css/open_map_styles.js');
            

        }
        
    }
    
    public function init_openmap_scripts_wp(){
//        var_dump(wp_enqueue_script('open-map', '//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.js'));
//        
//        wp_enqueue_style('open-map', '//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.css');
//        wp_enqueue_style('local-open-map', LOCATION_MAP_PLUGIN_URL . 'assets/css/open_map_styles.js');
    }
}
