<?php

defined('_JEXEC') or die('Restricted access');

/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */

if (version_compare(JVERSION, "1.6.0", "lt")){
    class JElementOwnerMedias extends JElement{
        function fetchElement($name, $value, &$node, $control_name){
            $db = JFactory::getDBO();
            $query = "SELECT u.name AS user, u.id AS id
                      FROM #__users AS u, #__medialibrary AS m 
                      WHERE m.owner_ID=u.id AND published = 1
                      GROUP BY u.name
                      ORDER BY u.name";
            $db->setQuery($query);
            $showowners = $db->loadObjectList();

            return JHTML::_('select.genericlist', $showowners, ''.$control_name.'['.$name.']', 
                'class="inputbox"', 'id', 'user', $value, $control_name.$name);
        }
    }
} else if (version_compare(JVERSION, "1.6.0", "ge")){
    class JFormFieldOwnerMedias extends JFormField{
        protected function getInput(){
            $db = JFactory::getDBO();
            $query = "SELECT u.name AS user, u.id AS id
                      FROM #__users AS u, #__medialibrary AS m
                      WHERE m.owner_ID=u.id AND published = 1
                      GROUP BY u.name
                      ORDER BY u.name";
            $db->setQuery($query);
            $showowners = $db->loadObjectList();

            return JHtml::_('select.genericlist', $showowners, $this->name, 'class="inputbox"', 'id', 
                'user', $this->value, $this->name);
        }
    }
} else {
    class JFormFieldOwnerMedias extends JFormField{
        protected function getInput(){
            $db = JFactory::getDBO();
            $query = "SELECT u.name AS user, u.id AS id
                      FROM #__users AS u, #__medialibrary AS m
                      WHERE m.owner_ID=u.id AND published = 1
                      GROUP BY u.name
                      ORDER BY u.name";
            $db->setQuery($query);
            $showowners = $db->loadObjectList();

            return JHtml::_('select.genericlist', $showowners, $this->name, 'class="inputbox"', 'id', 
                'user', $this->value, $this->name);
        }
    }
}
