<?php
/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
defined('_JEXEC') or die('Restricted access');
if (version_compare(JVERSION, "1.6.0", "lt")) {
    class JElementViewGamelay extends JElement {
        var $_name = 'media';
        function fetchElement($name, $value, &$node, $control_name) {
            $db = JFactory::getDBO();
            $query = "SELECT ml.id as id ,mb.title as title FROM `#__medialibrary` as ml
              left join `#__medialibrary_game` as mb on mb.id = ml.media_id
              where ml.media_type = 'game' and ml.published = '1' and ml.approved = '1' " ;
            $db->setQuery($query);
            $media = $db->loadObjectList();
            return JHTML::_('select.genericlist', $media, '' . $control_name . '[' . $name . ']', 
              'class="inputbox"', 'media', 'title', $value, $control_name . $name);
        }
    }
} else if (version_compare(JVERSION, "1.6.0", "ge")) {
    class JFormFieldViewGamelay extends JFormField {
        protected $type = 'media';
        protected function getInput() {
            $db = JFactory::getDBO();
            // Initialize variables.
            $html = array();
            $attr = '';
            // Initialize some field attributes.
            $attr.= $this->element['class'] ? ' class="' . (string)$this->element['class'] . '"' : '';
            // To avoid user's confusion, readonly="true" should imply disabled="true".
            if ((string)$this->element['readonly'] == 'true' || 
                (string)$this->element['disabled'] == 'true') {
                $attr.= ' disabled="disabled"';
            }
            $attr.= $this->element['size'] ? ' size="' . (int)$this->element['size'] . '"' : '';
            $attr.= $this->multiple ? ' multiple="multiple"' : '';
            // Initialize JavaScript field attributes.
            $attr.= $this->element['onchange'] ? ' onchange="' . 
                (string)$this->element['onchange'] . '"' : '';
            $query = "SELECT ml.id as id ,mb.title as title FROM `#__medialibrary` as ml
              left join `#__medialibrary_game` as mb on mb.id = ml.media_id
              where ml.media_type = 'game' and ml.published = '1' and ml.approved = '1' ";
            $db->setQuery($query);
            $media = $db->loadObjectList();
            $options = array();
            foreach($media as $item) $options[] = JHtml::_('select.option', $item->id, $item->title);
            // Create a read-only list (no name) with a hidden input to store the value.
            if ((string)$this->element['readonly'] == 'true') {
                $html[] = JHtml::_('select.genericlist', $options, '', 
                    trim($attr), 'value', 'text', $this->value, $this->id);
                $html[] = '<input type="hidden" name="' . $this->name . '" value="' . 
                    $this->value . '"/>';
            }
            // Create a regular list.
            else {
                $html[] = JHtml::_('select.genericlist', $options, $this->name, 
                    trim($attr), 'value', 'text', $this->value, $this->id);
            }
            return implode($html);
        }
    }
} else {
    echo "Sanity test. Error version check!";
    exit;
}
