<?php
defined('_JEXEC') or die('Restricted access');

/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */



require_once ($mosConfig_absolute_path."/components/com_medialibrary/medialibrary.class.lend.php");
require_once ($mosConfig_absolute_path."/components/com_medialibrary/medialibrary.class.review.php");


/**
* Book database table class
*/
class mosMedialibrary_music extends JTable {
    /** @var int Primary key */
    var $id=null;
    /** @var int */
    var $music_id=null;
    /** @var int */
    var $asin=null;
    /** @var datetime */
    var $title=null;
    /** @var varchar(200) */
    var $imageURL=null;
    /** @var varchar(250) */
    var $URL=null;
    /** @var int */
    var $rating=null;
    /** @var varchar(200) */
    /** @var varchar(200) */
    var $comment=null;
    /** @var varchar(45)  */
    var $language=null;        //no  amazon.com
    /** @var varchar(45)  */
    var $langDescription=null;
    /** @var varchar(45) */
    var $release_date = null;
    /** @var varchar(250) */
    var $emusicURL = null;        //no  amazon.com
    /** @var varchar(15) */
    var $price = null;
    /** @var priceunit */
    var $priceunit = null;
     /** @var tinyint(3) */
    var $number_of_discs = null;
     /** @var varchar(200) */
    var $label = null;
     /** @var text */
     var $tracklist = null;
     /** @var varchar(50) */
    var $binding = null;

    var $artist = null;

    /**
    * @param database - A database connector object
    */
    function __construct( &$db ) {
  //  $this->mosDBTable( '#__medialibrary', 'id', $db );
    parent::__construct('#__medialibrary_music', 'id', $db);//for 1.6
  }
    // overloaded check function
    function check() {
        global $medialibrary_configuration;


        if(trim( $this->title) == ''){
        $this->_error = _MEDIALIBRARY_LABEL_B_TITLE;
        return false;
        }

        // check for valid name
        if (trim( $this->asin ) == '') {
            $this->_error = _MEDIALIBRARY_LABEL_ISBN;
            return false;
        }

        // check for existing ASIN
        $this->_db->setQuery( "SELECT media_id FROM #__medialibrary "
            . " WHERE media_id='$this->id'");
        $xid = intval( $this->_db->loadResult() );
        if ($xid && $xid != intval( $this->id )) {
            $this->_error = _MEDIALIBRARY_ADMIN_INFOTEXT_JS_EDIT_MEDIAID;
            return false;

        }

        if($medialibrary_configuration['editmedia']['check']['isbn_asin'] == '1'){
            $this->_db->setQuery( "SELECT id FROM #__medialibrary_music "
                . "\nWHERE asin ='$this->asin'");
            $xid = intval( $this->_db->loadResult() );
            if ($xid && $xid != intval( $this->id )) {
                $this->_error = _MEDIALIBRARY_ADMIN_INFOTEXT_JS_EDIT_ISBN_ASIN;
                return false;
            }

        }
    $this->price=floatval(preg_replace('/[\s,]/','',$this->price));
        return true;
    }

    function toXML3($xmlDoc ){

        //create and append name element
        $retVal = $xmlDoc->createElement("music");

        $music_id = $xmlDoc->createElement("music_id");
        $music_id->appendChild($xmlDoc->createTextNode($this->music_id));
        $retVal->appendChild( $music_id);

        $asin = $xmlDoc->createElement("asin");
        $asin->appendChild($xmlDoc->createTextNode($this->asin));
        $retVal->appendChild( $asin );

        $title = $xmlDoc->createElement("title");
        $title->appendChild($xmlDoc->createCDATASection($this->title));
        $retVal->appendChild( $title);


        $label = $xmlDoc->createElement("label");
        $label->appendChild($xmlDoc->createCDATASection($this->label));
        $retVal->appendChild( $label);

        $releasedate = $xmlDoc->createElement("releasedate");
        $releasedate->appendChild($xmlDoc->createTextNode($this->release_date));
        $retVal->appendChild( $releasedate);

        $language = $xmlDoc->createElement("language");
        $language->appendChild($xmlDoc->createTextNode($this->language));
        $retVal->appendChild( $language);

        $langDescription = $xmlDoc->createElement("langDescription");
        $langDescription->appendChild($xmlDoc->createTextNode($this->langDescription));
        $retVal->appendChild( $langDescription);

        $number_of_discs = $xmlDoc->createElement("number_of_discs");
    $number_of_discs->appendChild($xmlDoc->createCDATASection($this->number_of_discs ));
        $retVal->appendChild( $number_of_discs);

        $rating = $xmlDoc->createElement("rating");
        $rating->appendChild($xmlDoc->createTextNode($this->rating));
        $retVal->appendChild( $rating);

        $price = $xmlDoc->createElement("price");
        $price->appendChild($xmlDoc->createTextNode($this->price));
        $retVal->appendChild( $price);

        $url = $xmlDoc->createElement("url");
    $url->appendChild($xmlDoc->createCDATASection($this->URL));
        $retVal->appendChild( $url);

        $imageURL = $xmlDoc->createElement("imageURL");
    $imageURL->appendChild($xmlDoc->createCDATASection($this->imageURL));
        $retVal->appendChild( $imageURL);

        $tracklist = $xmlDoc->createElement("tracklist");
    $tracklist->appendChild($xmlDoc->createCDATASection($this->tracklist));
        $retVal->appendChild( $tracklist);

        $emusicURL = $xmlDoc->createElement("emusicURL");
    $emusicURL->appendChild($xmlDoc->createCDATASection($this->emusicURL));
        $retVal->appendChild( $emusicURL);

        $binding = $xmlDoc->createElement("binding");
    $binding->appendChild($xmlDoc->createCDATASection($this->binding));
        $retVal->appendChild( $binding );

        $comment = $xmlDoc->createElement("comment");
        $comment->appendChild($xmlDoc->createCDATASection($this->comment));
        $retVal->appendChild( $comment);

        return $retVal;
    }


    function toXML2(){

            //create and append name element
            $retVal = "<music>\n";
            $retVal .= "<music_id><![CDATA[" . $this->music_id . "]]></music_id>\n";
            $retVal .= "<asin>" . $this->asin . "</asin>\n";
            $retVal .= "<title><![CDATA[" . $this->title . "]]></title>\n";
            $retVal .= "<label><![CDATA[" . $this->label . "]]></label>\n";
            $retVal .= "<releasedate>" . $this->release_date . "</releasedate>\n";
            $retVal .= "<language>" . $this->language . "</language>\n";
            $retVal .= "<langDescription>" . $this->langDescription . "</langDescription>\n";
            $retVal .= "<number_of_discs>" . $this->number_of_discs . "</number_of_discs>\n";
            $retVal .= "<rating>" . $this->rating . "</rating>\n";
            $retVal .= "<price>" . $this->price . "</price>\n";
            $retVal .= "<priceunit>" . $this->priceunit . "</priceunit>\n";
            $retVal .= "<URL><![CDATA[" . $this->URL . "]]></URL>\n";
            $retVal .= "<imageURL><![CDATA[" . $this->imageURL . "]]></imageURL>\n";
            $retVal .= "<tracklist><![CDATA[" . $this->tracklist . "]]></tracklist>\n";
            $retVal .= "<emusicURL><![CDATA[" . $this->emusicURL . "]]></emusicURL>\n";
            $retVal .= "<binding><![CDATA[" . $this->binding . "]]></binding>\n";
            $retVal .= "<comment><![CDATA[" . $this->comment . "]]></comment>\n";
            $retVal .= "</music>\n";

            return $retVal;
}


}

