<?php
defined('_JEXEC') or die('Restricted access');

/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */



require_once ($mosConfig_absolute_path."/components/com_medialibrary/medialibrary.class.lend.php");
require_once ($mosConfig_absolute_path."/components/com_medialibrary/medialibrary.class.review.php");


/**
* Book database table class
*/
class mosMedialibrary_video extends JTable {
    /** @var int Primary key */
    var $id=null;
    /** @var int */
    var $video_id=null;
    /** @var int */
    var $asin=null;
    /** @var datetime */
    var $title=null;
    /** @var varchar(200) */
    var $imageURL=null;
    /** @var varchar(250) */
    var $URL=null;
    /** @var int */
    var $rating=null;
    /** @var varchar(200) */
    /** @var varchar(200) */
    var $comment=null;
      /** @var varchar(200)  */
      var $language=null;
    /** @var varchar(45)  */
    var $langDescription=null;
    /** @var varchar(45) */
    var $release_date = null;
    /** @var varchar(250) */
    var $evideoURL = null;
    /** @var varchar(15) */
    var $price = null;
    /** @var priceunit */
    var $priceunit = null;
      /** @var tinyint(3) */
    var $number_of_discs = null;
      /** @var varchar(20) */
    var $run_time = null;
      /** @var varchar(50) */
    //var $studio = null;
      /** @var varchar(200) */
    //var $producers = null;
      /** @var varchar(150) */
    //var $directors = null;
      /** @var varchar(200) */
    var $format = null;
      /** @var varchar(150) */
    var $region = null;

    /**
    * @param database - A database connector object
    */
  function __construct( &$db ) {
  //  $this->mosDBTable( '#__medialibrary', 'id', $db );
    parent::__construct('#__medialibrary_video', 'id', $db);//for 1.6
  }
    // overloaded check function
    function check() {

        global $medialibrary_configuration;

        if(trim( $this->title) == ''){
        $this->_error = _MEDIALIBRARY_LABEL_B_TITLE;
        return false;
        }

        // check for valid name
        if (trim( $this->asin ) == '') {
            $this->_error = _MEDIALIBRARY_LABEL_ISBN;
            return false;
        }

        if($medialibrary_configuration['editmedia']['check']['isbn_asin'] == '1'){
            $this->_db->setQuery( "SELECT id FROM #__medialibrary_video "
                . "\nWHERE asin='$this->asin'");
            $result = $this->_db->loadResult();
            $xid = intval( $result );
            if ($xid && $xid != intval( $this->id )) {
                $this->_error = _MEDIALIBRARY_ADMIN_INFOTEXT_JS_EDIT_ISBN_ASIN;
                return false;
            }

        }
        $this->price=floatval(preg_replace('/[\s,]/','',$this->price));

        return true;
    }

    function toXML3($xmlDoc ){

        //create and append name element
        $retVal = $xmlDoc->createElement("video");

        $video_id = $xmlDoc->createElement("video_id");
        $video_id->appendChild($xmlDoc->createTextNode($this->video_id));
        $retVal->appendChild( $video_id);

        $asin = $xmlDoc->createElement("asin");
        $asin->appendChild($xmlDoc->createTextNode($this->asin));
        $retVal->appendChild( $asin);

        $title = $xmlDoc->createElement("title");
        $title->appendChild($xmlDoc->createCDATASection($this->title));
        $retVal->appendChild( $title);

/*
        $producers = $xmlDoc->createElement("producers");
        $producers->appendChild($xmlDoc->createCDATASection($this->producers));
        $retVal->appendChild( $producers);
*/
        $releasedate = $xmlDoc->createElement("releasedate");
        $releasedate->appendChild($xmlDoc->createTextNode($this->release_date));
        $retVal->appendChild( $releasedate);

        $language = $xmlDoc->createElement("language");
        $language->appendChild($xmlDoc->createTextNode($this->language));
        $retVal->appendChild( $language);

        $langDescription = $xmlDoc->createElement("langDescription");
        $langDescription->appendChild($xmlDoc->createTextNode($this->langDescription));
        $retVal->appendChild( $langDescription);
/*
        $directors = $xmlDoc->createElement("directors");
    $directors->appendChild($xmlDoc->createCDATASection($this->directors));
        $retVal->appendChild( $directors);
*/
        $rating = $xmlDoc->createElement("rating");
        $rating->appendChild($xmlDoc->createTextNode($this->rating));
        $retVal->appendChild( $rating);

        $price = $xmlDoc->createElement("price");
        $price->appendChild($xmlDoc->createTextNode($this->price));
        $retVal->appendChild( $price);

        $url = $xmlDoc->createElement("url");
    $url->appendChild($xmlDoc->createCDATASection($this->URL));
        $retVal->appendChild( $url);

        $imageURL = $xmlDoc->createElement("imageURL");
    $imageURL->appendChild($xmlDoc->createCDATASection($this->imageURL));
        $retVal->appendChild( $imageURL);
/*
        $studio = $xmlDoc->createElement("studio");
    $studio->appendChild($xmlDoc->createCDATASection($this->studio));
        $retVal->appendChild( $studio);
*/
        $evideoURL = $xmlDoc->createElement("evideoURL");
    $evideoURL->appendChild($xmlDoc->createCDATASection($this->evideoURL));
        $retVal->appendChild( $evideoURL);

        $comment = $xmlDoc->createElement("comment");
        $comment->appendChild($xmlDoc->createCDATASection($this->comment));
        $retVal->appendChild( $comment);

        $number_of_discs = $xmlDoc->createElement("number_of_discs");
        $number_of_discs->appendChild($xmlDoc->createCDATASection($this->number_of_discs));
        $retVal->appendChild( $number_of_discs);

        $run_time = $xmlDoc->createElement("run_time");
        $run_time->appendChild($xmlDoc->createCDATASection($this->run_time));
        $retVal->appendChild( $run_time);

        $format = $xmlDoc->createElement("format");
        $format->appendChild($xmlDoc->createCDATASection($this->format));
        $retVal->appendChild( $format);

        $region = $xmlDoc->createElement("region");
        $region->appendChild($xmlDoc->createCDATASection($this->region));
        $retVal->appendChild( $region );

        return $retVal;
    }

    function toXML2(){
             //create and append name element



            $retVal = "<video>\n";
            $retVal .= "<video_id><![CDATA[" . $this->video_id . "]]></video_id>\n";
            $retVal .= "<asin>" . $this->asin . "</asin>\n";
            $retVal .= "<title><![CDATA[" . $this->title . "]]></title>\n";
           // $retVal .= "<producers><![CDATA[" . $this->producers . "]]></producers>\n";
            $retVal .= "<releasedate>" . $this->release_date . "</releasedate>\n";
            $retVal .= "<language>" . $this->language . "</language>\n";
            $retVal .= "<langDescription>" . $this->langDescription . "</langDescription>\n";
          //  $retVal .= "<directors><![CDATA[" . $this->directors . "]]></directors>\n";
            $retVal .= "<rating>" . $this->rating . "</rating>\n";
            $retVal .= "<price>" . $this->price . "</price>\n";
            $retVal .= "<priceunit>" . $this->priceunit . "</priceunit>\n";
            $retVal .= "<url><![CDATA[" . $this->URL . "]]></url>\n";
            $retVal .= "<imageURL><![CDATA[" . $this->imageURL . "]]></imageURL>\n";
           // $retVal .= "<studio><![CDATA[" . $this->studio . "]]></studio>\n";
            $retVal .= "<evideoURL><![CDATA[" . $this->evideoURL . "]]></evideoURL>\n";
            $retVal .= "<comment><![CDATA[" . $this->comment . "]]></comment>\n";
            $retVal .= "<number_of_discs>" . $this->number_of_discs . "</number_of_discs>\n";
            $retVal .= "<run_time>" . $this->run_time . "</run_time>\n";
            $retVal .= "<format><![CDATA[" . $this->format . "]]></format>\n";
            $retVal .= "<region><![CDATA[" . $this->region . "]]></region>\n";
            $retVal .= "</video>\n";
            return $retVal;
    }
}
