<?php

if (!defined('_VALID_MOS') && !defined('_JEXEC'))
    die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */

class mosMediaLibrary_people extends JTable {

    /** @var int Primary key */
    var $id = null;

    /** @var datetime - date when adding this author */
    var $date = null;

   /** @var  */
    var $hits = null;

    var $published = null;

    var $approved = null;

    /** @var boolean */
    var $checked_out = null;

    /** @var time */
    var $checked_out_time = null;

    var $description = null;

    var $auto_gener_description = null;

    var $imageURL = null;

    var $language = null;

    var $user_name = null;

    var $people_name = null;
    /**
     * @param database - A database connector object
     */

    function __construct(&$db) {
        parent::__construct('#__medialibrary_people', 'id', $db);
    }

     function toXML2() {
        $retVal = "<people>\n";
        $retVal .= "<id>" . $this->id . "</id>\n";
        $retVal .= "<date>" . $this->date . "</date>\n";
        $retVal .= "<hits><![CDATA[" . $this->hits . "]]></hits>\n";
        if (isset($this->associate_people))
        $retVal .= "<associate_people><![CDATA[" . $this->associate_people . "]]></associate_people>\n";
        $retVal .= "<published>" . $this->published . "</published>\n";
        $retVal .= "<approved>" . $this->approved . "</approved>\n";
        $retVal .= "<people_name><![CDATA[" . $this->people_name . "]]></people_name>\n";
        $retVal .= "<description><![CDATA[" . $this->description . "]]></description>\n";
        $retVal .= "<auto_gener_description><![CDATA[" . $this->auto_gener_description . "]]>";
        $retVal .= "</auto_gener_description>\n";
        $retVal .= "<imageURL><![CDATA[" . $this->imageURL . "]]></imageURL>\n";
        if (isset($this->langshow))
        $retVal .= "<langshow>" . $this->langshow . "</langshow>\n";
        if (isset($this->owneremail))
        $retVal .= "<owneremail><![CDATA[" . $this->owneremail . "]]></owneremail>\n";
        if (isset($this->owner_id))
        $retVal .= "<owner_id><![CDATA[" . $this->owner_id . "]]></owner_id>\n";
        if (isset($this->type))
        $retVal .= "<type><![CDATA[" . $this->type . "]]></type>\n";
        $retVal .= "</people>\n";
         return $retVal;
     }
 }