<?php
if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__)
        .' is not allowed.' );

/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */




require_once ($mosConfig_absolute_path."/components/com_medialibrary/medialibrary.class.lend.php");
require_once ($mosConfig_absolute_path."/components/com_medialibrary/medialibrary.class.review.php");


/**
* Book database table class
*/
class mosMedialibrary_book extends JTable {
    /** @var int Primary key */
    var $id=null;
    /** @var int */
    var $book_id=null;
    /** @var int */
    var $isbn=null;
    /** @var datetime */
    var $title=null;
    /** @var varchar(200) */
    var $imageURL=null;
    /** @var varchar(250) */
    var $URL=null;
    /** @var int */
    var $rating=null;
    /** @var varchar(200) */
    var $manufacturer=null;
    /** @var varchar(45)*/
    var $edition=null;
    /** @var varchar(300) */
    var $comment=null;
    /** @var varchar(45)  */
    var $language=null;
    /** @var varchar(45)  */
    var $langDescription=null;
    /** @var varchar(45) */
    var $release_date = null;
    /** @var varchar(250) */
    var $ebookURL = null;
    /** @var varchar(15) */
    var $price = null;
    /** @var priceunit */
    var $priceunit = null;
    /** @var int(6) */
    var $numberOfPages = null;

    var $authors = null;

    var $fliphtml5 = null;

    var $id_article_book = null;


    /**
    * @param database - A database connector object
    */
      function __construct( &$db ) {
  //  $this->mosDBTable( '#__medialibrary', 'id', $db );
    parent::__construct('#__medialibrary_book', 'id', $db);//for 1.6
  }
    // overloaded check function
    function check() {
        global $medialibrary_configuration;

        if(trim( $this->title) == ''){
          $this->_error = _MEDIALIBRARY_LABEL_B_TITLE;
          return false;
        }

        // check for valid name
        if (trim( $this->isbn ) == '') {
            $this->_error = _MEDIALIBRARY_LABEL_ISBN;
            return false;
        }



    // check for existing ISBN
        if($medialibrary_configuration['editmedia']['check']['isbn_asin'] == '1'){
            $this->_db->setQuery( "SELECT id FROM #__medialibrary_book "
                . "\nWHERE isbn='$this->isbn'");
            $xid = intval( $this->_db->loadResult() );
            if ($xid && $xid != intval( $this->id )) {
                $this->_error = _MEDIALIBRARY_ADMIN_INFOTEXT_JS_EDIT_ISBN_ASIN;
                return false;
            }


        }
    $this->price=floatval(preg_replace('/[\s,]/','',$this->price));

        return true;
    }

    /**
     * Is used to load a book by the ISBN number
     * @param string - the ISBN number
     */
    function loadISBN($isbn){
        $this->_db->setQuery( "SELECT * FROM $this->_tbl WHERE isbn='$isbn'" );
        return $this->_db->loadObject( $this );
    }



    function toXML3($xmlDoc ){

        //create and append name element
        $retVal = $xmlDoc->createElement("book");

        $book_id = $xmlDoc->createElement("book_id");
        $book_id->appendChild($xmlDoc->createTextNode($this->book_id));
        $retVal->appendChild( $book_id);

        $catid = $xmlDoc->createElement("isbn");
        $catid->appendChild($xmlDoc->createTextNode($this->isbn));
        $retVal->appendChild( $catid);

        $title = $xmlDoc->createElement("title");
        $title->appendChild($xmlDoc->createCDATASection($this->title));
        $retVal->appendChild( $title);

        $manufacturer = $xmlDoc->createElement("manufacturer");
        $manufacturer->appendChild($xmlDoc->createCDATASection($this->manufacturer));
        $retVal->appendChild( $manufacturer);

        $releasedate = $xmlDoc->createElement("releasedate");
        $releasedate->appendChild($xmlDoc->createTextNode($this->release_date));
        $retVal->appendChild( $releasedate);

        $language = $xmlDoc->createElement("language");
        $language->appendChild($xmlDoc->createTextNode($this->language));
        $retVal->appendChild( $language);

        $langDescription = $xmlDoc->createElement("langDescription");
        $langDescription->appendChild($xmlDoc->createTextNode($this->langDescription));
        $retVal->appendChild( $langDescription);

        $rating = $xmlDoc->createElement("rating");
        $rating->appendChild($xmlDoc->createTextNode($this->rating));
        $retVal->appendChild( $rating);

        $price = $xmlDoc->createElement("price");
        $price->appendChild($xmlDoc->createTextNode($this->price));
        $retVal->appendChild( $price);

        $priceunit = $xmlDoc->createElement("priceunit");
        $priceunit->appendChild($xmlDoc->createTextNode($this->priceunit));
        $retVal->appendChild( $priceunit);

        $url = $xmlDoc->createElement("url");
        $url->appendChild($xmlDoc->createCDATASection($this->URL));
        $retVal->appendChild( $url);

        $imageURL = $xmlDoc->createElement("imageURL");
        $imageURL->appendChild($xmlDoc->createCDATASection($this->imageURL));
        $retVal->appendChild( $imageURL);

        $edition = $xmlDoc->createElement("edition");
        $edition->appendChild($xmlDoc->createCDATASection($this->edition));
        $retVal->appendChild( $edition);

        $ebookURL = $xmlDoc->createElement("ebookURL");
        $ebookURL->appendChild($xmlDoc->createCDATASection($this->ebookURL));
        $retVal->appendChild( $ebookURL);

        $comment = $xmlDoc->createElement("comment");
        $comment->appendChild($xmlDoc->createCDATASection($this->comment));
        $retVal->appendChild( $comment);

        $numberOfPages = $xmlDoc->createElement("numberOfPages");
        $numberOfPages->appendChild($xmlDoc->createTextNode($this->numberOfPages));
        $retVal->appendChild( $numberOfPages);

        return $retVal;
    }

    function toXML2(){
//echo $this->langDescription;exit;
             //create and append name element
            $retVal = "<book>\n";
            $retVal .= "<book_id><![CDATA[" . $this->book_id . "]]></book_id>\n";
            $retVal .= "<isbn>" . $this->isbn . "</isbn>\n";
            $retVal .= "<title><![CDATA[" . $this->title . "]]></title>\n";
            $retVal .= "<manufacturer><![CDATA[" . $this->manufacturer . "]]></manufacturer>\n";
            $retVal .= "<releasedate>" . $this->release_date . "</releasedate>\n";
            $retVal .= "<language>" . $this->language . "</language>\n";
            $retVal .= "<langDescription>" . $this->langDescription . "</langDescription>\n";
            $retVal .= "<rating>" . $this->rating . "</rating>\n";
            $retVal .= "<price>" . $this->price . "</price>\n";
            $retVal .= "<priceunit>" . $this->priceunit . "</priceunit>\n";
            $retVal .= "<url><![CDATA[" . $this->URL . "]]></url>\n";
            $retVal .= "<imageURL><![CDATA[" . $this->imageURL . "]]></imageURL>\n";
            $retVal .= "<edition><![CDATA[" . $this->edition . "]]></edition>\n";
            $retVal .= "<ebookURL><![CDATA[" . $this->ebookURL . "]]></ebookURL>\n";
            $retVal .= "<comment><![CDATA[" . $this->comment . "]]></comment>\n";
            $retVal .= "<numberOfPages>" . $this->numberOfPages . "</numberOfPages>\n";
            $retVal .= "</book>\n";

            return $retVal;
}

}
