<?php

/**
*
* @package Medialibrary
* @copyright 2016 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru);
* Homepage: https://ordasoft.com
* @version: 3.5 Free
*
**/
defined( '_JEXEC' ) or die( 'Restricted access' );

$doc = JFactory::getDocument();
$doc->addStyleSheet( JURI::root(true). '/components/com_medialibrary/includes/medialibrary-grid.css');
$doc->addStyleSheet( JURI::root(true).'/components/com_medialibrary/includes/medialibrary.css' );
if( checkJavaScriptIncluded("jQuerMedia.js") === false )   {
  $doc->addScript(JURI::root(true) . '/components/com_medialibrary/includes/jQuerMedia.js');
}



?>




<div class="ml-mod-base-block" id="ml_mod_feature-<?php echo $module->id;?>" >
    <?php 
    foreach ($rows as $row) {
        $link1 = "index.php?option=com_medialibrary&amp;task=view&amp;catid=".$row->catid."&amp;id="
                .$row->id."&amp;Itemid=".$ItemId_tmp;
        //for local images
        $imageURL = $row->imageURL;
        if($imageURL != '' && substr($imageURL,0,4) != "http"){
            $imageURL = JURI::base() . $row->imageURL;;
        }
        if($imageURL == ''){
            $imageURL = JURI::base() . "/components/com_medialibrary/images/no-img_eng.gif";
        }?>
        <div class="ml-base-list-product" >
            <?php 
            if ($show_covers==1) {?>
                <div class="product_block__image-container">
                    <a href="<?php echo JRoute::_( $link1 ); ?>" target="_self">
                        <img src="<?php echo $imageURL; ?>" alt="<?php echo $row->title; ?>" hspace="2" vspace="2" border="0" style="height: <?php echo $cover_height;?>px;" />
                    </a>
                </div>
            <?php
            } ?>
            <div class="product-block__title">
                <a href="<?php echo JRoute::_( $link1 ); ?>" target="_self"><?php echo $row->title; ?></a>
            </div>
            <?php 
            if($show_hits==1) {?>
                <div class="product-block__hits">
                    <span>
                        <?php echo _MEDIALIBRARY_LABEL_HITS ?>:
                    </span>
                    <span class='small'>(<?php echo $row->hits; ?>)</span>
                </div>
            <?php 
            }
            if($price != 0) { ?>
                <div class="product-block__price" >
                    <span>
                        <?php echo _MEDIALIBRARY_LABEL_PRICE ?>:
                    </span>
                    <span class='small'>
                        <?php 
                        //echo $row->price.' '.$row->priceunit;
                        if ($medialibrary_configuration['price_unit_show'] == '1'){
                          echo  formatMoney($row->price, true, $medialibrary_configuration[
                              'price_format']), ' ',  $row->priceunit;
                                }
                          else {
                          echo  $row->priceunit, ' ',formatMoney($row->price, true,
                              $medialibrary_configuration['price_format']);
                        }   

                         ?>
                    </span>
                </div>
            <?php 
            }?>
        </div>
    <?php 
    }?>
</div>

<div style="clear:both"></div>
<div style="text-align: center;">
<a href="https://ordasoft.com/MediaLibrary-Documentation/medialibrary-versions-feature-comparison.html">
Media Library</a> by OrdaSoft!</div>
