<?php
/*
 * @package Real Estate
 * @subpackage  Real Estate Slider
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru);
 * @Homepage: http://www.ordasoft.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

if(!class_exists('modRemOsFeaturedSliderHelper')) {
  class modRemOsTouchSliderHelper {

      static function getWhereUsergroupsString( $table_alias ) {
          global $my;

          if ( isset($my->id) AND $my->id != 0 ) {
            $usergroups_sh = modRemOsTouchSliderHelper::getGroupsByUser ($my->id,'');
            //$usergroups_sh = '-2'.$usergroups_sh;
          } else {
             $usergroups_sh = array ();
          }
          $usergroups_sh[] = -2;
          $s = '';
          for ($i=0; $i<count($usergroups_sh); $i++) {
            $g = $usergroups_sh[$i];
            $s .= " $table_alias.params LIKE '%,{$g}' or $table_alias.params = '{$g}' " .
             " or $table_alias.params LIKE '{$g},%' or $table_alias.params LIKE '%,{$g},%' ";
            if ( ($i+1)<count($usergroups_sh) )
              $s .= ' or ';
          }
          return $s;
      }

      static function getGroupsByUser ( $uid, $recurse ) {
          $database = JFactory::getDBO() ;
          $usergroups = array ();

          if ( $recurse == 'RECURSE' ) {
          // [1]: Recurse getting the usergroups
            $id_group = array ();
            $q1 = "SELECT group_id FROM `#__user_usergroup_map` WHERE user_id={$uid}";
            $database->setQuery($q1);
            $rows1 = $database->loadObjectList();
            foreach ($rows1 as $v) {
              $id_group[] = $v->group_id;
            }
            for ($k=0; $k<count($id_group); $k++) {
              $q = "SELECT g2.id FROM `#__usergroups` g1 " .
               " LEFT JOIN `#__usergroups` g2 ON g1.lft > g2.lft AND g1.lft < g2.rgt " .
               " WHERE g1.id={$id_group[$k]} ORDER BY g2.lft";
              $database->setQuery($q);
              $rows = $database->loadObjectList();
              foreach ($rows as $r) {
                $usergroups[] = $r->id;
                }
              }
            $usergroups = array_unique($usergroups);

          }
          return $usergroups;
      }

      static function sefRelToAbs( $value ) {
        //Need check!!!
        // Replace all &amp; with & as the router doesn't understand &amp;
        $url = str_replace('&amp;', '&', $value);
        if(substr(strtolower($url),0,9) != "index.php") return $url;
        $uri    = JURI::getInstance();
        $prefix = $uri->toString(array('scheme', 'host', 'port'));
        return $prefix.JRoute::_($url);
      }

      static function getSlideImage($slide,$params) {

        global $realestatemanager_configuration;
        $image_source_type = $params->get('image_source_type');
        $mosConfig_absolute_path=JPATH_BASE;
        $mosConfig_live_site=JURI::base(true);
        if($realestatemanager_configuration['thumb_param']['show'] == 1)
          $index = "_2_";
        else
          $index = "_1_";
        $imageURL = $slide->src ;
        if($imageURL!='' && file_exists('./components/com_realestatemanager/photos/'.$imageURL)){
          $file_pth= pathinfo($imageURL);
          $file_type=".".$file_pth['extension'];
          if(array_key_exists('filename' , $file_pth)) {
            $file_name = $file_pth['filename'];
          }
          else {
            $file_name = substr($imageURL, 0,strlen($imageURL) - strlen($file_pth['extension']) - 1);
          }

          $file1 = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/'.
          $file_name . $file_type;

          $img1 = './components/com_realestatemanager/photos/'. $file_name . $file_type;

          if($image_source_type == 0 ) {
            if(file_exists($file1)) {
              return $img1;
            }
          }

          $file2 = $mosConfig_absolute_path .'/components/com_realestatemanager/photos/'.
                    $file_name ."_".$realestatemanager_configuration['fotomain']['high']
                    ."_".$realestatemanager_configuration['fotomain']['width'].$index. $file_type;
          $img2 = '/components/com_realestatemanager/photos/'.
                    $file_name ."_".$realestatemanager_configuration['fotomain']['high']
                    ."_".$realestatemanager_configuration['fotomain']['width'].$index. $file_type;
          if($image_source_type == 1 ) {
            if( file_exists($file2)) {
              return $img2;
            }
            else return $img1;
          }

          if($image_source_type == 2) {
            $file3 = $mosConfig_absolute_path .'/components/com_realestatemanager/photos/'.
                    $file_name ."_".$realestatemanager_configuration['fotogallery']['high']
                    ."_".$realestatemanager_configuration['fotogallery']['width'].$index. $file_type;
            $img3 = '/components/com_realestatemanager/photos/'.
                    $file_name ."_".$realestatemanager_configuration['fotogallery']['high']
                    ."_".$realestatemanager_configuration['fotogallery']['width'].$index. $file_type;
            if( file_exists($file3)) {

              return $img3;
            }
            else if( file_exists($file2)) {
              return $img2;
            }
            else return $img1;
          }
        }
        else {
          $imageURL = "./components/com_realestatemanager/images/no-img_eng_big.gif";
        }
        return $imageURL ;
      }

      static function isHttpUrl($url)
      {
          $findme   = 'http';
          $pos = strpos($url, $findme);
          if($pos === false) $url = JURI::base().$url;
          return $url;
      }

      static function getSlideLink($slide,$params) {
        $link = '';
        $db = JFactory::getDBO();

        if( $params->get('ItemId', '') != "" ) {
          $ItemId_tmp=$params->get('ItemId', '');
        } else {
          $selectstring = "SELECT id  FROM #__menu " .
           " WHERE menutype like '%menu%' AND link LIKE '%option=com_realestatemanager%' " .
           " AND params LIKE '%back_button%' ";
          $db->setQuery($selectstring);
          $ItemId_tmp_from_db = $db->loadResult();
          $ItemId_tmp=$ItemId_tmp_from_db;
        }

        $link = 'index.php?option=com_realestatemanager&amp;task=view&amp;id='.
          $slide->id.'&amp;catid='.$slide->idcat.'&amp;Itemid='.$ItemId_tmp;

        return modRemOsTouchSliderHelper::sefRelToAbs($link);
      }

      static function getSlideDescription($slide, $limit) {
        $desc = strip_tags($slide->description);
        if($limit && $limit < strlen($desc)) {
          $cur_limit = strpos($desc, ' ', $limit);
          if( $cur_limit !== false ) $desc = mb_substr($desc, 0, $cur_limit);
          else $desc = mb_substr($desc, 0, $limit);
          $desc = nl2br($desc);
          $desc.='...';
        } else { // no limit or limit greater than description
          $desc = $slide->description;
        }

        return $desc;
      }

      static function getSlideAddress($slide, $limit) {

        $address = "";

        $tmp = trim(strip_tags($slide->hcountry)) ;
        if($tmp != "" ) $address = $tmp;

        $tmp = trim(strip_tags($slide->hregion)) ;
        if($tmp != "" &&  $address != "" ) $address .= ", " . $tmp;
        else if( $tmp != "" ) $address =  $tmp;

        $tmp = trim(strip_tags($slide->hcity)) ;
        if($tmp != "" &&  $address != "" ) $address .= ", " . $tmp;
        else if( $tmp != "" ) $address =  $tmp;

        $tmp = trim(strip_tags($slide->hlocation)) ;
        if($tmp != "" &&  $address != "" ) $address .= ", " . $tmp;
        else if( $tmp != "" ) $address =  $tmp;

        if($limit && $limit < strlen($address)) {
          $cur_limit = strpos($address, ' ', $limit);
          if( $cur_limit !== false ) $address = mb_substr($address, 0, $cur_limit);
          else $address = mb_substr($address, 0, $limit);
          $address = nl2br($address);
          $address.='...';
        }
        return $address;
    }

  }
}
