<?php

/**
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @package Xmap VehicleManager
* @copyright (C) 2020 OrdaSoft - Andrey Kvasnevskiy
* @license GNU/GPL
* @description VehicleManager plugin for VehicleManager Component
*/

defined('_JEXEC') or die ('Direct Access to this location is not allowed.');

$f_path = JPATH_SITE.'/components/com_vehiclemanager/functions.php';
if (!file_exists($f_path)){
    echo "You need to install VehicleManager first<br />"; exit;
}
else require_once ($f_path);

        
class xmap_com_vehiclemanager{
    var $orderby = 'title';

    function isOfType(&$xmap, &$parent){
        if (strpos($parent->link, 'option=com_vehiclemanager')){
            $parent->name="VehicleManager";
            $parent->option="com_vehiclemanager";
            return true;
        }
        return false;
    }


    function &getTree(&$xmap, &$parent, &$params){
        
        global $mosConfig_absolute_path;
        $list = array();
        $parent->name="VehicleManager";
        $parent->option="com_vehiclemanager";
        $parent->uid="com_vehiclemanager";

        $link_query = parse_url($parent->link);
        parse_str(html_entity_decode($link_query['query']), $link_vars);
        if (version_compare(JVERSION, "1.6.0", "lt")){
            $view = JArrayHelper::getValue($link_vars,'task','all_categories');
        } else {
            $view = JArrayHelper::getValue($link_vars,'view','all_categories');
        }
        switch ($view){
            case 'all_categories':
                $catid = JArrayHelper::getValue($link_vars,'catid', 0);
                xmap_com_vehiclemanager::getCategoryTree($xmap, $parent, $catid, $params);
                break;

            case 'alone_category':
                if (version_compare(JVERSION, "1.6.0", "lt")){
                    if (strpos($parent->params, 'catid=')!==false){
                        $catid = substr($parent->params, strpos($parent->params,'=',0)+1, strpos($parent->params,'back',0)-strpos($parent->params,'=',0)-2);
                    }
                } else {
                    $catid = ($parent->params->getValue('single_category'));
                }
                xmap_com_vehiclemanager::singleCategoryHandler($xmap, $parent, $catid);
                break;

            case 'my_vehicles':
            case 'show_my_cars':
                xmap_com_vehiclemanager::myVehiclesHandler($xmap, $parent);
                break;

            case 'owner_vehicles':
            case 'view_user_vehicles':
                if (version_compare(JVERSION, "1.6.0", "lt")){
                    if (strpos($parent->params, 'username=')!==false){
                        $username = substr($parent->params, strpos($parent->params,'=',0)+1, strpos($parent->params,'back',0)-strpos($parent->params,'=',0)-2);
                    }
                } else {
                    $username = ($parent->params->getValue('username'));
                }
                xmap_com_vehiclemanager::singleUserVehiclesHandler($xmap, $parent, $username);
                break;

            case 'owners_list':
                xmap_com_vehiclemanager::ownersListHandler($xmap, $parent);
                break;

            default:
                break;
        }
        return $list;
    }


    function getVehicles(&$xmap, &$parent, &$catid, &$params, $catid, $parentid){
        $parentid = (int)$parentid;
        $Itemid = $parent->id;
        $xmap->changeLevel(1);

        $database = JFactory::getDBO();
        $s = vmLittleThings::getWhereUsergroupsCondition();

        $q = "SELECT distinct v.id AS id, v.vtitle, c.id AS catid
           \n FROM #__vehiclemanager_vehicles as v
           \n LEFT JOIN #__vehiclemanager_categories AS vc ON v.id=vc.iditem
           \n LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
           \n WHERE v.published = '1' AND v.approved = '1' AND c.published = '1' AND (".$s.") AND vc.idcat = ".$catid."
           \n GROUP BY v.id";
        $database->setQuery($q);
        $vehicles = $database->loadObjectList();

        foreach($vehicles as $vehicle){
            $node = new stdclass;
            $node->id = $vehicle->id;
            $node->uid = $vehicle->id;
            $node->name = $vehicle->vtitle;
            $node->parent=1;
            $node->browsNav=1;//open new window
            $node->ordering=2;
            $node->priority=$parent->priority;
            $node->chansefreq=$parent->changefreq;
            $node->changefreq=$parent->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type='component';
            $node->menutype='mainmenu';
            $node->link ='index.php?option=com_vehiclemanager&amp;task=view_vehicle&amp;catid='.$vehicle->catid.'&amp;id='.$vehicle->id.'&amp;Itemid='.$Itemid;
            $xmap->printNode($node);
        }
        $xmap->changeLevel(-1);
    }


    function getCategoryTree(&$xmap, &$parent, &$catid, &$params){
        //xmap_com_vehiclemanager::header();
        global $my, $mosConfig_absolute_path;

        $database = JFactory::getDBO();
        $s = vmLittleThings::getWhereUsergroupsCondition();
        $q = "SELECT v.id AS id, v.vtitle AS title, c.name AS category, c.parent_id, c.id AS catid 
              FROM #__vehiclemanager_vehicles AS v 
              LEFT JOIN #__vehiclemanager_categories AS vc ON v.id=vc.iditem AND v.published=1 AND v.approved=1
              LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
              WHERE (".$s.") 
              AND c.published = '1' 
              GROUP BY c.id
              ORDER BY c.parent_id, c.ordering";
        $database->setQuery($q);
        $cats = $database->loadObjectList();

        xmap_com_vehiclemanager::getSubCategory($xmap, $parent, $catid, $params, $catid, $cats);
    }


    function getSubCategory(&$xmap, &$parent, &$catid, &$params, $parentid, $cats){
        $link_query = parse_url($parent->link);
        parse_str(html_entity_decode($link_query['query']), $link_vars);
        $Itemid = $parent->id;

        $xmap->changeLevel(1);

        foreach($cats as $subcat){ 
            if($subcat->parent_id==$parentid){
                $node = new stdclass;
                $node->id = $parent->id;
                $node->uid=$parent->uid.'a'.$subcat->catid; 
                $node->name = $subcat->category; 
                $node->parent=1; 
                $node->browsNav=1;
                $node->ordering=2;
                $node->priority=$parent->priority;
                $node->chansefreq=$parent->changefreq;
                $node->changefreq=$parent->changefreq;
                $node->modified= date("Y-m-d h:i:s");
                $node->type='component';
                $node->link = 'index.php?option=com_vehiclemanager&amp;task=showCategory&amp;catid='.$subcat->catid.'&amp;Itemid='.$Itemid;
                $xmap->printNode($node);
                xmap_com_vehiclemanager::getSubCategory($xmap, $parent, $catid ,$params, $subcat->catid, $cats);
                xmap_com_vehiclemanager::getVehicles($xmap, $parent, $catid ,$params, $subcat->catid, $parentid);
            }
        }

        $xmap->changeLevel(-1);
    }


    function singleCategoryHandler(&$xmap, &$parent, &$catid){
        // The [Single Category] menu type handler
        //xmap_com_vehiclemanager::header();
        $Itemid = $parent->id;

        $database = JFactory::getDBO();
        $s = vmLittleThings::getWhereUsergroupsCondition();
        $query = "SELECT v.*,vc.idcat AS catid, c.title as category_titel
                  \n FROM #__vehiclemanager_vehicles AS v"
                ."\n LEFT JOIN #__vehiclemanager_categories AS vc ON vc.iditem=v.id"
                ."\n LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat"
                ."\n WHERE vc.idcat = '".$catid."' AND v.published='1' AND v.approved='1' "
                ."\n AND c.published='1' AND (".$s.")"
                ."\n GROUP BY v.id";
        $database->setQuery($query);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);

        foreach($items as $vehicle)
            xmap_com_vehiclemanager::printNode($xmap, $parent, $Itemid, $vehicle->id, $vehicle->vtitle, $catid, $vehicle->id, true);

        $q = "SELECT v.id AS id, v.vtitle AS title, c.name AS category, c.parent_id, c.id AS catid 
              FROM #__vehiclemanager_vehicles AS v 
              LEFT JOIN #__vehiclemanager_categories AS vc ON v.id=vc.iditem AND v.published=1 AND v.approved=1
              LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
              WHERE (".$s.") 
              AND c.published = '1' 
              GROUP BY c.id 
              ORDER BY c.parent_id, c.ordering";
        $database->setQuery($q);
        $cats = $database->loadObjectList();

        xmap_com_vehiclemanager::getSubCategory($xmap, $parent, $catid ,$params, $catid, $cats);

        $xmap->changeLevel(-1);
    }


    function myVehiclesHandler(&$xmap, &$parent){
        // The [my vehicles] menu type handler
        //xmap_com_vehiclemanager::header();
        $Itemid = $parent->id;
        $items = array();

        $my = JFActory::getUser();
        if (!isset($my->name)) return;

        $database = JFActory::getDBO();
        $q = "SELECT v.vtitle as title, v.id as id, c.id AS catid 
              FROM `#__vehiclemanager_vehicles` AS v
              LEFT JOIN `#__users` AS u ON u.email=v.owneremail
              LEFT JOIN `#__vehiclemanager_categories` AS vc ON vc.iditem=v.id
              LEFT JOIN `#__vehiclemanager_main_categories` AS c ON vc.idcat=c.id
              WHERE v.owneremail = '".$my->email."'
              GROUP BY id;";
        $database->setQuery($q);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);

        if (isset($items[0])) foreach ($items as $vehicle)
            xmap_com_vehiclemanager::printNode($xmap, $parent, $Itemid, $vehicle->id, $vehicle->title, $vehicle->catid, $vehicle->id, true);

        $xmap->changeLevel(-1);
    }


    function singleUserVehiclesHandler(&$xmap, &$parent, &$username){
        // The [Single User Vehicles] menu type handler
        //xmap_com_vehiclemanager::header();
        $Itemid = $parent->id;

        $database = JFactory::getDBO();
        $q = "SELECT distinct v.*, c.id AS catid 
              FROM `#__vehiclemanager_vehicles` AS v
              LEFT JOIN #__vehiclemanager_categories AS vc ON vc.iditem=v.id 
              LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat 
              LEFT JOIN `#__users` AS u ON u.email=v.owneremail
              WHERE v.approved = 1 AND c.published = 1 AND v.published = 1 AND
              u.name='".$username."' 
              GROUP BY v.vtitle";
        $database->setQuery($q);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);

        foreach ($items as $vehicle)
            xmap_com_vehiclemanager::printNode($xmap, $parent, $Itemid, $vehicle->id, $vehicle->vtitle, $vehicle->catid, $vehicle->id, true);

        $xmap->changeLevel(-1);
    }


    function ownersListHandler(&$xmap, &$parent){
        // The [owners list] menu type handler
        //xmap_com_vehiclemanager::header();
        $Itemid = $parent->id;

        $database = JFactory::getDBO();
        $s = vmLittleThings::getWhereUsergroupsCondition();
        $q1 = "SELECT u.name, u.email, u.id, COUNT(vm.owneremail) AS vehicles
            \n FROM #__vehiclemanager_vehicles AS vm
            \n LEFT JOIN #__vehiclemanager_categories AS vc ON vc.iditem=vm.id
            \n LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
            \n LEFT JOIN #__users AS u ON vm.owneremail=u.email
            \n WHERE (".$s.") AND vm.published=1 AND vm.approved=1 AND c.published=1 AND vm.owneremail!=''
            \n GROUP BY u.name
            \n ORDER BY u.name ";
        $database->setQuery($q1);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);

        foreach($items as $owner){
            xmap_com_vehiclemanager::printNode($xmap, $parent, $Itemid, $owner->id, $owner->name, 0, 0, false, $owner->name);

            $s = vmLittleThings::getWhereUsergroupsCondition();
            $q = "SELECT v.*, c.id AS catid FROM `#__vehiclemanager_vehicles` AS v
                  LEFT JOIN #__vehiclemanager_categories AS vc ON vc.iditem=v.id
                  LEFT JOIN #__vehiclemanager_main_categories AS c ON c.id=vc.idcat
                  WHERE v.approved = 1 AND c.published = 1 AND v.published = 1 AND (".$s.") AND v.owneremail='".$owner->email."'
                  GROUP BY v.id";  
            $database->setQuery($q);
            $vehicles = $database->loadObjectList();   

            $xmap->changeLevel(1);

            foreach ($vehicles as $vehicle)
                xmap_com_vehiclemanager::printNode($xmap, $parent, $Itemid, $vehicle->id, $vehicle->vtitle, $vehicle->catid, $vehicle->id, true);

            $xmap->changeLevel(-1);
        }

        $xmap->changeLevel(-1);
    }


//     function header(){
//         echo "<hr style='width:50%; color: #555;background-color:#555;border:0px none;height:1px;clear:both;' />";
//     }


    function printNode(&$xmap, &$parent, $Itemid, $node_uid, $node_name, $catid = 0, $vehicleid = 0, $is_vehicle = false, $name = false){
        // [params for Vehicle]: $xmap obj, the `parent` Obj, Itemid, Vehicleid, Vehicle->title, catid, vehicleID, vehicle/category flag = 'true', user=false
        // [params for Category]: $xmap, $parent, Itemid, catid, category title, catid, 0, false, user=false
        // [params for User]: $xmap, $parent, Itemid, userid, username, 0, 0, false, username
        $node = new stdclass;
        $node->id = $Itemid;
        $node->uid = $node_uid;
        $node->name = $node_name;
        $node->parent = 1; 
        $node->browsNav = 1; 
        $node->ordering = 2; 
        $node->priority=$parent->priority;
        $node->chansefreq=$parent->changefreq;
        $node->changefreq=$parent->changefreq;
        $node->modified= date("Y-m-d h:i:s");
        $node->type = 'component'; 
        $node->menutype = 'mainmenu'; 
        if ($is_vehicle) $node->link = 'index.php?option=com_vehiclemanager&amp;task=view_vehicle&amp;catid='.$catid.'&amp;Itemid='.$Itemid.'&amp;id='.$vehicleid;
            elseif ($catid > 0) $node->link = 'index.php?option=com_vehiclemanager&amp;task=showCategory&amp;catid='.$catid.'&amp;Itemid='.$Itemid;
                elseif (isset($name) AND $name != '') $node->link = 'index.php?option=com_vehiclemanager&amp;task=view_user_vehicles&amp;Itemid='.$Itemid.'&amp;name='.$name;
        $xmap->printNode($node);
    }
}
