<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

/**
 * Supports a modal article picker.
 *
 * @since  1.6
 */

use Joomla\CMS\HTML\HTMLHelper;
// use Joomla\CMS\Language\LanguageHelper;
use Joomla\Database\ParameterType;

if (version_compare(JVERSION, "4.0.0", "ge")) {
     require_once ($mosConfig_absolute_path . 
         "/administrator/components/com_content/src/Field/Modal/ArticleField.php");
 } else {
    require_once ($mosConfig_absolute_path . 
        "/administrator/components/com_content/models/fields/modal/article.php");
}




if (version_compare(JVERSION, "4.4.0", "ge")  ) {

    class JFormFieldModal_Article_BL extends Joomla\Component\Content\Administrator\Field\Modal\ArticleField
{

        protected $type = 'Modal_Article_BL';
        protected $fieldname = 'Modal_Article_BL';
        /**
         * Method to get the field input markup.
         *
         * @return  string  The field input markup.
         *
         * @since   1.6
         */

        // public function __construct() {
        public function __construct($id_article_book,&$db) {
            
            $this->name = 'OnlineArticle';
            
            $allowNew = $this->element['new'] = 'true';
            $labelNew = $this->element['label'] = 'Text';
            $allowEdit   = $this->element['edit'] = 'true';
            $allowClear  = $this->element['clear'] = 'true';
            $allowSelect = $this->element['select'] = 'true';
            $allowLanguage = $this->element['language'] = '*'; //need more check, may be need set current language local like: JFactory::getLanguage()->getLocale(); 

            if ($id_article_book > 0) {
                $this->value =  $id_article_book ;
                $this->id =  $id_article_book ;
            }

            $this->setDatabase($db);
        }
        
        public function getInput()
        {
        
            $this->name = 'OnlineArticle';                                      
            $this->element['propagate'] = false;
            

            $allowNew       = ((string) $this->element['new'] == 'true');
            $allowEdit      = ((string) $this->element['edit'] == 'true');
            $allowClear     = ((string) $this->element['clear'] != 'false');
            $allowSelect    = ((string) $this->element['select'] != 'false');
            $allowPropagate = ((string) $this->element['propagate'] == 'true');

            $languages = JLanguageHelper::getContentLanguages([0, 1], false);

            // Load language
            JFactory::getLanguage()->load('com_content', JPATH_ADMINISTRATOR);

            // The active article id field.
            $value = (int) $this->value ?: '';

            // Create the modal id.
            $modalId = 'Article_' . $this->id;

            /** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
            $wa = JFactory::getApplication()->getDocument()->getWebAssetManager();

            // Add the modal field script to the document head.
            $wa->useScript('field.modal-fields');

            // Script to proxy the select modal function to the modal-fields.js file.
            if ($allowSelect) {
                static $scriptSelect = null;

                if (is_null($scriptSelect)) {
                    $scriptSelect = [];
                }

                if (!isset($scriptSelect[$this->id])) {
                    $wa->addInlineScript(
                        "
                    window.jSelectArticle_" . $this->id . " = function (id, title, catid, object, url, language) {
                        window.processModalSelect('Article', '" . $this->id . "', id, title, catid, object, url, language);
                    }",
                        [],
                        ['type' => 'module']
                    );

                    JText::script('JGLOBAL_ASSOCIATIONS_PROPAGATE_FAILED');

                    $scriptSelect[$this->id] = true;
                }
            }

            // Setup variables for display.
            $linkArticles = 'index.php?option=com_content&amp;view=articles&amp;layout=modal&amp;tmpl=component&amp;' . JSession::getFormToken() . '=1';
            $linkArticle  = 'index.php?option=com_content&amp;view=article&amp;layout=modal&amp;tmpl=component&amp;' . JSession::getFormToken() . '=1';

            if (isset($this->element['language'])) {
                $linkArticles .= '&amp;forcedLanguage=' . $this->element['language'];
                $linkArticle .= '&amp;forcedLanguage=' . $this->element['language'];
                $modalTitle    = JText::_('COM_CONTENT_SELECT_AN_ARTICLE') . ' &#8212; ' . $this->element['label'];
            } else {
                $modalTitle    = JText::_('COM_CONTENT_SELECT_AN_ARTICLE');
            }

            $urlSelect = $linkArticles . '&amp;function=jSelectArticle_' . $this->id;
            $urlEdit   = $linkArticle . '&amp;task=article.edit&amp;id=\' + document.getElementById(&quot;' . $this->id . '_id&quot;).value + \'';
            $urlNew    = $linkArticle . '&amp;task=article.add';

            if ($value) {
                $db    = $this->getDatabase();
                $query = $db->getQuery(true)
                    ->select($db->quoteName('title'))
                    ->from($db->quoteName('#__content'))
                    ->where($db->quoteName('id') . ' = :value')
                    ->bind(':value', $value, ParameterType::INTEGER);
                $db->setQuery($query);

                try {
                    $title = $db->loadResult();
                } catch (\RuntimeException $e) {
                    Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
                }
                if (empty($title)) {
                    $value = '';
                }
            }

            $title = empty($title) ? JText::_('COM_CONTENT_SELECT_AN_ARTICLE') : htmlspecialchars($title, ENT_QUOTES, 'UTF-8');

            // The current article display field.
            $html  = '';

            if ($allowSelect || $allowNew || $allowEdit || $allowClear) {
                $html .= '<span class="input-group">';
            }

            $html .= '<input class="form-control" id="' . $this->id . '_name" type="text" value="' . $title . '" readonly size="35">';

            // Select article button
            if ($allowSelect) {
                $html .= '<button'
                    . ' class="btn btn-primary' . ($value ? ' hidden' : '') . '"'
                    . ' id="' . $this->id . '_select"'
                    . ' data-bs-toggle="modal"'
                    . ' type="button"'
                    . ' data-bs-target="#ModalSelect' . $modalId . '">'
                    . '<span class="icon-file" aria-hidden="true"></span> ' . JText::_('JSELECT')
                    . '</button>';
            }

            // New article button
            if ($allowNew) {
                $html .= '<button'
                    . ' class="btn btn-secondary' . ($value ? ' hidden' : '') . '"'
                    . ' id="' . $this->id . '_new"'
                    . ' data-bs-toggle="modal"'
                    . ' type="button"'
                    . ' data-bs-target="#ModalNew' . $modalId . '">'
                    . '<span class="icon-plus" aria-hidden="true"></span> ' . JText::_('JACTION_CREATE')
                    . '</button>';
            }

            // Edit article button
            if ($allowEdit) {
                $html .= '<button'
                    . ' class="btn btn-primary' . ($value ? '' : ' hidden') . '"'
                    . ' id="' . $this->id . '_edit"'
                    . ' data-bs-toggle="modal"'
                    . ' type="button"'
                    . ' data-bs-target="#ModalEdit' . $modalId . '">'
                    . '<span class="icon-pen-square" aria-hidden="true"></span> ' . JText::_('JACTION_EDIT')
                    . '</button>';
            }

            // Clear article button
            if ($allowClear) {
                $html .= '<button'
                    . ' class="btn btn-secondary' . ($value ? '' : ' hidden') . '"'
                    . ' id="' . $this->id . '_clear"'
                    . ' type="button"'
                    . ' onclick="window.processModalParent(\'' . $this->id . '\'); return false;">'
                    . '<span class="icon-times" aria-hidden="true"></span> ' . JText::_('JCLEAR')
                    . '</button>';
            }

            // Propagate article button
            if ($allowPropagate && count($languages) > 2) {
                // Strip off language tag at the end
                $tagLength            = (int) strlen($this->element['language']);
                $callbackFunctionStem = substr("jSelectArticle_" . $this->id, 0, -$tagLength);

                $html .= '<button'
                . ' class="btn btn-primary' . ($value ? '' : ' hidden') . '"'
                . ' type="button"'
                . ' id="' . $this->id . '_propagate"'
                . ' title="' . JText::_('JGLOBAL_ASSOCIATIONS_PROPAGATE_TIP') . '"'
                . ' onclick="Joomla.propagateAssociation(\'' . $this->id . '\', \'' . $callbackFunctionStem . '\');">'
                . '<span class="icon-sync" aria-hidden="true"></span> ' . Text::_('JGLOBAL_ASSOCIATIONS_PROPAGATE_BUTTON')
                . '</button>';
            }

            if ($allowSelect || $allowNew || $allowEdit || $allowClear) {
                $html .= '</span>';
            }

            // Select article modal
            if ($allowSelect) {
                $html .= HTMLHelper::_(
                    'bootstrap.renderModal',
                    'ModalSelect' . $modalId,
                    [
                        'title'      => $modalTitle,
                        'url'        => $urlSelect,
                        'height'     => '400px',
                        'width'      => '800px',
                        'bodyHeight' => 70,
                        'modalWidth' => 80,
                        'footer'     => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
                                            . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
                    ]
                );
            }

            // New article modal
            if ($allowNew) {
                $html .= HTMLHelper::_(
                    'bootstrap.renderModal',
                    'ModalNew' . $modalId,
                    [
                        'title'       => JText::_('COM_CONTENT_NEW_ARTICLE'),
                        'backdrop'    => 'static',
                        'keyboard'    => false,
                        'closeButton' => false,
                        'url'         => $urlNew,
                        'height'      => '400px',
                        'width'       => '800px',
                        'bodyHeight'  => 70,
                        'modalWidth'  => 80,
                        'footer'      => '<button type="button" class="btn btn-secondary"'
                                . ' onclick="window.processModalEdit(this, \'' . $this->id . '\', \'add\', \'article\', \'cancel\', \'item-form\'); return false;">'
                                . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>'
                                . '<button type="button" class="btn btn-primary"'
                                . ' onclick="window.processModalEdit(this, \'' . $this->id . '\', \'add\', \'article\', \'save\', \'item-form\'); return false;">'
                                . JText::_('JSAVE') . '</button>'
                                . '<button type="button" class="btn btn-success"'
                                . ' onclick="window.processModalEdit(this, \'' . $this->id . '\', \'add\', \'article\', \'apply\', \'item-form\'); return false;">'
                                . JText::_('JAPPLY') . '</button>',
                    ]
                );
            }

            // Edit article modal
            if ($allowEdit) {
                $html .= HTMLHelper::_(
                    'bootstrap.renderModal',
                    'ModalEdit' . $modalId,
                    [
                        'title'       => JText::_('COM_CONTENT_EDIT_ARTICLE'),
                        'backdrop'    => 'static',
                        'keyboard'    => false,
                        'closeButton' => false,
                        'url'         => $urlEdit,
                        'height'      => '400px',
                        'width'       => '800px',
                        'bodyHeight'  => 70,
                        'modalWidth'  => 80,
                        'footer'      => '<button type="button" class="btn btn-secondary"'
                                . ' onclick="window.processModalEdit(this, \'' . $this->id . '\', \'edit\', \'article\', \'cancel\', \'item-form\'); return false;">'
                                . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>'
                                . '<button type="button" class="btn btn-primary"'
                                . ' onclick="window.processModalEdit(this, \'' . $this->id . '\', \'edit\', \'article\', \'save\', \'item-form\'); return false;">'
                                . JText::_('JSAVE') . '</button>'
                                . '<button type="button" class="btn btn-success"'
                                . ' onclick="window.processModalEdit(this, \'' . $this->id . '\', \'edit\', \'article\', \'apply\', \'item-form\'); return false;">'
                                . JText::_('JAPPLY') . '</button>',
                    ]
                );
            }

            // Note: class='required' for client side validation.
            $class = $this->required ? ' class="required modal-value"' : '';

            $html .= '<input type="hidden" id="' . $this->id . '_id" ' . $class . ' data-required="' . (int) $this->required . '" name="' . $this->name
                . '" data-text="' . htmlspecialchars(JText::_('COM_CONTENT_SELECT_AN_ARTICLE'), ENT_COMPAT, 'UTF-8') . '" value="' . $value . '">';

            return $html;



        }

        /**
         * Method to get the field label markup.
         *
         * @return  string  The field label markup.
         *
         * @since   3.4
         */
        public function getLabel()
        {
            return str_replace($this->id, $this->id . '_id', parent::getLabel());
        }
    }
} else if (version_compare(JVERSION, "4.0.0-alpha10", "ge") && version_compare(JVERSION, "4.4.4", "le") ) {
    class JFormFieldModal_Article_BL extends Joomla\Component\Content\Administrator\Field\Modal\ArticleField
{

        protected $type = 'Modal_Article_BL';
        protected $fieldname = 'Modal_Article_BL';
        /**
         * Method to get the field input markup.
         *
         * @return  string  The field input markup.
         *
         * @since   1.6
         */

        // public function __construct() {
        public function __construct($id_article_book,&$db) {
            
            $this->name = 'OnlineArticle';
            
            $allowNew = $this->element['new'] = 'true';
            $allowEdit   = $this->element['edit'] = 'true';
            $allowClear  = $this->element['clear'] = 'true';
            $allowSelect = $this->element['select'] = 'true';
            $allowLanguage = $this->element['language'] = '*'; //need more check, may be need set current language local like: JFactory::getLanguage()->getLocale(); 

            if ($id_article_book > 0) {
                $this->value =  $id_article_book ;
                $this->id =  $id_article_book ;
            }

            $this->setDatabase($db);
        }
        
        public function getInput()
        {
        
            $this->name = 'OnlineArticle';                                      
            $this->element['propagate'] = false;
            
            return parent::getInput();
        }

        /**
         * Method to get the field label markup.
         *
         * @return  string  The field label markup.
         *
         * @since   3.4
         */
        public function getLabel()
        {
            //return str_replace($this->id, $this->id . '_id', parent::getLabel());
        }
    }
} else  if (version_compare(JVERSION, "4.0.0-alpha10", "le")  ) {
   class JFormFieldModal_Article_BL extends JFormFieldModal_Article
    {

        protected $type = 'Modal_Article_BL';
        protected $fieldname = 'Modal_Article_BL';

	/**
	 * Method to get the field input markup.
         *
	 * @return  string  The field input markup.
	 *
	 * @since   1.6

	 */
    // public function __construct() {
	public function __construct($id_article_book = 0) {
		
		$this->name = 'OnlineArticle';
		
		$allowNew = $this->element['new'] = 'true';
		$allowEdit   = $this->element['edit'] = 'true';
		$allowClear  = $this->element['clear'] = 'true';
		$allowSelect = $this->element['select'] = 'true';
        $allowLanguage = $this->element['language'] = '*'; //need more check, may be need set current language local like: JFactory::getLanguage()->getLocale(); 

        if ($id_article_book > 0) {
            $this->value =  $id_article_book ;
            $this->id =  $id_article_book ;
        }
	}


	public function getInput()
	{
	
		$this->name = 'OnlineArticle';										
		
		return parent::getInput();
	}

	/**
	 * Method to get the field label markup.
	 *
	 * @return  string  The field label markup.
	 *
	 * @since   3.4
	 */
	public function getLabel()
	{
		return str_replace($this->id, $this->id . '_id', parent::getLabel());
        }
	}
}
