<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */

if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );
if(!defined('DS'))  define('DS', DIRECTORY_SEPARATOR);

/**
* mosBlSefurl database table class
*/
jimport( 'joomla.database.table');
class mosBlSefurl extends JTable {


//keys
  /** @var int Primary key */
  var $id=null;
  /** @var BLOB */
  var $ser_url_segments=null;
  /** @var varchar(35) */
  var $hash_url_segments=null;
  /** @var BLOB */
  var $ser_vars=null;
  /** @var varchar(35) */
  var $hash_vars=null;
  /** @var varchar(55) */
  var $lang=null;
  /** @var datetime */
  var $date=null;
  /** @var int */
  var $hits=null;
  /** @var boolean */
  var $published=null;


  /**
  * @param database - A database connector object
  */
  function __construct( &$db ) {
    parent::__construct( '#__booklibrary_sef_urls', 'id', $db );
  }

  function loadByHashUrlSegments($hash){

    $this->_db->setQuery("SELECT id FROM #__booklibrary_sef_urls WHERE hash_url_segments = '$hash' ");
    $id = intval( $this->_db->loadResult() );
    if ($id) {
      $this->load($id );

      //if url not exist, remove it
      if( !$this->check_url_exist() ){
        return null;
      }

      //if url exist, update it date
      $this->date = date("Y-m-d H:i:s") ;
      $this->store();
      return $this;
    }
    else return null;
  }

  function loadByHashVars($hash){

    $this->_db->setQuery("SELECT id FROM #__booklibrary_sef_urls WHERE hash_vars = '$hash' ");
    $id = intval( $this->_db->loadResult() );
    if ($id) {
      $this->load($id );

      //if url not exist, remove it
      if( !$this->check_url_exist() ){
        return null;
      }

      //if url exist, update it date
      $this->date = date("Y-m-d H:i:s") ;
      $this->store();
      return $this;
    }
    else return null;
  }

  function check_url_exist(){

    $var_array = unserialize($this->ser_vars)  ;

    if(  isset($var_array['id']) 
        && ( $var_array['task'] == 'view' || $var_array['task'] == 'view_bl' ) ){
      //if link to book = check so book exist ?
      $selectstring = "SELECT id FROM #__booklibrary WHERE id = ". $var_array['id'];
      $this->_db->setQuery($selectstring);
      $itemData = $this->_db->LoadRow();
 // echo ":111111111111111111111111:";
 // print_r($this->ser_vars);
 // exit;
      if( isset($itemData) && count($itemData) > 0 ) return $this;

      //if book not exist - remove this url
      $this->delete();
      return false;

    }else if(  isset($var_array['id']) && $var_array['task'] == 'view_author' ){
      //if link to author = check so author exist ?
      $selectstring = "SELECT id FROM #__booklibrary_authors WHERE id = ". $var_array['id'];
      $this->_db->setQuery($selectstring);
      $itemData = $this->_db->LoadRow();
 // echo ":111111111111111111111111:";
 // print_r($this->ser_vars);
 // exit;
      if( isset($itemData) && count($itemData) > 0 ) return $this;
//echo ":111111111111111111111111 11:"; exit;
      //if author not exist - remove this url
      $this->delete();
      return false;

    }else if( isset($var_array['catid']) && ( $var_array['task'] != "search" && $var_array['task'] != "show_search" )  ){
      //if link to CATEGORY = check so category exist ?
      $selectstring = "SELECT  c.id FROM #__booklibrary_main_categories AS c "
                      . " WHERE c.id = " . intval($var_array['catid']);
      $this->_db->setQuery($selectstring);
      $catData = $this->_db->LoadRow();

      if( isset($catData) && count($catData) > 0 ) return $this;

      //if category not exist - remove this url
      $this->delete();
      return false;
    }

    return true;
  }
}
