<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');
if (!function_exists('userGID_BL')) {

    function userGID_BL($oID) {
        global $database, $ueConfig;
 
            if ($oID > 0) {
                $query = "SELECT group_id FROM #__user_usergroup_map WHERE user_id  = '" . $oID . "'";
                $database->setQuery($query);
                $gids = $database->loadAssocList();
                if (count($gids) > 0) {
                    $ret = '';
                    foreach ($gids as $gid) {
                        if ($ret != "")
                            $ret .=',';
                        $ret .= $gid['group_id'];
                    }
                    return $ret;
                }
                else
                    return -2;
            }
            else
                return -2;
     
    }

}

if (!function_exists('get_group_children_bl')) {

    function get_group_children_bl() {
        global $acl, $database;
        $groups['-2'] = ('Everyone');

            $query = 'SELECT `id`,`title` FROM #__usergroups';
            $database->setQuery($query);
            $rows = $database->loadObjectList();
            foreach ($rows as $k => $v) {
                $id_group = $rows[$k]->id;
                $group_name = $rows[$k]->title;
                $groups[$id_group] = $group_name;
            }
            return $groups;
   
    }

}

use Joomla\CMS\Helper\UserGroupsHelper;

if (!function_exists('get_group_children_tree_bl')) {

    function get_group_children_tree_bl() {
        global $acl, $mosConfig_absolute_path;
        $gtree[] = mosHTML :: makeOption('-2', 'Everyone');
     
            $group_children_tree = array();
            if (version_compare(JVERSION, "4.0.0-alpha10", "ge")) {
                jimport('joomla.cms.helper.usergroupshelper');
                $options = UserGroupsHelper::getInstance()->getAll();
            } else {
                include_once($mosConfig_absolute_path . '/administrator/components/com_users/models/groups.php');
                $model = JModelLegacy::getInstance('Groups', 'UsersModel', 
                    array('ignore_request' => true));
                $options = $model->getItems();
            }
            foreach ($g = $options as $k => $v) { // $g contains basic usergroup items info
                $group_title = '.';
                for ($i = 1; $i <= $g[$k]->level; $i++)
                    $group_title .= '-';
                $group_title .= '-' . $g[$k]->title;
                $group_children_tree[] = mosHTML :: makeOption($g[$k]->id, $group_title);
            }
            $gtree = array_merge($gtree, $group_children_tree);
            return $gtree;
       
    }

}

if (!function_exists('positions_bl')) {

    function positions_bl($position) {
  
  
            $err_state = ini_get('display_errors');
            $plug_row = new stdClass() ;
            ini_set('display_errors', 'Off');
            $plug_row->text = $position; // load the var into plugin_row object
            // Include the content plugins for the change of content state event.
            JPluginHelper::importPlugin('content');
            // Class 'JDispatcher' not found: JDispatcher deprecated J >= 4.0. Use JFactory::getApplication()->triggerEvent(...) instead
            $offset = 0;
            $plug_params = 1;
            if ( version_compare(JVERSION, "4.0.0-alpha10", "ge") ) { 
                // Trigger the onContentPrepare event.
                JFactory::getApplication()->triggerEvent('onContentPrepare', array("com_booklibrary", $plug_row, $plug_params,$offset));
            } else {

            // Class 'JDispatcher' not found: JDispatcher deprecated J >= 4.0. Use JFactory::getApplication()->triggerEvent(...) instead
             $dispatcher = JDispatcher::getInstance();
             $results = $dispatcher->trigger('onContentPrepare', array('com_booklibrary', &$plug_row, &$plug_params, $offset)); //run mambot nPrepareContent on plug_row object
            }

            echo $plug_row->text; //echo new content out
            ini_set('display_errors', $err_state);
  
    }

}

if (!function_exists('set_menu_metatags_bl')) {
    function set_menu_metatags_bl($Itemid) {
        global $database,$task,$doc  ;

        $app = JFactory::getApplication();
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $conf = $app->getConfig();
        } else {
            $conf = JFactory::getConfig(); //old 09/2022
        }    

        $menu = new JTableMenu($database);
        if($Itemid == 0 ) $Itemid = $app->getMenu()->getActive()->id ;
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);


        //check:
        //- this some menu item 
        // - not some child task for that menu item 
        if ( is_menu_item_bl($Itemid) )  {

            $page_title = '';
            if(  $params->get('page_title') !== null &&  trim($params->get('page_title')) != "" ){
              $doc->setTitle( trim($params->get('page_title')) );
              $page_title = trim($params->get('page_title') ) ;
            } else{
              if ($app->getParams()->get('page_title') !='') $page_title = $app->getParams()->get('page_title');
              else $page_title = $app->getMenu()->getActive()->title;
            }  
            $doc->setTitle( $page_title );

            if( $params->get('menu-meta_keywords') !== null && trim($params->get('menu-meta_keywords')) != "" ){
              $doc->setMetaData('keywords', trim($params->get('menu-meta_keywords')) );           
            }   
              
            if( $params->get('menu-meta_description') !== null && trim($params->get('menu-meta_description')) != "" ){
              $doc->setMetaData('description', trim($params->get('menu-meta_description')) );
            } 
          
            if( $params->get('robots') !== null && trim($params->get('robots')) != "" ){
                $doc->setMetaData('robots', trim($params->get('robots')) ) ;
            } else if( $conf->get('robots') !== null && trim($conf->get('robots')) != "" ){
                $doc->setMetaData('robots', trim($conf->get('robots')) ) ;
            } else {
                $doc->setMetaData('robots', 'index, follow' ) ;
            }


            //we set all OK
            return true;
        }

        //we set nothing
        return false;
          
    }

}

if (!function_exists('get_menu_header_bl')) {

    function get_menu_header_bl($Itemid) {
        global $database,$task  ;

        $app = JFactory::getApplication();

        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

      
        $page_heading = "" ;
        if( $params->get('show_page_heading') == 1 
            && $params->get('page_heading') != null
            && trim($params->get('page_heading')) != "" ){
            
            $menu_item = $app->getMenu()->getItem($Itemid);
            $query_view = $menu_item->query['view'] ;

            //if in some menu item but not in child
            if ( is_menu_item_bl($Itemid))  {
                  $page_heading = trim($params->get('page_heading')) ;
            }
        }  


        return $page_heading ;
    }

}

if (!function_exists('get_menu_url_alias_bl')) {

    function get_menu_url_alias_bl($Itemid,$task,$view) {
        global $database  ;

        $app = JFactory::getApplication();

        $menu_item = $app->getMenu()->getItem($Itemid);

        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);


        $url_alias = "" ;

        //if in some menu item but not in child
        if (  is_menu_item_bl($Itemid)  )  {
              $url_alias = trim( $menu->alias ) ;
        }


        return $url_alias ;
    }

}

//if this not menu, as example we show house for menu all-house, return false
//if menu: all-house, and show all-houses - return true 
// $from_view - we may set Vew name from which we call this function
//so if $from_view == $task - this view main - not child
if (!function_exists('is_menu_item_bl')) {
    function is_menu_item_bl($Itemid, $from_view = "") {
        global $database,$task  ;

        $app = JFactory::getApplication();

        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        $menu_item = $app->getMenu()->getItem($Itemid);
        $query_view = $menu_item->query['view'] ;

        $single_category = $params->get('single_category') ;
        $catid = $app->input->getInt('catid', null);
        $book_id = $params->get('book');
        $id = $app->input->getInt('id', null);
        $author_id = $params->get('author');

     //echo ":1111111111111111111112222222:".$view."::".$task."::".$view."::".$single_category."::".$catid."::";

        //if in some menu item but not in child
        if (isset( $view ) && isset( $view ) && $view == $query_view  &&  ( 
            ( $view == 'categories' && ( $task == "all_category" || $task == "categories" )  ) 
            || ($view == 'all_authors' && $task == $view )  
            || ($view == 'books' && $task == $view ) 
            || ($view == 'owners_list' && ($task == "owners_list" || $task == "ownerslist" ) ) 
            || ($view == 'show_search_book' && ($task == "show_search_book" || $task == "show_search" ) )
            || ($view == 'owner_books' && ($task == "owner_books" || $task == "showownerbooks" || $task == "view_user_books" ) && $params->get('username') !== null ) 
            || ($view == 'showCategory' && ($task == "showCategory" || $task == "alone_category" ) && $single_category !== null && $catid == null ) 
            || ($view == 'view_book' && ($task == "view_book" || $task == "view_bl" || $task == "view" ) && $book_id !== null && ($id == null || $book_id == $id )  ) 
            || ($view == 'view_author' && $task == "view_author" && $author_id !== null && ($id == null || $author_id == $id )) 
            ) )  {

             return true ;
        }

        return false ;
    }

}

if (!function_exists('catOrderDownIcon')) {

    function catOrderDownIcon($i, $n, $index, $task = 'orderdown', $alt = 'Move Down') {
        global $templateDir, $mosConfig_live_site;
        if ($i < $n - 1) {
            return '<a href="#reorder" 
                onclick="return listItemTask(\'cb' . $index . '\',\'' . $task . '\')" 
                title="' . $alt . '">
                <img src="' . $mosConfig_live_site . 
                '/components/com_booklibrary/images/down.png" border="0" alt="' . $alt . '" />
                </a>';
        } else
            return '&nbsp;';
    }

}

if (!function_exists('catOrderUpIcon')) {

    function catOrderUpIcon($i, $index, $task = 'orderup', $alt = 'Move Up') {
        global $templateDir, $mosConfig_live_site;
        if ($i > 0) {
            return '<a href="#reorder" 
                onclick="return Joomla.listItemTask(\'cb' . $index . '\',\'' . $task . '\')" 
                title="' . $alt . '">
                <img src="' . $mosConfig_live_site . 
                '/components/com_booklibrary/images/up.png" border="0" alt="' . $alt . '" />
                </a>';
        } else
            return '&nbsp;';
    }

}

if (!defined('_BOOKLIBRARY_COMPAT_FILE_LOADED')) {

    define('_BOOKLIBRARY_COMPAT_FILE_LOADED', 1);

    if (class_exists('JConfig')) {
        // These are needed when the Joomla! 1.5 legacy plugin is not enabled
        if (!defined('_JLEGACY')) {
            // TODO: determine what else is needed to work without the legacy plugin
            $mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
            include_once($mosConfig_absolute_path . 
                "/components/com_booklibrary/functions.php");

            if (!class_exists('mosHTML')) {
                include_once($mosConfig_absolute_path . 
                    "/components/com_booklibrary/includes/html.php");
            }

            if (!class_exists('JComponentHelper') && !isset($mainframe)) {
                include_once ( JPATH_BASE . DS . 'includes' . DS . 'defines.php' );
                include_once ( JPATH_BASE . DS . 'includes' . DS . 'framework.php' );
                $mainframe = JFactory::getApplication(defined('_VM_IS_BACKEND') ? 'administrator' : 'site');
            }
            jimport('joomla.application.component.helper');
            if (class_exists('JComponentHelper')) {
                $usersConfig = JComponentHelper::getParams('com_users');
                $contentConfig = JComponentHelper::getParams('com_content');
                // User registration settings
                $mosConfig_allowUserRegistration = $GLOBALS['mosConfig_allowUserRegistration'] = 
                    $usersConfig->get('allowUserRegistration');
                $mosConfig_useractivation = $GLOBALS['mosConfig_useractivation'] = 
                    $usersConfig->get('useractivation');

                // TODO: Do we need these? They are set in the template.
                // Icon display settings
                // (hide pdf, etc has been changed to *show* pdf, etc in J! 1.5)
                $mosConfig_icons = $contentConfig->get('show_icons');
                $mosConfig_hidePdf = 1 - intval($contentConfig->get('show_pdf_icon'));
                $mosConfig_hidePrint = 1 - intval($contentConfig->get('show_print_icon'));
                $mosConfig_hideEmail = 1 - intval($contentConfig->get('show_email_icon'));
            }
            $jconfig = new JConfig();

            // Settings from the Joomla! configuration file 
            foreach (get_object_vars($jconfig) as $k => $v) {
                $name = 'mosConfig_' . $k;
                $$name = $GLOBALS[$name] = $v;
            }

            // Paths
            if (isset($mainframe) && is_object($mainframe)) {
                // $url = $mainframe->isAdmin() ? $mainframe->getSiteURL() : JURI::base();
                $url = $mainframe->isClient('administrator') ? $mainframe->getSiteURL() : JURI::base();
            } else {
                $url = JURI::base();
            }

            $mosConfig_live_site = $GLOBALS['mosConfig_live_site'] = JURI::root(true);
            $mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
            $mosConfig_cachepath = $GLOBALS['mosConfig_cachepath'] = JPATH_BASE . DS . 'cache';

            if (!isset($option)) {
                $jinput = JFactory::getApplication()->input;
                // $option = strtolower(JRequest::getCmd('option', 'com_booklibrary'));
                $option = strtolower($jinput->getCmd('option', 'com_booklibrary'));
            }

            // The selected language
            $lang = JFactory::getLanguage();

            // $database is directly needed by some functions, so we need to create it here. 
            $GLOBALS['database'] = $database = JFactory::getDBO();

            // The $my (user) object
            if (version_compare(JVERSION, "4.0.0", "ge")) {
                $app = JFactory::getApplication();
                $GLOBALS['my'] = $app->getIdentity();
            } else {
                $GLOBALS['my'] = JFactory::getUser(); //old 09/2022
            }

            // The permissions object
            // deprecated in Joomla 4.0 - Use JAccess directly:
            // $acl = JFactory::getACL(); 
            $acl = new JAccess; 
            $GLOBALS['acl'] = $acl;

            // Version information
            $_VERSION = $GLOBALS['_VERSION'] = new JVersion();

            if (!function_exists('sefreltoabs')) {

                function sefRelToAbs($value) {
                    //Need check!!!
                    //Create a file "router.php" inside /components/com_virtuemart/
                    //$router = JRouter::getInstance('virtuemart');
                    //return $router->build($url);
                    // Replace all &amp; with & as the router doesn't understand &amp;
                    $url = str_replace('&amp;', '&', $value);
                    if (substr(strtolower($url), 0, 9) != "index.php")
                        return $url;
                    $uri = JURI::getInstance();
                    $prefix = $uri->toString(array('scheme', 'host', 'port'));
                    return $prefix . JRoute::_($url);
                }
            }
            
            if (!function_exists('editorArea')) {
                function editorArea($name, $content, $hiddenField, $width, $height, $col, $row, $options = true) {
                    if (version_compare(JVERSION, "4.0.0-alpha10", "ge")) {
                        jimport('joomla.html.editor');

                        // get user's default editor
                        if (version_compare(JVERSION, "4.0.0", "ge")) {
                            $app = JFactory::getApplication();
                            $conf = $app->getConfig();
                            $user_editor = $app->getIdentity()->getParam("editor");
                        } else {
                            $conf = JFactory::getConfig(); //old 09/2022
                            $user_editor = JFactory::getUser()->getParam("editor"); //old 09/2022
                        }                         

                        // get editor selected in global settings:
                        $global_editor = $conf->get( 'editor' );

                        if($user_editor && $user_editor !== 'JEditor') {
                            $selected_editor = $user_editor;
                        } else {
                            $selected_editor = $global_editor;
                        }
                        $editor = JEditor::getInstance($selected_editor);
                        // display(string $name, string $html, string $width, string $height, integer $col, integer $row, boolean $buttons = true, string $id = null, string $asset = null, object $author = null, array $params = array()) : string
                        echo $editor->display($hiddenField, $content, $width, $height, $col, $row, $options);
                    } else {
                        jimport('joomla.html.editor');
                        $editor = JFactory::getEditor();
                        echo $editor->display($hiddenField, $content, $width, $height, $col, $row, $options);
                    }
                }
            }


            // Load the menu bar class
            JLoader::register('mosMenuBar_ext', $mosConfig_absolute_path . DS . 'administrator' . 
                DS . 'components' . DS . 'com_booklibrary' . DS . 'menubar_ext.php');
            // Load the user class
            JLoader::register('mosUser', $mosConfig_absolute_path . DS . 'plugins' . DS . 'system' . 
                DS . 'legacy' . DS . 'user.php');
        } else {
            // We need these even when the Joomla! 1.5 legacy plugin is enabled
            // We need to set these when we don't enter as a component or module (like in notify.php)
            if (!isset($usersConfig)) {
                $usersConfig = JComponentHelper::getParams('com_users');
            }
            if (!isset($contentConfig)) {
                $contentConfig = JComponentHelper::getParams('com_content');
            }

            // Paths
            // These are in the legacy plugin as globals, but we need them locally too
            $mosConfig_live_site = $GLOBALS['mosConfig_live_site'];

            $mosConfig_cachepath = $GLOBALS['mosConfig_cachepath'];

            // User registration settings
            $mosConfig_allowUserRegistration = $GLOBALS['mosConfig_allowUserRegistration'] = 
                $usersConfig->get('allowUserRegistration');

            $mosConfig_useractivation = $GLOBALS['mosConfig_useractivation'] =
                $usersConfig->get('useractivation');

            // TODO: Do we need these? They are set in the template.
            // Icon display settings
            // hide pdf, etc has been changed to show pdf, etc in J! 1.5

            $mosConfig_icons = $contentConfig->get('show_icons');
            $mosConfig_hidePdf = 1 - intval($contentConfig->get('show_pdf_icon'));
            $mosConfig_hidePrint = 1 - intval($contentConfig->get('show_print_icon'));
            $mosConfig_hideEmail = 1 - intval($contentConfig->get('show_email_icon'));

            // TODO: Do we still need this in the latest J! 1.5 SVN?
            // Adjust the time offset
            //		$server_time = date( 'O' ) / 100;
            //		$offset = $mosConfig_offset - $server_time;
            //		$GLOBALS['mosConfig_offset'] = $offset;
            // Version information
            $_VERSION = $GLOBALS['_VERSION'];
        }
    }
}
