<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
 if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');
/**
 * Legacy function, use <jdoc:include type="module" /> instead
 *
 * @deprecated    As of version 1.5
 */
if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
if (isset($GLOBALS['mosConfig_absolute_path'])) $mosConfig_absolute_path = 
    $GLOBALS['mosConfig_absolute_path'];
else $mosConfig_absolute_path = JPATH_SITE; //JURI::base(true); // if file is calling from the module
include_once ($mosConfig_absolute_path . DS . 'components' . DS . 'com_booklibrary' . 
    DS . 'booklibrary.class.main.categories.php');

require_once ($mosConfig_absolute_path . DS . 'components' . DS . 'com_booklibrary' . 
    DS . 'booklibrary.class.authors.php');

jimport('joomla.html.pagination');
if (!isset($GLOBALS['booklibrary_configuration'])) {
    require_once (JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booklibrary' . 
        DS . 'admin.booklibrary.class.conf.php');
    $GLOBALS['booklibrary_configuration'] = $booklibrary_configuration;
}


/**
 * function, included all PHP files from some folder
 */
if(!function_exists("auto_include")){
    function auto_include($path_to_files)
    {
        //for absolut path
        $component_path = JPath::clean( $path_to_files);
        if (is_dir($component_path) && ($files_in_folder = JFolder::files($component_path, '^[^-]*\.php$', false, true))) {
            foreach ($files_in_folder as $i => $file) {
                require_once($file);
            }
        }else{
            //for relative path
            $component_path = JPath::clean(JPATH_SITE . $path_to_files);
            if (is_dir($component_path) && ($files_in_folder = JFolder::files($component_path, '^[^-]*\.php$', false, true))) {
                foreach ($files_in_folder as $i => $file) {
                    require_once($file);
                }
            }            
        }
    }
}

if (!function_exists('mosLoadModule')) {
    function mosLoadModule($name, $style = - 1) {
?><jdoc:include type="module" name="<?php echo $name ?>" style="<?php echo $style ?>" /><?php
    }
}

if (!function_exists('checkJavaScriptIncluded')) {
  function checkJavaScriptIncluded($name) {

      $doc = JFactory::getDocument();

      foreach($doc->_scripts as $script_path=>$value){
        if(strpos( $script_path, $name ) !== false ) return true ;
      }
      return false;
  }
}

if (!function_exists('checkStylesIncludedBl')) {
  function checkStylesIncludedBl($name) {

      $doc = JFactory::getDocument();

      foreach($doc->_styleSheets as $script_path=>$value){
        if(strpos( $script_path, $name ) !== false ) return true ;
      }
      return false;
  }
}


if (!function_exists('os_hide_left_panel')) {

   function os_hide_left_panel() {
      if (version_compare(JVERSION, "4.0.0-alpha10", "lt")) {

      } else {
        $input = JFactory::getApplication()->input;
        $input->set('hidemainmenu', true);
      }
   }

}

if (!function_exists('checktype')) {
    function checktype($ext, $filename, $i) {
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        // $file['type'] = $_FILES[$filename . $i]['type'];
        $file['type'] = $finfo->file( $_FILES[$filename . $i]['tmp_name'] );
        
        $db = JFactory::getDbo();
        $db->setQuery("SELECT mime_type 
                       FROM #__booklibrary_mime_types 
                       WHERE `mime_ext` = " . $db->quote($ext));
        $file_db_mime = $db->loadColumn();
        
        // if ($file_db_mime != $file['type']) {
        if ( !in_array( $file['type'], $file_db_mime ) ) {
            echo "<script> alert(' " . _BOOKLIBRARY_FILE_MIME_TYPE_NOT_MATCH
                . " - " . $_FILES[$filename . $i]['name'] . "'); window.history.go(-1); </script>\n";
            exit();
        } else {
            // return $file_db_mime;
            return $file['type'];
        }
    }
}
if (!function_exists('checktypeUrl')) {
    function checktypeUrl($ext) {
        $db = JFactory::getDbo();
        $db->setQuery("SELECT mime_type 
                       FROM #__booklibrary_mime_types 
                       WHERE `mime_ext` = " . $db->quote($ext));
        $db_mime = $db->loadResult();
        if (!$db_mime) {
            return $type = "unknown";
        } else {
            return $db_mime;
        }
    }
}
//***************Globally/Universally Unique Identifier****************************
if (!function_exists('storeTrack')) {
    function storeTrack(&$book) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        $jinput = JFactory::getApplication()->input;
        for ($i = 1;isset($_FILES['new_upload_track' . $i]) 
                || array_key_exists('new_upload_track_url' . $i, $_POST);$i++) {
            if (isset($_FILES['new_upload_track' . $i]) 
                    && $_FILES['new_upload_track' . $i]['name'] != "") {
                //storing e-Document
                // $track = $jinput->get('new_upload_track' . $i, '', 'files');
                //$track = $jinput->files->get('new_upload_track' . $i, '', 'files');
                $ext = pathinfo($_FILES['new_upload_track' . $i]['name'], PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $allowed_exts = explode(",", $booklibrary_configuration['allowed_exts_track']);
                if (!in_array($ext, $allowed_exts)) {
                    echo "<script> alert(' File ext. not allowed to upload! - " . $ext . "');
                           window.history.go(-1); </script>\n";
                    exit();
                }
                $type = checktype($ext, 'new_upload_track', $i);
                $code = guid();
                $track_name = $code . '_' . filter($_FILES['new_upload_track' . $i]['name']);
                //mime_content_type($file_name);
                //if( !isset($_FILES['new_upload_file'.$i]) ) continue;
                if (intval($_FILES['new_upload_track' . $i]['error']) > 0 && intval($_FILES['new_upload_track' . $i]['error']) < 4) {
                    echo "<script> alert('" . _BOOKLIBRARY_LABEL_TRACK_UPLOAD_ERROR . " - " . 
                        $track_name . "'); window.history.go(-1); </script>\n";
                    exit();
                } else if (intval($_FILES['new_upload_track' . $i]['error']) != 4) {
                    $track_new = $mosConfig_absolute_path . 
                        $booklibrary_configuration['tracks']['location'] . $track_name;
                    if (!move_uploaded_file($_FILES['new_upload_track' . $i]['tmp_name'], $track_new)) {
                        echo "<script> alert('" . _BOOKLIBRARY_LABEL_TRACK_UPLOAD_ERROR . " - " . 
                            $track_name . "'); window.history.go(-1); </script>\n";
                        exit();
                    }
                }
                if (array_key_exists('new_upload_track_kind' . $i, $_POST) 
                        && $_POST['new_upload_track_kind' . $i] != "") {
                    $uploadTrackKind = $jinput->get('new_upload_track_kind' . $i, '', 'post');
                    $uploadTrackKind = strip_tags(trim($uploadTrackKind));
                }
                if (array_key_exists('new_upload_track_scrlang' . $i, $_POST) 
                        && $_POST['new_upload_track_scrlang' . $i] != "") {
                    $uploadTrackScrlang = $jinput->get('new_upload_track_scrlang' . $i, '', 'post');
                    $uploadTrackScrlang = strip_tags(trim($uploadTrackScrlang));
                }
                if (array_key_exists('new_upload_track_label' . $i, $_POST)
                        && $_POST['new_upload_track_label' . $i] != "") {
                    $uploadTrackLabel = $jinput->get('new_upload_track_label' . $i, '', 'post');
                    $uploadTrackLabel = strip_tags(trim($uploadTrackLabel));
                }
                saveTracks($book->id, $track_name, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel);
            }
            if (array_key_exists('new_upload_track_url' . $i, $_POST) 
                    && $_POST['new_upload_track_url' . $i] != "") {
                if (isset($_FILES['new_upload_track' . $i]) 
                        && $_FILES['new_upload_track' . $i]['name'] == "") {
                    $uploadTrackURL = $jinput->get('new_upload_track_url' . $i, '', 'post');
                    $uploadTrackURL = strip_tags(trim($uploadTrackURL));
                    if (array_key_exists('new_upload_track_kind' . $i, $_POST) 
                            && $_POST['new_upload_track_kind' . $i] != "") {
                        $uploadTrackKind = $jinput->get('new_upload_track_kind' . $i, '', 'post');
                        $uploadTrackKind = strip_tags(trim($uploadTrackKind));
                    }
                    if (array_key_exists('new_upload_track_scrlang' . $i, $_POST) 
                            && $_POST['new_upload_track_scrlang' . $i] != "") {
                        $uploadTrackScrlang = $jinput->get('new_upload_track_scrlang' . $i, '', 'post');
                        $uploadTrackScrlang = strip_tags(trim($uploadTrackScrlang));
                    }
                    if (array_key_exists('new_upload_track_label' . $i, $_POST) 
                            && $_POST['new_upload_track_label' . $i] != "") {
                        $uploadTrackLabel = $jinput->get('new_upload_track_label' . $i, '', 'post');
                        $uploadTrackLabel = strip_tags(trim($uploadTrackLabel));
                    }
                    saveTracks($book->id, $uploadTrackURL, $uploadTrackKind, $uploadTrackScrlang, 
                               $uploadTrackLabel);
                }
            }
        }
    }
}
if (!function_exists('storeAudio')) {
    function storeAudio(&$book) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        $jinput = JFactory::getApplication()->input;
        for ($i = 1;isset($_FILES['new_upload_audio' . $i]) 
                || array_key_exists('new_upload_audio_url' . $i, $_POST);$i++) {
            if (isset($_FILES['new_upload_audio' . $i]) 
                    && $_FILES['new_upload_audio' . $i]['name'] != "") {
                //storing e-Document
                // $audio = $jinput->get('new_upload_audio' . $i, '', 'files');
                //$audio = $jinput->files->get('new_upload_audio' . $i, '', 'files');
                $ext = pathinfo($_FILES['new_upload_audio' . $i]['name'], PATHINFO_EXTENSION);
                $allowed_exts = explode(",", $booklibrary_configuration['allowed_exts_audio']);
                $ext = strtolower($ext);
                if (!in_array($ext, $allowed_exts)) {
                    echo "<script> alert(' File ext. not allowed to upload! - " . $ext . "'); 
                           window.history.go(-1); </script>\n";
                    exit();
                }
                $type = checktype($ext, 'new_upload_audio', $i);
                $code = guid();
                $audio_name = $code . '_' . filter($_FILES['new_upload_audio' . $i]['name']);
                //mime_content_type($file_name);
                //if( !isset($_FILES['new_upload_file'.$i]) ) continue;
                if (intval($_FILES['new_upload_audio' . $i]['error']) > 0 && intval($_FILES['new_upload_audio' . $i]['error']) < 4) {
                    echo "<script> alert('" . _BOOKLIBRARY_LABEL_AUDIO_UPLOAD_ERROR . " - " . 
                        $audio_name . "'); window.history.go(-1); </script>\n";
                    exit();
                } else if (intval($_FILES['new_upload_audio' . $i]['error']) != 4) {
                    $audio_new = $mosConfig_absolute_path . 
                        $booklibrary_configuration['audios']['location'] . $audio_name;
                    if (!move_uploaded_file($_FILES['new_upload_audio' . $i]['tmp_name'], $audio_new)) {
                        echo "<script> alert('" . _BOOKLIBRARY_LABEL_AUDIO_UPLOAD_ERROR . " - " . 
                            $audio_name . "'); window.history.go(-1); </script>\n";
                        exit();
                    }
                    saveAudios($audio_name, $book->id, $type);
                }
            }
            if (array_key_exists('new_upload_audio_url' . $i, $_POST) 
                    && $_POST['new_upload_audio_url' . $i] != "") {
                if (isset($_FILES['new_upload_audio' . $i]) 
                        && $_FILES['new_upload_audio' . $i]['name'] == "") {
                    $uploadAudioURL = $jinput->get('new_upload_audio_url' . $i, '', 'post');
                    $uploadAudioURL = strip_tags(trim($uploadAudioURL));
                    $ext = pathinfo($uploadAudioURL, PATHINFO_EXTENSION);
                    $uploadAudioURL = strip_tags(trim($uploadAudioURL));
                    $type = checktypeUrl($ext);
                    saveAudios($uploadAudioURL, $book->id, $type);
                }
            }
        }
    }
}
if (!function_exists('storeVideo')) {
    function storeVideo(&$book) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        $jinput = JFactory::getApplication()->input;
        for ($i = 1;isset($_FILES['new_upload_video' . $i]) 
                || array_key_exists('new_upload_video_url' . $i, $_POST) 
                || array_key_exists('new_upload_video_youtube_code' . $i, $_POST);$i++) {

            if (array_key_exists('new_upload_video_youtube_code' . $i, $_POST)
                    && $_POST['new_upload_video_youtube_code' . $i] != "") {
                $uploadVideoYoutubeCode = $jinput->get('new_upload_video_youtube_code' . 
                    $i, '', 'post');
                $uploadVideoYoutubeCode = strip_tags(trim($uploadVideoYoutubeCode));
                saveYouTubeCode($uploadVideoYoutubeCode, $book->id);
            }
            if (isset($_FILES['new_upload_video' . $i]) 
                    && $_FILES['new_upload_video' . $i]['name'] != "") {
                if (array_key_exists('new_upload_video_youtube_code' . $i, $_POST) 
                        && $_POST['new_upload_video_youtube_code' . $i] == "") {
                    
                    // $video = $jinput->get('new_upload_video' . $i, '', 'files');
                    //$video = $jinput->files->get('new_upload_video' . $i, '', 'files');
                    $ext = pathinfo($_FILES['new_upload_video' . $i]['name'], PATHINFO_EXTENSION);
                    $allowed_exts = explode(",", $booklibrary_configuration['allowed_exts_video']);
                    $ext = strtolower($ext);
                    if (!in_array($ext, $allowed_exts)) {
                        echo "<script> alert(' File ext. not allowed to upload! - " . $ext . "'); 
                               window.history.go(-1); </script>\n";
                        exit();
                    }
                    $type = checktype($ext, 'new_upload_video', $i);
                    $code = guid();
                    $video_name = $code . '_' . filter($_FILES['new_upload_video' . $i]['name']);
                    //mime_content_type($file_name);
                    //if( !isset($_FILES['new_upload_file'.$i]) ) continue;
                    if (intval($_FILES['new_upload_video' . $i]['error']) > 0 && intval($_FILES['new_upload_video' . $i]['error']) < 4) {
                        echo "<script> alert('" . _BOOKLIBRARY_LABEL_VIDEO_UPLOAD_ERROR . " - " . 
                            $video_name . "'); window.history.go(-1); </script>\n";
                        exit();
                    } else if (intval($_FILES['new_upload_video' . $i]['error']) != 4) {
                        $video_new = $mosConfig_absolute_path . 
                            $booklibrary_configuration['videos']['location'] . $video_name;
                        if (!move_uploaded_file($_FILES['new_upload_video' . $i]['tmp_name'], $video_new)) {
                            echo "<script> alert('" . _BOOKLIBRARY_LABEL_VIDEO_UPLOAD_ERROR . " - " . 
                                $video_name . "'); window.history.go(-1); </script>\n";
                            exit();
                        }
                        saveVideos($video_name, $book->id, $type);
                    }
                }
            }
            if (array_key_exists('new_upload_video_url' . $i, $_POST) 
                    && $_POST['new_upload_video_url' . $i] != "") {
                if (array_key_exists('new_upload_video_youtube_code' . $i, $_POST) 
                        && $_POST['new_upload_video_youtube_code' . $i] == "" 
                        && (isset($_FILES['new_upload_video' . $i]) 
                        && $_FILES['new_upload_video' . $i]['name'] == "")) {
                    $uploadVideoURL = $jinput->get('new_upload_video_url' . $i, '', 'post');
                    $ext = pathinfo($uploadVideoURL, PATHINFO_EXTENSION);
                    $uploadVideoURL = strip_tags(trim($uploadVideoURL));
                    $type = checktypeUrl($ext);
                    saveVideos($uploadVideoURL, $book->id, $type);
                }
            }
        }
    }
}
//********************************functions ave/delete ebook **************************************
if (!function_exists('storeEbook')) {
    function storeEbook(&$book) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        $jinput = JFactory::getApplication()->input;
        //check how much files already attachmented
        $efiles_count = 0;
        if (intval($book->id) > 0) {
            $db = JFactory::getDBO();
            $db->setQuery("SELECT count(id) as count 
                           FROM #__booklibrary_files 
                           where fk_book_id=" . $book->id);
            $rows = $db->loadObjectList();
            $efiles_count = intval($rows[0]->count);
        }
        for ($i = 1;isset($_FILES['new_upload_file' . $i]) 
                || array_key_exists('new_upload_file_url' . $i, $_POST);$i++) {
            if (isset($_FILES['new_upload_file' . $i]) 
                    && $_FILES['new_upload_file' . $i]['name'] != "") {
                //storing e-Document
                $ext = pathinfo($_FILES['new_upload_file' . $i]['name'], PATHINFO_EXTENSION);
                $allowed_exts = explode(",", $booklibrary_configuration['allowed_exts']);
                $ext = strtolower($ext);
                if (!in_array($ext, $allowed_exts)) {
                    echo "<script> alert(' File ext. not allowed to upload! - " . $ext . "'); 
                           window.history.go(-1); </script>\n";
                    exit();
                }
                $type = checktype($ext, 'new_upload_file', $i);
                $code = guid();
                $file_name = $code . '_' . filter($_FILES['new_upload_file' . $i]['name']);
                if (intval($_FILES['new_upload_file' . $i]['error']) > 0 && intval($_FILES['new_upload_file' . $i]['error']) < 4) {
                    echo "<script> alert('" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_ERROR . " - " . 
                        $file_name . "'); window.history.go(-1); </script>\n";
                    exit();
                } else if (intval($_FILES['new_upload_file' . $i]['error']) != 4) {
                    $file_new = $mosConfig_absolute_path . 
                        $booklibrary_configuration['ebooks']['location'] . $file_name;
                    if (!move_uploaded_file($_FILES['new_upload_file' . $i]['tmp_name'], $file_new)) {
                        echo "<script> alert('" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_ERROR . " - " . 
                            $file_name . "'); window.history.go(-1); </script>\n";
                        exit();
                    }
                    saveFiles($file_name, $book->id);
                }
            }
            if (array_key_exists('new_upload_file_url' . $i, $_POST) 
                    && $_POST['new_upload_file_url' . $i] != "") {
                if (isset($_FILES['new_upload_file' . $i]) && 
                        $_FILES['new_upload_file' . $i]['name'] == "") {
                    $uploadFileURL = $jinput->get('new_upload_file_url' . $i, '', 'post');
                    $uploadFileURL = strip_tags(trim($uploadFileURL));
                    saveFiles($uploadFileURL, $book->id);
                }
            }
        }
    }
}
if (!function_exists('filter')) {
    function filter($value) {
        $value = str_replace(array("/", "|", "\\", "?", ":", ";", "*", "#", "%", "$", 
                                   "+", "=", ";", " "), "_", $value);
        return $value;
    }
}
if (!function_exists('guid')) {
    function guid() {
        if (function_exists('com_create_guid')) {
            return com_create_guid();
        } else {
            mt_srand((double)microtime() * 10000); //optional for php 4.2.0 and up.
            $charid = strtoupper(md5(uniqid(rand(), true)));
            $hyphen = chr(45); // "-"
            $uuid = //chr(123)// "{"
            substr($charid, 0, 8) . $hyphen . substr($charid, 8, 4) . $hyphen . 
                substr($charid, 12, 4) . $hyphen . substr($charid, 16, 4) . $hyphen . substr($charid, 20, 12);
            //.chr(125);// "}"
            return $uuid;
        }
    }
}
if (!function_exists('saveTracks')) {
    function saveTracks($book_id, $src, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        if ($src != "" && !strstr($src, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_track_source (fk_book_id,src,kind,scrlang,label) 
                           VALUE ($book_id,'" . $booklibrary_configuration['tracks']['location'] . 
                           $src . "','" . $uploadTrackKind . "',
                           '" . $uploadTrackScrlang . "','" . $uploadTrackLabel . "')");
            $db->execute();
        } else if ($src != "" && strstr($src, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_track_source (fk_book_id,src,kind,scrlang,label) 
                           VALUE ($book_id,'" . $src . "','" . $uploadTrackKind . "',
                           '" . $uploadTrackScrlang . "','" . $uploadTrackLabel . "')");
            $db->execute();
        }
    }
}
if (!function_exists('saveAudios')) {
    function saveAudios($src, $book_id, $type) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        if ($src != "" && strstr($src, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_audio_source(fk_book_id,src,type) 
                           VALUE($book_id,'" . $src . "','" . $type . "')");
            $db->execute();
        } else if ($src != "" && !strstr($src, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_audio_source(fk_book_id,src,type) 
                           VALUE($book_id,'" . $booklibrary_configuration['audios']['location'] . 
                            $src . "','" . $type . "')");
            $db->execute();
        }
    }
}
if (!function_exists('saveVideos')) {
    function saveVideos($src, $book_id, $type) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        if ($src != "" && strstr($src, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_video_source(fk_book_id,src,type) 
                           VALUE($book_id,'" . $src . "','" . $type . "')");
            $db->execute();
        } else if ($src != "" && !strstr($src, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_video_source(fk_book_id,src,type) 
                           VALUE($book_id,'" . $booklibrary_configuration['videos']['location'] . 
                           $src . "','" . $type . "')");
            $db->execute();
        }
    }
}
if (!function_exists('saveYouTubeCode')) {
    function saveYouTubeCode($youtube_code, $book_id) {
        $db = JFactory::getDBO();
        $db->setQuery("SELECT youtube 
                       FROM #__booklibrary_video_source 
                       WHERE fk_book_id = $book_id");
        $db->execute();
        $youtube = $db->LoadResult();
        if (!empty($youtube)) {
            $db = JFactory::getDBO();
            $db->setQuery("DELETE FROM #__booklibrary_video_source 
                           WHERE youtube = '" . $youtube . "' AND fk_book_id 
            = $book_id");
            $db->execute();
        }

        $db = JFactory::getDBO();
        $db->setQuery("INSERT INTO #__booklibrary_video_source (fk_book_id,youtube) 
                       VALUE($book_id,'" . $youtube_code . "')");
        $db->execute();
    }
}

if (!function_exists('saveFiles')) {
    function saveFiles($location, $book_id) {
        global $booklibrary_configuration, $mosConfig_absolute_path;
        if ($location != "" && strstr($location, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_files(fk_book_id,location) 
                           VALUE($book_id,'" . $location . "')");
            $db->execute();
        } else if ($location != "" && !strstr($location, "http")) {
            $db = JFactory::getDBO();
            $db->setQuery("INSERT INTO #__booklibrary_files(fk_book_id,location) 
                           VALUE($book_id,'" . $booklibrary_configuration['ebooks']['location'] . 
                           $location . "')");
            $db->execute();
        }
    }
}
if (!function_exists('deleteFiles')) {
    function deleteFiles($book_id, $remove_all_ebook = 0) {
        global $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
        $jinput = JFactory::getApplication()->input;
        $db = JFactory::getDBO();
        $db->setQuery("SELECT id 
                       FROM #__booklibrary_files where fk_book_id = $book_id;");
        $ediles_id = $db->loadColumn();
        $delete_id = array();
        if ($remove_all_ebook) {
            $delete_id = $ediles_id;
        } else {
            foreach($ediles_id as $key => $value) {
                if (isset($_POST['file_option_del' . $value])) {
                    array_push($delete_id, $jinput->get('file_option_del' . $value, '', 'post'));
                }
            }
        }
        if ($delete_id['0']) {
            $del_id = "";
            $sql = "SELECT location 
                    FROM #__booklibrary_files 
                    WHERE id IN (";
            foreach($delete_id as $efl_id) $del_id.= $efl_id . ",";
            $sql.= $del_id . "0)";
            $db->setQuery($sql);
            $efiles = $db->loadColumn();
            if ($efiles) {
                foreach($efiles as $name) {
                    if (substr($name, 0, 4) != "http" && $name != "" ) unlink($mosConfig_absolute_path . $name);
                }
            }
            $sql = "DELETE FROM #__booklibrary_files 
                    WHERE (id IN (" . $del_id . "0)) and (fk_book_id=$book_id)";
            $db->setQuery($sql);
            $db->execute();
        }
    }
}
if (!function_exists('deleteTracks')) {
    function deleteTracks($book_id, $remove_all_track = 0) {
        global $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
        $jinput = JFactory::getApplication()->input;
        $db = JFactory::getDBO();
        $db->setQuery("SELECT id 
                       FROM #__booklibrary_track_source where fk_book_id = $book_id;");
        $tdiles_id = $db->loadColumn();
        $deleteTr_id = array();
        if ($remove_all_track) {
            $deleteTr_id = $tdiles_id;
        } else {
            foreach($tdiles_id as $key => $value) {
                if (isset($_POST['track_option_del' . $value])) {
                    array_push($deleteTr_id, $jinput->get('track_option_del' . $value, '', 'post'));
                }
            }
        }
        if ($deleteTr_id['0']) {
            $del_tid = "";
            $sql = "SELECT src FROM #__booklibrary_track_source WHERE id IN (";
            foreach($deleteTr_id as $tid_id) $del_tid.= $tid_id . ",";
            $sql.= $del_tid . "0)";
            $db->setQuery($sql);
            $tracks = $db->loadColumn();
            if ($tracks) {
                foreach($tracks as $name) {
                    if (substr($name, 0, 4) != "http"  && $name != "") unlink($mosConfig_absolute_path . $name);
                }
            }
            $sql = "DELETE FROM #__booklibrary_track_source 
                    WHERE (id IN (" . $del_tid . "0)) and (fk_book_id = $book_id)";
            $db->setQuery($sql);
            $db->execute();
        }
    }
}
if (!function_exists('deleteAudios')) {
    function deleteAudios($book_id, $remove_all_audio = 0) {
        global $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
        $jinput = JFactory::getApplication()->input;
        $db = JFactory::getDBO();
        $db->setQuery("SELECT id 
                       FROM #__booklibrary_audio_source where fk_book_id = $book_id;");
        $adiles_id = $db->loadColumn();
        $deleteAud_id = array();
        if ($remove_all_audio) {
            $deleteAud_id = $adiles_id;
        } else {
            foreach($adiles_id as $key => $value) {
                if (isset($_POST['audio_option_del' . $value])) {
                    array_push($deleteAud_id, $jinput->get('audio_option_del' . $value, '', 'post'));
                }
            }
        }
        if ($deleteAud_id['0']) {
            $del_id = "";
            $sql = "SELECT src 
                    FROM #__booklibrary_audio_source 
                    WHERE id IN (";
            foreach($deleteAud_id as $aid_id) $del_id.= $aid_id . ",";
            $sql.= $del_id . "0)";
            $db->setQuery($sql);
            $audios = $db->loadColumn();
            if ($audios) {
                foreach($audios as $name) {
                    if (substr($name, 0, 4) != "http"  && $name != "" ) unlink($mosConfig_absolute_path . $name);
                }
            }
            $sql = "DELETE FROM #__booklibrary_audio_source 
                    WHERE (id IN (" . $del_id . "0)) and (fk_book_id=$book_id)";
            $db->setQuery($sql);
            $db->execute();
        }
    }
}
if (!function_exists('deleteVideos')) {
    function deleteVideos($book_id, $remove_all_video = 0) {
        global $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
        $jinput = JFactory::getApplication()->input;
        $db = JFactory::getDBO();
        $db->setQuery("SELECT id 
                       FROM #__booklibrary_video_source 
                       where fk_book_id = $book_id;");
        $vdiles_id = $db->loadColumn();
        $deleteVid_id = array();
        
        if ($remove_all_video) {
            $deleteVid_id = $vdiles_id;
        } else {
            foreach($vdiles_id as $key => $value) {
                if (isset($_POST['video_option_del' . $value]) 
                        || isset($_POST['youtube_option_del' . $value])) {
                    array_push($deleteVid_id, $jinput->get('video_option_del' . $value, '', 'post'));
                } else if(isset($_POST['youtube_option_del' . $value])) {
                    array_push($deleteVid_id, $jinput->get('youtube_option_del' . $value, '', 'post'));
                }
            }
        }

        if ($deleteVid_id['0']) {
            $del_id = "";
            $sql = "SELECT src 
                    FROM #__booklibrary_video_source 
                    WHERE id IN (";
            foreach($deleteVid_id as $vid_id) $del_id.= $vid_id . ",";
            $sql.= $del_id . "0)";
            $db->setQuery($sql);
            $videos = $db->loadColumn();
            if ($videos) {
                foreach($videos as $name) {
                    if (substr($name, 0, 4) != "http"  && $name != "") unlink($mosConfig_absolute_path . $name);
                }
            }
            $sql = "DELETE FROM #__booklibrary_video_source 
                    WHERE (id IN (" . $del_id . "0)) and (fk_book_id=$book_id)";
            $db->setQuery($sql);
            $db->execute();
        }
    }
}

//******************************end functions save/delete ebook ***********************************

/**
 * Legacy function, using <jdoc:include type="modules" /> instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosMail')) {
    function mosMail($from, $fromname, $recipient, $subject, $body, $mode = 0, $cc = NULL, 
                     $bcc = NULL, $attachment = NULL, $replyto = NULL, $replytoname = NULL) {

      try {

        $a = JFactory::getMailer();     
        $ret = $a->sendMail($from, $fromname, $recipient, $subject, $body, $mode, $cc, $bcc, 
                         $attachment, $replyto, $replytoname);
      } catch (Exception $ex) {
        JFactory::getApplication()->enqueueMessage($ex->getMessage() );
        $ret = false ;
      }        

      return $ret;

    }
}
if (!function_exists("formatMoney")) {
    function formatMoney($number, $fractional = false, $pattern = ".") {
        if ($fractional) {
            $number = sprintf('%.2f', $number);
        }
        if ($pattern == ".") $number = str_replace(".", ",", $number);
        while (true) {
            $replaced = preg_replace('/(-?\d+)(\d\d\d)/', '$1' . $pattern . '$2', $number);
            //echo $replaced."<br>";
            if ($replaced != $number) {
                $number = $replaced;
            } else {
                break;
            }
        }
        // $number = preg_replace('/\^/', $number, $pattern);
        return $number;
    }
}
if (!function_exists('mosLoadAdminModules')) {
    function mosLoadAdminModules($position = 'left', $style = 0) {
        // Select the module chrome function
        if (is_numeric($style)) {
            switch ($style) {
                case 2:
                    $style = 'xhtml';
                break;
                case 0:
                default:
                    $style = 'raw';
                break;
            }
        }
?>
<jdoc:include type="modules" name="<?php echo $position ?>" style="<?php echo $style ?>" />

<?php
    }
}
/**
 * Legacy function, using <jdoc:include type="module" /> instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosLoadAdminModule')) {
    function mosLoadAdminModule($name, $style = 0) {
?>
<jdoc:include type="module" name="<?php echo $name ?>" style="<?php echo $style ?>" />

<?php
    }
}
/**
 * Legacy function, always use {@link $jinput->get()} instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosStripslashes')) {
    function mosStripslashes(&$value) {
        $ret = '';
        if (is_string($value)) {
            $ret = stripslashes($value);
        } else {
            if (is_array($value)) {
                $ret = array();
                foreach($value as $key => $val) {
                    $ret[$key] = mosStripslashes($val);
                }
            } else {
                $ret = $value;
            }
        }
        return $ret;
    }
}
/**
 * Legacy function, use {@link JFolder::files()} or {@link JFolder::folders()} instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosReadDirectory')) {
    function mosReadDirectory($path, $filter = '.', $recurse = false, $fullpath = false) {
        $arr = array(null);
        // Get the files and folders
        jimport('joomla.filesystem.folder');
        $files = JFolder::files($path, $filter, $recurse, $fullpath);
        $folders = JFolder::folders($path, $filter, $recurse, $fullpath);
        // Merge files and folders into one array
        $arr = array_merge($files, $folders);
        // Sort them all
        asort($arr);
        return $arr;
    }
}
/**
 * Legacy function, use {@link JApplication::redirect() JApplication->redirect()} instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosRedirect')) {
    function mosRedirect($url, $msg = '') {
        $mainframe = JFactory::getApplication(); 
        $mainframe->enqueueMessage($msg, 'Notice');
        $mainframe->redirect( $url );
    }
}
/**
 * Legacy function, use {@link JArrayHelper::getValue()} instead
 *
 * @deprecated  As of version 1.5
 */
 if (!function_exists('mosGetParam')) {
     function mosGetParam(&$arr, $name, $def = null,$filter = "STRING" ) {
        // Static input filters for specific settings
        $jinput = JFactory::getApplication()->input;
         
        return $jinput->get($name, $def,$filter);
    }
}
// if (!function_exists('mosGetParam')) {
//     function mosGetParam(&$arr, $name, $def = null, $mask = 0) {
//         // Static input filters for specific settings
//         static $noHtmlFilter = null;
//         static $safeHtmlFilter = null;
//         $var = JArrayHelper::getValue($arr, $name, $def, '');
//         // If the no trim flag is not set, trim the variable
//         if (!($mask & 1) && is_string($var)) {
//             $var = trim($var);
//         }
//         // Now we handle input filtering
//         if ($mask & 2) {
//             // If the allow html flag is set, apply a safe html filter to the variable
//             if (is_null($safeHtmlFilter)) {
//                 $safeHtmlFilter = JFilterInput::getInstance(null, null, 1, 1);
//             }
//             $var = $safeHtmlFilter->clean($var, 'none');
//         } elseif ($mask & 4) {
//             // If the allow raw flag is set, do not modify the variable
//             $var = $var;
//         } else {
//             // Since no allow flags were set, we will apply the most strict filter to the variable
//             if (is_null($noHtmlFilter)) {
//                 $noHtmlFilter = JFilterInput::getInstance( /* $tags, $attr, $tag_method, 
//                                                               $attr_method, $xss_auto */
//                 );
//             }
//             $var = $noHtmlFilter->clean($var, 'none');
//         }
//         return $var;
//     }
// }
/**
 * Legacy function, use {@link JEditor::save()} or {@link JEditor::getContent()} instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('getEditorContents')) {
    function getEditorContents($editorArea, $hiddenField) {
        jimport('joomla.html.editor');
        // ################################# ATENTION!!! This code needs to be reworked:
        //$editor = JFactory::getEditor();
        $editor = JEditor::getInstance();
    //    echo $editor->save($hiddenField);
        echo $editor->save($hiddenField);
    }
}
/**
 * Legacy function, use {@link JFilterOutput::objectHTMLSafe()} instead
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosMakeHtmlSafe')) {
    function mosMakeHtmlSafe(&$mixed, $quote_style = ENT_QUOTES, $exclude_keys = '') {
        JFilterOutput::objectHTMLSafe($mixed, $quote_style, $exclude_keys);
    }
}
/**
 * Legacy utility function to provide ToolTips
 *
 * @deprecated As of version 1.5
 */
if (!function_exists('mosToolTip')) {
    function mosToolTip($tooltip, $text = '', $image = '' ) {
    ?>

        <span class="tooltip_link" rel="tooltip" data-placement="top" data-toggle="tooltip"
         title='<?php echo $tooltip ; ?>' >
        <?php 
            if($text != "" ) echo $text ; 
            else if($image != "" ) echo "<img src='".$image."' />" ;
        ?>
        </span>

    <?php 
    }
}
/**
 * Legacy function to replaces &amp; with & for xhtml compliance
 *
 * @deprecated  As of version 1.5
 */
if (!function_exists('mosTreeRecurse')) {
    function mosTreeRecurse($id, $indent, $list, &$children, $maxlevel = 9999, $level = 0, $type = 1) {
        jimport('joomla.html.html');
        return JHtml::_('menu.treerecurse', $id, $indent, $list, $children, $maxlevel, $level, $type);
    }
}
class blLittleThings {
    static function getGroupsByUser($uid, $recurse) {

            $database = JFactory::getDBO();
            // Custom algorythm
            $usergroups = array();
            if ($recurse == 'RECURSE') {
                // [1]: Recurse getting the usergroups
                $id_group = array();
                $q1 = "SELECT group_id 
                       FROM `#__user_usergroup_map` 
                       WHERE user_id={$uid}";
                $database->setQuery($q1);
                $rows1 = $database->loadObjectList();
                foreach($rows1 as $v) $id_group[] = $v->group_id;
                for ($k = 0;$k < count($id_group);$k++) {
                    $q = "SELECT g2.id 
                          FROM `#__usergroups` g1 
                          LEFT JOIN `#__usergroups` g2 ON g1.lft > g2.lft AND g1.lft < g2.rgt 
                          WHERE g1.id={$id_group[$k]} ORDER BY g2.lft";
                    $database->setQuery($q);
                    $rows = $database->loadObjectList();
                    foreach($rows as $r) $usergroups[] = $r->id;
                }
                $usergroups = array_unique($usergroups);
            }
            // [2]: Non-Recurse getting usergroups
            $q = "SELECT * 
                  FROM #__user_usergroup_map 
                  WHERE user_id = {$uid}";
            $database->setQuery($q);
            $rows = $database->loadObjectList();
            foreach($rows as $k => $v) $usergroups[] = $rows[$k]->group_id;
            // If user is unregistered, Joomla contains it into standard group (Public by default).
            // So, groupId for anonymous users is 1 (by default).
            // But custom algorythm doesnt do this: if user is not autorised, he will NOT connected to any group.
            // And groupId will be 0.
            if (count($rows) == 0) $usergroups[] = - 2;
            return $usergroups;
      
    }
    static function getWhereUsergroupsCondition($table_alias = "c") {
   
            // Get Current User 
            if (version_compare(JVERSION, "4.0.0", "ge")) {
                $app = JFactory::getApplication();
                $user = $app->getIdentity();
            } else {
                $user = JFactory::getUser(); 
            }          
            if (isset($user->id) AND $user->id != 0) $usergroups_sh = 
                blLittleThings::getGroupsByUser($user->id, '');
            else $usergroups_sh = array();
            $usergroups_sh[] = - 2;
            $s = '';
            for ($i = 0;$i < count($usergroups_sh);$i++) {
                $g = $usergroups_sh[$i];
                $s.= " $table_alias.params LIKE '%,{$g}' or 
                       $table_alias.params = '{$g}' or 
                       $table_alias.params LIKE '{$g},%' or 
                       $table_alias.params LIKE '%,{$g},%' ";
                if (($i + 1) < count($usergroups_sh)) $s.= ' or ';
            }
            return $s;
   
    }
}


if (!function_exists('checkAccessBL')) {
    function checkAccessBL($accessgroupid, $recurse, $usersgroupid, $acl) {
        if (isset($usersgroupid) && !is_int($usersgroupid) ) $usersgroupid = explode(',', $usersgroupid);
        elseif (!is_array($usersgroupid)) {
            $usersgroupid = $usersgroupid * 1;
            if (!(is_int($usersgroupid))) return false;
            else {
                if (is_int($usersgroupid) AND isset($usersgroupid) AND $usersgroupid > 0) {
                    $t = $usersgroupid;
                    $usersgroupid = (array)$usersgroupid; // force to array
                    $usersgroupid[] = $t;
                } elseif (is_int($usersgroupid) AND isset($usersgroupid) AND $usersgroupid == 0) {
                    $usersgroupid = (array)$usersgroupid; // force to array
                    $usersgroupid[] = 0;
                }
            }
        }
        //parse usergroups
        $tempArr = array();
        $tempArr = explode(',', $accessgroupid);
        for ($i = 0;$i < count($tempArr);$i++) {
            if (((!is_array($usersgroupid) && $tempArr[$i] == $usersgroupid) OR 
                  (is_array($usersgroupid) && in_array($tempArr[$i], $usersgroupid))) || $tempArr[$i] == - 2) {
                //allow access
                return true;
            } else {
                if ($recurse == 'RECURSE') {
                    if (is_array($usersgroupid)) {
                        for ($j = 0;$j < count($usersgroupid);$j++) if (in_array($usersgroupid[$j], $tempArr)) return 1;
                    } else {
                        if (in_array($usersgroupid, $tempArr)) return 1;
                    }
                }
            }
        } // end for
        //deny access
        return 0;
    }
    // End of checkAccessBL ()
    
}
// [author]: Wonderer
// [description]: Analogue of
//    $usergroups = $acl->get_group_parents($my->gid,'ARO','RECURSE');
// [call]: $usergroups = getGroupsByUser ($my->id,'RECURSE');   $usergroups = getGroupsByUser ($my->id,'');
// [date]: 03 June 2011
if (!function_exists('getGroupsByUser')) {
    function getGroupsByUser($uid, $recurse) {

            $database = JFactory::getDBO();
            // Custom algorythm
            $usergroups = array();
            if ($recurse == 'RECURSE') {
                // [1]: Recurse getting the usergroups
                $id_group = array();
                $q1 = "SELECT group_id 
                       FROM `#__user_usergroup_map` 
                       WHERE user_id={$uid}";
                $database->setQuery($q1);
                $rows1 = $database->loadObjectList();
                foreach($rows1 as $v) $id_group[] = $v->group_id;
                for ($k = 0;$k < count($id_group);$k++) {
                    $q = "SELECT g2.id 
                          FROM `#__usergroups` g1 
                          LEFT JOIN `#__usergroups` g2 ON g1.lft > g2.lft 
                          AND g1.lft < g2.rgt 
                          WHERE g1.id={$id_group[$k]} 
                          ORDER BY g2.lft";
                    $database->setQuery($q);
                    $rows = $database->loadObjectList();
                    foreach($rows as $r) $usergroups[] = $r->id;
                }
                $usergroups = array_unique($usergroups);
            }
            // [2]: Non-Recurse getting usergroups
            $q = "SELECT * 
                  FROM #__user_usergroup_map
                  WHERE user_id = {$uid}";
            $database->setQuery($q);
            $rows = $database->loadObjectList();
            foreach($rows as $k => $v) $usergroups[] = $rows[$k]->group_id;
            // If user is unregistered, Joomla contains it into standard group (Public by default).
            // So, groupId for anonymous users is 1 (by default).
            // But custom algorythm doesnt do this: if user is not autorised, he will NOT connected to any group.
            // And groupId will be 0.
            if (count($rows) == 0) $usergroups[] = - 2;
            return $usergroups;
    
    }
}
// [author]: Wonderer
// [description]:
//  Returns a string for WHERE condition
// instead of using $usergroups.
// Now we replace an old (c.params IN ('.$usergroups.') construction
// with ({$s}).
// [call]: $s = getWhereUsergroupsString ( "alias_name" );
// (alias_name) its a `#__booklibrary_main_categories` table alias.
// (alias_name) depends of the particular query, as usual its "c", "cc" or something like this.
// [date]: 13 June 2011
if (!function_exists('getWhereUsergroupsString')) {
    function getWhereUsergroupsString($table_alias) {
        global $my;
        if (isset($my->id) AND $my->id != 0) {
            $usergroups_sh = getGroupsByUser($my->id, '');
            //$usergroups_sh = '-2'.$usergroups_sh;
            
        } else {
            $usergroups_sh = array();
        }
        $usergroups_sh[] = - 2;
        $s = '';
        for ($i = 0;$i < count($usergroups_sh);$i++) {
            $g = $usergroups_sh[$i];
            $s.= " $table_alias.params LIKE '%,{$g}' or 
                   $table_alias.params = '{$g}' or 
                   $table_alias.params LIKE '{$g},%' or
                   $table_alias.params LIKE '%,{$g},%' ";
            if (($i + 1) < count($usergroups_sh)) $s.= ' or ';
        }
        return $s;
    }
}

//  Returns a string for WHERE condition
// [call]: $s = getWhereDatePublishString ( "alias_name" );
// (alias_name) its a `#__booklibrary_main_categories` table alias.
// (alias_name) depends of the particular query, as usual its "c", "cc" or something like this.
if (!function_exists('getWhereDatePublishString')) {
    function getWhereDatePublishString($table_alias) {
        
        $s = '';
        $s.= " ( $table_alias.publish_up <= now() or 
                $table_alias.publish_up = '0000-00-00 00:00:00' or 
                ($table_alias.publish_up IS NULL) ) and 
               ( $table_alias.publish_down >= now() or
                $table_alias.publish_down = '0000-00-00 00:00:00' or 
                ($table_alias.publish_down IS NULL) ) ";
        return $s;
    }
}
if (!function_exists('addSubmenuBookLibrary')) {
function addSubmenuBookLibrary($vName) {
        if ( version_compare(JVERSION, "4.0.0-alpha10", "ge") ) { 
            return;
        } else {
            if (!defined('_BOOKLIBRARY_HEADER_NUMBER')) loadConstBooklibrary();
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_HEADER_NUMBER), 
                'index.php?option=com_booklibrary', $vName == 'Books');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_LABEL_AUTHORS), 
                'index.php?option=com_booklibrary&task=manage_author', $vName == 'Add Author');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_CATEGORIES_NAME), 
                'index.php?option=com_booklibrary&section=categories', $vName == 'Categories');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_SHOW_LEND_REQUESTS), 
                'index.php?option=com_booklibrary&task=lend_requests', $vName == 'Lend Requests'); 
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_SHOW_LEND_REQUESTS_HISTORY), 
                'index.php?option=com_booklibrary&task=users_lend_history', $vName == 'User Lend History');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_SHOW_LANGUAGE_MANAGER), 
                'index.php?option=com_booklibrary&section=language_manager', $vName == 'Language Manager');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_SHOW_IMPORT_EXPORT), 
                'index.php?option=com_booklibrary&task=show_import_export', $vName == 'Import/Export');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_SHOW_SETTINGS_FRONTEND), 
                'index.php?option=com_booklibrary&task=config_frontend', $vName == 'Settings Frontend');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_SHOW_SETTINGS_BACKEND), 
                'index.php?option=com_booklibrary&task=config_backend', $vName == 'Settings Backend');
            JSubMenuHelper::addEntry(JText::_(_BOOKLIBRARY_ADMIN_ABOUT_ABOUT), 
                'index.php?option=com_booklibrary&task=about', $vName == 'About');
        }
    }
}

if (!function_exists('loadConstBooklibrary')) {
  function loadConstBooklibrary() {
    global $database, $mosConfig_absolute_path;
    $is_exception = false;
    
    // Clean the memory to avoid installation problems:
    // Clean the memory, $langs do not use in this part of script:
    // $database->setQuery("SELECT * 
    //                      FROM #__booklibrary_languages");
    // $langs = $database->loadObjectList();
    $component_path = JPath::clean($mosConfig_absolute_path . '/components/com_booklibrary/language/');
    $component_constans = array();
    if (is_dir($component_path) && ($component_constans =
        JFolder::files($component_path, '^[^_]*\.php$', false, true))) {

        //check and add constants file in DB
        foreach ($component_constans as $i => $file) {
          $file_name = pathinfo($file);
          $file_name = $file_name['filename'];
          if ($file_name === 'constant') {
            require($mosConfig_absolute_path . "/components/com_booklibrary/language/$file_name.php");
            foreach ( $constMas as $mas ) {
              $database->setQuery(
                "INSERT IGNORE INTO #__booklibrary_const (const, sys_type) VALUES ('".
                $mas["const"]."','".$mas["sys_type"]."')");
              $database->execute();
            }
          }
        }                
        //check and add new text files in DB
        $flag1=true;
        print_r("<br><b>These constants exist in Languages files but not exist in file constants:</b><br><br>");
        
        foreach ($component_constans as $i => $file) {
          $file_name = pathinfo($file);
          $file_name = $file_name['filename'];
          $LangLocal = '';
          if ($file_name != 'constant') {
            require($mosConfig_absolute_path . "/components/com_booklibrary/language/$file_name.php");
            try {
              $database->setQuery("INSERT IGNORE INTO #__booklibrary_languages (lang_code,title) 
                                   VALUES ('". $LangLocal['lang_code'] . "','" . 
                                    $LangLocal['title'] . "')");
              $database->execute();
              $database->setQuery("SELECT id 
                                   FROM #__booklibrary_languages " ." 
                                   WHERE lang_code = '" . $LangLocal['lang_code'] . "' 
                                   AND title='".$LangLocal['title']."'");
              $idLang = $database->loadResult();
              foreach ($constLang as $item) {
                $database->setQuery("SELECT id 
                                     FROM #__booklibrary_const
                                     WHERE const = '" . $item['const'] . "'");
                ini_set('memory_limit', '-1');
                $idConst = $database->loadResult();
                if(!array_key_exists ( 'value_const'  , $item ) || !$idConst){
                     print_r($item['const']." not exist in file <b>'constant'</b> for this language:  <b>". 
                        $LangLocal['title']."</b>.");
                   $flag1 = false;
                } else {
                  $database->setQuery("INSERT IGNORE INTO #__booklibrary_const_languages (fk_constid,
                                       fk_languagesid,value_const) ". " 
                                       VALUES ($idConst, $idLang, " . 
                                       $database->quote($item['value_const']) . ")");
                  $database->execute();
                }
                // Clean the memory to avoid installation problems:
                unset($idConst);
              }
              // Clean the memory to avoid installation problems:
              unset($idLang);
            } catch (Exception $e) {
            // } catch (\RuntimeException $e) {
              $is_exception = true;
              echo 'Send exception, please write to admin for language check: ',  $e->getMessage(), "\n";
            }
          }
        }
        if($flag1){
          print_r("<br /><p style='color:green;'><b>Everything is [ OK ]</b></p><br />");
        }
        else{
          print_r("<br><b style='color:red;'>This constants not loaded.!</b><br><br>");
        }

        //if text constant missing recover they in DB
        if (!defined('_HEADER_NUMBER')) {
             $query = "SELECT c.const, cl.value_const ";
             $query.= "FROM #__booklibrary_const_languages as cl ";
             $query.= "LEFT JOIN #__booklibrary_languages AS l ON cl.fk_languagesid=l.id ";
             $query.= "LEFT JOIN #__booklibrary_const AS c ON cl.fk_constid=c.id ";
             $query.= "WHERE l.lang_code = 'en-GB'";
          $database->setQuery($query);
          $langConst = $database->loadObjectList();
          // foreach ($langConst as $item) {
          //   if(!defined($item->const)){
          //     defined($item->const) or define($item->const, $item->value_const);
          //   }
          // }
        }
        //if some language file missing recover it
        foreach ($component_constans as $i => $file) {
            $isLang = 0;
            $file_name = pathinfo($file);
            $file_name = $file_name['filename'];
            if ($file_name != 'constant') {
                require($mosConfig_absolute_path . "/components/com_booklibrary/language/$file_name.php");
                //$fileMas[] = $LangLocal;
                $fileMas[] = $LangLocal['title']; 
            }
        }
        // Clean the memory to avoid installation problems:
        unset($component_constans);
    }
    
    $database->setQuery("SELECT title 
                         FROM #__booklibrary_languages");
    $langs = $database->loadColumn();
    
    if (count($langs) > count($fileMas)) {

      $results = array_diff($langs, $fileMas);
      foreach ($results as $result) {
        
        $database->setQuery("SELECT lang_code 
                             FROM #__booklibrary_languages 
                             WHERE title = '$result'");
        $lang_code = $database->loadResult();
        $langfile = "<?php if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) 
            die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );";
        $langfile .= "\n/**\n*\n* @package  BookLibrary\n
            * @copyright  Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);\n
            * Homepage: http://www.ordasoft.com\n* @version: 3.2 Pro\n*\n* */\n";
        $langfile .= "\$LangLocal = array('lang_code'=>'$lang_code', 'title'=>'$result');\n";
        $langfile .= "\$constLang = array();\n";
        $query = "SELECT c.const, cl.value_const ";
        $query.= "FROM #__booklibrary_const_languages as cl ";
        $query.= "LEFT JOIN #__booklibrary_languages AS l ON cl.fk_languagesid=l.id ";
        $query.= "LEFT JOIN #__booklibrary_const AS c ON cl.fk_constid=c.id ";
        $query.= "WHERE l.title = '$result'";
        $database->setQuery($query);
        $constlanguages = $database->loadObjectList();
        foreach ($constlanguages as $constlanguage) {
            $langfile .= "\$constLang[] = array('const'=>'" . $constlanguage->const
             . "', 'value_const'=>" . $database->quote($constlanguage->value_const) . ");\n";
        }
        // Clean the memory to avoid installation problems:
        unset($constlanguages);
        // Write out new initialization file
        $fd = fopen($mosConfig_absolute_path . 
            "/components/com_booklibrary/language/$result.php", "w")
            or die("Cannot create language file.");
        fwrite($fd, $langfile);
        fclose($fd); 
      }
      // Clean the memory to avoid installation problems:
      unset($lang_code);
    }
  } 
}

if (!function_exists('language_check_booklib')) {
  function language_check_booklib($component_db_name = 'booklibrary' ) {
    global $database;          
    $database->setQuery("SELECT * 
                         FROM #__".$component_db_name."_languages");
    $langIds = $database->loadObjectList();
    $flag2=true;
    print_r("<br /><b>These constants exist in file constants but not exist in Languages files:</b><br />");
    foreach ($langIds as $langId){
      $query = " SELECT  lc.*  FROM    #__".$component_db_name."_const as lc ";
      $query .= " WHERE  NOT EXISTS ";
      $query .= " ( SELECT  l1.*  FROM #__".$component_db_name."_const_languages as l1 ";
      $query .= " WHERE lc.id = l1.`fk_constid` and l1.fk_languagesid = ".$langId->id.") ";
      $database->setQuery($query);
      $badLangConsts = $database->loadObjectList();
        if($badLangConsts){
          $flag2 = false;
          print_r("<br />Languages: ".$langId->title."<br />");
          print_r($badLangConsts);
          echo "<br><br>";
        }
      } 
      if($flag2)  
        print_r("<br /><p style='color:green;'><b>Everything is [ OK ]</b></p><br /><br />");  
  }
}

if (!function_exists('remove_langs')) {
    function remove_langs($component_db_name = 'booklibrary') {
        global $database;
        $query = " TRUNCATE TABLE #__" . $component_db_name . "_languages; ";
        $database->setQuery($query);
        $database->execute();
        $query = " TRUNCATE TABLE #__" . $component_db_name . "_const; ";
        $database->setQuery($query);
        $database->execute();
        $query = " TRUNCATE TABLE #__" . $component_db_name . "_const_languages ;";
        $database->setQuery($query);
        $database->execute();
    }
}

if (!function_exists('data_transformer')) {

  function data_transformer($date, $date_format = "from") {
      global $booklibrary_configuration, $database;     
      
      if ( $date_format == "to" ) {
          $formatDateFrom = $booklibrary_configuration['date_format'];
          $formatDateTo = 'Y-m-d';
      } else { // $date_format == "from"
           $date = substr($date, 0,10);
           $formatDateFrom = 'Y-m-d' ;
           $formatDateTo = $booklibrary_configuration['date_format'] ;
      }
       
      $formatDateSource = str_replace("%","",$formatDateFrom);
      $formatDateTo = str_replace("%","",$formatDateTo);
      
      if(function_exists('date_format')){
          $dateObject = date_create_from_format($formatDateSource, $date);
        
          if($dateObject){
              $date = date_format($dateObject, $formatDateTo);
          } else $date = "" ;

      } else $date = "" ;


      if($date == "" ){
          $query = "SELECT STR_TO_DATE('$date','$formatDateTo')";
          $database->setQuery($query);
          $normaDat = $database->loadResult(); 
      
          if(strlen($normaDat) > 0){
              $date = $normaDat;
          }           
      }
      return $date;
      
  }

} 

class getLayoutPathBook {
    static function getLayoutPathCom($components, $type, $layout = 'default') {
        $template = JFactory::getApplication()->getTemplate();

        if ( $layout  === "")  $layout = 'default' ;

        $defaultLayout = $layout;
        if (strpos($layout, ':') !== false) {
            // Get the template and file name from the string
            $temp = explode(':', $layout);
            $template = ($temp[0] == '_') ? $template : $temp[0];
            $layout = $temp[1];
            $defaultLayout = ($temp[1]) ? $temp[1] : 'default';
        }
        // Build the template and base path for the layout
        $tPath = JPATH_THEMES . '/' . $template . '/html/' . $components . '/' . 
            $type . '/' . $layout . '.php';
        $cPath = JPATH_BASE . '/components/' . $components . '/views/' . $type . '/tmpl/' . 
            $layout . '.php';
        $dPath = JPATH_BASE . '/components/' . $components . '/views/' . $type . '/tmpl/default.php';
        // If the template has a layout override use it
        if (file_exists($tPath)) {
            return $tPath;
        } else if (file_exists($cPath)) {
            return $cPath;
        } else if (file_exists($dPath)) {
            return $dPath;
        } else {
            echo "Bad layout path, please write to admin";
            exit;
        }
    }
}
if (!function_exists('save_author_associate')) {
    function save_author_associate() {
        global $database;
        $jinput = JFactory::getApplication()->input;
        $id_check = $jinput->get('id', "");
        $id_true = $jinput->get('idtrue', "");
        $language_post = $jinput->get('langshow', "");
        if ($id_check) {
            if (empty($id_true)) {
                //----------get new values (what book we choose for chaque language) ------------//
                $i = 1;
                $assocArray = array();
                $assocAuthorId = array();
                // while (count($jinput->get("associate_author" . $i))) {
                while ( isset($_REQUEST["associate_author" . $i]) ) {
                    $langAssoc = $jinput->get("associate_author_lang" . $i, '');
                    $valAssoc = $jinput->get("language_associate_author" . $i, '');
                    if ($valAssoc == '') {
                        $i++;
                        continue;
                    }
                    $assocArray[$langAssoc] = $valAssoc;
                    if ($valAssoc) {
                        $assocAuthorId[] = $valAssoc; //----Array of new house_ids
                        
                    }
                    $i++;
                }
                if (count($assocArray) > 0) {
                    $assocArray[$language_post] = $id_check;
                    $assocStr = serialize($assocArray);
                    //-----------slect associate with old values----------------------------------//
                    $oldAssociateArray = getAssociateOldAuthors();
                    //----------------------------------------------------------------//
                    if (!isset($assocAuthorId[$id_check])) {
                        $assocAuthorId[] = $id_check;
                    }
                    if ($assocArray !== $oldAssociateArray) { //-----------compare old and new values--
                        //---------set null for books that are not more in associates----------------//
                        ClearAssociateDiffAuthors();
                        //---------set new associates for houses that are choosed----------------//
                        $idToChange = implode(',', $assocAuthorId); /*ids of new houses where we set 
                                                                      new values for column associate_author*/
                        if (count($assocAuthorId) > 1 && !empty($idToChange)) {
                            $query = "UPDATE #__booklibrary_authors 
                                      SET `associate_authors`='" . $assocStr . "' 
                                      where `id` in (" . $idToChange . ")";
                            $database->setQuery($query);
                            $database->execute();
                        } else {
                            $query = "UPDATE #__booklibrary_authors 
                                      SET `associate_authors`= null where `id` = " . $id_check . "";
                            $database->setQuery($query);
                            $database->execute();
                        }
                    }
                }
            }
        }
    }
}
if (!function_exists('ClearAssociateDiffAuthors')) {
    function ClearAssociateDiffAuthors() {
        global $database;
        $jinput = JFactory::getApplication()->input;
        $id_check = $jinput->get('id', "");
        $language_post = $jinput->get('langshow', "");
        $oldAssociateArray = getAssociateOldAuthors();
        $i = 1;
        $assocArray = array();
        // while (count($jinput->get("associate_author" . $i))) {
        while ( isset($_REQUEST["associate_author" . $i]) ) {
            $langAssoc = $jinput->get("associate_author_lang" . $i);
            $valAssoc = $jinput->get("language_associate_author" . $i);
            $assocArray[$langAssoc] = $valAssoc;
            $i++;
        }
        $assocArray[$language_post] = $id_check;

        
        if (!empty($oldAssociateArray) && !empty($assocArray)) {
            $old_ids_assoc = 
                getAssociateDiffAuthor($oldAssociateArray, $assocArray);
            if (count($old_ids_assoc) > 0) {
                foreach($old_ids_assoc as $key => $value) {
                    $diff_assoc2 = getAssociateAuthors($value);
                    if (!empty($diff_assoc2)) {
                        $ids_assoc_diff2 = explode(',', $diff_assoc2);
                        foreach($ids_assoc_diff2 as $key2 => $value2) {
                            if (!in_array($value2, $old_ids_assoc)) {
                                $assoc_lang = getAssociateAuthorsLang($value);
                                foreach($assoc_lang as $key3 => $value3) {
                                    if ($value3 == $value2) {
                                        $assoc_lang[$key3] = 0;
                                    }
                                }
                                $AuthorLangIds = serialize($assoc_lang);
                                $query = "UPDATE #__booklibrary_authors 
                                          SET `associate_authors`='" . $AuthorLangIds . "' 
                                          where `id` = " . $value . "";
                                $database->setQuery($query);
                                $database->execute();
                            }
                        }
                    }
                }
            }
        }
        
        if (!empty($oldAssociateArray) && !empty($assocArray)){
            $new_ids_assoc = 
                getAssociateDiffAuthor($assocArray, $oldAssociateArray);
            if (count($new_ids_assoc) > 0) {
                foreach($new_ids_assoc as $key => $value) {
                    $diff_assoc2 = getAssociateAuthors($value);
                    if (!empty($diff_assoc2)) {
                        $ids_assoc_diff2 = explode(',', $diff_assoc2);
                        foreach($ids_assoc_diff2 as $key2 => $value2) {
                            if ($value2 == $value || $value2 == 0) continue;
                            $assoc_lang = getAssociateAuthors($value2);
                            foreach($assoc_lang as $key3 => $value3) {
                                if ($value3 == $value) {
                                    $assoc_lang[$key3] = 0;
                                }
                            }
                            $AuthorLangIds = serialize($assoc_lang);
                            $query = "UPDATE #__booklibrary_authors 
                                      SET `associate_authors`='" . $AuthorLangIds . "' 
                                      where `id` = " . $value2 . "";
                            $database->setQuery($query);
                            $database->execute();
                        }
                    }
                }
            }
        } 
    }
}
if (!function_exists('getAssociateAuthors')) {
    function getAssociateAuthors($AuthorId) {
        global $database;
        $one = array();
        $query = "select associate_authors 
                  from #__booklibrary_authors 
                  where id = " . $AuthorId . " and associate_authors is not null";
        $database->setQuery($query);
        $AuthorAssociateAuthor = $database->loadResult();
        $is_correct_assosiate_array = false ;
        if (!empty($AuthorAssociateAuthor)) {
            $AuthorIds_tmp = unserialize($AuthorAssociateAuthor);
            foreach($AuthorIds_tmp as $oneAuthor) {
                if ($oneAuthor != 0) {
                    $one[] = $oneAuthor;
                    if($oneAuthor == $AuthorId) $is_correct_assosiate_array = true ;
                }
            }
            $bids = implode(',', $one);
            if( !$is_correct_assosiate_array ) $bids = ""; //return empty - if in assosiate array - not exist author with same id 
            return $bids;
        }
    }
}

if (!function_exists('getAssociateAuthorsLang')) {
    function getAssociateAuthorsLang($AuthorIds) {
        global $database;
        $query = "select associate_authors 
                  from #__booklibrary_authors 
                  where id = " . $AuthorIds . " and associate_authors is not null";
        $database->setQuery($query);
        $AuthorAssociateAuthor = $database->loadResult();
        if (!empty($AuthorAssociateAuthor)) {
            $AuthorLangIds = unserialize($AuthorAssociateAuthor);
            return $AuthorLangIds;
        }
    }
}
if (!function_exists('getAssociateDiffAuthor')) {
    function getAssociateDiffAuthor($assocArray1, $assocArray2) {
        global $database;
        $diff_ids = array();
        $diff = array_diff($assocArray1, $assocArray2);
        foreach($diff as $key => $value) {
            if ($value != 0) {
                $diff_ids[] = $value;
            }
        }
        return $diff_ids;
    }
}
if (!function_exists('getAssociateOldAuthors')) {
    function getAssociateOldAuthors() {
        global $database;
        $jinput = JFactory::getApplication()->input;
        $id_check = $jinput->get('id', "");
        $query = "select `associate_authors` 
                  from #__booklibrary_authors 
                  where `id` = " . $id_check . "";
        $database->setQuery($query);
        $oldAssociate = $database->loadResult();
        $oldAssoc_func = unserialize($oldAssociate);
        return $oldAssoc_func;
    }
}
if (!function_exists('edit_author_associate')) {
    function edit_author_associate($author) {
        global $my, $database;
        $associateArray = array();
        $userid = $my->id;
        $query = "SELECT lang_code 
                  FROM `#__languages`";
                  
        $database->setQuery($query);
        $allLanguages = $database->loadColumn();
        $query = "SELECT id,langshow,authors_name 
                  FROM `#__booklibrary_authors`";

        $database->setQuery($query);
        $allauthors = $database->loadObjectlist();
        $query = "select associate_authors 
                  from #__booklibrary_authors 
                  where id =" . $author->id;
        $database->setQuery($query);
        $authorAssociateauthor = $database->loadResult();
        if (!empty($authorAssociateauthor)) {
            $authorAssociateauthor = unserialize($authorAssociateauthor);
        } else {
            $authorAssociateauthor = array();
        }
        $i = 0;
        foreach($allLanguages as $oneLang) {
            $i++;
            $associate_author = array();
            $associate_author[] = mosHtml::makeOption(0, 'select');
            foreach($allauthors as & $oneAuthor) {
                if ($oneLang == $oneAuthor->langshow && $oneAuthor->id != $author->id) {
                    $associate_author[] = mosHtml::makeOption(($oneAuthor->id), 
                    $oneAuthor->authors_name);
                }
            }
            if ($author->langshow != $oneLang) {
                if (isset($authorAssociateauthor[$oneLang]) 
                    && $authorAssociateauthor[$oneLang] !== $author->id) {
                        $associateArray[$oneLang]['assocId'] = $authorAssociateauthor[$oneLang];
                } else {
                    $associateArray[$oneLang]['assocId'] = 0;
                }
                $associate_author_list = mosHTML::selectList($associate_author, 
                    'language_associate_author' . $i, 
                    'class="inputbox" size="1"', 'value', 'text', $associateArray[$oneLang]['assocId']);
            } else {
                $associate_author_list = null;
            }
            $associateArray[$oneLang]['list'] = $associate_author_list;
            if (isset($authorAssociateauthor[$oneLang]) 
                    && $authorAssociateauthor[$oneLang] !== $author->id) {
                $associateArray[$oneLang]['assocId'] = $authorAssociateauthor[$oneLang];
            } else {
                $associateArray[$oneLang]['assocId'] = 0;
            }
        }
        return $associateArray;
    }
}
if (!function_exists('edit_book_associate')) {
    function edit_book_associate($book, $access) {
        global $my, $database;
        $associateArray = array();
        $userid = $my->id;
        $query = "SELECT lang_code 
                  FROM `#__languages`";
        $database->setQuery($query);
        $allLanguages = $database->loadColumn();


        if($access)
        {
            $query = "SELECT id,langshow,title 
                  FROM `#__booklibrary`";
        }
        else
        {
            $query = "SELECT id,langshow,title 
                  FROM `#__booklibrary`
                  WHERE owner_id = " . $userid . "";
        }

                  
        $database->setQuery($query);
        $allbook = $database->loadObjectlist();
        $query = "select associate_book 
                  from #__booklibrary 
                  where id =" . $book->id;
        $database->setQuery($query);
        $bookAssociateBook = $database->loadResult();
        if (!empty($bookAssociateBook)) {
            $bookAssociateBook = unserialize($bookAssociateBook);
        } else {
            $bookAssociateBook = array();
        }
        $i = 0;
        foreach($allLanguages as $oneLang) {
            $i++;
            $associate_book = array();
            $associate_book[] = mosHtml::makeOption(0, 'select');
            foreach($allbook as & $oneBook) {
                if ($oneLang == $oneBook->langshow && $oneBook->id != $book->id) {
                    $associate_book[] = mosHtml::makeOption(($oneBook->id), $oneBook->title);
                }
            }
            if ($book->langshow != $oneLang) {
                if (isset($bookAssociateBook[$oneLang]) && $bookAssociateBook[$oneLang] !== $book->id) {
                    $associateArray[$oneLang]['assocId'] = $bookAssociateBook[$oneLang];
                } else {
                    $associateArray[$oneLang]['assocId'] = 0;
                }
                $associate_book_list = mosHTML::selectList($associate_book, 'language_associate_book' . $i, 
                    'class="inputbox" size="1"', 'value', 'text', $associateArray[$oneLang]['assocId']);
            } else {
                $associate_book_list = null;
            }
            $associateArray[$oneLang]['list'] = $associate_book_list;
            if (isset($bookAssociateBook[$oneLang]) && $bookAssociateBook[$oneLang] !== $book->id) {
                $associateArray[$oneLang]['assocId'] = $bookAssociateBook[$oneLang];
            } else {
                $associateArray[$oneLang]['assocId'] = 0;
            }
        }
        return $associateArray;
    }
}
if (!function_exists('save_book_associate')) {
    function save_book_associate() {
        global $database;
        $jinput = JFactory::getApplication()->input;
        $id_check = $jinput->get('id', "");
        $id_true = $jinput->get('idtrue', "");
        $language_post = $jinput->get('langshow', "");
        if ($id_check) {
            if (empty($id_true)) {
                //----------get new values (what book we choose for chaque language) --------------//
                $i = 1;
                $assocArray = array();
                $assocBookId = array();
                // while (count($jinput->get("associate_book" . $i))) {
                while ( isset($_REQUEST["associate_book" . $i]) ) {
                    $langAssoc = $jinput->get("associate_book_lang" . $i, '');
                    $valAssoc = $jinput->get("language_associate_book" . $i, '');
                    if ($valAssoc == '') {
                        $i++;
                        continue;
                    }
                    $assocArray[$langAssoc] = $valAssoc;
                    if ($valAssoc) {
                        $assocBookId[] = $valAssoc; //----Array of new house_ids
                        
                    }
                    $i++;
                }
                if (count($assocArray) > 0) {
                    $assocArray[$language_post] = $id_check;
                    $assocStr = serialize($assocArray);
                    //-----------slect associate with old values------------------------------------//
                    $oldAssociateArray = getAssociateOld();
                    //----------------------------------------------------------------//
                    if (!isset($assocBookId[$id_check])) {
                        $assocBookId[] = $id_check;
                    }
                    if ($assocArray !== $oldAssociateArray) { //-----------compare old and new values--
                        //---------set null for books that are not more in associates----------------//
                        ClearAssociateDiff();
                        //---------set new associates for houses that are choosed----------------//
                        $idToChange = implode(',', $assocBookId); //--ids of new houses where we set new values for column associate_book
                        if (count($assocBookId) > 0 && !empty($idToChange)) {
                            $query = "select * 
                                      from #__booklibrary_lend 
                                      where `fk_bookid` in (" . $idToChange . ") 
                                      and `lend_return` is NULL";
                            $database->setQuery($query);
                            $CheckAssociate = $database->loadObjectList();
                            if (!empty($CheckAssociate)) {
                                echo "<script> alert(' You must return all books from rent first! '); 
                                       window.history.go(-1); </script>";
                                exit;
                            }
                            $query = "UPDATE #__booklibrary 
                                      SET `associate_book`='" . $assocStr . "' 
                                      where `id` in (" . $idToChange . ")";
                            $database->setQuery($query);
                            $database->execute();
                        } else {
                            $query = "UPDATE #__booklibrary 
                                      SET `associate_book`= null 
                                      where `id` = " . $id_check . "";
                            $database->setQuery($query);
                            $database->execute();
                        }
                    }
                }
            }
        }
    }
}
if (!function_exists('getAssociateOld')) {
    function getAssociateOld() {
        global $database;
        $jinput = JFactory::getApplication()->input;
        $jinput = JFactory::getApplication()->input;
        $id_check = $jinput->get('id', "");
        $query = "select `associate_book` 
                  from #__booklibrary 
                  where `id` = " . $id_check . "";
        $database->setQuery($query);
        $oldAssociate = $database->loadResult();
        $oldAssoc_func = unserialize($oldAssociate);
        return $oldAssoc_func;
    }
}
if (!function_exists('ClearAssociateDiff')) {
    function ClearAssociateDiff() {
        global $database;
        $jinput = JFactory::getApplication()->input;
        $id_check = $jinput->get('id', "");
        $language_post = $jinput->get('langshow', "");
        $oldAssociateArray = getAssociateOld();
        $i = 1;
        $assocArray = array();
        // while (count($jinput->get("associate_book" . $i))) {
        while ( isset($_REQUEST["associate_book" . $i]) ) {
            $langAssoc = $jinput->get("associate_book_lang" . $i);
            $valAssoc = $jinput->get("language_associate_book" . $i);
            $assocArray[$langAssoc] = $valAssoc;
            $i++;
        }
        $assocArray[$language_post] = $id_check;
        if (!empty($oldAssociateArray) && !empty($assocArray)) {
            $old_ids_assoc = 
                getAssociateDiff($oldAssociateArray, $assocArray);
            if (count($old_ids_assoc) > 0) {
                foreach($old_ids_assoc as $key => $value) {
                    $diff_assoc2 = getAssociateBooks($value);
                    if (!empty($diff_assoc2)) {
                        $ids_assoc_diff2 = explode(',', $diff_assoc2);
                        foreach($ids_assoc_diff2 as $key2 => $value2) {
                            if (!in_array($value2, $old_ids_assoc)) {
                                $assoc_lang = getAssociateBooksLang($value);
                                foreach($assoc_lang as $key3 => $value3) {
                                    if ($value3 == $value2) {
                                        $assoc_lang[$key3] = 0;
                                    }
                                }
                                $bookLangIds = serialize($assoc_lang);
                                $query = "UPDATE #__booklibrary 
                                          SET `associate_book`='" . 
                                    $bookLangIds . "' where `id` = " . $value . "";
                                $database->setQuery($query);
                                $database->execute();
                            }
                        }
                    }
                }
            }

        }
        if (!empty($oldAssociateArray) && !empty($assocArray)) {
            $new_ids_assoc = 
                getAssociateDiff($assocArray, $oldAssociateArray);
            if (count($new_ids_assoc) > 0) {
                foreach($new_ids_assoc as $key => $value) {
                    $diff_assoc2 = getAssociateBooks($value);
                    if (!empty($diff_assoc2)) {
                        $ids_assoc_diff2 = explode(',', $diff_assoc2);
                        foreach($ids_assoc_diff2 as $key2 => $value2) {
                            if ($value2 == $value || $value2 == 0) continue;
                            $assoc_lang = getAssociateBooksLang($value2);
                            foreach($assoc_lang as $key3 => $value3) {
                                if ($value3 == $value) {
                                    $assoc_lang[$key3] = 0;
                                }
                            }
                            $bookLangIds = serialize($assoc_lang);
                            $query = "UPDATE #__booklibrary 
                                      SET `associate_book`='" . 
                                $bookLangIds . "' where `id` = " . $value2 . "";
                            $database->setQuery($query);
                            $database->execute();
                        }
                    }
                }
            }            
        }

    }
}
if (!function_exists('getAssociateDiff')) {
    function getAssociateDiff($assocArray1, $assocArray2) {
        global $database;
        $diff_ids = array();
        $diff = array_diff($assocArray1, $assocArray2);
        foreach($diff as $key => $value) {
            if ($value != 0) {
                $diff_ids[] = $value;
            }
        }
        return $diff_ids;
    }
}
if (!function_exists('getAssociateBooks')) {
    function getAssociateBooks($bookId) {
        global $database;
        $one = array();
        $query = "select associate_book 
                  from #__booklibrary 
                  where id = " . $bookId . " and associate_book is not null";
        $database->setQuery($query);
        $bookAssociateBook = $database->loadResult();
        $is_correct_assosiate_array = false ;
        if (!empty($bookAssociateBook)) {
            $bookIds_tmp = unserialize($bookAssociateBook);
            foreach($bookIds_tmp as $oneBook) {
                if ($oneBook != 0) {
                    $one[] = $oneBook;
                    if($oneBook == $bookId) $is_correct_assosiate_array = true ;
                }
            }
            $bids = implode(',', $one);
            if( !$is_correct_assosiate_array ) $bids = ""; //return empty - if in assosiate array - not exist book with same id 
            return $bids;
        }
    }
}
if (!function_exists('getAssociateBooksLang')) {
    function getAssociateBooksLang($bookIds) {
        global $database;
        $query = "select associate_book 
                  from #__booklibrary 
                  where id = " . $bookIds . " and associate_book is not null";
        $database->setQuery($query);
        $bookAssociateBook = $database->loadResult();
        if (!empty($bookAssociateBook)) {
            $bookLangIds = unserialize($bookAssociateBook);
            return $bookLangIds;
        }
    }
}

if(!function_exists('return_bytes')){
  function return_bytes($val) {
        if (empty($val))
        {
            return 0;
        }

        $val = trim($val);

        preg_match('#([0-9]+)[\s]*([a-z]+)#i', $val, $matches);

        $last = '';

        if (isset($matches[2]))
        {
            $last = $matches[2];
        }

        if (isset($matches[1]))
        {
           $val = (int) $matches[1];
        }

        switch (strtolower($last))
        {
            case 'g':
            case 'gb':
                $val *= 1024;
            case 'm':
            case 'mb':
                $val *= 1024;
            case 'k':
            case 'kb':
                $val *= 1024;
        }

        return (int) $val;
  }
}

if(!function_exists('protectInjection')){
    function protectInjection($element, $def = '', $filter = "STRING",$bypass_get=false){
        
        $database = JFactory::getDBO();
        
        if(!$bypass_get){
            $value = JFactory::getApplication()->input->get($element, $def, $filter);
        // $value = $element;
        }else{
            $value = $element;
        }

        if(!isset($value) ) return $def;



        if(is_array($value)){
            foreach($value as $key=>$item_value){
                $value[$key] = $database->quote($item_value);
            }
            return $value ;

        }

        return $database->quote($value);
    }

}

if(!function_exists('protectInjectionWithoutQuote')){
    function protectInjectionWithoutQuote($element, $def = '', $filter = "STRING", $bypass_get=false){
        
        $database = JFactory::getDBO();
        
        if(!$bypass_get){
                $value = JFactory::getApplication()->input->get($element, $def, $filter);
                // $value = $element;
             }else{
                $value = $element;
             }

        if(!isset($value) ) return $def;
        $special_symb = array("/*","*/","select", "insert", "update", "drop", "delete", "alter");

        if(is_array($value)){
            foreach($value as $key => $val){
                if(!is_array($val)){
                    $isset_spec_symb = false;
                    foreach($special_symb as $symb){
                        $indx = stripos($val, $symb);
                        if($indx  !== false){
                            if($indx == 0 && preg_match('#'.$symb.'[0-9a-zA-Z@]+#i', $val)==0 ){
                                $isset_spec_symb = true;
                                continue;
                            } else if($indx > 0 && preg_match('#[0-9a-zA-Z@]+'.$symb.'#i', $val)==0 ){
                                $isset_spec_symb = true;
                                continue;
                            }
                        }
                    }
                    if($isset_spec_symb){
                        $val = protectInjection($val, $def , $filter ,true);
                    }else{
                        $val = protectInjectionWithoutQuote($val, $def , $filter ,true);
                    }
                }else{
                    $val = protectInjectionWithoutQuote($val, $def , $filter ,true);
                }
                $value[$key] = $val;
            }
        }else {
            $isset_spec_symb = false;
            foreach($special_symb as $symb){
                $indx = stripos($value, $symb);
                if($indx !== false){
                    if($indx == 0 && preg_match('#'.$symb.'[0-9a-zA-Z@]+#i', $value)==0 ){
                        $isset_spec_symb = true;
                        continue;
                    } else if($indx > 0 && preg_match('#[0-9a-zA-Z@]+'.$symb.'#i', $value)==0 ){
                        $isset_spec_symb = true;
                        continue;
                    }
                }
            }
            if($isset_spec_symb){
                $value = protectInjection($value, $def , $filter ,true);
            }else{
                $value = $database->escape($value);
            }
        }

        return $value;
    }
}


if(!function_exists('findAuthorByName')) {
    function findAuthorByName($author_name) {
        global $database;
        $author_name = addslashes($author_name);
        $query = "SELECT id
                FROM #__booklibrary_authors 
                WHERE authors_name LIKE '%$author_name%'";
        $database->setQuery($query);
        $author_id = $database->loadResult();
        if (!empty($author_id)) return $author_id;
        else return;
    }

}

if(!function_exists('createAuthorByName')) {
    function createAuthorByName($author_name) {
        global $database, $my;
        $authors = null;
        $author_t = new mosBookLibrary_authors($database);
        $author_t->date = date("Y-m-d H:i:s");
        $author_t->approved = 1;
        $author_t->published = 1;
        $author_t->owner_id = $my->id;
        $author_t->authors_name = $author_name;
        if( $author_t->store() ){
           $authors = $author_t->id;
        }   //array( $author_t->id );
        return $authors;
    }
}  

if(!function_exists('addInfoAboutUpdate')){
    function addInfoAboutUpdate() {
        
        global $mosConfig_absolute_path;
        // function for check equivalence versions
        function checkVersion($newversion, $oldversion) {
                if (strpos($newversion, " ") !== false ) 
                    $newversion = explode('.', substr($newversion, 0, strpos($newversion, ' ')));
                else  $newversion = explode('.', $newversion);

                $oldversion = explode('.', substr($oldversion, 0, strpos($oldversion, ' ')));
                return $oldversion === max($newversion, $oldversion);
        }
        // add info about update
        $url="https://ordasoft.com/xml_update/booklibrary_update_shop_pro.xml";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT ,0); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);

        $data = curl_exec($ch);
        curl_close($ch);
 
        if (!$data || stristr($data, 'Not Found')) return; // exit from function if not xml
        $xml = simplexml_load_string($data);
        $ordasoftBookV = (string)$xml->version;
        $ordasoftCreationDate = (string)$xml->creationDate;
        unset($xml);

        $xml = simplexml_load_file($mosConfig_absolute_path . "/administrator/components/com_booklibrary/booklibrary.xml");
        $version = (string)$xml->version;
        $creationDate = (string)$xml->creationDate;
        unset($xml);

        //-------------------------------------------------
        if (!empty($ordasoftBookV) && !checkVersion($ordasoftBookV, $version)) {
            $message = "Available new version Booklibrary $ordasoftBookV" . 
            ", creation date $ordasoftCreationDate";
            JFactory::getApplication()->enqueueMessage($message);
        }
    }
}  


if (!function_exists('checkLendOutTermBL')) {
    function checkLendOutTermBL($lend_from, $lend_until, $oneTerm_lend_from, $oneTerm_lend_until) {
        if (($lend_from >= $oneTerm_lend_from 
            && $lend_from <= $oneTerm_lend_until) 
            || ($lend_from <= $oneTerm_lend_from
            && $lend_until >= $oneTerm_lend_until) 
            || ($lend_until >= $oneTerm_lend_from 
                && $lend_until <= $oneTerm_lend_until)) {
            echo "<script> alert('" . _BOOKLIBRARY_SORRY_OBJECT_ALREADY_LEND_OUT . " " .
                    $oneTerm_lend_from . " until " . $oneTerm_lend_until . "'); 
                    window.history.go(-1); </script>\n";
            exit();
        }
    }
}

if (!function_exists('checkBLVersionProFree')) {
    function checkBLVersionProFree(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_booklibrary/booklibrary.xml");
        if($xml){
            $version = (string)$xml->tag;
            unset($xml);

            return $version;
        }
        return "free" ;
    }
}
