<?php
 /**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');

use Joomla\Utilities\ArrayHelper;

global $doc, $hide_js, $Itemid, $mosConfig_live_site, $mosConfig_absolute_path, $my, $database;
global $limit, $total, $limitstart, $Itemid, $task, $paginations, $mainframe, 
       $booklibrary_configuration, $option;

if(!isset($Itemid)) $Itemid = intval(mosGetParam($_REQUEST, 'Itemid', 0));

if ($cat_name != "") $category_url_part = "task=$cat_name";
else $category_url_part = "task=showCategory&amp;catid=$catid";
$session = JFactory::getSession();
$arr = $session->get("array", "default");
// deprecated in Joomla 4.0 - Use JAccess directly:
// $acl = JFactory::getACL(); 
$acl = new JAccess;

// Get Current User 
if (version_compare(JVERSION, "4.0.0", "ge")) {
    $app = JFactory::getApplication();
    $user = $app->getIdentity();
} else {
    $user = JFactory::getUser(); //old 09/2022
} 

$doc->addStyleSheet($mosConfig_live_site . '/components/com_booklibrary/includes/custom.css');


if( checkJavaScriptIncluded("jQuerBook-1.2.6.js") === false )   {
  $doc->addScript(JURI::root(true) . '/components/com_booklibrary/lightbox/js/jQuerBook-1.2.6.js');
} 
?>


    <script type="text/javascript">
        function lend_request_submitbutton_bl() {
            var form = document.userForm_bl;
            if (form.user_name.value == "") {
                alert( "<?php echo _BOOKLIBRARY_INFOTEXT_JS_LEND_REQ_NAME; ?>" );
            } else if (form.user_email.value == "" || !isValidEmail(form.user_email.value)) {
                alert( "<?php echo _BOOKLIBRARY_INFOTEXT_JS_LEND_REQ_EMAIL; ?>" );
            } else if (form.user_mailing == "") {       
                alert( "<?php echo _BOOKLIBRARY_INFOTEXT_JS_LEND_REQ_MAILING; ?>" );
            } else if ((form.lend_until.value == "")  ) {
                alert( "<?php echo _BOOKLIBRARY_INFOTEXT_JS_LEND_REQ_UNTIL; ?>" );
            } else {
                form.submit();
            }
        }
        function isValidEmail(str) {
            return (str.indexOf("@") > 0);
        }
                
        function allreordering(){
            if(document.orderForm.direction.value=='asc')
                document.orderForm.direction.value='desc';

            else document.orderForm.direction.value='asc';

            document.orderForm.submit();
        }
    </script>

<div class="bl" >

<div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    
    <?php if ($params->get('show_page_heading') && $params->get('header') != "" ) {  ?>
                <h1><?php echo $params->get('header'); ?></h1>
    <?php } else {  ?>
                <h1><?php echo $currentcat->header;  ?></h1>                
    <?php } ?>

 </div>

    <table class="basictable bl_single_category_top_table_width_icons" border="0" cellpadding="4" 
           cellspacing="0" width="100%">
        <tr>                
<?php 
if ($currentcat->img != null && $params->get('show_cat_pic') && false) { ?>
            <td>
                <img src="<?php echo $currentcat->img; ?>" align="<?php echo $currentcat->align; ?>" 
                     alt="booklibrary"/>
            </td>

<?php } ?>

     <td width="85%">
<?php
if (!$params->get('wrongitemid')) {
?>
    <?php 
    echo $currentcat->descrip;
} ?>
        </td>
        </tr>
    </table>
    <?php

if (isset($currentcat->header) && strpos($currentcat->header, _BOOKLIBRARY_LABEL_SEARCH) && count($rows) == 0) {
?>
        <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
        <?php echo _BOOKLIBRARY_NOTHING_FOUND; ?>
        </div>
        <?php
    mosHTML::BackButton($params, $hide_js);
    return;
}
if ($params->get('show_search')) { ?>
    <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">

        <div  class="single_category_search">
        <?php
    
        if ($params->get('advsearch_show')) 
                echo '<div class="bl_bl_single_category_top_advanced_search my_btn my_btn-info">
                <a href="' . JRoute::_('index.php?option=com_booklibrary&task=show_search&catid=0&Itemid=' . $Itemid ) . '">' . 
                _BOOKLIBRARY_ADMIN_CONFIG_ADVSEARCH . '</a></div>';
        if ($params->get('search_fieldshow')) echo HTML_booklibrary::displaySimpleSearch();
        ?>
        </div>
    </div>
<?php
}
$total = count($rows);
if ($total + 1 > 0) {
    $sort_arr['field'] = $params->get('sort_arr_field');
    $sort_arr['direction'] = $params->get('sort_arr_direction');
?>
        <table width="100%" class="basictable bl_all_books_list_top_table_order_by">
        <tr>
        <?php

              // JArrayHelper deprecated 4.0 Use Joomla\Utilities\ArrayHelper instead (ArrayHelper since J 1.0)
              // $option_type = JArrayHelper::getValue($_REQUEST, 'option');
              $option_type = ArrayHelper::getValue($_REQUEST, 'option');
 if (count($rows) > 1 ) {  
	if ($option_type != 'com_simplemembership') { ?> 
            <td >
              <div id="ShowOrderBy" style="text-align:right" >
              <form class="bl_bl_books_gallery_sort_by" id="adminFormSort" method="POST" action="<?php
        if (isset($_SERVER['REQUEST_URI'])) {
            echo sefRelToAbs($_SERVER['REQUEST_URI']);
            // print_r($_SERVER['REQUEST_URI']);
            //echo "<pre>";
            // var_dump($sort_arr); exit();
            // echo "</pre>";
            
        } ?>" 
            name="orderForm">
                
                  <input type="hidden" id="direction" name="direction" 
                         value="<?php echo $sort_arr['direction']; ?>" >
                  <a title="Click to sort by this column." 
                     onclick="javascript:allreordering();return false;" href="#">
                      <img alt="" src="<?php echo $mosConfig_live_site; ?>/components/com_booklibrary/images/sort_<?php
        if ($sort_arr['direction'] == false) {
            echo 'asc';
        } else {
            echo $sort_arr['direction'];
        } ?>.png" />
                  </a>
                  <?php echo _BOOKLIBRARY_LABEL_ORDER_BY; ?>
      <select size="1" class="inputbox" 
              onchange="javascript:document.orderForm.direction.value='asc'; document.orderForm.submit();" 
              id="field" name="field">
      <option value="authors" <?php if ($sort_arr['field'] == "authors") 
        echo 'selected="selected"'; ?> > <?php echo _BOOKLIBRARY_LABEL_AUTHORS; ?></option>
      <option value="title" <?php if ($sort_arr['field'] == "title") 
        echo 'selected="selected"'; ?> > <?php echo _BOOKLIBRARY_LABEL_TITLE; ?></option>
      <option value="rating" <?php if ($sort_arr['field'] == "rating") 
        echo 'selected="selected"'; ?> > <?php echo _BOOKLIBRARY_LABEL_RATING; ?></option>
      <option value="hits" <?php if ($sort_arr['field'] == "hits") 
        echo 'selected="selected"'; ?> > <?php echo _BOOKLIBRARY_LABEL_HITS; ?></option>
  </select>       
              </form>
              </div>
            </td>

    <?php }
 } ?>

          </tr>
    </table>                

    <?php
    $available = false;

    ?>
        <div id="list" class="bl_bl_books">
            <table  width="100%" border="0" cellspacing="0" cellpadding="0" 
                    class="bl_bl_books_list my_table my_table-bordered my_table-hover">
                <tr>
                    <th width="50" class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
                        <?php echo _BOOKLIBRARY_LABEL_COVER; ?>
                    </th>
                    <th class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE; ?>
                    </th>
                    <th class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
                        <?php echo _BOOKLIBRARY_LABEL_AUTHORS; ?>
                    </th>

    <?php if ($params->get('show_rating')) { ?>

                        <th class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
                            <?php echo _BOOKLIBRARY_LABEL_RATING; ?>
                        </th>
    <?php }
        if ($params->get('hits')) {
    ?>
                        <th width="30" class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>" >
                            <?php echo _BOOKLIBRARY_LABEL_HITS; ?>
                        </th>
    <?php
    }
        if ($params->get('search_request')) {
    ?>
                        <th class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
                        <?php echo _BOOKLIBRARY_LABEL_CATEGORY; ?>
                        </th>
    <?php
    }
        if ($params->get('show_lendstatus') && $params->get('show_lendrequest')) {
    ?>
                        <th class="sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>" 
                            align="center">    
                            <?php echo _BOOKLIBRARY_LABEL_LEND_CB; ?>
                        </th>
    <?php
        }
    ?>
                </tr>
        <?php
        $k = 0;

        //****************************************   add my perenos
        foreach($rows as $row) {


            //****************************************   add my perenos
            $cat_id = @(isset($row->category_id)) ? $row->category_id : $catid;

            $option = 'com_booklibrary';

            $link = 'index.php?option=' . $option . 
                '&task=view_bl&id=' . $row->id . '&catid=' . 
                $cat_id . '&Itemid=' . $Itemid;


        ?>
                    <tr class="<?php echo $tabclass[$k]; ?>" >
                        <td class="bl_table_book_img" width="15%" 
                            style="padding:7px;text-align:center;position:relative;">
        <?php
            $book = $row;
            //for local images
            $imageURL = $book->imageURL;
        ?>    
                            <a href="<?php echo sefRelToAbs($link); ?>" 
                              class="category<?php echo $params->get('pageclass_sfx'); ?>">
                            <?php
                            if ($imageURL != '' && substr($imageURL, 0, 4) != "http") {
                                $imageURL = $mosConfig_live_site . '' . $book->imageURL;;
                            }
                            if ($imageURL != '') {
                                echo '<img src="' . $imageURL . '" alt="cover" border="0" 
                                    height="80" width="60"  />'; 
                                
                            } else {
                                echo '<img src="' . $mosConfig_live_site . 
                                    '/components/com_booklibrary/images/' . _BOOKLIBRARY_NO_PICTURE . 
                                    '" alt="no-img_eng.png" border="0" height="80" width="60" />';
                            }
                            ?> 
                            </a>

                        </td>
                        <td  width="35%">
                        <span class="hidename"> <?php echo _BOOKLIBRARY_LABEL_TITLE; ?>:</span>
                            <a href="<?php echo sefRelToAbs($link); ?>" 
                               class="category<?php echo $params->get('pageclass_sfx'); ?>">
                                <?php echo $row->title; ?> 
                            </a> 
                        </td>
                        
                        <td  width="15%">
                        <span class="hidename"> <?php echo _BOOKLIBRARY_LABEL_AUTHORS; ?>:</span>

                        <?php

                        if (isset($authors_info[$row->id])) {
                            
                            $authors = $authors_info[$row->id];
                            $i = 1;
                            $count = count($authors);

                                foreach ($authors as $author) 
                                {

                                    $link1 = "index.php?option=com_booklibrary&amp;task=view_author&amp;id=" . $author['author_id'] . 
                                    "&amp;Itemid=" . $Itemid;
                                    ?>
                                    <a href="<?php echo sefRelToAbs($link1); ?>" 
                                        class="category<?php echo $params->get('pageclass_sfx'); ?>">
                                    <?php 
                                    echo $author['authors_name']."</a>";
                                    if ($i < $count) echo ", ";
                                    $i++;
                                }
                            unset($i);
                            unset($count);
                            unset($authors);
                        } elseif (isset($rows[0]->authors)) {

                                echo '<div style="text-align: center;">' . $rows[0]->authors . "</div>";

                        }
                        ?>
                       
                        </td>
                        <?php
                        if ($params->get('show_rating')) {
                            if ($row->rating == 0 && $row->rating2 != 0) $row->rating = $row->rating2;
                        ?>
                            <td width="10%">
                            <span class="hidename"> <?php echo _BOOKLIBRARY_LABEL_RATING; ?>:</span>
                                <img src="<?php echo $mosConfig_live_site; ?>/components/com_booklibrary/images/rating-<?php 
                                     echo $row->rating; ?>.png" 
                                     alt="<?php echo ($row->rating) / 2; ?>" border="0" width="100"/>
                            </td>
                            <?php
                            }
                                if ($params->get('hits')) {
                            ?>
                            <td width="5%">
                            <span class="hidename"> <?php echo _BOOKLIBRARY_LABEL_HITS; ?>:</span>
                            <?php echo $row->hits; ?>
                            </td>
                            <?php
                            }
                                if ($params->get('search_request')) {
                                    $link1 = 'index.php?option=com_booklibrary&task=showCategory&catid=' . 
                                        $row->category_id . '&Itemid=' . $Itemid;
                            ?>
                            <td width="10%">
                            <span class="hidename"> <?php echo _BOOKLIBRARY_LABEL_CATEGORY; ?>:</span>
                                <a href="<?php echo sefRelToAbs($link1); ?>" 
                                   class="category<?php echo $params->get('pageclass_sfx'); ?>">
                                    <?php echo $row->category; ?>
                                </a>
                            </td>
                            <?php
                            }
                            if ($params->get('show_lendstatus') && $params->get('show_lendrequest')) {
                                $data1 = JFactory::getDBO();
                                $query = "SELECT  b.lend_from , b.lend_until  
                                          FROM #__booklibrary_lend  AS b 
                                          LEFT JOIN #__booklibrary AS c ON b.fk_bookid = c.id 
                                          WHERE  c.id=" . $row->id . " AND c.published='1' 
                                          AND c.approved='1' AND b.lend_return IS NULL";
                                $data1->setQuery($query);
                                $rents1 = $data1->loadObjectList();
                            ?>
                            <td align="center" width="10%">
                            <span class="hidename"> <?php echo _BOOKLIBRARY_LABEL_LEND_CB; ?>:</span>
                            <?php
                                 if (count($rents1) == 0) {
                            ?>
                            <?php
                                echo "<img src='" . $mosConfig_live_site . 
                                "/components/com_booklibrary/images/ok.png' alt='Available' 
                                name='image' border='0' align='middle' />";
                            } else {
                                echo _BOOKLIBRARY_LABEL_LEND_FROM_UNTIL . "<br />";
                                for ($a = 0;$a < count($rents1);$a++) {
                                    $from_until = substr($rents1[$a]->lend_from, 0, 10) . 
                                        "&nbsp;/&nbsp;" . substr($rents1[$a]->lend_until, 0, 10) . "\n";
                                    print_r($from_until);
                                }
                            }
                            if ($params->get('lend_save')) {
                                $available = true;
                            } else {
                                $available = false;
                            }
                            ?>
                                <br>
                            </td>

                            <?php } ?>

                        </tr>
                    <?php
                    $k = 1 - $k;
                    }
                    ?>

            </table>
        <?php
        //show index for field authors,title
        if (!isset($_REQUEST['task'])) $_REQUEST['task'] = '';
        if ($_REQUEST['task'] != 'lend_request_bl') {
            if ($sort_arr['field'] == "authors" || $sort_arr['field'] == "title") {
        ?>
                    <div id="paginator-custom-index">    
                    <?php
                    foreach($list_str as $a) {
                        echo $a;
                    }
                    ?>
                    </div>  
            <?php
                }
            } // close show index
        
            ?>
        </div>

    <?php
} ?>

            <div id="paginator-custom">
                <?php
                if ($pageNav != null && $pageNav->total > $pageNav->limit) {
                    echo $pageNav->getPagesLinks(); 
                }
                ?>
            </div>
    <?php
if ($params->get('show_lendstatus') && $params->get('show_lendrequest') 
    && $params->get('lend_save')) {
?>

        <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
        <?php echo _BOOKLIBRARY_LABEL_LEND_INFORMATIONS; ?>
        </div>
        <form class="a" id="adminForm_bl" action="<?php echo sefRelToAbs("index.php"); ?>" 
              name="userForm_bl" method="post">
            <table  class="basictable bl_view_book_lend_request_table_lend_information_first my_table" 
                    width="100%" border="0" cellspacing="0" cellpadding="0">            
                <tr>
                    <td style="text-align:left;padding:10px 0px 0px 0px;display:inline-block;
                               width:125px;text-transform:capitalize;">
                        <?php
    echo _BOOKLIBRARY_LABEL_LEND_REQUEST_NAME;
    global $my;
?>:&nbsp;
                    </td>
                    <td style="text-align:left;padding:0px;display:inline-block;width:230px;">
                       <input type="hidden"  name="bookid" id="bookid"  value="<?php
                        if (!empty($rows[0])) {
                            echo $rows[0]->id;
                        } ?>"  maxlength="80" />
                        <input style="position:relative;top:10px;" class="inputbox" type="text" 
                               name="user_name" size="38" maxlength="80" 
                               value="<?php if ($my->name != '') echo $my->name ?>" />       
                    </td>
                    <td></td>
                </tr>

                <tr>
                    <td style="text-align:left;padding:10px 0px 0px 0px;display:inline-block;
                               width:125px;text-transform:capitalize;">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_REQUEST_EMAIL; ?>:&nbsp;
                    </td>
                    <td style="text-align:left;padding:0px;display:inline-block;width:230px;">
                        <input style="position:relative;top:10px;" class="inputbox" type="text" 
                               name="user_email" size="38" maxlength="80" 
                               value="<?php if ($my->name != '') echo $my->email ?>" />
                        <input type="hidden" name="option" value="<?php echo $option; ?>"/>
                        <input type="hidden" name="task" value="save_lend_request_bl"/>
                        <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>"/>
                        <input type="hidden" name="bookid" value="<?php
                        if (!empty($rows[0])) {
                            echo $rows[0]->id;
                            }?>"/>            
                        <input type="hidden" name="bid[]" value="<?php
                        if (!empty($rows[0])) {
                            echo $rows[0]->id;
                        }?>"/>
                    </td>
                    <td></td>
                </tr>

            </table>                     
            <script>
                Date.prototype.toLocaleFormat = function(format) {
                    var f = {Y : this.getYear() + 1900,m : this.getMonth() +
                      1,d : this.getDate(),H : this.getHours(),M : this.getMinutes(),S : this.getSeconds()}
                    for(k in f)
                        format = format.replace('%' + k, f[k] < 10 ? "0" + f[k] : f[k]);
                    return format;
                };

                        
                window.onload = function ()
                {
                    var today = new Date();
                    var date = today.toLocaleFormat("<?php 
                        echo $booklibrary_configuration['date_format'] ?>");
                    document.getElementById('lend_from').value = date;
                    document.getElementById('lend_until').value = date;
                }; 
            </script>
            <table  class="basictable bl_view_book_lend_request_table_lend_information_second my_table" 
                    width="100%" border="0" cellspacing="0" cellpadding="0">              
                <tr>
                    <td style="text-align:left;padding:0px;display:inline-block;width:125px;">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_REQUEST_MAILING; ?>:&nbsp;                    
                    </td>
                    <td style="text-align:left;padding:0px;display:inline-block;width:260px;">     
                        <textarea align= "top" name="user_mailing" id="user_mailing" cols="60" 
                                  rows="10" style="width:210px;height:100px;" value=""></textarea>
                    </td>
                    <td></td>
                </tr>
                <tr>    
                    <td style="text-align:left;padding:0px;display:inline-block;width:125px;">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_REQUEST_FROM; ?>:&nbsp;
                    </td>
                    <td style="text-align:left;padding:0px;display:inline-block;width:260px;">
                    <?php
                        $date_format = str_replace('%', '', $booklibrary_configuration['date_format']);
                        
                        echo JHtml::_('calendar', date("Y-m-d"), 'lend_from', 'lend_from', 
                            $booklibrary_configuration['date_format']);
                    ?>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td style="text-align:left;padding:0px;display:inline-block;width:125px;">
        <?php echo _BOOKLIBRARY_LABEL_LEND_REQUEST_UNTIL; ?>:&nbsp;
                    </td>    
                    <td style="text-align:left;padding:5px 0px 0px 0px;display:inline-block;width:260px;">
        <?php 
        echo JHtml::_('calendar', date("Y-m-d"), 'lend_until', 'lend_until', 
            $booklibrary_configuration['date_format']); ?>
                    </td>
                    <td></td>
                </tr>
            </table>
            <input type="button" class="button my_btn my_btn-success" 
            value="<?php echo _BOOKLIBRARY_LABEL_BUTTON_LEND_REQU_SAVE; ?>" 
                   onclick="lend_request_submitbutton_bl()" />
          </form>

        <?php } ?>

        <table  class="basictable bl_bl_view_book_lent_request_intresting_table_with_hidden_inputs" 
                width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td width="260">
                    <?php
                    if ($params->get('show_lendstatus') && $params->get('show_lendrequest') 
                        && $params->get('lend_save')) {
                    ?>

                    <?php }  ?>

                </td>                      
                <td align="right">
                <?php
                //     displays back button
                    if (count($rows)) mosHTML::BackButton($params, $hide_js);
                ?>
                </td>
            </tr>
        </table>
    <?php
        if ($is_exist_sub_categories) {
    ?>   
        <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
            <?php echo _BOOKLIBRARY_LABEL_FETCHED_SUBCATEGORIES . " : " . 
            $params->get('category_name'); ?>
        </div>
<?php
    //HTML_booklibrary::listCategories($params, $categories, $catid, $tabclass, $currentcat);
     ?>
        <div class="bl_bl_single_category_list_categories_table my_table-bordered show_categories_wrapper">
        <?php
            $show_subcat_class = "all_categories_new";
            if(!isset($one_item_layout) || $one_item_layout == "_one_item1" ) {
                $show_subcat_class = "";
        ?>
            <div class="show_categories_wrapper_title">
                <div class="sectiontableheader sectiontableheader_category<?php echo $params->get('pageclass_sfx'); ?>">
        <?php echo _BOOKLIBRARY_LABEL_CATEGORY; ?>
                </div>
                <div class="sectiontableheader sectiontableheader_books<?php echo $params->get('pageclass_sfx'); ?>">
                <?php echo _BOOKLIBRARY_LABEL_BOOKS; ?> 
                </div>


                <div class="sectiontableheader sectiontableheader_rss" style="text-align:center;">
                <?php
                    $Itemid = intval(mosGetParam($_REQUEST, 'Itemid', 0));
                ?>
                        <?php  
              if ($params->get('rss_show')){ ?>
                        <a href="<?php echo $mosConfig_live_site; ?>/index.php?option=com_booklibrary&task=show_rss_categories&Itemid=<?php 
                            echo $Itemid; ?>">
                            <img src="<?php echo $mosConfig_live_site; ?>/components/com_booklibrary/images/rss.gif" 
                                 alt="All categories RSS" title="All categories RSS"/>
                        </a>
                        <?php } ?>
                </div>

                
            </div>
        <?php
            }//if(!isset($one_item_layout) || $one_item_layout == "_one_item1" )
        ?>
                
            <div class="show_categories_list_wrapper <?php echo $show_subcat_class; ?>">
                <div>
                    <?php
                        HTML_booklibrary::showInsertSubCategory($catid, $categories, $params, $tabclass, 
                                                                $Itemid, 0,$one_item_layout);
                    ?>
                </div>
            </div>

        </div>


    <?php
    echo '<table  class="basictable bl_bl_single_category_intresting_table_with_not_visible_button" 
           width="100%"><tr><td width="60%"></td><td>';
    mosHTML::BackButton($params, $hide_js);
    echo '</td></tr></table>';
}
?>

<!-- Modal -->
<a href="#aboutus" class="book-button-about"></a>
                    
<a href="#book-modal-css" class="book-overlay" id="book-aboutus" style="display: none;"></a>
<div class="book-popup">
    <div class="book-modal-text">
        Please past text to modal
    </div>
     
    <a class="book-close" title="Close" href="#book-close"></a>
</div>

<div style="text-align: center;font-size: 10px;"><a href="https://ordasoft.com/book-library" >Book Library</a>, by OrdaSoft!</div>

</div> <!-- class="bl" -->
