<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');
//require_once ($mosConfig_absolute_path . "/libraries/joomla/factory.php");
require_once (JPATH_BASE . DS . 'includes' . DS . 'defines.php');
require_once (JPATH_BASE . DS . 'includes' . DS . 'framework.php');

$mainframe = JFactory::getApplication();
$templateDir = 'templates/' . $mainframe->getTemplate();
$GLOBALS['mainframe'] = $mainframe;
$GLOBALS['templateDir'] = $templateDir;
$mosConfig_live_site = JURI::root(true);
$GLOBALS['mosConfig_live_site'] = $mosConfig_live_site;
$doc = JFactory::getDocument();
$GLOBALS['doc'] = $doc;
// --
// ensure this file is being included by a parent file
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.ws.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.others.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.conf.php");
class HTML_Categories {
    
    static function show($rows, $myid, &$pageNav, &$lists, $type, $langshow_filter) {
        global $my, $mainframe, $mosConfig_live_site, $templateDir, $doc;
        $doc->addScript($mosConfig_live_site . 
            '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='Config' />" . 
            _BOOKLIBRARY_CATEGORIES_MANAGER . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
        $section = "com_booklibrary";
        $section_name = "BookLibrary";
?>
        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">

            <div class="admin1 wrapper-search-books">
                    <div>
                      <?php echo $langshow_filter; ?>
                    </div>
                    
            </div>
            <div class="wrapper-col-books">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                    <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?>
                    </label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div> 

            <table class="adminlist my_table my_table-bordered my_table-hover bl_admin_categories_main_table">
                <tr class="cat-header">
                    <th width="20" style="text-align:center;">#</th>
                    <th width="20" style="text-align:center;">
                        <input type="checkbox" name="toggle" value="" 
                            onClick="Joomla.checkAll(this<?php //echo count($rows);?>);" />
                    </th>
                    <th align = "center" class="title"><?php echo _BOOKLIBRARY_HEADER_CATEGORY; ?></th>
                    <th align = "center" width="5%"><?php echo _BOOKLIBRARY_HEADER_NUMBER; ?></th>
                    <th align = "center" width="10%"><?php echo _BOOKLIBRARY_HEADER_PUBLISHED; ?></th>
                    <?php if ($section <> 'content') { ?>
                        <th align = "center" colspan="2"><?php echo _BOOKLIBRARY_HEADER_REORDER; ?></th>

    <?php } ?>

                    <th align = "center" width="10%"><?php echo _BOOKLIBRARY_HEADER_ACCESS; ?></th>
                        <?php if ($section == 'content') { ?>
                        <th width="12%" align="left">Section</th>
    <?php } ?>
                    <th align = "center" width="12%">ID</th>
                    <th align = "center" width="12%"><?php echo _BOOKLIBRARY_HEADER_CHECKED_OUT; ?></th>
                    <th align = "center" width="8%"><?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?></th>
                </tr>
                
                
                
    <?php
        $k = 0;
        $i = 0;
        $n = count($rows);
        foreach($rows as $row) {
            $img = $row->published ? 'ok.png' : 'remove.png';
            $task = $row->published ? 'unpublish' : 'publish';
            $alt = $row->published ? 'Published' : 'Unpublished';
            if (!$row->access) {
                $color_access = 'style="color: green;"';
                $task_access = 'accessregistered';
            } else if ($row->access == 1) {
                $color_access = 'style="color: red;"';
                $task_access = 'accessspecial';
            } else {
                $color_access = 'style="color: black;"';
                $task_access = 'accesspublic';
            }
    ?>
                <tr class="<?php echo "row$k"; ?>">
                    <td width="20" align="center"><?php echo $pageNav->getRowOffset($i); ?></td>
                    <td width="20" style="text-align:center">
                        <?php echo mosHTML::idBox($i, $row->id, ($row->checked_out_contact_category && 
                            $row->checked_out_contact_category != $my->id), 'bid'); ?>
                    </td>
                    <td width="35%"  align = "left" >
                        <?php if ($row->checked_out_contact_category && 
                        ($row->checked_out_contact_category != $my->id)) { ?>
                        <?php // echo $row->treename . ' ( ' . $row->title . ' )'; ?>
                        <?php echo $row->treename . ' ( ' . $row->alias . ' )'; ?>
                        &nbsp;[ <i>Checked Out</i> ]

    <?php } else { ?>

                        <a href="#edit" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit')">
                            <?php // echo $row->treename . ' ( ' . $row->title . ' )'; ?>
                            <?php echo $row->treename . ' ( ' . $row->alias . ' )'; ?>
                        </a> 

    <?php } ?>

                    </td>
                    <td align="center" style="text-align:center"><?php echo $row->cc; ?></td>
                    <td align="center" style="text-align:center">
                        <a href="javascript: void(0);" 
                           onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','<?php echo $task; ?>')">
                          <img src="<?php echo $mosConfig_live_site . 
                             "/components/com_booklibrary/images/" . $img; ?>" 
                             border="0" alt="<?php echo $alt; ?>" />
                        </a>
                    </td>
                    <td style="text-align:center;vertical-align:middle;">
                        <?php echo catOrderUpIcon($row->ordering - 1, $i); ?></td>
                    <td style="text-align:center;vertical-align:middle;">
                        <?php echo catOrderDownIcon($row->ordering - 1, $row->all_fields_in_list, $i); ?></td>
                    <td align="center"><?php echo $row->groups; ?></td>
                    <td align="center"><?php echo $row->id; ?></td>
                    <td align="center"><?php echo $row->checked_out_contact_category ? $row->editor : ""; ?></td>
                    <td align="center"><?php echo $row->language ?></td>
                    <?php $k = 1 - $k; ?>
                </tr>
                <?php $k = 1 - $k;
                $i++;
                    } ?>
                <tr class="for_paginator">
                    <td colspan = "11"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>

            <input type="hidden" name="option" value="com_booklibrary" />
            <input type="hidden" name="section" value="categories" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="chosen" value="" />
            <input type="hidden" name="act" value="" />
            <input type="hidden" name="boxchecked" value="0" />
            <input type="hidden" name="type" value="<?php echo $type; ?>" />
        </form>
    <?php
    }
    /**
     * Writes the edit form for new and existing categories
     *
     */
    static function edit(&$row, $section, &$lists, $redirect, $associate_cat_arr,$meta_robots) {
        global $my, $mosConfig_live_site, $mainframe, $option, $doc,$database,$booklibrary_configuration;

        os_hide_left_panel();

        $doc->addScript($mosConfig_live_site . 
            '/components/com_booklibrary/includes/functions.js');
        $aa = $row->id ? _BOOKLIBRARY_HEADER_EDIT : _BOOKLIBRARY_HEADER_ADD;
        $a = $aa . " " . _BOOKLIBRARY_CATEGORY . " " . $row->name;
        $html = '<div class="book_manager_caption"><img 
            src="./components/com_booklibrary/images/cfg.png"/>' . $a . '</div>';
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
        if ($row->image == "") {
            $row->image = './components/com_booklibrary/images/no-img_eng.gif';
        }
        mosMakeHtmlSafe($row, ENT_QUOTES, 'description');
    ?>
        <script language="javascript" type="text/javascript">
           
           
           // function submitbutton(pressbutton) {       
            Joomla.submitbutton = function(pressbutton) {
                
                var form = document.adminForm;
                if (pressbutton == 'cancel') {
                    Joomla.submitform( pressbutton );
                    return;
                }
                
                /* [inserted by]: Wonderer */
                alias = document.getElementById('alias'); alias = trim(alias.value);        
                cat_name = document.getElementById('cat_name'); cat_name = trim(cat_name.value);
                title = document.getElementById('title'); title.value = cat_name;
                        
                if ( alias == '' ) { alert( "<?php 
                    echo _BOOKLIBRARY_ADMIN_INFOTEXT_CAT_CHECK_ERR_ALIAS; ?>" );return;}
                if ( cat_name == '' ) { alert( "<?php 
                    echo _BOOKLIBRARY_ADMIN_INFOTEXT_CAT_CHECK_ERR_NAME; ?>" );return;}
                if ( title == '' ) { alert( "<?php 
                    echo _BOOKLIBRARY_ADMIN_INFOTEXT_CAT_CHECK_ERR_TITLE; ?>" );return;}
                // --

                /* if ( form.name.value == "" ) {
                    alert('<?php // echo _BOOKLIBRARY_DML_CAT_MUST_SELECT_NAME; ?>');
                } else {
                    <?php // getEditorContents('editor1', 'description'); ?> */
                    Joomla.submitform(pressbutton);
                // }
            }
                    
                    function trim(string)
                    {
                        return string.replace(/(^\s+)|(\s+$)/g, "");
                    }
        </script>

    <?php
        
        //my !!!!! -------- langdescription   --------------------------------------------
        // Comment added in ver 5.0 when migrate on J4. It seems like this code don`t use:
        // $lg = JFactory::getLanguage();
        // $installed = $lg->getKnownLanguages();
        // $languages_row[] = mosHTML::makeOption('*', 'All');
        // foreach($installed as $installang) {
        //     $langname = $installang['name'];
        //     $languages_row[] = mosHTML::makeOption($langname, $langname);
        // }
        // $langlistshow = mosHTML::selectList($languages_row, 'langshow', 'class="inputbox" size="1"', 
        //     'value', 'text', $row->langshow);
        // $lists['langshow'] = $langlistshow;
        //end of my langdecription ---------  !!!!   -------------------------------------
        
    ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">

            <table width="100%" class="my_table bl_admin_categories_category">
                <tr>
                    <td valign="top">

                        <table class="adminform my_table bl_admin_edit_category" width="100%">
                            <tr>
                                <th colspan="3"><h1><?php echo _BOOKLIBRARY_CATEGORIES__DETAILS; ?></h1></th>
                </tr>
                <tr>
                    <td width="20%"><?php echo "ID"; ?>:</td>
                    <td colspan="2" width="80%">
                        <input readonly="readonly" class="text_area id" type="text" name="catid" id="catid" 
                                value="<?php echo $row->id; ?>" 
                                size="30" maxlength="50" title="" />
                    </td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_CATEGORIES_HEADER_NAME; ?>:</td>
                    <td colspan="2">
                        <input class="text_area" type="hidden" name="title" id="title" 
                                value="<?php echo $row->title; ?>" maxlength="50" title="" />
                        <input class="text_area" type="text" name="name" id="cat_name" 
                                value="<?php echo $row->name; ?>" 
                                size="30" maxlength="255" title="" />
                    </td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_CATEGORIES_HEADER_ALIAS; ?>:</td>
                    <td colspan="2">
                        <input class="text_area" type="text" name="alias" id="alias" 
                                value="<?php echo $row->alias; ?>" size="30" 
                        maxlength="255" title="A short name to appear in menus" />
                    </td>
                </tr>

    <?php
        /*******************************************************************************************/
        if (!empty($associate_cat_arr) && !empty($row->language) && $row->language != '' && 
            $row->language != '*') {
    ?>
                <tr> 
                    <td width="15%"><?php echo 'language associate category' ?>:</td>                        
                </tr>   
    <?php
            $j = 1;
            foreach($associate_cat_arr as $lang => $value) {
                $displ = '';
                if (!$value['list']) {
                    $displ = 'none';
                }
    ?>    
                <tr style="display: <?php echo $displ ?>">
                    <td width="15%"><?php echo $lang; ?>:</td>
                    <td width="60%"><?php echo $value['list']; ?> 
                    <input class="inputbox" id="associate_category" type="text" 
                    name="associate_category<?php echo $j; ?>" size="20" readonly="readonly" 
                    maxlength="20" style="width:25px;" 
                    value="<?php echo $value['assocId']; ?>" />
                    <input style="display: none" name="associate_category_lang<?php echo $j; ?>" 
                    value="<?php echo $lang ?>"/>  
                    </td>                          
                </tr>
    <?php
                $j++;
            }
        } else {
    ?>
                <tr> 
                    <td width="15%"><?php echo 'language associate category' ?>:</td> 
                    <td width="60%"><?php echo 'this property only for category with language' ?> 
                </tr> 
    <?php
        }
        /******************************************************************************************/
    ?>  
<script>
    window.onload = function(){
        
        var languageParentId = document.querySelectorAll('#language_associate_category');
        for(var i = 0; i < languageParentId.length; i++){
    
            var el = languageParentId[i];
            var idField = languageParentId[i].nextSibling.nextSibling;
            el.value = idField.value;
    
            var field = (function(x){
                el.onchange= function(){
                    var el = languageParentId[x];
                    var idField = languageParentId[x].nextSibling.nextSibling;
                    idField.value = el.value;     
                };  
            })(i);
        }
    };
</script>  
                <tr>
                    <td><?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?>:</td>
                    <td colspan="2"><?php echo $lists['languages']; ?></td>
                </tr>

<!--                 <tr>
                    <td><?php echo _BOOKLIBRARY_CONFIG_VIEW_TYPE; ?>:</td>
                    <td colspan="2"><?php echo $lists['alone_category']; ?></td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_VIEW_BOOK; ?>:</td>
                    <td colspan="2"><?php echo $lists['view_book']; ?></td>
                </tr>
 -->                <tr>
                    <td><?php echo _BOOKLIBRARY_CATEGORIES__PARENTITEM; ?>:</td>
                    <td colspan="2"><?php echo $lists['parent']; ?></td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_CATEGORIES_HEADER_IMAGE; ?>:</td>
                    <td><?php echo $lists['image']; ?><?php echo _BOOKLIBRARY_IMAGES_STORIES; ?></td>
                    <td rowspan="4" width="50%" style="vertical-align: baseline;">
                        <script language="javascript" type="text/javascript">
                            if ( document.adminForm.image.selectedIndex > 0 )
                            {
                                jsimg='../images/stories/' + getSelectedValue( 'adminForm', 'image' );
                            } 
                            else 
                            {
                                jsimg='../components/com_booklibrary/images/no-img_eng.gif';
                            }
                            document.write('<img src=' + jsimg + ' name="imagelib" width="80" height="80"  border="2" alt="<?php echo _BOOKLIBRARY_CATEGORIES__IMAGEPREVIEW; ?>" />');

                        </script>
                    </td>
                </tr>
                <!--tr>
                    <td><?php echo _BOOKLIBRARY_CATEGORIES_HEADER_IMAGEPOS; ?>:</td>
                    <td><?php echo $lists['image_position']; ?></td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_CATEGORIES_HEADER_ORDER; ?>:</td>
                    <td><?php echo $lists['ordering']; ?></td>
                </tr-->
                <!--tr>
                    <td><?php echo _BOOKLIBRARY_HEADER_ACCESS; ?>:</td>
                    <td><?php echo $lists['category']['registrationlevel']; ?></td>
                </tr-->
                <tr>
                    <td><?php echo _BOOKLIBRARY_HEADER_PUBLISHED; ?>:</td>
                    <td colspan="2"><?php echo $lists['published']; ?></td>
                </tr>
                <tr>
                    <td valign="top"><?php echo _BOOKLIBRARY_CATEGORIES__DETAILS; ?>:</td>
                    <td colspan="2">
    <?php
        // parameters : areaname, content, hidden field, width, height, rows, cols
        editorArea('editor1', $row->description, 'description', '500', '200', '50', '5');
    ?>
                    </td>
                </tr>
                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                <tr>
                    <td valign="top" >
                        <strong><?php echo _BOOKLIBRARY_START_PUBLISHING; ?>:</strong>
                    </td>
                    <td align="left">
                        <?php echo JHTML::_( 'calendar',$row->publish_up ,$name='publish_up' ,$id='publish_up' ,$booklibrary_configuration['date_format'] ,array('class'=>"bl_calendar") ); ?>                
                    </td>
                </tr>
                <tr>
                    <td valign="top" >
                        <strong><?php echo _BOOKLIBRARY_FINISH_PUBLISHING; ?>:</strong>
                    </td>
                    <td align="left"  style="width:230px">
                        <?php echo JHTML::_( 'calendar',$row->publish_down ,$name='publish_down' ,$id='publish_down' ,$booklibrary_configuration['date_format'] ,array('class'=>"bl_calendar") ); ?>                
                    </td>
                </tr>

                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                
                <tr>
                    <td valign="top">
                        <strong><?php echo _BOOKLIBRARY_META_TITLE; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" type="text" name="metadata[meta_title]" size="50" maxlength="150"
                               value="<?php echo $row->metadata["meta_title"]; ?>" />                
                    </td>
                </tr>
                <tr>
                    <td valign="top">
                        <strong><?php echo _BOOKLIBRARY_META_KEYWORDS; ?>:</strong>
                    </td>
                    <td align="left">
                        <textarea class="text_area" type="text" name="metadata[meta_keywords]" cols="30" rows="3" 
                        ><?php echo $row->metadata["meta_keywords"]; ?></textarea>                                              
                    </td>
                </tr>
                <tr>
                    <td valign="top">
                        <strong><?php echo _BOOKLIBRARY_META_DESCRIPTION; ?>:</strong>
                    </td>
                    <td align="left">
                        <textarea class="text_area" type="text" name="metadata[meta_description]" cols="30" rows="3" 
                        ><?php echo $row->metadata["meta_description"]; ?></textarea> 
                    </td>
                </tr>
                <tr>
                    <td valign="top">
                        <strong><?php echo _BOOKLIBRARY_ROBOTS; ?>:</strong>
                    </td>
                    <td align="left">
                          <?php echo $meta_robots; ?> 
                    </td>
                </tr>
            </table>
        </td>
        </tr>
        </table>

        <input type="hidden" name="option" value="com_booklibrary" />
        <input type="hidden" name="section" value="categories" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
        <input type="hidden" name="sectionid" value="com_booklibrary" />
        <input type="hidden" name="redirect" value="<?php echo $redirect; ?>" />
        </form>
    <?php
    }
}
/**
 * Booklibrary Import Export Class
 * Handles the import and export of data from the booklibrary.
 */
class HTML_booklibrary {
    static function sort_head_let($sortby) {
        // global $mosConfig_live_site, $templateDir;
        global $mosConfig_live_site;
        $p = JURI::root() . "components/com_booklibrary";
        $img_str = "";
        switch ($sortby) {
            case 'lend_out':
                $title = "";
            break;
            case 'lend_out_desc':
                $title = "";
            break;
            case 'lend_until':
                // $img_str = "<img src=\"" . $templateDir . "/images/admin/uparrow-1.png\" width=\"12\" 
                $img_str = "<img src=\"" . $p . "/images/uparrow-1.png\" width=\"12\" 
                            height=\"12\" border=\"0\" alt='Sorted up' />";
                $title = _BOOKLIBRARY_ORDER_LEND_UNTIL;
            break;
            case 'lend_until_desc':
                // $img_str = "<img src=\"" . $templateDir . "/images/admin/downarrow-1.png\" width=\"12\" 
                $img_str = "<img src=\"" . $p . "/images/downarrow-1.png\" width=\"12\" 
                            height=\"12\" border=\"0\" alt='Sorted up' />";
                $title = _BOOKLIBRARY_ORDER_LEND_UNTIL;
            break;
            case 'lend_from':
                // $img_str = "<img src=\"" . $templateDir . "/images/admin/uparrow-1.png\" width=\"12\" 
                $img_str = "<img src=\"" . $p . "/images/uparrow-1.png\" width=\"12\" 
                            height=\"12\" border=\"0\" alt='Sorted up' />";
                $title = _BOOKLIBRARY_ORDER_LEND_FROM;
            break;
            case 'lend_from_desc':
                // $img_str = "<img src=\"" . $templateDir . "/images/admin/downarrow-1.png\" width=\"12\" 
                $img_str = "<img src=\"" . $p . "/images/downarrow-1.png\" width=\"12\" 
                            height=\"12\" border=\"0\" alt='Sorted up' />";
                $title = _BOOKLIBRARY_ORDER_LEND_FROM;
            break;
            default:
                $value = "lend_until";
                $title = _BOOKLIBRARY_LABEL_LEND;
            break;
        }
        $enums = Array('none', 'lend_until', 'lend_until_desc', 'lend_from', 'lend_from_desc');
        for ($i = 0;$i < count($enums);$i++) {
            if ($enums[$i] == $sortby) {
                if (($i + 1) != count($enums)) {
                    $value = $enums[$i + 1];
                } else {
                    $value = $enums[0];
                }
                break;
            }
        }
        $str = "<a href='" . $mosConfig_live_site . 
            "/administrator/index.php?option=com_booklibrary&amp;sortlet=$value'>" . 
              $img_str . $title . "</a>";
        return $str;
    }

    static function sort_head($title, $fieldname, $sort_arr) {
        global $mosConfig_live_site, $templateDir; 
        $img_str = "";
        $p = JURI::root() . "components/com_booklibrary";
        if ($sort_arr['field'] == $fieldname) {
            if ($sort_arr['direction'] == '') {
                // $img_str = "<img src=\"{$templateDir}/images/admin/uparrow-1.png\" 
                $img_str = "<img src=\"{$p}/images/uparrow-1.png\" 
                    width=\"12\" height=\"12\" border=\"0\" alt='Sorted up' />";
            } else {
                // $img_str = "<img src=\"{$templateDir}/images/admin/downarrow-1.png\" 
                $img_str = "<img src=\"{$p}/images/downarrow-1.png\" 
                    width=\"12\" height=\"12\"  border=\"0\" alt='Sorted up' />";
            }
        }
        $str = "<a href='" . $mosConfig_live_site . 
            "/administrator/index.php?option=com_booklibrary&amp;sort=$fieldname'>" . 
              $img_str . $title . "</a>";
        return $str;
    }

    static function edit_review($option, $book_id, $review) {
        global $my, $mosConfig_live_site, $mainframe, $doc; 

        os_hide_left_panel();

        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
    ?>

        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" 
              enctype="multipart/form-data">
            <table cellpadding="4" cellspacing="5" border="0" width="100%" class="adminform admin5">
                <tr>
                    <td colspan="2"><?php echo _BOOKLIBRARY_LABEL_REVIEW_TITLE; ?></td>
                </tr>
                <tr>
                    <td colspan="2">
                        <input class="inputbox" type="text" name="title" size="80" 
                                value="<?php echo $review[0]->title ?>" />
                    </td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_LABEL_REVIEW_COMMENT; ?></td>
                    <td align="left"><?php echo _BOOKLIBRARY_LABEL_REVIEW_RATING; ?></td>
                </tr>
                <tr>
                    <td>
                        <?php editorArea('editor1', $review[0]->comment, 
                            'comment', '410', '200', '60', '10'); ?>
                    </td>
                    <td width="102" align='left'>
                        <?php $k = 0;
        while ($k < 11) { ?>
                            <input type="radio" name="rating" value="<?php echo $k; ?>" 
            <?php if ($k == $review[0]->rating) echo 'checked="checked"'; ?> alt="Rating" />
                            <img src="<?php echo JURI::root(true); ?>/components/com_booklibrary/images/rating-<?php echo $k; ?>.png" 
                                 alt="<?php echo ($k) / 2; ?>" border="0" /><br />
            <?php $k++; } ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">&nbsp;</td>
                </tr>
            </table>

            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="update_review" />
            <input type="hidden" name="book_id" value="<?php echo $book_id; ?>" />
            <input type="hidden" name="review_id" value="<?php echo $review[0]->id; ?>" />
        </form>
    <?php
    }
    //*************   begin for manage reviews   ********************
    static function edit_manage_review($option, &$review) {
        global $my, $mosConfig_live_site, $mainframe, $doc; 

        os_hide_left_panel();

        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' >
                <img src='./components/com_booklibrary/images/cfg.png' alt ='Config' />" . 
                _BOOKLIBRARY_HEADER_EDIT . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" 
              enctype="multipart/form-data">
            <table cellpadding="4" cellspacing="5" border="0" width="100%" 
                   class="adminform bl_admin_user_review my_table">
                <tr>
                    <td><?php echo _BOOKLIBRARY_LABEL_REVIEW_TITLE; ?></td>
                    <td>
                        <input class="inputbox" type="text" name="title" size="80" 
                                value="<?php echo $review[0]->title ?>" />
                    </td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_LABEL_REVIEW_COMMENT; ?></td>
                    <td>
        <?php editorArea('editor1', $review[0]->comment, 'comment', '410', '200', '60', '10'); ?>
                    </td>
                </tr>
                <tr>
                    <td align="left"><?php echo _BOOKLIBRARY_LABEL_REVIEW_RATING; ?></td>
                    <td align='left'>
        <?php $k = 0;
        while ($k < 11) { ?>
                            <input type="radio" name="rating" value="<?php echo $k; ?>" 
    <?php if ($k == $review[0]->rating) echo 'checked="checked"'; ?> alt="Rating" />
                            <img src="<?php echo JURI::root(true); ?>/components/com_booklibrary/images/rating-<?php echo $k; ?>.png" 
                                 alt="<?php echo ($k) / 2; ?>" border="0" /><br />
            <?php $k++; } ?>

                    </td>
                </tr>
            </table>

            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="update_edit_manage_review" />
            <input type="hidden" name="review_id" value="<?php echo $review[0]->id; ?>" />
        </form>
    <?php
    }
    //***************   end for manage reviews   ********************
    static function showRequestLendBooks($option, $lend_requests, $b_associated, $title_assoc, &$pageNav) {
        global $my, $mosConfig_live_site, $mainframe, $doc;
        $doc->addScript($mosConfig_live_site . 
            '/components/com_booklibrary/includes/functions.js');
        $doc->addScript($mosConfig_live_site . '/media/system/js/core.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' 
                alt ='Config' /> " . _BOOKLIBRARY_ADMIN_REQUEST_LEND . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
        
    ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">
            <div class="admin8 wrapper-col-books">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                    <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div>
    
            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                class="adminlist bl_admin_lend_requests_table my_table my_table-bordered my_table-hover">
                <tr>
                    <th align = "center" width="20">
                        <input type="checkbox" name="toggle" value="" 
                               onClick="Joomla.checkAll(this<?php //echo count( $lend_requests );?>);" />
                    </th>
                    <th align = "center" width="30">id</th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_FROM; ?>
                    </th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL; ?>
                    </th>
                    <th align = "center" class="title" width="5%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_BOOKID; ?>
                    </th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_ISBN; ?>
                    </th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE; ?>
                    </th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_USER; ?>
                    </th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL; ?>
                    </th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_ADRES; ?>
                    </th>
                </tr>
    <?php
        for ($i = 0, $n = count($lend_requests);$i < $n;$i++) {
            $row = $lend_requests[$i];
            $assoc_title = '';
            if ($title_assoc) {
                for ($t = 0, $z = count($title_assoc);$t < $z;$t++) {
                    if ($title_assoc[$t]->id != $row->id) $assoc_title.= " " . $title_assoc[$t]->title;
                }
            }
    ?>

                    <tr class="row<?php echo $i % 2; ?>">
                        <td width="20">
                            <?php
                            // echo mosHTML::idBox($i, $row->id, ($row->fk_lendid = 0), 'bid[]');
                            echo mosHTML::idBox($i, $row->id, ($row->fk_lendid = 0), 'bid');
?>
                        </td>
                        <td align = "center"><?php echo $row->id; ?></td>
                        <td align = "center">
                            <?php echo $row->lend_from; ?>
                        </td>
                        <td align = "center">
                            <?php echo $row->lend_until; ?>
                        </td>
                        <td align = "center"><?php echo $row->fk_bookid; ?></td>
                        <td align = "center">
                            <?php echo $row->isbn; ?>
                        </td>
                        <td align = "center">
                            <?php echo $row->title . " ( " . $assoc_title . " ) "; ?>
                        </td>
                        <td align = "center">                    
                            <?php echo $row->user_name; ?>
                        </td>
                        <td align = "center">
                            <a href=mailto:"<?php echo $row->user_email; ?>">
                                <?php echo $row->user_email; ?></a>
                        </td>
                        <td align = "center"><?php echo $row->user_mailing; ?></td>
                    </tr>

    <?php } ?>

                <tr class="for_paginator">
                    <td colspan = "11"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="lend_requests" />
            <input type="hidden" name="boxchecked" value="0" />
        </form>
    <?php
    }
    
    
    static function showUsersLendHistory($option,$alllend, &$userlist){
    global $my, $mosConfig_live_site, $mainframe;
    
    global $doc, $css;

    $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
    $doc->addScript($mosConfig_live_site . '/media/system/js/core.js');
    $html = "<div class='book_manager_caption' ><img src='./components/com_booklibrary/images/cfg.png' 
            alt ='Config' /> " . _BOOKLIBRARY_ADMIN_SHOW_USER_LEND_HISTORY . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    
    ?>
    <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" >
      <table cellpadding="4" cellspacing="0" border="0" width="100%">
        <tr>
            <td align="right" nowrap="nowrap"><?php echo _BOOKLIBRARY_ADMIN_LEND_USER . ': '.
                $userlist; ?></td>
        </tr>
      </table>
      <input type="hidden" name="task" value="users_lend_history"/>
      <input type="hidden" name="option" value="<?php echo $option; ?>" />
    </form>
    <table cellpadding="4" cellspacing="0" border="0" width="100%" 
           class="adminlist bl_admin_lend_requests_table my_table my_table-bordered my_table-hover">
      <tr>
        <th align = "center" width="30">#</th>

        <th align = "center" class="title" width="5%" nowrap="nowrap">
            <a href = "index.php?option=com_booklibrary&task=sorting_userlend_book_id">
            <?php  echo _BOOKLIBRARY_LABEL_BOOKID; ?></a>
        </th>

        <th align = "center" class="title" width="25%" nowrap="nowrap">
            <a href="index.php?option=com_booklibrary&task=sorting_userlend_book_title">
            <?php echo _BOOKLIBRARY_LABEL_TITLE; ?></a>
        </th>

        <th align = "center"  width="15%" nowrap="nowrap">
            <a href="index.php?option=com_booklibrary&task=sorting_userlend_lendfrom">
            <?php echo _BOOKLIBRARY_LABEL_LEND_FROM; ?></a>
        </th>

        <th align = "center" class="title" width="15%" nowrap="nowrap">
            <a href="index.php?option=com_booklibrary&task=sorting_userlend_lenduntil">
            <?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL; ?></a>
        </th>

        <th align = "center" class="title" width="15%" nowrap="nowrap">
            <a href="index.php?option=com_booklibrary&task=sorting_userlend_returnmedia">
            <?php echo _BOOKLIBRARY_LABEL_LEND_RETURN; ?></a>
        </th>

        <th align = "center" class="title" width="15%" nowrap="nowrap">
            <?php echo _BOOKLIBRARY_LABEL_LEND_ADRES; ?></th>

        <th align = "center" class="title" width="20%" nowrap="nowrap">
            <a href="index.php?option=com_booklibrary&task=sorting_userlend_email">
            <?php echo _BOOKLIBRARY_LABEL_LEND_TO; ?></a>
        </th>

      </tr>
    <?php 
      if($alllend){
        for ($i = 0; $i < count($alllend); $i++) {
          print_r("
            <td align=\"center\">" . ($i+1) . "</td>
            <td align=\"center\">" . $alllend[$i]->bookid . "</td>
            <td align=\"center\">" . $alllend[$i]->title . "</td>
            <td align=\"center\">" . $alllend[$i]->lend_from . "</td>
            <td align=\"center\">" . $alllend[$i]->lend_until . "</td>  
            <td align=\"center\">" . $alllend[$i]->lend_return . "</td>
            <td align=\"center\">" . $alllend[$i]->user_mailing . "</td>  
            <td align=\"center\">" . $alllend[$i]->user_name . ":  " . $alllend[$i]->user_email . "</td> </tr>");
        }
      }
    ?>
      </table>
    <?php
  }
  
  
    static function showLendHistory($option, $main_book, $rows){
    global $my, $mosConfig_live_site, $mainframe;
    global $doc, $css;

    $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
    $doc->addScript($mosConfig_live_site . '/media/system/js/core.js');
    $html = "<div class='book_manager_caption' ><img src='./components/com_booklibrary/images/cfg.png' 
            alt ='Config' /> " . _BOOKLIBRARY_ADMIN_REQUEST_LEND_HISTORY . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    ?>
    
    <div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
    <table cellpadding="4" cellspacing="0" border="0" width="100%" 
           class="adminlist bl_admin_lend_requests_table my_table my_table-bordered my_table-hover">
      <tr>
        <td width="100%">
          <?php
          echo '<h2 align="center">'._BOOKLIBRARY_ADMIN_REQUEST_LEND_HISTORY.'</h2>';
          ?>
        </td>
      </tr>
    </table>
    <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist adminlist_09">
      <tr>
        <th align = "center" width="30">#</th>
        <th align = "center" class="title" width="5%" nowrap="nowrap">
            <?php  echo _BOOKLIBRARY_LABEL_BOOKID; ?></th>
        <th align = "center" class="title" width="25%" nowrap="nowrap">
            <?php echo _BOOKLIBRARY_LABEL_TITLE; ?></th>
        <th align = "center" class="title" width="15%" nowrap="nowrap">
            <?php echo _BOOKLIBRARY_LABEL_LEND_FROM; ?></th>
        <th align = "center" class="title" width="20%" nowrap="nowrap">
            <?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL; ?></th>
        <th align = "center" class="title" width="15%" nowrap="nowrap">
            <?php echo _BOOKLIBRARY_LABEL_LEND_RETURN; ?></th>
        <th align = "center" class="title" width="20%" nowrap="nowrap">
            <?php echo _BOOKLIBRARY_LABEL_LEND_TO; ?></th>
      </tr>
      
      <?php 

      for ($j = 0, $n = count($rows); $j < $n; $j++) {
        $row = $rows[$j];
        $book_id = $row->id;
        $data = JFactory::getDBO();
        $query = "SELECT * 
                  FROM #__booklibrary_lend 
                  WHERE fk_bookid =" . $book_id . " 
                  ORDER BY lend_return "; // AND id =50" 
        $data->setQuery($query);
        $alllend = $data->loadObjectList();
        if (isset($alllend)) {
           for ($i = 0; $i < count($alllend); $i++) {
            $fromcut = explode(' ', $alllend[$i]->lend_from);
            $untilcut = explode(' ', $alllend[$i]->lend_until);
            $alllend[$i]->lend_from = $fromcut[0];  
            $alllend[$i]->lend_until = $untilcut[0]; 
          }
        }
        $num = 1;
        for ($i = 0, $n2 = count($alllend); $i < $n2; $i++) {
          print_r("
            <td align=\"center\">" . $num . "</td>
            <td align=\"center\">" . $row->bookid . "</td>
            <td align=\"center\">" . $row->title . "</td>
            <td align=\"center\">" . $alllend[$i]->lend_from . "</td>
            <td align=\"center\">" . $alllend[$i]->lend_until . "</td>  
            <td align=\"center\">" . $alllend[$i]->lend_return . "</td> 
            <td align=\"center\">" . $alllend[$i]->user_name . ":  " . $alllend[$i]->user_email . 
            "</td> </tr>"
            );
           $num++;
        }
      } ?>
        </table>
    <?php
    }
  
  
    static function showBooks($option, $rows_book, &$clist, &$lendlist, &$userlist, &$publist, &$search, &$pageNav, 
                              &$sort_arr, $search_for_list, $order_let, $langshow_filter) {
        global $my, $mosConfig_live_site, $session;
        global $mainframe, $templateDir, $doc; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='Config' />" . _BOOKLIBRARY_SHOW . 
            "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm" class="bl_admin_books">
           
           <table class="admin10" cellpadding="4" cellspacing="0" border="0" width="100%">
                <tr>

                <td width="68%" class="book_manager_caption" valign='bottom' ></td>
                </tr>
            </table>
            
            <div class="wrapper-search-books adminlist my_table bl_admin_books_top_table_with_search_ans_orders">
                    <div class="search_label">
                        <label><?php echo _BOOKLIBRARY_SHOW_SEARCH; ?></label>
                         <input type="text" name="search" value="<?php echo $search; ?>" 
                               class="inputbox" />
                    </div>
                   <!--  <td width="19%">
                        <input type="text" name="search" value="<?php echo $search; ?>" 
                               class="inputbox" />
                    </td> -->

                    <div class="for_label">
                        <label><?php echo _BOOKLIBRARY_SHOW_SEARCH_FOR; ?></label>
                         <?php echo $search_for_list; ?>
                    </div>
                    
                    <div>
                      <input class="my_btn my_btn_go" type="submit" name="go" 
                             value="<?php echo _BOOKLIBRARY_SHOW_SEARCH_GO; ?>" >
                    </div>
            </div>

            <div class="wrapper-col-books">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                        <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                        <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div>
            
            
            <div class="wrapperSelectsBookLibrary">
                    <div><?php echo $publist; ?></div>
                    <div><?php echo $lendlist; ?></div>
                    <div><?php echo $userlist; ?></div>
                    <div><?php echo $clist; ?></div>
                    <div><?php echo $langshow_filter; ?></div>
            </div>
            
            
            <table cellpadding="4" cellspacing="0" border="0" width="100%" class="my_table 
                   my_table-bordered my_table-hover adminlist bl_admin_books_main_table">
                <tr>
                    <th width="4%">
                        <input type="checkbox" name="checkall-toggle" value="" class="hasTooltip" title="Check All Items" onclick="Joomla.checkAll(this)">
                    </th>
                    <th width="4%">id</th>
                    <th width="8%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_BOOKID; ?>
                    </th>
                   <!--th width="12%" align = "center"  class="title" nowrap="nowrap">
                        <?php echo HTML_booklibrary::sort_head(_BOOKLIBRARY_LABEL_ISBN, 'isbn', $sort_arr); ?>
                    </th-->
                    <th width="12%" align = "center"  class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_AUTHORS; ?>
                    </th>            
                    <th width="12%" align = "center" class="title" nowrap="nowrap">
                        <?php echo HTML_booklibrary::sort_head(_BOOKLIBRARY_LABEL_TITLE, 
                            'title', $sort_arr); ?>
                    </th>
                    <!--<th align = "center" class="title" width="5%" nowrap="nowrap" colspan="2">
                        <?php echo _BOOKLIBRARY_LABEL_LINE; ?>
                    </th>-->
                    <!--th width="10%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_FETCH_INFO; ?>
                    </th-->
                    
                    <th width="10%" align = "center" class="title" nowrap="nowrap">
                        <?php echo HTML_booklibrary::sort_head(_BOOKLIBRARY_LABEL_CATEGORY, 
                            'category', $sort_arr); ?>
                    </th>
                    <th width="8%" align = "center" class="title" nowrap="nowrap">
                        <?php echo HTML_booklibrary::sort_head_let($order_let); ?>
                    </th>
                    <th width="8%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_HITS; ?>
                    </th>
                    <th width="10%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_TYPE_USER; ?>
                    </th>      
                    <th width="8%" align = "center"  class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_PUBLIC." / "._BOOKLIBRARY_LABEL_APPROVED; ?>
                    </th>
                    <th width="8%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_CONTROL; ?>
                    </th>
                    <th width="8%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?>
                    </th>
                </tr>
                
        <?php for ($i = 0, $n = count($rows_book);$i < $n;$i++) {
            $row = $rows_book[$i];
        ?>
                    <tr class="row<?php echo $i % 2; ?>">
                       
                <td align="left">
    <?php if ($row->checked_out && $row->checked_out != $my->id) { ?>
                                &nbsp;
        <?php
            } else {
                echo mosHTML::idBox($i, $row->id, ($row->checked_out && 
                    $row->checked_out != $my->id), 'bid');
            }
        ?>
                        </td>
                        <td align = "center" ><?php echo $row->id; ?></td>
                        <td align = "center"><?php echo $row->bookid; ?></td>
                        <!--td align="center">
                            <a href="#edit" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit')">
                            <?php echo $row->isbn; ?>
                            </a>
                        </td-->
                        <td align = "center"><?php echo $row->authors; ?></td>
                        <td align="left">
                          
                          <a href="#edit" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit')">
                                <?php echo $row->title; ?>
                    
                            </a>
                        </td>
                        <!--td align="center">
                            <?php echo mosBooklibraryWS::getWsNameById($row->informationFrom); ?>
                        </td-->
                        <td align = "center"><?php echo $row->category; ?></td>
                        
                        <td align = "center" style="text-align:center;">
                        <?php if ($row->lend_from == null) { ?>
                                <a class="my_btn my_btn-success" href="javascript: void(0);"
                                    onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','lend')">
                                    <img style="vertical-align:middle;" src="<?php
                                    echo $mosConfig_live_site; ?>/components/com_booklibrary/images/next.png"/>
                                </a>

                        <?php } else { ?>

                                <a class="my_btn my_btn-warning" href="javascript: void(0);"
                                    onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','lend_return')">
                                    <img style="vertical-align:middle;" src="<?php
                                echo $mosConfig_live_site; ?>/components/com_booklibrary/images/back.png"/>
                                </a>    

                        <?php } ?>

                        </td>
                        <td align = "center"><?php echo $row->hits; ?></td>
            <?php //print_r($row);exit;?>
                        <td align="center"><?php echo $row->owner_name; ?></td>
                        <?php
                            $task = $row->published ? 'unpublish' : 'publish';
                            $alt = $row->published ? 'Unpublish' : 'Publish';
                            $img = $row->published ? 'ok.png' : 'remove.png';
                            $task1 = $row->approved ? 'unapprove' : 'approve';
                            $alt1 = $row->approved ? 'Unapproved' : 'Approved';
                            $img1 = $row->approved ? 'ok.png' : 'remove.png';
                        ?>
                        <td align="center">
                            <a href="javascript: void(0);" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>',
                                '<?php echo $task; ?>')">
                                <img src="<?php echo $mosConfig_live_site . 
                                "/components/com_booklibrary/images/" . $img; ?>" 
                                border="0" alt="<?php echo $alt; ?>" />
                            </a> / <a href="javascript: void(0);" 
                               onClick="return Joomla.listItemTask('cb<?php echo $i; ?>',
                              '<?php echo $task1; ?>')">
                                <img src="<?php echo $mosConfig_live_site . 
                                "/components/com_booklibrary/images/" . $img1; ?>" 
                                border="0" alt="<?php echo $alt1; ?>" />
                            </a> 
                        </td>
                        <?php if ($row->checked_out) { ?>
                            <td align="center"><?php echo $row->editor; ?></td>
                        <?php } else { ?>
                            <td align="center">&nbsp;</td>
                        <?php } ?>
                        <td align = "center"><?php echo $row->langshow; ?></td>
                    </tr>
    <?php
        } //end for
        
    ?>
                <tr class="for_paginator">
                    <td colspan = "15"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="boxchecked" value="0" />
        </form>

    <?php
    }
    static function showAuthors($option, $rows, $pageNav, $search, $search_for_list, $langshow_filter) {
        global $my, $mosConfig_live_site, $session;
        global $mainframe, $templateDir, $doc; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $doc->addScript($mosConfig_live_site . '/media/system/js/core.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' 
                alt ='Config' />" . _BOOKLIBRARY_SHOW_AUTHORS . "</div>";

        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>
         <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">

            <div class="wrapper-search-books adminlist my_table bl_admin_books_top_table_with_search_ans_orders">
                    <div class="search_label">
                    <label><?php echo _BOOKLIBRARY_SHOW_SEARCH; ?></label>
                     <input type="text" name="auth_search" value="<?php echo $search; ?>" 
                               class="inputbox" />
                    </div>

                   <div class="for_label">
                        <label><?php echo _BOOKLIBRARY_SHOW_SEARCH_FOR; ?></label>
                        <?php echo $search_for_list; ?>

                    </div>

                    <div>
                        <?php echo $langshow_filter ?>
                    </div>

                    <div>
                        <input class="my_btn my_btn_go" type="submit" name="go" 
                               value="<?php echo _BOOKLIBRARY_SHOW_SEARCH_GO; ?>" >
                    </div>
                    
            </div>
            <div class="wrapper-col-books">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                    <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div>
            
                <td width="70%" class="book_manager_caption" valign='bottom' ></td>
            </table>
              <table cellpadding="4" cellspacing="0" border="0" width="100%" class="my_table 
                   my_table-bordered my_table-hover adminlist bl_admin_books_main_table">
                <tr>
                    <th width="4%">
                        <input type="checkbox" name="toggle" value="" onClick="Joomla.checkAll(this);" />
                    </th>
                    <th width="4%">id</th>
                    <th width="12%" align = "center"  class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_AUTHOR; ?>
                    </th>     
                   <th width="12%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE_BOOK; ?>
                    </th>            
                    <th width="12%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_HITS; ?>
                    </th>              
                    <th width="12%" align = "center"  class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_PUBLIC; ?>
                    </th>
                    <th width="12%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_CONTROL; ?>
                    </th>
                    <th width="12%" align = "center" class="title" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?>
                    </th>
                </tr>
            
    <?php for ($i = 0, $n = count($rows);$i < $n;$i++) {
            $row = $rows[$i];
    ?>
             <tr class="row<?php echo $i % 2; ?>">
                    <td width="20" align="left">
                        
        <?php if ($row->checked_out && $row->checked_out != $my->id) { ?>
                                &nbsp;
        <?php
            } else {
                echo mosHTML::idBox($i, $row->id, ($row->checked_out && 
                    $row->checked_out != $my->id), 'bid');
            }
        ?>



                    </td>
                    <td align="center" width="30"><?php echo $row->id; ?></td>
                        
                    <!--td align="center" width="12%"><?php echo $row->authors_name; ?></td-->
                        
                    <td align="left">
                          
                        <a href="#edit" 
                           onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit_author')">
                           <?php echo $row->authors_name; ?>
                    
                        </a>
                    </td>
                    <td align="center" width="25%"><?php echo $row->book_title; ?></td>
                    <td align="center" width="16%"><?php echo $row->hits; ?></td>
                    <td align="center" width="7%" style="text-align:center;vertical-align:middle;">
                        <?php
                            $task = $row->published ? 'unpublish_manage_author' : 'publish_manage_author';
                            $alt = $row->published ? 'Unpublish' : 'Publish';
                            $img = $row->published ? 'ok.png' : 'remove.png';
                        ?>
        
                        <a href="javascript: void(0);" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>',
                            '<?php echo $task; ?>')">
                            <img src="<?php echo $mosConfig_live_site . "/components/com_booklibrary/images/" . 
                                $img; ?>" border="0" alt="<?php echo $alt; ?>" />
                        </a>
                    </td>
                    <td align="left">

                      <?php if ($row->checked_out) { ?>
                        <?php print_r($row->editor); ?>
                      <?php } else { ?>
                       &nbsp;
                      <?php } ?>
                    </td>
                    <td align="center" width="12%"><?php echo $row->langshow; ?></td>
                </tr>
    <?php
        } //end for(...)
        
    ?>
                <tr class="for_paginator">
                    <td colspan = "11"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="manage_author" />
            <input type="hidden" name="author" value="1" />
            <input type="hidden" name="boxchecked" value="0" />
        </form>

    <?php
    }
    //**********   begin for manage reviews  *****************
    static function showManageReviews($option, &$pageNav, &$reviews) {
        global $my, $mosConfig_live_site, $mainframe, $doc, $templateDir; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $doc->addScript($mosConfig_live_site . '/media/system/js/core.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' 
            alt ='Config' />" . _BOOKLIBRARY_SHOW_REVIEW_MANAGER . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">
            <div class="admin14 wrapper-search-books">
                                  
                    <div class="book_manager_caption" valign='bottom' ></div>
            </div>
            <div class="wrapper-col-books">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                    <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div>  

            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                   class="adminlist bl_admin_reviews_table my_table my_table-hover
                   my_table-bordered">
                <tr>
                    <th width="20">
                        <input type="checkbox" name="toggle" value="" 
                                onClick="Joomla.checkAll(this<?php //echo count( $reviews );?>);" />
                    </th>
                    <th align="center" width="30">
                        <a href="#numer" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_numer');">id</a>
                    </th>
                    <th align="center" class="title" width="12%" nowrap="nowrap">
                        <a href="#isbn" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_isbn');">
                        <?php echo _BOOKLIBRARY_LABEL_ISBN; ?></a>
                    </th>
                    <th align="center" class="title" width="25%" nowrap="nowrap">
                        <a href="#title_book" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_title_book');">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE_BOOK; ?></a>
                    </th>
                    <th align="center" class="title" width="16%" nowrap="nowrap">
                        <a href="#title_catigory" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_title_catigory');">
                        <?php echo _BOOKLIBRARY_LABEL_CATEGORY; ?></a>
                    </th>
                    <th align="center" class="title" width="25%" nowrap="nowrap">
                        <a href="#title_review" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_title_review');">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE_COMMENT; ?></a>
                    </th>
                    <th align="center" class="title" width="7%" nowrap="nowrap">
                        <a href="#user_name" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_user_name');">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_USER; ?></a>
                    </th>
                    <th align="center" class="title" width="8%" nowrap="nowrap">
                        <a href="#date" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_date');">
                        <?php echo _BOOKLIBRARY_LABEL_PUB_DATE; ?></a>
                    </th>
                    <th align="center" class="title" width="7%" nowrap="nowrap">
                        <a href="#rating" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_rating');">
                        <?php echo _BOOKLIBRARY_LABEL_RATING; ?></a>
                    </th>
                    <th align="center" class="title" width="7%" nowrap="nowrap">
                        <a href="#rating" onClick="return Joomla.listItemTask('cb<?php echo "1"; ?>',
                        'sorting_manage_review_approve');">
                        <?php echo _BOOKLIBRARY_LABEL_APPROVE; ?></a>
                    </th>
                </tr>
        <?php for ($i = 0, $n = count($reviews);$i < $n;$i++) {
            $row = $reviews[$i];
        ?>
                <tr class="row<?php echo $i % 2; ?>">
                    <td width="20" align="left">
                        <input type="checkbox" id="cb<?php echo $i; ?>" name="bid[]" 
                        value="<?php echo $row->review_id; ?>" onClick="Joomla.isChecked(this.checked);" />
                    </td>
                    <td align="center" width="30"><?php echo $reviews[$i]->review_id; ?></td>
                    <td align="center" width="12%"><?php echo $reviews[$i]->isbn; ?></td>
                    <td align="center" width="25%"><?php echo $reviews[$i]->title_book; ?></td>
                    <td align="center" width="16%"><?php echo $reviews[$i]->title_catigory; ?></td>
                    <td align="center" width="25%">
                        <a href="#edit" 
                           onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit_manage_review');">

    <?php 
        if (strlen($reviews[$i]->title_review) > 55) {
            for ($j = 0;$j < 55;$j++) {
                echo $reviews[$i]->title_review[$j];
                }
        } else {
            echo $reviews[$i]->title_review;
            }
    ?>
                            </a>
                        </td>
                        <td align="center" width="7%"><?php echo $reviews[$i]->user_name; ?></td>
                        <td align="center" width="8%"><?php echo $reviews[$i]->date; ?></td>
                        <td style="text-align:center;vertical-align:middle;" align="center" width="7%">
                            <div style="text-align:center;vertical-align:middle;">
                            <img src="<?php echo JURI::root(true); ?>/components/com_booklibrary/images/rating-<?php 
                                 echo $reviews[$i]->rating; ?>.png" 
                                 alt="<?php echo ($reviews[$i]->rating) / 2; ?>" 
                                 border="0" align="right"/>&nbsp;</div>
                        </td>
                        
                        <td align="center" width="7%" style="text-align:center;vertical-align:middle;">
                        <?php
                            $task = $reviews[$i]->published ? 'unpublish_manage_review' : 'publish_manage_review';
                            $alt = $reviews[$i]->published ? 'Unpublish' : 'Publish';
                            $img = $reviews[$i]->published ? 'tick.png' : 'publish_x.png';
                        ?>
                            <a href="javascript: void(0);" 
                               onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','<?php echo $task; ?>')">
                                <img src="<?php echo $mosConfig_live_site . 
                                    "/components/com_booklibrary/images/" . $img; ?>" border="0" 
                                    alt="<?php echo $alt; ?>" />
                            </a>
                        </td>
                    </tr>
    <?php
        } //end for(...)
        
    ?>
                <tr class="for_paginator">
                    <td colspan = "11"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="manage_review" />
            <input type="hidden" name="boxchecked" value="0" />
        </form>

    <?php
    }
    //*************************************************************************************************************
    //*********************************   end for manage reviews   ************************************************
    //*************************************************************************************************************
        //*****************************************************************************************
        //*********************************   begin for manage suggestion    **********************
        //*****************************************************************************************
        static function showManageSuggestion($option, &$pageNav, &$suggestion) {
            global $my, $mainframe, $mosConfig_live_site, $doc; 
            $doc->addScript($mosConfig_live_site . 
                '/components/com_booklibrary/includes/functions.js');
            $html = "<div class='book_manager_caption' ><img 
                src='./components/com_booklibrary/images/cfg.png' 
                    alt ='Config' />" . _BOOKLIBRARY_SHOW_SUGGESTION_MANAGER . "</div>";
            $app = JFactory::getApplication();
            $app->JComponentTitle = $html;
        ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">
            <div class="admin18 wrapper-search-books">             
                    <div class="book_manager_caption" valign='bottom' ></div>
            </div>
            <div class="wrapper-col-books">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                    <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
            </div>        

            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                   class="adminlist bl_admin_suggestions_table my_table my_table-bordered my_table-hover">
                <tr>
                    <th width="20">
                        <input type="checkbox" name="toggle" value="" 
                               onClick="Joomla.checkAll(this<?php //echo count( $suggestion );?>);" />
                    </th>
                    <th align = "center" width="30">id</th>
                    <th align = "center" class="title" width="25%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_SUGGESTION_TITLE; ?>
                    </th>
                    <th align = "center" class="title" width="40%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_SUGGESTION_COMMENT; ?>
                    </th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_USER; ?>
                    </th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL; ?>
                    </th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
                         <?php echo _BOOKLIBRARY_LABEL_PUB_DATE; ?>
                    </th>
                </tr>
        <?php for ($i = 0, $n = count($suggestion);$i < $n;$i++) {
            $row = $suggestion[$i];
            ?>
                <tr class="row<?php echo $i % 2; ?>">
                    <td width="20" align = "center">
                        <input type="checkbox" id="cb<?php echo $i; ?>" name="bid[]" 
                               value="<?php echo $row->id; ?>" onClick="Joomla.isChecked(this.checked);" />
                    </td>
                    <td width="30"><?php echo $row->id; ?></td>
                    <td width="25%" align = "center">
                    <?php
                        if (strlen($row->title) > 30) {
                            for ($j = 0;$j < 30;$j++) {
                                echo $row->title[$j];
                            }
                        } else {
                            echo $row->title;
                        }
                    ?>
                    </td>
                    <td align = "center" width="40%">
                        <a href="#view" 
                           onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','view_suggestion');">
                        <?php
                            if (strlen($row->comment) > 40) {
                                for ($j = 0;$j < 40;$j++) {
                                    echo $row->comment[$j];
                                }
                            } else {
                                echo $row->comment;
                            }
                        ?>
                        </a>
                    </td>
                    <td width="10%" align = "center"><?php echo $row->user_name; ?></td>
                    <td width="15%" align = "center">
        <?php
            if ($row->user_name == 'anonymous') {
                echo "---";
            } else {
        ?>
                        <a href="mailto:<?php echo $row->email; ?>"><?php echo $row->email; ?></a>
        <?php } ?>

                    </td>
                    <td width="10%" align = "center"><?php echo $row->date; ?></td>
                </tr>
        <?php
        } //end for(...)
        
        ?>
                <tr class="for_paginator">
                    <td colspan = "11"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="manage_suggestion" />
            <input type="hidden" name="boxchecked" value="0" />
        </form>

        <?php
        }
        //end showManageSuggestion($option, & $pageNav, & $suggestion)
       /*
        * add Nikolaj
        * function showViewSuggestion for display view one suggestion
        * in 'Manage Suggestion'
        */
        static function showViewSuggestion($option, $suggestion) {
            global $doc, $mosConfig_live_site;
            $html = "<div class='book_manager_caption' ><img 
                src='./components/com_booklibrary/images/cfg.png' alt ='Config' />" 
                . _BOOKLIBRARY_HEADER_EDIT . "</div>";
            $app = JFactory::getApplication();
            $app->JComponentTitle = $html;
        ?>

        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" 
              enctype="multipart/form-data">
            <table cellpadding="4" cellspacing="5" border="0" width="100%" 
                   class="adminform my_table bl_admin_suggestion_view_suggestion">
                <tr>
                    <td width="15%">
                        <label><?php echo _BOOKLIBRARY_LABEL_LEND_USER; ?>:</label>
                    </td>
                    <td>
                        <?php echo $suggestion->user_name; ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL; ?></label>
                    </td>
                    <td>
        <?php if ($suggestion->user_name == 'anonymous') {
            echo "---";
        } else {
        ?>
                        <a href="mailto:<?php echo $suggestion->email; ?>">
                            <?php echo $suggestion->email; ?></a>
        <?php } ?>

                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_LABEL_PUB_DATE; ?>:</label>
                    </td>
                    <td>
                        <?php echo $suggestion->date; ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_LABEL_SUGGESTION_TITLE; ?>:</label>
                    </td>
                    <td>
                        <?php echo $suggestion->title; ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_LABEL_SUGGESTION_COMMENT; ?>:</label>
                    </td>
                    <td>
                        <?php echo $suggestion->comment; ?>  
                    </td>
                </tr>

            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="delete_suggestion" />
            <input type="hidden" name="boxchecked" value="1"/>                
            <input type="hidden" name="bid[]" value="<?php echo $suggestion->id; ?>"/>
        </form>
    <?php
    }
    //end showViewSuggestion($option, $suggestion)
    //*************************************************************************************************************
    //*********************************   end for manage suggestion    ********************************************
    //*************************************************************************************************************
    
    /**
     * Writes the edit form for new and existing records
     *
     * A new record is defined when <var>$row</var> is passed with the <var>id</var>
     * property set to 0.
     * @param mosBookLibrary The book object
     * @param string The html for the categories select list
     * @param string The html for the ordering select list
     */
     
    static function editBook($option, &$row, &$clist, &$wslist, &$langshow, &$languages_lg, &$rating, 
                 &$delete_ebook, &$reviews, &$files, $videos, $audios, $tracks, 
                 &$youtubeCode, &$youtubeId, &$associateArray, $authorsshow,$meta_robots) {
        global $books, $database, $booklibrary_configuration, $my, $mosConfig_live_site, $mainframe, 
               $doc , $a, $acl; 

        os_hide_left_panel();               

        //    $query = "SELECT lang_code, title FROM #__languages";
        //  $database->setQuery($query);
        // $languages = $database->loadObjectList();
        //my !!!!! -------- langdescription   -------------------------------------------
        //$lg = JFactory::getLanguage();
        // remove_langs($component_db_name = 'booklibrary' );
        /*echo "1111111111"._BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_PRICE."2222222222".
               _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_CATEGORY."3333333333333333333"; */
        /*  $installed = $lg->getKnownLanguages();
        $languages_row[] = mosHTML::makeOption('*', 'All');
        foreach ($installed as $installang) {
        $langname = $installang['name'];
        $languages_row[] = mosHTML::makeOption($langname, $langname);
        }
        @$langlistshow = mosHTML :: selectList($languages_row, 'langshow', 
            'class="inputbox" size="1"', 'value', 'text', $row->langshow); */
        //end of my langdecription ---------  !!!!   ------------------------------------
        //echo "<br /><pre>" . print_r($languages_row, true). "</pre>"; exit;
        //---- end of my langdescrition
        //  echo $mosConfig_live_site; exit();
        // var_dump($youtubeId); exit();
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $aa = $row->id ? _BOOKLIBRARY_HEADER_EDIT : _BOOKLIBRARY_HEADER_ADD;
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='' />" . $aa . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;

    ?>
        <script language="javascript" type="text/javascript">
                          
           function trim(string){return string.replace(/(^\s+)|(\s+$)/g, "");}
            
            Joomla.submitbutton = function(task) { 
                var form = document.adminForm;  
                var bookid = document.getElementById("bookid").value; 
                var isbn = document.getElementById("isbn").value; // OR document.adminForm.isbn.value    
                var catid = document.getElementById("catid").value;
                var authors = document.getElementById("authors").value;
                var titleid = document.getElementById("titleid").value;
                var priceid = document.getElementById("priceid").value;
                var informationFrom = document.adminForm.informationFrom.value;

               
                if (task == 'save' || task == 'apply') {  
                var post_max_size = <?php echo return_bytes(ini_get('post_max_size')) ?>;
                var upl_max_fsize = <?php echo return_bytes(ini_get('upload_max_filesize')) ?>;
                var file_upl = <?php echo ini_get('file_uploads') ?>;
                    

                    if (trim(titleid) == '' && informationFrom == 0  ) {
                        alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_TITLEID_CHECK; ?>" );
                        return;
                    } else if (trim(bookid) == '') {
                        alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_BOOKID_CHECK; ?>" );
                        return;
                    } else if ( trim(isbn) == '') {
                        alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_ISBN_CHECK; ?>" );
                        return;
                    } else if (catid == '0' || catid == '') {
                        alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_CATEGORY; ?>");
                        return;
                    } else if (form.new_authors.value == '' && (form.authors.value == '' || form.authors.value == 'Selected') && informationFrom == 0 ) {
                        alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_AUTHOR; ?>");
                        return;
                    } else if (form.authors.value == 'Selected' && (form.new_authors.value == '' || form.new_authors.value == 'Selected') && informationFrom == 0 ) {
                        alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_AUTHOR; ?>");
                        return;    
                    // } else if ( (authors == '0' || authors == '' ) && informationFrom == 0 ) {
                    //     alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_AUTHOR; ?>");
                    //     return;
                    } 
       
              
              for (i=1; document.getElementById('new_upload_video'+i); i++){
                  if(document.getElementById('new_upload_video'+i).files != null){
                      if(!file_upl){
                        window.scrollTo(0,findPosY(document.getElementById('new_upload_video'+i))-100);
                        document.getElementById('error_video').innerHTML = "<?php
                        echo _BOOKLIBRARY_ADMIN_SETTINGS_VIDEO_ERROR_UPLOAD_OFF; ?>";
                        document.getElementById('new_upload_video'+i).style.borderColor = "#FF0000";
                        document.getElementById('new_upload_video'+i).style.color = "#FF0000";
                        document.getElementById('error_video').style.color = "#FF0000";
                        return;
                      }

                     if(document.getElementById('new_upload_video'+i).files.length != 0 && 
                        document.getElementById('new_upload_video_youtube_code'+i).value != null) {  
                     if(document.getElementById('new_upload_video'+i).files[0].size >= post_max_size){
                        window.scrollTo(0,findPosY(document.getElementById('new_upload_video'+i))-100);
                        document.getElementById('error_video').innerHTML = "<?php
                        echo _BOOKLIBRARY_ADMIN_SETTINGS_VIDEO_ERROR_POST_MAX_SIZE; ?>";
                        document.getElementById('new_upload_video'+i).style.borderColor = "#FF0000";
                        document.getElementById('new_upload_video'+i).style.color = "#FF0000";
                        document.getElementById('error_video').style.color = "#FF0000";
                        return;
                      }
                    } 
                      
                    if(document.getElementById('new_upload_video'+i).files.length != 0 && 
                        document.getElementById('new_upload_video_youtube_code'+i).value != null) {      
                      if(document.getElementById('new_upload_video'+i).files[0].size >= upl_max_fsize){
                        window.scrollTo(0,findPosY(document.getElementById('new_upload_video'+i))-100);
                        document.getElementById('error_video').innerHTML = "<?php
                        echo _BOOKLIBRARY_ADMIN_SETTINGS_VIDEO_ERROR_UPLOAD_MAX_SIZE; ?>";
                        document.getElementById('new_upload_video'+i).style.borderColor = "#FF0000";
                        document.getElementById('new_upload_video'+i).style.color = "#FF0000";
                        document.getElementById('error_video').style.color = "#FF0000";
                        return;
                      }
                 }
                
                }
            }
            
            if(form.new_upload_track_url1){
            <!-- document.getElementById instead form.getElementById -->
              for (i = 1;document.getElementById('new_upload_track_url'+i); i++) {
                if(document.getElementById('new_upload_track'+i).value != '' 
                  || document.getElementById('new_upload_track_url'+i).value != ''){
                    if(document.getElementById('new_upload_track_kind'+i).value == ''){
                      window.scrollTo(0,findPosY(document.getElementById('new_upload_track_kind'+i))-100);
                      document.getElementById('new_upload_track_kind'+i).placeholder = "<?php
                       echo _BOOKLIBRARY_ADMIN_SETTINGS_INFOTEXT_JS_TRACK_KIND; ?>";
                      document.getElementById('new_upload_track_kind'+i).style.borderColor = "#FF0000";
                      document.getElementById('new_upload_track_kind'+i).style.color = "#FF0000";
                      return;
                    }else if(document.getElementById('new_upload_track_scrlang'+i).value == ''){
                      window.scrollTo(0,findPosY(document.getElementById('new_upload_track_scrlang'+i))-100);
                      document.getElementById('new_upload_track_scrlang'+i).placeholder = "<?php
                       echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_TRACK_LANGUAGE; ?>";
                      document.getElementById('new_upload_track_scrlang'+i).style.borderColor = "#FF0000";
                      document.getElementById('new_upload_track_scrlang'+i).style.color = "#FF0000";
                      return;
                    }else if(document.getElementById('new_upload_track_label'+i).value == ''){
                      window.scrollTo(0,findPosY(document.getElementById('new_upload_track_label'+i))-100);
                      document.getElementById('new_upload_track_label'+i).placeholder = "<?php
                       echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_TRACK_TITLE; ?>";
                      document.getElementById('new_upload_track_label'+i).style.borderColor = "#FF0000";
                      document.getElementById('new_upload_track_label'+i).style.color = "#FF0000";
                      return;
                    }
                  }
              }
              Joomla.submitform(task);
            }else {
              Joomla.submitform(task);
            }
          } else {
            Joomla.submitform(task);
          }
    }   
        </script>
        
        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" 
              enctype="multipart/form-data">
           
           <table cellpadding="4" cellspacing="1" border="0" width="100%" 
                  class="adminform bl_admin_books_book my_table">
                <tr>
                    <td width="15%" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_BOOKID; ?>:</strong>
                    </td>
                    <td width="85%" align="left">
                        <input class="inputbox" type="text" name="bookid" id="bookid" size="20" 
                               maxlength="20" value="<?php echo $row->bookid; ?>" />
                    </td>
                </tr>
                <tr>
                    <td width="20%" align="right"><strong><?php echo _BOOKLIBRARY_LABEL_ISBN; ?>:</strong></td>
                    <td align="left">
                        <input class="inputbox" type="text" name="isbn" id="isbn" size="20" 
                               maxlength="20" value="<?php echo $row->isbn; ?>" />                
                    </td>
                </tr>
    <?php
        /*******************************************    language    **************************************************/
        if (!empty($associateArray) && !empty($row->langshow) && $row->langshow != '' && 
            $row->langshow != '*') {
    ?>
                <tr> 
                    <td width="15%"><?php echo 'language associate books' ?>:</td>                        
                </tr>   
            
    <?php
            $j = 1;
            foreach($associateArray as $lang => $value) {
                $displ = '';
                if (!$value['list']) {
                    $displ = 'none';
                }
    ?>    
                <tr style="display: <?php echo $displ ?>">
                    <td width="15%"><?php echo $lang; ?>:</td>
                    <td width="60%"><?php echo $value['list']; ?> 
                    <input class="inputbox" id="associate_book" type="text" 
                            name="associate_book<?php echo $j; ?>" size="20" 
                            readonly="readonly" maxlength="20" style="width:25px;" 
                            value="<?php echo $value['assocId']; ?>" />
                    <input style="display: none" name="associate_book_lang<?php echo $j; ?>" 
                            value="<?php echo $lang ?>"/>  
                    </td>                          
                </tr>
    <?php
                $j++;
            }
        } else {
    ?>
                <tr> 
                    <td width="15%"><?php echo 'language associate books' ?>:</td> 
                    <td width="60%"><?php echo 'this property only for books with language' ?> 
                </tr> 
<?php
        }
        /***************************************************************************************/
?>                        
          <tr>
                    <td valign="top" align="right"><strong>
                        <?php echo _BOOKLIBRARY_LABEL_LANGUAGEDESCRIPTION; ?>:</strong></td>
                    <td align="left"><?php echo $langshow; ?></td>
                </tr>   
                
                <tr>
                    <td valign="top" align="right"><strong>
                        <?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?>:</strong></td>
                    <td align="left"><?php echo $languages_lg; ?></td>
                </tr>
                  
                <tr>
                    <td valign="top" align="right"><strong>
                        <?php echo _BOOKLIBRARY_LABEL_CATEGORY; ?>:</strong></td>
                    <td align="left"><?php echo $clist; ?></td>
                </tr>
                <tr>
                    <td valign="top" align="right"><strong>
                    <?php echo _BOOKLIBRARY_LABEL_FETCH_INFO; ?>:</strong></td>
                    <td align="left">
                        <?php echo $wslist; ?>
                        &nbsp;&nbsp;&nbsp;<img 
                            src="../components/com_booklibrary/images/amazon/com-logo.gif" 
                            alt="amazon.com" border="0"/>
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right"><strong>
                    <?php echo _BOOKLIBRARY_LABEL_COMMENT; ?>:</strong></td>
                    <td align="left">
                        <?php editorArea('editor1', $row->comment, 'comment', 500, 250, '70', '10'); ?>
                    </td>
                </tr>
                <tr>
                  <td width="185"></td>
                  <td><span id="error_video"></span></td>
                  
              </tr>
 <!---------------------------------Start AJAX load track------------------------------>

  <script language="javascript" type="text/javascript">
                var request = null;
                var tid=1;
                function createRequest_track() {
                    if (request != null)
                    return;
                    try {
                       request = new XMLHttpRequest();
                    } catch (trymicrosoft) {
                        try {
                           request = new ActiveXObject("Msxml2.XMLHTTP");
                        } catch (othermicrosoft) {
                            try {
                                request = new ActiveXObject("Microsoft.XMLHTTP");
                            } catch (failed) {
                                request = null;
                            }
                        }
                    }
                    if (request == null) 
                        alert(" :-( ___ Error creating request object! ");
                }
        
                function testInsert_track(id1,upload){
                    for(var i=1; i< upload_tracks; i++){
                        if(upload.id != ('new_upload_track'+i) && 
                        document.getElementById('new_upload_track'+i).value == upload.value){
                            return false;
                        }
                    }
                    return true;   
                }
                
                function refreshRandNumber1_track(id1,upload){
                    id=id1;
                    if(testInsert_audio(id1,upload)){
                        createRequest_track();
                        var url = "<?php echo $mosConfig_live_site . 
                            "/administrator/index.php?option=$option&task=randNumber&format=raw";
                            ?>&file="+encodeURI(upload.value)+"&path=<?php
                            echo str_replace("\\", "/", $mosConfig_live_site) . 
                            '/components/com_booklibrary/media/track/'?>";
                       try{
                        request.onreadystatechange = updateRandNumber1_track;
                        request.open("GET", url,true);
                        request.send(null);
                        }catch (e)
                        {
                            alert(e);
                        }
                    }
                    else
                    {
                        alert("You alredy select this track file");
                        upload.value="";
                    }
                }
                
                function updateRandNumber1_track() {
                    if (request.readyState == 4) {
                        document.getElementById("randNumTrack"+tid).innerHTML = request.responseText;
                    }
                }
  </script>
 
 <!-------------------------------- END Ajax load track---------------------------------->
 
 
 <!-------------------------------- END Ajax load audio---------------------------------->
  <script language="javascript" type="text/javascript">
                var request = null;
                var aid=1;
                function createRequest_audio() {
                    if (request != null)
                    return;
                    try {
                          request = new XMLHttpRequest();
                    } catch (trymicrosoft) {
                        try {
                           request = new ActiveXObject("Msxml2.XMLHTTP");
                        } catch (othermicrosoft) {
                            try {
                                request = new ActiveXObject("Microsoft.XMLHTTP");
                            } catch (failed) {
                                request = null;
                            }
                        }
                    }
                    if (request == null) 
                        alert(" :-( ___ Error creating request object! ");
                }
        
                function testInsert_audio(id1,upload){
                    for(var i=1; i< upload_audios; i++){
                        if(upload.id != ('new_upload_audio'+i) && 
                        document.getElementById('new_upload_audio'+i).value == upload.value){
                            return false;
                        }
                    }
                    return true;   
                }
                
                function refreshRandNumber1_audio(id1,upload){
                    id=id1;
                    if(testInsert_audio(id1,upload)){
                        createRequest_audio();
                        var url = "<?php echo $mosConfig_live_site . 
                            "/administrator/index.php?option=$option&task=randNumber&format=raw";
                            ?>&file="+encodeURI(upload.value)+"&path=<?php
                            echo str_replace("\\", "/", $mosConfig_live_site) . 
                            '/components/com_booklibrary/media/audio/'?>";
                       try{
                        request.onreadystatechange = updateRandNumber1_audio;
                        request.open("GET", url,true);
                        request.send(null);
                        }catch (e)
                        {
                            alert(e);
                        }
                    }
                    else
                    {
                        alert( "You alredy select this audio file");
                        upload.value="";
                    }
                }
                
                function updateRandNumber1_audio(){
                    if (request.readyState == 4) {
                        document.getElementById("randNumAudio"+aid).innerHTML = request.responseText;
                    }
                }
  </script>
   
<!-------------------------------- END Ajax load audio---------------------------------->
           
                
<!-------------------------------- START Ajax load video---------------------------------->


            <script language="javascript" type="text/javascript">
                
               var request = null;
               var vid=1;
                
               function createRequest_video(){
                    if (request != null)
                    return;
                    try {
                       request = new XMLHttpRequest();
                    } catch (trymicrosoft) {
                        try {
                            request = new ActiveXObject("Msxml2.XMLHTTP");
                        } catch (othermicrosoft) {
                            try {
                                request = new ActiveXObject("Microsoft.XMLHTTP");
                            } catch (failed) {
                                request = null;
                            }
                        }
                    }
                    if (request == null) 
                        alert(" :-( ___ Error creating request object! ");
                }
                
                function testInsertVideo1(id1,upload){
                    for(var i=1 ;i< upload_videos; i++){
                        if(upload.id != ('new_upload_video'+i) && 
                        document.getElementById('new_upload_video'+i).value == upload.value)
                        {
                          return false;
                        }
                    }
                    return true;   
                }
                
                function refreshRandNumber1_video(id1,upload){
                    id=id1;
                    if(testInsertVideo1(id1,upload)){
                        createRequest_video();
                        var url = "<?php echo $mosConfig_live_site . 
                            "/administrator/index.php?option=$option&task=randNumber&format=raw";
                            ?>&file="+encodeURI(upload.value)+"&path=<?php
                            echo str_replace("\\", "/", $mosConfig_live_site) . 
                            '/components/com_booklibrary/media/video/'?>";
                       try{
                        request.onreadystatechange = updateRandNumber1_video;
                        request.open("GET",url,true);
                        request.send(null);
                        }catch (e)
                        {
                            alert(e);
                        }
                    }
                    else
                    {
                        alert("You alredy select this video file");
                        upload.value="";
                    }
                }
                
                function updateRandNumber1_video() {
                    if (request.readyState == 4) {
                        document.getElementById("randNumVideo"+vid).innerHTML = request.responseText;
                    }
                }
                </script>
                
                               
  <!-------------------------------- END Ajax load video---------------------------------->
         
              
  <!---------------------------------Start AJAX load file------------------------------>
         
   
                <script language="javascript" type="text/javascript">
                
                var request = null;
                var fid=1;
                function createRequest() {
                    if (request != null)
                    return;
                    try {
                        request = new XMLHttpRequest();
                    } catch (trymicrosoft) {
                        try {
                               request = new ActiveXObject("Msxml2.XMLHTTP");
                        } catch (othermicrosoft) {
                            try {
                                request = new ActiveXObject("Microsoft.XMLHTTP");
                            } catch (failed) {
                                request = null;
                            }
                        }
                    }
                    if (request == null) 
                        alert(" :-( ___ Error creating request object! ");
                }
                
                
                function testInsertFile1(id1,upload){
                    for(var i=1; i< upload_files; i++){
                        if(upload.id != ('new_upload_file'+i) && 
                        document.getElementById('new_upload_file'+i).value==upload.value){
                            return false;
                        }
                    }
                    return true;   
                }
                
                function refreshRandNumber1(id1,upload) {
                    id=id1;
                    if(testInsertFile1(id1,upload)){
                        createRequest();
                        var url = "<?php echo $mosConfig_live_site . 
                            "/administrator/index.php?option=$option&task=randNumber&format=raw";
                            ?>&file="+encodeURI(upload.value)+"&path=<?php
                            echo str_replace("\\", "/", $mosConfig_live_site) . 
                            '/components/com_booklibrary/ebooks/'?>";
                        try{
                        request.onreadystatechange = updateRandNumber1;
                        request.open("GET",url,true);
                        request.send(null);
                        }catch (e)
                        {
                            alert(e);
                        }
                    }
                    else
                    {
                        alert( "You alredy select this file");
                        upload.value="";
                    }
                }
                        
        
                function updateRandNumber1() {
                    if (request.readyState == 4) {
                        document.getElementById("randNumFile"+fid).innerHTML = request.responseText;
                    }
                }
                
                </script>
                
<!-------------------------------- END Ajax load file ---------------------------------->   


 <script language="javascript" type="text/javascript">
    var upload_tracks=0;
    function new_tracks(){
        div=document.getElementById("t_items");
        button=document.getElementById("t_add");
        upload_tracks++;
        newitem="<table width='50%'><tr><td width='15%'><strong style=\"float:left\">" + 
        "<?php echo _BOOKLIBRARY_LABEL_TRACK_UPLOAD ?>"+upload_tracks+": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:100%\" type=\"file\" onClick=\"document.adminForm.new_upload_track"+upload_tracks+".value ='';\" " +
        " onChange=\"refreshRandNumber1_track("+upload_tracks+
        ",this);\"  name=\"new_upload_track"+upload_tracks+"\" "+"id=\"new_upload_track"+upload_tracks;
        newitem+="\" value=\"\"size=\"45\">";
        newitem+="<span id=\"randNumTrack"+upload_tracks+"\" style=\"color:red;\"></span></td></tr></td></tr><tr><td style=\"text-align:center\"> OR </td><td></td></tr></table>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        
        newitem="<table width='50%'><tr><td width='15%'><strong>" + 
        "<?php echo _BOOKLIBRARY_LABEL_TRACK_UPLOAD_URL; ?>" +upload_tracks+ ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:90%\" type=\"text\" name=\"new_upload_track_url"
        +upload_tracks+"\" "+"id=\"new_upload_track_url"+upload_tracks;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><br/>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='15%'><strong>" + 
        "<?php echo _BOOKLIBRARY_LABEL_TRACK_UPLOAD_KIND; ?>" +upload_tracks+ ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:90%\" type=\"text\" name=\"new_upload_track_kind"
        +upload_tracks+"\" "+"id=\"new_upload_track_kind"+upload_tracks;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><br/>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='15%'><strong>" + 
        "<?php echo _BOOKLIBRARY_LABEL_TRACK_UPLOAD_SCRLANG; ?>" +upload_tracks+ ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:90%\" type=\"text\" name=\"new_upload_track_scrlang"+upload_tracks+"\" "+"id=\"new_upload_track_scrlang"+upload_tracks;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><br/>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
      
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='15%'><strong>" + 
        "<?php echo _BOOKLIBRARY_LABEL_TRACK_UPLOAD_LABEL; ?>" +upload_tracks+ ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:90%\" type=\"text\" name=\"new_upload_track_label"
        +upload_tracks+"\" "+"id=\"new_upload_track_label"+upload_tracks;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><br/>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
    }
</script>
                
<script language="javascript" type="text/javascript">
    var upload_audios=0;
    function new_audios(){
        div=document.getElementById("a_items");
        button=document.getElementById("a_add");
        upload_audios++;
        newitem="<table width='50%'><tr><td width='15%'><strong style=\"float:left\">" +
         "<?php echo _BOOKLIBRARY_LABEL_AUDIO_UPLOAD ?>" + upload_audios + ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:100%\" type=\"file\" onClick=\"document.adminForm.new_upload_audio_url"+upload_audios+".value ='';\" " +
        " onChange=\"refreshRandNumber1_audio("+upload_audios+
        ",this);\"  name=\"new_upload_audio"+upload_audios+"\" "+"id=\"new_upload_audio"+upload_audios;
        newitem+="\" value=\"\"size=\"45\">";
        newitem+="<span id=\"randNumAudio"+upload_audios+
        "\" style=\"color:red;\"></span></td></tr><tr><td style=\"text-align:center\"> OR </td><td></td></tr></table>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='15%'><strong>" + "<?php echo _BOOKLIBRARY_LABEL_AUDIO_UPLOAD_URL; ?>" +
         ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:90%\" type=\"text\" name=\"new_upload_audio_url"
         +upload_audios+"\" "+"id=\"new_upload_audio_url"+upload_audios;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><br />";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
         var allowed_aud_files = 5;
        if(upload_audios + <?php echo count($audios); ?> >= allowed_aud_files) {
         button.setAttribute("style","display:none");
        }
    }
</script>
                
<script language="javascript" type="text/javascript">

    window.onload = function(){
    var button_video = document.getElementById("v_add");
    var allowed_vid_files = 5;
   <?php if (count($videos) > 0) echo "allowed_files = " . (5 - count($videos)) . ";"; ?>
   if(allowed_vid_files >= 1) {
    button_video.removeAttribute("style");
    }
    
  var button_audio = document.getElementById("a_add");
  var allowed_aud_files = 5;
  <?php if (count($audios) > 0) echo "allowed_files = " . (5 - count($audios)) . ";"; ?>
    if(allowed_aud_files >= 1) {
    button_audio.removeAttribute("style");
    }
     
      for (var i=1; i < 5; i++) {
        if (document.getElementById('new_upload_video_youtube_code'+i) === null) continue;
        var add =  document.getElementById('new_upload_video_youtube_code'+i).value;
          if(add.length){
               var obj = document.getElementById('v_add');
               obj.style.display = "none"; 
            }
        }
  }
               
        function findPosY(obj) {
          var curtop = 0;
          if (obj.offsetParent) {
              while (1) {
                  curtop+=obj.offsetTop;
                  if (!obj.offsetParent) {
                      break;
                  }
                  obj=obj.offsetParent;
              }
          } else if (obj.y) {
              curtop+=obj.y;
          }
          return curtop-20;
         }
           
    function changeButtomName() {
    document.getElementById('v_add').value = "<?php 
        echo _BOOKLIBRARY_LABEL_VIDEO_ADD_ALTERNATIVE_VIDEO ?>";  
    }

    var upload_videos=0;
    function new_videos(){
        div=document.getElementById("v_items");
        button=document.getElementById("v_add");
        upload_videos++;
        newitem="<table width='50%'><tr><td width='160px'><strong style=\"float:left\">" + 
            "<?php echo _BOOKLIBRARY_LABEL_VIDEO_UPLOAD ?>" +upload_videos+ ": </strong></td>";
        newitem+="<td width='400px'><input style=\"float:left; width:150%\" type=\"file\"" + 
            " onClick=\"document.adminForm.new_upload_video_url"+upload_videos+".value ='';\" " +
            " onChange=\"refreshRandNumber1_video("+upload_videos+
            ",this);\" name=\"new_upload_video"+upload_videos+"\" "+"id=\"new_upload_video"+upload_videos;
        newitem+="\" value=\"\"size=\"45\">";
        newitem+="<span id=\"randNumVideo"+upload_videos+"\"" + 
            "style=\"color:red;\"></span></td></tr></td></tr><tr><td" + 
            "style=\"text-align:center\">OR</td><td></td></tr></table>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='160px'><strong>" + 
            "<?php echo _BOOKLIBRARY_LABEL_VIDEO_UPLOAD_URL; ?>" +upload_videos+ ": </strong></td>";
        newitem+="<td width='400px'><input style=\"float:left; width:90%\" type=\"text\"" + 
            "name=\"new_upload_video_url"+upload_videos+"\" "+"id=\"new_upload_video_url"+upload_videos;
        newitem+="\" value=\"\"size=\"45\"></td></tr></td></tr></td></tr><tr><td" + 
            "style=\"text-align:center\">OR</td><td></td></tr></table>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='160px'><strong>" + 
            "<?php echo _BOOKLIBRARY_LABEL_VIDEO_UPLOAD_YOUTUBE_CODE; ?>" + ": </strong></td>";
        newitem+="<td width='400px'><input style=\"float:left; width:90%\" type=\"text\"" + 
            "name=\"new_upload_video_youtube_code"+upload_videos+"\" "+"id=\"new_upload_video_youtube_code"+upload_videos;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><p><font" + 
            "color=\"red\">!!!</font> Youtube code has more priority." + 
            "If you enter Youtube code you will see video in the frontend from youtube source</p><br/>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        var allowed_files = 5;
        if(upload_videos + <?php echo count($videos); ?> >= allowed_files) {
         button.setAttribute("style","display:none");
        }
        changeButtomName();
    }
</script>
                
<script language="javascript" type="text/javascript">
    var upload_files=0;
    function new_files(){
        div=document.getElementById("f_items");
        button=document.getElementById("f_add");
        upload_files++;
        newitem="<table width='50%'><tr><td width='15%'><strong style=\"float:left\">" +
         "<?php echo _BOOKLIBRARY_LABEL_EBOOK_UPLOAD ?>" + upload_files + ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:100%\" "+
        "type=\"file\" onClick=\"document.adminForm.new_upload_file_url"+upload_files+".value ='';\" " +
        " onChange=\"refreshRandNumber1("+upload_files+
        ",this);\"  name=\"new_upload_file"+upload_files+"\" "+"id=\"new_upload_file"+upload_files;
        newitem+="\" value=\"\"size=\"45\">";
        newitem+="<span id=\"randNumFile"+upload_files+"\" style=\"color:red;\"></span></td></tr></table>";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
        newitem="<table width='50%'><tr><td width='15%'><strong>" +
         "<?php echo _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_URL; ?>" + ": </strong></td>";
        newitem+="<td width='85%'><input style=\"float:left; width:90%\" type=\"text\" name=\"new_upload_file_url"
        +upload_files+"\" "+"id=\"new_upload_file_url"+upload_files;
        newitem+="\" value=\"\"size=\"45\"></td></tr></table><br><br />";
        newnode=document.createElement("span");
        newnode.innerHTML=newitem;
        div.insertBefore(newnode,button);
    }
</script>
                               
<script type="text/javascript">      
function newInput(element_id) {
        if (document.getElementById(element_id)) { 
            var obj = document.getElementById(element_id); 
            if (obj.style.display != "block") { 
                obj.style.display = "block";
            var authors = document.getElementById('authors'); 
                authors.style.display = "none"; 
                document.getElementById('button').value = 'Show all authors';
            }
            else {
              obj.style.display = "none";
            var authors = document.getElementById('authors'); 
              authors.style.display = "block";
              authors.style.float = "left";
              
              document.getElementById('button').value = 'Add new Author';
            }
     }
} 
</script>
<!--****************************************************end files upload********************-->                   
                
                
        <!-- <?php //if ($booklibrary_configuration['ebooks']['allow']) {
        
        ?>    
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_EBOOK_UPLOAD; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="file" name="ebook_file" value="" size="30" 
                    maxlength="250" onClick="document.adminForm.ebook_Url.value ='';"/>
                </td>
            </tr>        
             <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_URL; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="text" name="ebook_Url" 
                    value="<?php echo $row->ebookURL; ?>" size="30" maxlength="250"/>
                </td>
            </tr>        
        <?php
        // } if (count($row->ebookURL) > 0) {
        
        ?>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_EBOOK_DELETE; ?>:</strong>
                </td>
                <td align="left"><?php echo $delete_ebook; ?></td>
            </tr>
        <?php
        // }
        
        ?>        
            <tr>
                <td colspan="2"><hr size="2" width="100%" /></td>
            </tr>   -->
            <tr>
                <td valign="top" align="right">&nbsp;</td>
                <td align="left">
                    <?php echo _BOOKLIBRARY_ADMIN_TEXT_WSINFO_TEXT1; ?>
                    <strong>
                    <?php echo _BOOKLIBRARY_LABEL_FETCH_INFO; ?>
                        ->
                    <?php echo _BOOKLIBRARY_WS_NO; ?>

                    </strong>
                </td>
            </tr>    
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_TITLE; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" id="titleid" type="text" name="title" size="80" 
                           value="<?php echo $row->title; ?>" />
                </td>
            </tr>
                
                
            <tr>
                <td valign="top" align="right"><strong>
                    <?php echo _BOOKLIBRARY_LABEL_AUTHORS ; ?>:</strong>
                </td>
                <td align="left"><?php echo $authorsshow; ?>
                    <span ID="block_id" style="display:none; float:left" >
                        <input class="inputbox"  type="text" name="new_authors"/>
                    </span>
                    <span>
                        <input class="inputbox" id="button" type="button" value="<?php echo 'Add new Author'; ?>" 
                                onClick="newInput('block_id')">
                    </span>
                </td>
            </tr> 
               




        </script>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_MANUFACTURER; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="text" name="manufacturer" size="80" 
                           value="<?php echo $row->manufacturer; ?>" />
                </td>
            </tr>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_PUB_DATE; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="text" name="release_Date" size="30" 
                           value="<?php echo $row->release_Date; ?>" />                
                </td>
            </tr>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_PRICE; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="text" id="priceid" name="price" size="15" 
                           value="<?php echo $row->price; ?>" />
                    <input class="inputbox" type="text" name="priceunit" size="6" 
                           value="<?php echo $row->priceunit; ?>" />
                </td>
            </tr>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_EDITION; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="text" name="edition" size="45" 
                           value="<?php echo $row->edition; ?>" />
                </td>
            </tr>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_NUMPAGES; ?>:</strong>
                </td>
                <td align="left">
                    <input class="inputbox" type="text" name="numberOfPages" size="6" 
                           value="<?php echo $row->numberOfPages; ?>" />
                </td>
            </tr>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_RATING; ?>:</strong>
                </td>
                <td align="left">
                    <?php echo $rating; ?>
                </td>                
            </tr>
            <tr>
                <td valign="top" align="right">
                    <strong><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL; ?>:</strong>
                </td>
                <!-- /////////////////////////////Begin AddPatch CODE///////////////////-->           
                <td align="left">
                    <input class="inputbox" type="text" name="imageURL" size="80" 
                           value="<?php echo $row->imageURL; ?>" />                
                    <input class="inputbox" type="button" name="default_patch" 
                           value="Set Local Cover Path" onClick="build_patch()" />
                        
        <script type="text/javascript" language="javascript">
            function build_patch()
            {
                var isbn = document.adminForm.isbn.value;var url = 
                    'components/com_booklibrary/isbn_build.php';
                
          <?php $cover_path = $booklibrary_configuration['fetchImages']['location']; ?>    
                    var cover_path = "<?php echo $cover_path; ?>";                                    
                    if (window.XMLHttpRequest)
                    {
                        // Mozilla, Safari,...
                        http_request = new XMLHttpRequest();
                        if (http_request.overrideMimeType)
                        {http_request.overrideMimeType('text/xml');} }
                    else if (window.ActiveXObject)
                    {
                        // IE
                        try
                        {http_request = new ActiveXObject("Msxml2.XMLHTTP");}
                        catch (e)
                        { try
                            {http_request = new ActiveXObject("Microsoft.XMLHTTP");}
                            catch (e) {} }}
                    if (!http_request)
                    { alert('Giving up :( Cannot create an XMLHTTP instance');
                        return false; }
                    http_request.onreadystatechange = alertContents;
                    http_request.open("POST", url, true);
                    http_request.setRequestHeader('Content-Type' , 'application/x-www-form-urlencoded');
                    http_request.send('isbn='+isbn+'&cover_path='+cover_path); }

                function alertContents()
                { if (http_request.readyState == 4)
                    { if (http_request.status == 200)
                        { var resp_text = http_request.responseText;if (resp_text == 1)
                            { alert("<?php echo _BOOKLIBRARY_TOOLBAR_NEW_BOOK_INCORRECT_FOLDER . " " . 
                                $cover_path; ?>");}
                            if (resp_text == false) 
                            { alert(resp_text + "<?php 
                                echo _BOOKLIBRARY_TOOLBAR_NEW_BOOK_INCORRECT_FILE; ?>");}
                            else { document.adminForm.imageURL.value = resp_text;} }
                        else { alert('There was a problem with the request.');}
                    } }
        </script>  
                    </td>
                </tr>
                
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL_UPLOAD; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" type="file" name="picture_file" value="" 
                              size="30" maxlength="250" />
                        <br /><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL_DESC; ?>
    <?php
        if ($row->imageURL != "" && !strstr($row->imageURL, "http")) {
            echo '<div><img class="bl_view_book_book_image" src="' . $mosConfig_live_site . '' . $row->imageURL . 
                '" alt="' . $row->title . '" border="0" 
                              height="' . $booklibrary_configuration['foto']['high'] . '" width="' . 
                              $booklibrary_configuration['foto']['width'] . 
                '"/></div>';
        } else if ($row->imageURL != "" && strstr($row->imageURL, "http")) {
            echo '<div><img class="bl_view_book_book_image" src="' . $row->imageURL . '" alt="' . 
                $row->title . '" border="0" 
                height="' . $booklibrary_configuration['foto']['high'] . '" width="' . 
                $booklibrary_configuration['foto']['width'] . 
                  '"/></div>';
        }
    ?>
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_URL; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" type="text" name="URL" size="80" 
                               value="<?php echo $row->URL; ?>" />
                    </td>
                </tr>
                
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_BOOKOWNER_EMAIL; ?>:</strong>
                    </td>
                    <td align="left">
                        <?php //echo $row->owner; ?><?php //echo $row->owneremail; ?>
                        <input name="owneremail" type="text" size="80" 
                               value="<?php echo $row->owneremail; ?>" />
                    </td>
                </tr>
               <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_BOOKOWNER_ID; ?>:</strong>
                    </td>
                    <td align="left">
                        <?php //echo $row->owner; ?><?php //echo $row->owneremail; ?>
                        <input name="owner_id" type="text" id ="owner_id"
                               size="80" value="<?php echo $row->owner_id; ?>" />
                    </td>
                </tr>

                <?php 
                if ( ($booklibrary_configuration['online_book_from_article']['allow']) ) {
                    if ( checkAccessBL($booklibrary_configuration['online_book_from_article']['registrationlevel'], 
                        'RECURSE', userGID_BL($my->id), $acl) ) {
                        ?>
                 <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LOAD_ARTICLE_BOOK; ?>:</strong>
                        <?php 
                            echo mosToolTip(_BOOKLIBRARY_LOAD_ARTICLE_BOOK_TT_BODY, '', 
                            JURI::root() . '/components/com_booklibrary/images/circle-info.png');
                        ?>
                    </td>
                    <td align="left">
                        <?php echo $row->modal_article; ?>
                    </td>
                </tr>

                <?php 
                    }
                } ?>


                <?php 
                if ( ($booklibrary_configuration['online_book_flip']['allow']) ) {
                    if ( checkAccessBL($booklibrary_configuration['online_book_flip']['registrationlevel'], 
                        'RECURSE', userGID_BL($my->id), $acl) ) {
                        ?>

                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_FLIPHTML_BOOK; ?>:</strong>
                        <?php 
                            echo mosToolTip( _BOOKLIBRARY_INSERT_LINK_FLIPHTML5_TT_BODY, '', 
                            JURI::root() . '/components/com_booklibrary/images/circle-info.png');
                        ?>
                    </td>
                    <td align="left">
                       <input name="fliphtml5" type="text" value="<?php echo $row->flipHTML5 ?>" /> 
                    </td>
                </tr>
                <?php 
                    }
                } ?>

                
        <?php  
                $user = JFactory::getUser($my->id);
                $user->name;
                if($user->name == "Super User"){ ?>
                <script type="text/javascript" language="javascript">
                    document.getElementById("owner_id").removeAttribute("readonly"); 
                </script>  
        <?php } else{ ?>


                <script type="text/javascript" language="javascript">
                    document.getElementById("owner_id").setAttribute("readonly","on"); 
                </script>  
        <?php } ?>
                 
        <?php
        if ($booklibrary_configuration['videos_tracks']['allow']) {
            echo '<tr><td colspan="2"></td></tr>';
            echo "<tr > <td valign='top' align='right'>" . _BOOKLIBRARY_LABEL_VIDEO . ":</td>";
            if (count($videos) > 0 && empty($youtubeCode)) {
                $upload_videos = 0;
                for ($i = 0;$i < count($videos);$i++) {
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_VIDEO_ATTRIBUTE . ($i + 1) . ":";
                    echo "</td><td>";
                    $upload_videos++;
                    if (isset($videos[$i]->src) && substr($videos[$i]->src, 0, 4) != "http" && 
                    empty($videos[$i]->youtube)) echo "<input type='text' name='new_upload_video" . 
                        $upload_videos . "' id='new_upload_video" . $upload_videos . "' 
                    size='60' value='" . $mosConfig_live_site . $videos[$i]->src . 
                        "' readonly='readonly' />";
                    elseif (isset($videos[$i]->src) && substr($videos[$i]->src, 0, 4) == "http" && 
                    empty($videos[$i]->youtube)) echo "<input type='text' name='new_upload_video" . 
                        $upload_videos . "' id='new_upload_video_url" . $upload_videos . "' 
                    size='60' value='" . $videos[$i]->src . "' readonly='readonly' />";
                    echo "</td></tr>";
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_VIDEO_DELETE . ":";
                    echo "</td><td>";
                    echo isset($videos[$i]->id) ? "<input type=\"checkbox\" name=\"video_option_del" . 
                        $videos[$i]->id . "\" value=\"" . $videos[$i]->id . "\">" : "";
                    echo "</td></tr>";
                }
            } else if (!empty($youtubeCode)) {
                $upload_videos = 0;
                for ($i = 0;$i < count($youtubeCode);$i++) {
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_VIDEO_ATTRIBUTE . ($i + 1) . ":";
                    echo "</td><td>";
                    $upload_videos++;
                    if (isset($youtubeCode['youtube'])) echo "<input type='text' 
                          name='new_upload_video_youtube_code" . $upload_videos . "' 
                          id='new_upload_video_youtube_code" . $upload_videos . "' 
                          size='60' value='" . $youtubeCode['youtube'] . "' />";
                    echo "</td></tr>";
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_VIDEO_DELETE . ":";
                    echo "</td><td>";
                    echo isset($youtubeId) ? "<input type=\"checkbox\" name=\"youtube_option_del" . 
                        $youtubeId . "\" value=\"" . $youtubeId . "\">" : "";
                    echo "</td></tr>";
                }
            }
            if (count($videos) > 0) echo "<td>"; //style="display:none" ?>
                       <td ID="v_items">
                            <input  type="button" name="new_video"
                            value="<?php echo _BOOKLIBRARY_LABEL_ADD_NEW_VIDEO_FILE; ?>" 
                            onClick="new_videos()" ID="v_add" />
                       </td> 
          <?php if (count($videos) > 0) echo "<td>";
        }
        if ($booklibrary_configuration['videos_tracks']['allow']) {
            echo '<tr><td colspan="2"></td></tr>';
            echo "<tr > <td valign='top' align='right'>" . _BOOKLIBRARY_LABEL_TRACK . ":</td>";
            if (count($tracks) > 0) {
                for ($i = 0;$i < count($tracks);$i++) {
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_TRACK_UPLOAD_URL . ($i + 1) . ":";
                    echo "</td><td>";
                    if (isset($tracks[$i]->src) && substr($tracks[$i]->src, 0, 4) != "http") 
                    echo "<input type='text' class='trackitems' size='60' value='" . 
                        $mosConfig_live_site . $tracks[$i]->src . "' readonly='readonly'/>";
                    elseif (isset($tracks[$i]->src) && substr($tracks[$i]->src, 0, 4) == "http") 
                    echo "<input type='text' class='trackitems' size='60' value='" . 
                        $tracks[$i]->src . "' readonly='readonly'/>";
                    if (!empty($tracks[$i]->kind)) echo "<input class='trackitems' type='text' 
                        size='60' value='" . $tracks[$i]->kind . "' readonly='readonly'/>";
                    if (!empty($tracks[$i]->scrlang)) echo "<input class='trackitems'type='text' 
                        size='60' value='" . $tracks[$i]->scrlang . "' readonly='readonly'/>";
                    if (!empty($tracks[$i]->label)) echo "<input class='trackitems' type='text' 
                        size='60' value='" . $tracks[$i]->label . "' readonly='readonly'/>";
                    echo "</td></tr>";
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_TRACK_DELETE . ":";
                    echo "</td><td>";
                    echo isset($tracks[$i]->id) ? "<input type=\"checkbox\" name=\"track_option_del" . 
                        $tracks[$i]->id . "\" value=\"" . $tracks[$i]->id . "\">" : "";
                    echo "</td></tr>";
                }
            }
            if (count($tracks) > 0) echo "<td>"; ?>
                    <td ID="t_items">
                        <input  type="button" name="new_track"
                                value="<?php echo _BOOKLIBRARY_LABEL_ADD_NEW_TRACK; ?>" 
                                onClick="new_tracks()" ID="t_add"/>
                    </td>
          <?php if (count($tracks) > 0) echo "<td>";
        }
        if ($booklibrary_configuration['audios']['allow']) {
            echo '<tr><td colspan="2"></td></tr>';
            echo "<tr > <td valign='top' align='right'>" . _BOOKLIBRARY_LABEL_AUDIO . ":</td>";
            if (count($audios) > 0) {
                for ($i = 0;$i < count($audios);$i++) {
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_AUDIO_ATTRIBUTE . ($i + 1) . ":";
                    echo "</td><td>";
                    if (isset($audios[$i]->src) && substr($audios[$i]->src, 0, 4) != "http") 
                    echo "<input type='text' size='60' value='" . $mosConfig_live_site . 
                        $audios[$i]->src . "' readonly='readonly' />";
                    elseif (isset($audios[$i]->src) && substr($audios[$i]->src, 0, 4) == "http") 
                    echo "<input type='text' size='60' value='" . $audios[$i]->src . 
                        "' readonly='readonly'/>";
                    echo "</td></tr>";
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_AUDIO_DELETE . ":";
                    echo "</td><td>";
                    echo isset($audios[$i]->id) ? "<input type=\"checkbox\" name=\"audio_option_del" . 
                        $audios[$i]->id . "\" value=\"" . $audios[$i]->id . "\">" : "";
                    echo "</td></tr>";
                }
            }
            if (count($audios) > 0) echo "<td>"; //style="display:none" ?>
                    <td ID="a_items">
                            <input  type="button" name="new_audio"
                            value="<?php echo _BOOKLIBRARY_LABEL_ADD_NEW_AUDIO_FILE; ?>" 
                            onClick="new_audios()" ID="a_add" />
                    </td>
                         
        <?php if (count($audios) > 0) echo "<td>";
        }
        if ($booklibrary_configuration['ebooks']['allow']) {
            echo '<tr><td colspan="2"></td></tr>';
            echo "<tr > <td valign='top' align='right'>" . _BOOKLIBRARY_LABEL_EBOOK . ":</td>";
            if (count($files) > 0) {
                for ($i = 0;$i < count($files);$i++) {
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_URL . ($i + 1) . ":";
                    echo "</td><td>";
                    if (isset($files[$i]->location) && substr($files[$i]->location, 0, 4) != "http") 
                    echo "<input type='text' size='60' value='" . $mosConfig_live_site . 
                        $files[$i]->location . "' readonly='readonly'/>";
                    elseif (isset($files[$i]->location) && substr($files[$i]->location, 0, 4) == "http") 
                    echo "<input type='text' size='60' value='" . $files[$i]->location . 
                        "' readonly='readonly'/>";
                    echo "</td></tr>";
                    echo "<tr><td align='right'>" . _BOOKLIBRARY_LABEL_EBOOK_DELETE . ":";
                    echo "</td><td>";
                    echo isset($files[$i]->id) ? "<input type=\"checkbox\" name=\"file_option_del" . 
                        $files[$i]->id . "\" value=\"" . $files[$i]->id . "\">" : "";
                    echo "</td></tr>";
                }
            }
        if (count($files) > 0) echo "<td>"; 
        ?>
                    <td ID="f_items">
                        <input  type="button" name="new_file"
                        value="<?php echo "Add new ebook file"; ?>" onClick="new_files()"  
                        ID="f_add"/>
                    </td>
        <?php if (count($files) > 0) echo "<td>";
        }
        ?>
                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                
                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_START_PUBLISHING; ?>:</strong>
                    </td>
                    <td align="left">
                        <?php echo JHTML::_( 'calendar',$row->publish_up ,$name='publish_up' ,$id='publish_up' ,$booklibrary_configuration['date_format'] ,array('class'=>"bl_calendar") ); ?>                
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_FINISH_PUBLISHING; ?>:</strong>
                    </td>
                    <td align="left"  style="width:230px">
                        <?php echo JHTML::_( 'calendar',$row->publish_down ,$name='publish_down' ,$id='publish_down' ,$booklibrary_configuration['date_format'] ,array('class'=>"bl_calendar") ); ?>                
                    </td>
                </tr>

                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_META_TITLE; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" type="text" name="metadata[meta_title]" size="50" maxlength="150"
                               value="<?php echo $row->metadata["meta_title"]; ?>" />                
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_META_KEYWORDS; ?>:</strong>
                    </td>
                    <td align="left">
                        <textarea class="text_area" type="text" name="metadata[meta_keywords]" cols="30" rows="3" 
                        ><?php echo $row->metadata["meta_keywords"]; ?></textarea>                                              
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_META_DESCRIPTION; ?>:</strong>
                    </td>
                    <td align="left">
                        <textarea class="text_area" type="text" name="metadata[meta_description]" cols="30" rows="3" 
                        ><?php echo $row->metadata["meta_description"]; ?></textarea> 
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_ROBOTS; ?>:</strong>
                    </td>
                    <td align="left">
                          <?php echo $meta_robots; ?> 
                    </td>
                </tr>

                
        <?php
        //*****************************************************************************************
        //**********************************   begin change review   ******************************
        //*****************************************************************************************
        if ($reviews > false) { /* show, if review exist */
        ?>
                    <tr>
                        <td colspan="7">
                            <hr width="100%" size="2" align="left"> <h3>
                            <?php echo _BOOKLIBRARY_LABEL_REVIEWS; ?>:</h3> 
                        </td>
                    </tr>

                    <table class="adminlist admin22">
                        <tr class="row0">
                            <td width="3%" valign="top" align="center"><div>id</div></td>
                            <td width="2%" valign="top" align="center"><div></div></td>
                            <td width="10%" valign="top" align="center">
                                <strong><?php echo _BOOKLIBRARY_LABEL_REVIEW_TITLE; ?>:</strong>
                            </td>
                            <td width="10%" valign="top" align="center">
                                <strong><?php echo _BOOKLIBRARY_LABEL_LEND_USER; ?>:</strong>
                            </td>
                            <td width="65%" valign="top" align="center">
                                <strong><?php echo _BOOKLIBRARY_LABEL_REVIEW_COMMENT; ?>:</strong>
                            </td>
                            <td width="5%" valign="top" align="center">
                                <strong><?php echo _BOOKLIBRARY_LABEL_PUB_DATE; ?>:</strong>
                            </td>
                            <td width="5%" valign="top" align="center">
                                <strong><?php echo _BOOKLIBRARY_LABEL_REVIEW_RATING; ?>:</strong>
                            </td>
                        </tr>

        <?php for ($i = 0, $nn = 1;$i < count($reviews);$i++, $nn++) /* if not one comment */ {
        ?>
                            <tr class="row0">
                                <td valign="top" align="center">
                                    <div><?php echo $nn; ?></div>
                                </td>
                                <td valign="top" align="center">
                                    <div>
                                <?php echo "<input type='radio' id='cb" . $i . "' name='bid[]' 
                                    value='" . $row->id . "," . $reviews[$i]->id . "' 
                                    onclick='Joomla.isChecked(this.checked);' />"; ?>
                                    </div>
                                </td>
                                <td valign="top" align="center">
                                    <div><?php print_r($reviews[$i]->title); ?></div>
                                </td>
                                <td valign="top" align="left">
                                    <div><?php print_r($reviews[$i]->name); ?></div>
                                </td>
                                <td valign="top" align="left">
                                    <div><?php print_r($reviews[$i]->comment); ?></div>
                                </td>
                                <td valign="top" align="left">
                                    <div><?php print_r($reviews[$i]->date); ?></div>
                                </td>
                                <td valign="top" align="left">
                                    <div><img src="<?php echo JURI::root(true); ?>/components/com_booklibrary/images/rating-<?php echo $reviews[$i]->rating; ?>.png" 
                                             alt="<?php echo ($reviews[$i]->rating) / 2; ?>" border="0" 
                                             align="right"/>&nbsp;</div>
                                </td>
                            </tr>
        <?php } /* end for(...) */ ?>

                    </table>
                    
                    
        <?php } /* end if(...) */ ?>

            </table>

            <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
            <input type="hidden" name="option" value="<?php echo $option; ?>" />        
            <input type="hidden" name="boxchecked" value="0" />
            <input type="hidden" name="task" value="" />                
        </form>
        
         <script language="javascript" type="text/javascript"> 
          
          var task = "<?php echo $_REQUEST['task']; ?>";
            if(task === 'clone_book'){
                if(sessionStorage.getItem('saver') !== 'null'){ 
                    sessionStorage.setItem('saver', 'null');
                    Joomla.submitform('apply');   
                }     
                sessionStorage.setItem('saver', 'notnull');     
            }
          
        </script>
    <?php
        //*********************************************************************************
        //**********************************   end change review   ************************
        //*********************************************************************************
        
    }
    static function editAuthor($option, $author, $langshow, $authors_name, $rows, 
                               $ItemId_tmp_from_db, $books_titles, $associateArray,$meta_robots) {
        global $database, $booklibrary_configuration, $my, $mosConfig_live_site, 
               $mainframe, $doc; 

        os_hide_left_panel();

        $doc->addScript($mosConfig_live_site . 
            '/components/com_booklibrary/includes/functions.js');
        $aa = $author->id ? _BOOKLIBRARY_HEADER_EDIT : _BOOKLIBRARY_HEADER_ADD;
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' 
                alt ='' />" . $aa . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>   
        <script language="javascript" type="text/javascript">
            function trim(string){
                return string.replace(/(^\s+)|(\s+$)/g, "");
            }
            
            Joomla.submitbutton = function(task) { 

                if (task == 'save_author' || task == 'apply_author') {
                    var author_name = document.getElementById("authors_name").value;
                    if (trim(author_name) == '') {
                        alert( "<?php echo _BOOKLIBRARY_LABEL_CHECK_AUTHOR_NAME; ?>" );
                        return;
                    }
                    else {
                        <?php
                            echo "Joomla.submitform( task )";
                        ?>
                    }
                } else {
                    <?php
                        echo "Joomla.submitform(task)";
                    ?>
                }
            }
        </script>
 
           <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" 
                enctype="multipart/form-data">
            <table cellpadding="4" cellspacing="1" border="0" width="100%" 
                   class="adminform bl_admin_books_book my_table">
                
                <tr>
                    <td width="20%"><?php echo "ID"; ?>:</td>
                    <td colspan="2" width="80%">
                        <input readonly="readonly" class="text_area id" type="text" name="catid" 
                        id="catid" value="<?php echo $author->id; ?>" 
                        size="30" maxlength="50" title="" />
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_AUTHOR_NAME; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" id="authors_name" type="text" name="authors_name" 
                               size="20" value="<?php echo $author->authors_name; ?>" />
                    </td>
                </tr>

    <?php
        /*******************************************    language    ************************/
        if (!empty($associateArray) && !empty($author->langshow) && $author->langshow != '' && 
            $author->langshow != '*') {
    ?>
                <tr> 
                    <td width="15%"><?php echo 'language associate authors' ?>:</td>                        
                </tr>   
            
    <?php
            $j = 1;
            foreach($associateArray as $lang => $value) {
                $displ = '';
                if (!$value['list']) {
                    $displ = 'none';
                }
    ?>    
                <tr style="display: <?php echo $displ ?>">
                    <td width="15%"><?php echo $lang; ?>:</td>
                    <td width="60%"><?php echo $value['list']; ?> 
                    <input class="inputbox" id="associate_author" type="text" 
                           name="associate_author<?php echo $j; ?>" size="20" 
                           readonly="readonly" maxlength="20" style="width:25px;" 
                           value="<?php echo $value['assocId']; ?>" />
                    <input style="display: none" name="associate_author_lang<?php echo $j; ?>" 
                           value="<?php echo $lang ?>"/>  
                    </td>                          
                </tr>
    <?php
                $j++;
            }
        } else {
    ?>
                <tr> 
                    <td width="15%"><?php echo 'language associate authors' ?>:</td> 
                    <td width="60%"><?php echo 'this property only for authors with language' ?> 
                </tr> 
    <?php
        }
        /*******************************************************************************************/
    ?>                        
                 <tr>
                    <td valign="top" align="right"><strong>
                    <?php echo _BOOKLIBRARY_LABEL_LANGUAGEDESCRIPTION; ?>:</strong></td>
                    <td align="left"><?php echo $langshow; ?></td>
                </tr> 
                
                <tr>
                    <td valign="top" align="right"><strong>
                    <?php echo _BOOKLIBRARY_LABEL_COMMENT; ?>:</strong></td>
                    <td align="left">
        <?php editorArea('editor1', $author->description, 'description', 500, 250, '400', '400'); ?>
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_AUTHOR_GENERATE_DESCRIPTION; ?>:</strong>
                    </td>
                    <td align="left">
                        <div  id="auto_gener_desc" name="auto_gener_desc" 
                              style="width: 650px; border: 1px solid #9e9e9e; 
                              height: auto; padding:10px;"/>
    <?php
          if(strlen($books_titles) > 1){
            $message = _BOOKLIBRARY_ADMIN_CONFIG_AUTHOR_DESCTIPTION;
            $message = str_replace("{author_name}", $author->authors_name, $message);
            $message = str_replace("{books_titles}", $books_titles, $message);
            echo $message;
          }
    ?>          
                        </div>  
                    </td>
                    
                     <td align="right">
                        <?php echo _BOOKLIBRARY_ADMIN_CONFIG_TAG_FOR_DESCRIPTION; ?>
                        <div style="background:#F5F5F5; padding:10px;">
                        <?php echo _BOOKLIBRARY_ADMIN_CONFIG_AUTHOR_DESCTIPTION; ?>
                        </div>
                    
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_PUB_DATE; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" type="text" name="pub_date_author" 
                               size="30" value="<?php
        if (empty($author->date)) {
            echo date("Y-m-d H:i:s");
        } else {
            echo $author->date;
        }?>" />                
                    </td>
                </tr>
                
    <!--<tr>
        <td valign="top" align="right">
            <strong><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL; ?>:</strong>
        </td>
        <td align="left">
            <input class="inputbox" type="text" name="imageURL" size="80" 
                value="<?php echo $author->imageURL; ?>" />                
            <input class="inputbox" type="button" name="default_patch" 
                value="Set Local Cover Path" onClick="build_patch()" />
            <script type="text/javascript" language="javascript">
                function build_patch()
                {
                    var id = document.adminForm.id.value;
                    var url = 'components/com_booklibrary/isbn_build.php';
                   
          <?php $cover_path = $booklibrary_configuration['fetchImages']['location']; ?>    
                        var cover_path = "<?php echo $cover_path; ?>";                                    
                        if (window.XMLHttpRequest)
                        {
                            // Mozilla, Safari,...
                            http_request = new XMLHttpRequest();
                            if (http_request.overrideMimeType)
                            {http_request.overrideMimeType('text/xml');} }
                        else if (window.ActiveXObject)
                        {
                            // IE
                            try
                            {http_request = new ActiveXObject("Msxml2.XMLHTTP");}
                            catch (e)
                            { try
                                {http_request = new ActiveXObject("Microsoft.XMLHTTP");}
                                catch (e) {} }}
                        if (!http_request)
                        { alert('Giving up :( Cannot create an XMLHTTP instance');
                            return false; }
                        http_request.onreadystatechange = alertContents;
                        http_request.open("POST", url, true);
                        http_request.setRequestHeader('Content-Type' , 
                            'application/x-www-form-urlencoded');
                        http_request.send('isbn='+id+'&cover_path='+cover_path); }

                    function alertContents()
                    { if (http_request.readyState == 4)
                        { if (http_request.status == 200)
                            { var resp_text = http_request.responseText;if (resp_text == 1)
                                { alert("<?php echo _BOOKLIBRARY_TOOLBAR_NEW_BOOK_INCORRECT_FOLDER . 
                                    " " . $cover_path; ?>");}
                                if (resp_text == false) 
                                { alert(resp_text + "<?php 
                                    echo _BOOKLIBRARY_TOOLBAR_NEW_BOOK_INCORRECT_FILE; ?>");}
                                else { document.adminForm.imageURL.value = resp_text;} }
                            else { alert('There was a problem with the request.');}
                        } }
            </script>                
        </td>
    </tr>-->
                
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL_UPLOAD; ?>:</strong>
                    </td>
                   
                   <td align="left">
                        <input class="inputbox" type="file" name="picture_file_author" 
                               value="" size="30" maxlength="250" />
                        <br /><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL_DESC; ?>
    <?php
        if ($author->imageURL != "" && !strstr($author->imageURL, "http")) {
            echo '<div><img class="bl_view_book_book_image" src="' . $mosConfig_live_site . '' . 
                $author->imageURL . 
                '" alt="' . $author->authors_name . '" border="0" 
                height="' . $booklibrary_configuration['foto']['high'] . '" width="' . 
                $booklibrary_configuration['foto']['width'] . '"/></div>';
        } else if ($author->imageURL != "" && strstr($author->imageURL, "http")) {
            echo '<div><img class="bl_view_book_book_image" src="' . $author->imageURL . '" alt="' . 
                $author->authors_name . '" border="0" height="' . 
                $booklibrary_configuration['foto']['high'] . '" width="' . 
                $booklibrary_configuration['foto']['width'] . '"/></div>';
        }
    ?>
                   </td>
                </tr>
                
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_LABEL_AUTHOR_OWNER; ?>:</strong>
                    </td>
                    <td align="left">
                        <?php echo $author->owner; ?>(<?php echo $author->owneremail; ?>)
                        <input type="hidden" name="owneremail_author" size="80" 
                               value="<?php echo $author->owneremail; ?>" />
                    </td>
                </tr>
                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_START_PUBLISHING; ?>:</strong>
                    </td>
                    <td align="left">
                        <?php echo JHTML::_( 'calendar',$author->publish_up ,$name='publish_up' ,$id='publish_up' ,$booklibrary_configuration['date_format'] ,array('class'=>"bl_calendar") ); ?>                
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_FINISH_PUBLISHING; ?>:</strong>
                    </td>
                    <td align="left"  style="width:230px">
                        <?php echo JHTML::_( 'calendar',$author->publish_down ,$name='publish_down' ,$id='publish_down' ,$booklibrary_configuration['date_format'] ,array('class'=>"bl_calendar") ); ?>                
                    </td>
                </tr>

                 <tr>
                    <td colspan="2"><hr size="2" width="100%" /></td>
                </tr>               
                
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_META_TITLE; ?>:</strong>
                    </td>
                    <td align="left">
                        <input class="inputbox" type="text" name="metadata[meta_title]" size="50" maxlength="150"
                               value="<?php echo $author->metadata["meta_title"]; ?>" />                
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_META_KEYWORDS; ?>:</strong>
                    </td>
                    <td align="left">
                        <textarea class="text_area" type="text" name="metadata[meta_keywords]" cols="30" rows="3" 
                        ><?php echo $author->metadata["meta_keywords"]; ?></textarea>                                              
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_META_DESCRIPTION; ?>:</strong>
                    </td>
                    <td align="left">
                        <textarea class="text_area" type="text" name="metadata[meta_description]" cols="30" rows="3" 
                        ><?php echo $author->metadata["meta_description"]; ?></textarea> 
                    </td>
                </tr>
                <tr>
                    <td valign="top" align="right">
                        <strong><?php echo _BOOKLIBRARY_ROBOTS; ?>:</strong>
                    </td>
                    <td align="left">
                          <?php echo $meta_robots; ?> 
                    </td>
                </tr>
                
            </table>
            <input type="hidden" name="id" value="<?php echo $author->id; ?>" />
            <input type="hidden" name="option" value="<?php echo $option; ?>" />        
            <input type="hidden" name="boxchecked" value="0" />
            <input type="hidden" name="task" value="" /> 
        </form>

        
    <?php
    }
    static function showInfoRefetchBooks($option, $result, &$wslist) {
        global $my, $mosConfig_live_site, $mainframe, $doc; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
    ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">
            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                   class="adminlist bl_admin_fetch_information my_table">
                <tr>
                    <td  colspan="6"><?php echo _BOOKLIBRARY_REFETCH; ?></td>
                </tr>
                <tr>
                    <td colspan="6">
                        <strong><?php echo _BOOKLIBRARY_LABEL_INFO_FETCH; ?></strong>
                        <?php echo $wslist; ?>
                        &nbsp;&nbsp;&nbsp;
                        <img src="../components/com_booklibrary/images/amazon/com-logo.gif" 
                             alt="amazon.com" border="0" />
                    </td>
                </tr>
                <tr>
                    <th align = "center" class="title" width="20">
                        <?php echo _BOOKLIBRARY_LABEL_INFO_REFETCH; ?>
                    </th>
                    <th align = "center" class="title" width="30">id</th>
                    <th align = "center"  class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_BOOKID; ?></th>
                    <th align = "center" class="title" width="30%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_ISBN; ?></th>
                    <th align = "center"  class="title" width="30%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_RESULT; ?></th>
                </tr>
    <?php
        $i = 0;
        while ($i < count($result)) {
            $row = $result[$i];
    ?>

                <tr class="row<?php echo $i % 2; ?>">
                    <td align = "center">
        <?php
            if ($row[3] != "OK") {
                echo "<input type='checkbox' id='cb'" . $i . "' name='bid[]' value='" . 
                    $row[0] . "' onclick='isChecked(this.checked);' />";
            } else {
                echo "&nbsp";
            }
        ?>
                    </td>
                    <td align = "center"><?php echo $row[0] ?></td>
                    <td align = "center"><?php echo $row[1] ?></td>
                    <td align = "center"><?php echo $row[2] ?></td>
                    <td align = "center"><?php echo $row[3] ?></td>                
                </tr>
        <?php $i++; } ?>

                <input type="hidden" name="option" value="<?php echo $option; ?>" />
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="0" />
            </table>
        </form>
    <?php
    }
    static function refetchBoosks($option, $rows, &$wslist) {
        global $my, $mosConfig_live_site, $mainframe, $doc; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
    ?>

        <form id="adminForm" action="index.php?option=com_booklibrary" method="post" name="adminForm">

            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                   class="adminlist bl_admin_refetch_information my_table">
                <tr>
                    <td  colspan="6"><?php echo _BOOKLIBRARY_REFETCH; ?></td>
                </tr>
                <tr>
                    <td  colspan="6">
                        <strong><?php echo _BOOKLIBRARY_LABEL_INFO_FETCH; ?></strong>
                        <?php echo $wslist; ?>
                        &nbsp;&nbsp;&nbsp;
                        <img src="../components/com_booklibrary/images/amazon/com-logo.gif" 
                             alt="amazon.com" border="0" />
                    </td>
                </tr>
                <tr>
                    <th  class="title" width="20">
                        <input type="checkbox" name="toggle" value="" checked="checked" 
                               onClick="Joomla.checkAll(this<?php // echo count( $rows );?>);" />
                    </th>
                    <th align = "center" class="title" width="30">id</th>
                    <th  align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_BOOKID; ?></th>
                    <th align = "center" class="title" width="30%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_ISBN; ?></th>
                    <th align = "center" class="title" width="30%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE; ?></th>
                    <th align = "center" class="title" width="25%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_FETCHED_FROM; ?></th>
                </tr>

    <?php
        $i = 0;
        while ($i < count($rows)) {
            $row = $rows[$i];
    ?>
                    <tr class="row<?php echo $i % 2; ?>">
                        <td align = "center">
                            <input type="checkbox" checked="checked" id="cb<?php echo $i; ?>" 
                                   name="bid[]" value="<?php echo $row->id; ?>" 
                                   onClick="isChecked(this.checked);" />
                        </td>
                        <td align = "center"><?php echo $row->id ?></td>
                        <td align = "center"><?php echo $row->bookid ?></td>
                        <td align = "center"><?php echo $row->isbn ?></td>
                        <td align = "left"><?php echo $row->title ?></td>
                        <td align = "center">
                            <?php echo mosBooklibraryWS::getWsNameById($row->informationFrom); ?>
                        </td>
                    </tr>
    <?php $i++; } ?>

                <input type="hidden" name="option" value="<?php echo $option; ?>" />
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="1" />
            </table>
        </form>
    <?php
    }
    static function showImportExportBooks($params, $option) {
        global $my, $mosConfig_live_site, $mainframe, $doc; 

        JHtml::_('behavior.formvalidator'); //iclude core.js
        
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' ><img 
                src='./components/com_booklibrary/images/cfg.png' 
                alt ='Config' /> " . _BOOKLIBRARY_ADMIN_IMPEXP . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
        <script language="javascript" type="text/javascript">
            function impch()
            {    
                var a = document.getElementById('import_type').value;
                if(a == 4){
                    document.getElementById('import_catid').disabled=true;
                }
                else{
                    document.getElementById('import_catid').disabled=false;
                }
            }
            function expch()
            {    
                var a = document.getElementById('export_type').value;
                if(a == 4)
                    document.getElementById('export_catid').disabled=true;
                else
                    document.getElementById('export_catid').disabled=false;
            }
            // function submitbutton(pressbutton) { 
             Joomla.submitbutton = function(pressbutton) {
        var form = document.adminForm;
        if (pressbutton == 'import') {
            if (form.import_type.value == '0') {
                alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR1; ?>" );
                return;
            }
            if (form.import_file.value == '' ) {
                alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR3; ?>");
                return;
            }
            if (form.import_catid.value == '0' && form.import_type.value != '4' && 
                    form.import_type.value != '0') {
                alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR2; ?>");
                return;
            }
            if (form.import_catid.value != '0' && form.import_file.value == '') {
                alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR3; ?>");
                return;
            }
            if ((form.import_type.value == '2') && (form.import_catid.value != '0' && 
                    form.import_file.value != '')) {
                alert("<?php echo _BOOKLIBRARY_SHOW_IMPEXP_ERR5; ?>");
                Joomla.submitform( pressbutton );
            }
            if ((form.import_type.value == '1') && (form.import_catid.value != '0' && 
                    form.import_file.value != '')) {
                Joomla.submitform( pressbutton );
            }
                                
            if (form.import_type.value == '4') {
                resultat_1 = confirm("<?php echo _BOOKLIBRARY_SHOW_IMPEXP_CONF; ?>");
                if (resultat_1) Joomla.submitform( pressbutton );
            }
        }
        if (pressbutton == 'export') {
            if (form.export_type.value == '0') {
                alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR4; ?>");
                return;
            }
            if (form.export_type.value == '1') {
                Joomla.submitform( pressbutton );
            }
            if (form.export_type.value == '2') {
                Joomla.submitform( pressbutton );
            }
            if (form.export_type.value == '4') {
                Joomla.submitform( pressbutton );
            }
        } }
        </script>

        <form class="bl_admin_import_export_form" id="adminForm" action="index.php?option=com_booklibrary" method="post" 
              name="adminForm" enctype="multipart/form-data">
    <?php
            $options = Array();
            echo JHtml::_('bootstrap.startTabSet', 'addBook', array('active' => 'panel_1_addBook'));
            echo JHtml::_('bootstrap.addTab', 'addBook', 'panel_1_addBook', _BOOKLIBRARY_ADMIN_IMP);
    ?>

            <table class="adminform bl_admin_import_export_import_table my_table" width="100%">
                <!--*******************************************************************************-->
                <!--**   begin add Warning in 'Import' for 'CSV', 'XML', 'MySQL tables import'   **-->
                <!--*******************************************************************************-->
                <tr>
                    <td colspan="3">
                        <?php echo _BOOKLIBRARY_SHOW_IMPORT_WARNING_MESSAG; ?>
                        <hr />
                    </td>        
                </tr>
                <!--*****************************************************************************-->
                <!--**   end add Warning in 'Import' for 'CSV', 'XML', 'MySQL tables import'   **-->
                <!--*****************************************************************************-->
                <tr>
                    <td><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_IMPORT_TYP; ?>:</td> <!-- Typ importu -->
                    <td class="width_mostooltip" width="5%">
                        <?php 
                        echo mosToolTip(
                        _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_TYP_TT_HEAD, '', JURI::root() . 
                        '/components/com_booklibrary/images/circle-info.png');?>
                    </td>
                    <td><?php echo $params['import']['type']; ?></td>
                </tr>
                <tr>
                    <td width="5%"><?php 
                        echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_IMPORT_CATEGORY; ?>:</td> <!-- Kategoria -->
                    <td class="width_mostooltip" width="5%">
                        <?php 
                        echo mosToolTip(
                        _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_CAT_TT_HEAD, '', JURI::root() . 
                        '/components/com_booklibrary/images/circle-info.png');?>
                    </td>
                    <td width="50%"><?php echo $params['import']['category']; ?></td>         
                </tr>      
                <tr>
                    <td><?php 
                        echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_IMPORT_FILE; ?>:</td>   <!-- Plik do importu -->      
                    <td class="width_mostooltip" width="20">
                    <?php 
                    echo mosToolTip(
                    _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_FILE_TT_HEAD, '', JURI::root() . 
                    '/components/com_booklibrary/images/circle-info.png');?>
                    </td>
                    <td><input class="inputbox" type="file" name="import_file" value="" 
                               size="30" maxlength="250" /></td>         
                </tr>
                <tr>
                    <td colspan="3">&nbsp;</td>
                </tr>
                <!-- begin old poka ostavim
                <tr>
                    <td width="185">&nbsp;</td>
                    <td width="20">&nbsp;</td>
                    <td>
                            <?php //echo _BOOKLIBRARY_SHOW_IMPEXP_FORMAT; ?>
                    </td>
                </tr>
                end old poka ostavim -->
            </table>

    <?php
            echo JHtml::_('bootstrap.endTab');
            echo JHtml::_('bootstrap.addTab', 'addBook', 'panel_2_addBook', _BOOKLIBRARY_ADMIN_EXP);
    ?>

            <table class="adminform bl_admin_import_export_export_table my_table" width="100%">
                <!--*******************************************************************************-->
                <!--**   begin add Warning in 'Export' for 'CSV', 'XML', 'MySQL tables import'   **-->
                <!--*******************************************************************************-->
                <tr>
                    <td colspan="3">
                        <?php echo _BOOKLIBRARY_SHOW_EXPORT_WARNING_MESSAG; ?>
                        <hr />
                    </td>        
                </tr>
                <!--*****************************************************************************-->
                <!--**   end add Warning in 'Export' for 'CSV', 'XML', 'MySQL tables import'   **-->
                <!--*****************************************************************************-->
                <tr>
                    <td width="5%"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_EXPORT_TYP; ?>:</td>
                    <td width="5%" style="text-align:left;">
                        <?php 
                        echo mosToolTip(
                        _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_EXPORT_TYP, '', JURI::root() . 
                        '/components/com_booklibrary/images/circle-info.png');?>
                    </td>
                    <td width="50%"><?php echo $params['export']['type']; ?></td>
                </tr>
                <tr>
                    <td><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_EXPORT_CATEGORY; ?>:</td>
                    <td><?php 
                        echo mosToolTip(
                        _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_EXPORT_CAT_TT_HEAD, '', JURI::root() . 
                        '/components/com_booklibrary/images/circle-info.png');?>
                    </td>
                    <td><?php echo $params['export']['category']; ?></td>         
                </tr>
                <tr>
                    <td colspan="3">&nbsp;</td>
                </tr>
            </table>

    <?php
            echo JHtml::_('bootstrap.endTab');
            echo JHtml::_('bootstrap.endTabSet');
    ?>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="" />
        </form>

    <?php
    }
    static function showLendBooks($option, $books, $rows, &$userlist, $type) {
        global $my, $mosConfig_live_site, $mainframe, $doc, $app;
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        switch ($type) {
            case 'lend':
                $a = _BOOKLIBRARY_SHOW_LEND_BOOKS;
            break;
            case 'lend_return':
                $a = _BOOKLIBRARY_SHOW_LEND_RETURN;
            break;
            case 'edit_lend':
                $a = _BOOKLIBRARY_SHOW_LEND_EDIT;
            break;
            default:
                $a = "&nbsp;";
            break;
        }
        $html = "<div class='book_manager_caption' >
                <img src='./components/com_booklibrary/images/cfg.png' alt ='Config' /> " . $a . 
                "</div>";
        $app->JComponentTitle = $html;
    ?>
        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">
            
     <?php if ($type == "lend" or $type == "edit_lend") { ?>
            <table class="bl_admin_lent-top_table my_table" cellpadding="4" cellspacing="0" 
                 border="0" width="100%">
                <tr>
                    <td align="center" nowrap="nowrap" width="10%">
                        <label><?php echo _BOOKLIBRARY_LABEL_LEND_TO . ':'; ?></label>
                    </td>
                    <td align="center" nowrap="nowrap" width="35%">
                        <?php echo $userlist; ?>
                    </td>
                </tr>
                <tr>
                    <td align="center" nowrap="nowrap" width="10%">
                        <label><?php echo _BOOKLIBRARY_LABEL_LEND_USER . ':'; ?></label>
                    </td>
                    <td colspan="2" width="35%">  
                        <input type="text" name="user_name" class="inputbox" />
                    </td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap">
                        <label><?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL . ':'; ?></label>
                    </td>
                    <td colspan="4">    
                        <input type="text" name="user_email" class="inputbox" />
                    </td>
                </tr>
                <tr>        
                    <td align="left" nowrap="nowrap">
                        <label><?php echo "lend from:"; ?></label>
                    </td>
                    <td align="left" nowrap="nowrap">
                        <?php echo JHtml::_('calendar', date("Y-m-d"), 'lend_from', 
                            'lend_from', '%Y-%m-%d'); ?>
                    </td>
                    <td align="left" nowrap="nowrap">
                        <label><?php echo _BOOKLIBRARY_LABEL_LEND_TIME . ':'; ?></label>
                    </td>
                    <td align="left" nowrap="nowrap" colspan="2">
                        <?php echo JHtml::_('calendar', date("Y-m-d"), 'lend_until', 
                            'lend_until', '%Y-%m-%d'); ?>
                    </td>
                </tr>       
            </table>

    <?php } else { ?>

                &nbsp;
    <?php } ?>

            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                   class="adminlist bl_admin_lent-bottom_table my_table">
                <tr>
                    <th width="20" align="center">
    <?php if ($type != 'lend') {?> 
                        <input type="checkbox" name="toggle" value="" 
                               onClick="Joomla.checkAll(this);" />

    <?php } ?> 
                    </th>

                    <th align = "center" width="30">#</th>
                    <th align = "center" class="title" width="5%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_BOOKID; ?></th>
                    <th align = "center" class="title" width="5%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_ISBN; ?></th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE; ?></th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_FROM; ?></th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL; ?></th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_RETURN; ?></th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_TO; ?></th>
                </tr>
                
                <tr>
    <?php if ($type == "lend") { ?>
                        <td align="center">  <input class="inputbox"  type="checkbox"  
                            name="checkbook" id="checkbook" size="0" maxlength="0" value="on" />
                        </td>
                 <?php
        } else if ($type == "edit_lend") { ?>
                  <td align="center">
                    <input type="hidden"  name="checkbook" id="checkbook" value="on" />
                  </td>
    <?php
        }
        $assoc_title = '';
        for ($t = 0, $z = count($rows);$t < $z;$t++) {
            if ($rows[$t]->id != $books->id) $assoc_title.= " " . $rows[$t]->title;
        }
        ?>
        <td align="center"> <?php echo $books->id; ?> </td>

                    <td align="center"> <?php echo $books->bookid; ?> </td>
                    <td align="center"> <?php echo $books->isbn; ?> </td>
                    <td align="center"> <?php 

                    if(!empty($assoc_title)) echo $books->title. '(' . $assoc_title . ')';
                    else echo $books->title; ?>
                     
                     </td>
                    
                    <td align="center"></td>
                    <td align="center"></td>
                    <td align="center"></td>
                    <td align="center"></td>
                    </tr>
       <?php 
        print_r("<tr>
                  <td align=\"center\">--</td>
                  <td align=\"center\">--</td>
                  <td align=\"center\">-------</td>
                  <td align=\"center\">" . "-----------" . "</td>
                  <td align=\"center\">" . "-----------------" . "</td>
                  <td align=\"center\">" . " -------------" . "</td>
                  <td align=\"center\">" . " ---------" . "</td>
                  <td align=\"center\">" . " ---------------------" . "</td>
                  <td align=\"center\">" . "------------------" . "</td> 
                  </tr>");
        for ($j = 0, $n = count($rows);$j < $n;$j++) {
            $row = $rows[$j];
    ?>
                    <input class="inputbox" type="hidden"  name="bookid" id="bookid" size="0" 
                           maxlength="0" value="<?php echo $books->bookid; ?>" />
                    <input class="inputbox"  type="hidden"  name="id" id="id" size="0" 
                           maxlength="0" value="<?php echo $row->id; ?>" />
                    <input class="inputbox"  type="hidden"  name="id2" id="id2" size="0" 
                           maxlength="0" value="<?php echo $row->id; ?>" />
    <?php
            $data = JFactory::getDBO();
            $query = "SELECT * 
                      FROM #__booklibrary_lend 
                      WHERE fk_bookid=" . $row->id . " 
                      ORDER BY lend_return ";
            $data->setQuery($query);
            $alllend = $data->loadObjectList();
            if (!empty($alllend)) {
                for ($i = 0; $i < count($alllend); $i++) {

                    $cutfrom = explode(' ', $alllend[$i]->lend_from);
                    $cutuntil = explode(' ', $alllend[$i]->lend_until);

                    $alllend[$i]->lend_from = $cutfrom[0];
                    $alllend[$i]->lend_until = $cutuntil[0];
                }   
            }
            $num = 1;
            for ($i = 0, $n2 = count($alllend);$i < $n2;$i++) {
                if (!isset($alllend[$i]->lend_return) && $type != "lend") {
    ?>
                         <td align="center"><input type="checkbox"  id="cb<?php echo $i; ?>" name="bid[]" 
                             value="<?php echo $alllend[$i]->id; ?>" 
                             onClick="isChecked(this.checked);" /></td>
    <?php } else { ?>
                                <td align="center"></td>
    <?php
                }
                print_r("
                <td align=\"center\">" . $num . "</td>
                <td align=\"center\">" . $row->bookid . "</td>
                <td align=\"center\">" . $row->isbn . "</td>
                <td align=\"center\">" . $row->title . "</td>
                <td align=\"center\">" . $alllend[$i]->lend_from . "</td>
                <td align=\"center\">" . $alllend[$i]->lend_until . "</td>      
                <td align=\"center\">" . $alllend[$i]->lend_return . "</td>     
                <td align=\"center\">" . $alllend[$i]->user_name . ":  " . 
                    $alllend[$i]->user_email . "</td> </tr>");
                $num++;
            }
    ?>

    <?php } ?>

            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="boxchecked" value="1" />
            <input type="hidden" name="save" value="1" />
        </form>
    <?php
    }
    static function editLendBooks($option, $books, $rows, $title_assoc, &$userlist, 
                                  &$all_assosiate_lend, $type) {
        global $my, $mosConfig_live_site, $mainframe, $doc, $app;

        os_hide_left_panel();

        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        switch ($type) {
            case 'lend':
                $a = _BOOKLIBRARY_SHOW_LEND_BOOKS;
            break;
            case 'lend_return':
                $a = _BOOKLIBRARY_SHOW_LEND_RETURN;
            break;
            case 'edit_lend':
                $a = _BOOKLIBRARY_SHOW_LEND_EDIT;
            break;
            default:
                $a = "&nbsp;";
            break;
        }
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' 
                alt ='Config' /> " . $a . "</div>";
        $app->JComponentTitle = $html;
    ?>
        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">
            
     <?php if ($type == "lend" or $type == "edit_lend") { ?>
                <table class="bl_admin_lent-top_table my_table" cellpadding="4" cellspacing="0" 
                       border="0" width="100%">
                    <tr>
                        <td align="center" nowrap="nowrap" width="10%">
                            <label><?php echo _BOOKLIBRARY_LABEL_LEND_TO . ':'; ?></label>
                        </td>
                        <td align="center" nowrap="nowrap" width="35%">
                            <?php echo $userlist; ?>
                        </td>
                    </tr>
                    <tr>
                        <td align="center" nowrap="nowrap" width="10%">
                            <label><?php echo _BOOKLIBRARY_LABEL_LEND_USER . ':'; ?></label>
                        </td>
                        <td colspan="2" width="35%">  
                            <input type="text" name="user_name" class="inputbox" />
                        </td>
                    </tr>
                    <tr>
                        <td align="left" nowrap="nowrap">
                            <label><?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL . ':'; ?></label>
                        </td>
                        <td colspan="4">    
                            <input type="text" name="user_email" class="inputbox" />
                        </td>
                    </tr>
                    <tr>        
                        <td align="left" nowrap="nowrap">
                            <label><?php echo "lend from:"; ?></label>
                        </td>
                        <td align="left" nowrap="nowrap">
                            <?php echo JHtml::_('calendar', date("Y-m-d"), 'lend_from', 
                                'lend_from', '%Y-%m-%d'); ?>
                        </td>
                        <td align="left" nowrap="nowrap">
                            <label><?php echo _BOOKLIBRARY_LABEL_LEND_TIME . ':'; ?></label>
                        </td>
                        <td align="left" nowrap="nowrap" colspan="2">
                                    <?php echo JHtml::_('calendar', date("Y-m-d"), 'lend_until', 
                                        'lend_until', '%Y-%m-%d'); ?>
                        </td>
                    </tr>       
                </table>

    <?php } else { ?>

                &nbsp;

    <?php } ?>

            <table cellpadding="4" cellspacing="0" border="0" width="100%" 
                  class="adminlist bl_admin_lent-bottom_table my_table">
                <tr>
                    <th width="20" align="center">
    <?php if ($type != 'lend') {?> 
                        <input type="checkbox" name="toggle" value="" 
                               onClick="Joomla.checkAll(this);" />
    <?php } ?> </th>

                    <th align = "center" width="30">#</th>
                    <th align = "center" class="title" width="5%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_BOOKID; ?></th>
                    <th align = "center" class="title" width="5%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_ISBN; ?></th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_TITLE; ?></th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_FROM; ?></th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL; ?></th>
                    <th align = "center" class="title" width="20%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_RETURN; ?></th>
                    <th align = "center" class="title" width="15%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LEND_TO; ?></th>
                </tr>

    <?php if ($type == "edit_lend") { ?>

                        <input type="hidden"  name="checkHouse" id="checkHouse" value="on" /></td>
    <?php
        }
        $assoc_title = '';
        //                  var_dump($title_assoc);
        //                  exit();
        //
        for ($t = 0, $z = count($title_assoc);$t < $z;$t++) {
            if ($title_assoc[$t]->id != $books->id) $assoc_title.= " " . $title_assoc[$t]->title;
        }
        //show rent history what we may change
        
    ?>
                                &nbsp;
                        <input class="inputbox" type="hidden"  name="bookid" id="bookid" size="0" 
                               maxlength="0" value="<?php echo $books->bookid; ?>" />
                        <input class="inputbox"  type="hidden"  name="id" id="id" size="0" 
                               maxlength="0" value="<?php echo $books->id; ?>" />
                        <input class="inputbox"  type="hidden"  name="id2" id="id2" size="0" 
                               maxlength="0" value="<?php echo $books->id; ?>" />   
    <?php
        $num = 1;
        for ($i = 0, $n2 = count($all_assosiate_lend[0]);$i < $n2;$i++) {
            $assoc_lend_ids = '';
            for ($j = 0, $n3 = count($all_assosiate_lend);$j < $n3;$j++) {
                if ($assoc_lend_ids != "") $assoc_lend_ids.= "," . $all_assosiate_lend[$j][$i]->id;
                else $assoc_lend_ids = $all_assosiate_lend[$j][$i]->id;
            }
    ?>
                    <td align="center"><input type="checkbox"  id="cb<?php echo $i; ?>" 
                        name="bid[]" value="<?php echo $assoc_lend_ids; ?>" 
                        onClick="isChecked(this.checked);" /></td>
                    <td align="center"> <?php echo $num; ?> </td>

                    <td align="center"> <?php echo $books->bookid; ?> </td>
                    <td align="center"> <?php echo $books->isbn; ?> </td>
                    <td align="center"> <?php 

                    if(!empty($assoc_title)) echo $books->title . '(' . $assoc_title . ')';
                    else echo $books->title; ?>
                     
                     </td>
                    
                    <td align="center"> <?php if (isset($all_assosiate_lend[0][$i]->lend_from ))
                                                    echo $all_assosiate_lend[0][$i]->lend_from; ?> </td>
                    <td align="center"> <?php if (isset($all_assosiate_lend[0][$i]->lend_until ))
                                                    echo $all_assosiate_lend[0][$i]->lend_until; ?> </td>
                    <td align="center"> <?php if (isset($all_assosiate_lend[0][$i]->lend_return ))
                                                    echo $all_assosiate_lend[0][$i]->lend_return; ?> </td>
                    <td align="center"> <?php echo $all_assosiate_lend[0][$i]->user_name . ': '. $all_assosiate_lend[0][$i]->user_email;  ?> </td></tr>
       <?php $num++; }
        print_r("
                    <td align=\"center\">--</td>
                    <td align=\"center\">--</td>
                    <td align=\"center\">-------</td>
                    <td align=\"center\">" . "------------" . "</td>
                    <td align=\"center\">" . "-----------------" . "</td>
                    <td align=\"center\">" . " -------------" . "</td>
                    <td align=\"center\">" . " ---------" . "</td>
                    <td align=\"center\">" . " ---------------------" . "</td>
                    <td align=\"center\">" . "------------------" . "</td> </tr>");
        //show rent history what we can't change
        for ($j = 0, $n = count($rows);$j < $n;$j++) {
            $row = $rows[$j];
            if ($row->lend_return == "" || $row->lend_return == '0000-00-00 00:00:00' ) continue;
            $num = 1;
    ?>
                        &nbsp;
                    </td>
                        <input class="inputbox" type="hidden"  name="bookid" id="bookid" size="0" 
                               maxlength="0" value="<?php echo $row->bookid; ?>" />
                        <input class="inputbox"  type="hidden"  name="id" id="id" size="0" 
                               maxlength="0" value="<?php echo $row->id; ?>" />
                        <input class="inputbox"  type="hidden"  name="id2" id="id2" size="0" 
                               maxlength="0" value="<?php echo $row->id; ?>" />
                    <td align="center">
                    </td>
    <?php
            print_r("
                <td align=\"center\">" . $num . "</td>
                <td align=\"center\">" . $row->bookid . "</td>
                <td align=\"center\">" . $row->isbn . "</td>
                <td align=\"center\">" . $row->title . "</td>
                <td align=\"center\">" . $row->lend_from . "</td>
                <td align=\"center\">" . $row->lend_until . "</td>      
                <td align=\"center\">" . $row->lend_return . "</td>     
                <td align=\"center\">" . $row->user_name . ":  " . $row->user_email . "</td> </tr>");
            $num++;
    ?>

    <?php } ?>

            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="boxchecked" value="1" />
            <input type="hidden" name="save" value="1" />
        </form>
    <?php
    }
    static function showConfiguration_frontend($lists, $option, $txt) {
        global $my, $mosConfig_live_site, $mainframe, $act, $task, $doc; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' 
                alt ='Config' /> " . _BOOKLIBRARY_ADMIN_CONFIG_FRONTEND . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>
        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
<script>
    window.onload=function()
    {
        if (document.getElementById('money_select').options[document.getElementById('money_select')
                .selectedIndex].value == 'other') { 
            document.getElementById('patt').type="text";
            document.getElementById('patt').removeAttribute('readonly');
        }
    }
    function set_pricetype(sel) {
        var value = sel.options[sel.selectedIndex].value;
        if (value=="space") {
            document.getElementById('patt').value="&nbsp;";
            document.getElementById('patt').setAttribute('readonly', true); 
            document.getElementById('patt').type="hidden";
        }
        else if (value!="other") {
            document.getElementById('patt').value=value;
            document.getElementById('patt').setAttribute('readonly', true); 
            document.getElementById('patt').type="hidden";
        } else
        {
            document.getElementById('patt').value="";
            document.getElementById('patt').type="text";
            document.getElementById('patt').removeAttribute('readonly');
        }
    }
</script>
        <h1><?php echo _BOOKLIBRARY_ADMIN_CONFIG_FRONTEND; ?></h1>


        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">

            <div class="my_tab_menu">

                <a href="#my_tab1">
                    <!--<input type="checkbox" id="point_tab1"/>
                    <label for="point_tab1">BookLibrary Page Settings</label>-->
                    BookLibrary Page Settings
                </a>

                <div>
                    <table class="adminform my_table bl_admin_settings_frontend_tabs_bl_page_settings" 
                           width="100%">
                        <!--***************   begin add send mail for admin   *****************-->
                        <!--************   end add send mail for admin   **********************-->
                        <h2>BookLibrary Page Settings</h2>
                        <tr>
                            <td width="22%"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_SHOW; ?>:</td>
                                <td width="7%"><?php 
                                    echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_SHOW_TT_BODY, '', 
                                    JURI::root() . '/components/com_booklibrary/images/circle-info.png');?>
                                </td>

                            <td width="22%"><?php echo $lists['reviews']['show']; ?></td>
                            <td width="22%"><?php 
                                echo _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_REGISTRATIONLEVEL; ?>:</td>         
                            <td width="7%"><?php 
                                echo mosToolTip( 
                                    _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_REGISTRATIONLEVEL_TT_BODY, '',
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td width="22%"><?php echo $lists['reviews']['registrationlevel']; ?></td>         
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>

                           
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_LENDSTATUS_SHOW; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_LENDSTATUS_SHOW_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['lendstatus']['show']; ?></td>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_LENDREQUEST_REGISTRATIONLEVEL; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_LENDREQUEST_REGISTRATIONLEVEL_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['lendrequest']['registrationlevel']; ?></td>         
                        </tr>

                        <!--************   begin add button 'buy now'   ******************-->
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_BUYNOW_SHOW; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_BUYNOW_SHOW_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                           <td><?php echo $lists['buy_now']['show']; ?></td>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_BUYNOW_REGISTRATIONLEVEL; ?></td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_BUYNOW_REGISTRATIONLEVEL_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['buy_now']['allow']['categories']; ?></td>
                        </tr>
                        <!--************   end add button 'buy now'   *********************-->
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>

                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_SHOW; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_SHOW_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['ebooks']['show']; ?></td>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_REGISTRATIONLEVEL; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_REGISTRATIONLEVEL_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['ebooks']['registrationlevel']; ?></td>
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_SEARCHFIELD_SHOW; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_SEARCHFIELD_SHOW_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['search_field']['show']; ?></td>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_SEARCHFIELD_REGISTRATIONLEVEL; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_SEARCHFIELD_REGISTRATIONLEVEL_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['search_field']['registrationlevel']; ?></td>
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_ADVSEARCH_SHOW; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_ADVSEARCH_SHOW_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['advsearch']['show']; ?></td>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_ADVSEARCH_REGISTRATIONLEVEL; ?>:</td>
                            <td><?php echo mosToolTip( 
                                _BOOKLIBRARY_ADMIN_CONFIG_ADVSEARCH_REGISTRATIONLEVEL_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['advsearch']['registrationlevel']; ?></td>
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <!--
                        //*************************************************************************
                        //                begin add FotoSize
                        //*************************************************************************
                        -->
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_FOTO_SIZE; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_FOTO_SIZE_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo ($lists['foto']['high']) . ($lists['foto']['width']); ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        
                        <tr>    
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_FOTO_AUTHOR_SIZE; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_FOTO_SIZE_TT_BODY_AUTHOR, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo ($lists['foto']['high_author']) . 
                                ($lists['foto']['width_author']); ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                            <!--
                            //*********************************************************************
                            //                end add FotoSize
                            //*********************************************************************
                            -->
                        <tr>     
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_DEFAULT_SORT; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_DEFAULT_SORT_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['category']['default_sort']; ?></td> 

                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>     
                            <td><?php echo _BOOKLIBRARY_ADD_META_MANUAL; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADD_META_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['show_metadata']; ?></td> 

                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>                        
                        <!--
                        //*************************************************************************
                        //                begin add PageItems
                        //*************************************************************************
                        -->
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_PAGE_ITEMS; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_PAGE_ITEMS_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['page']['items']; ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                       
                       <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_PAGE_ITEMS_AUTHORS; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_PAGE_ITEMS_TT_BODY_AUTHORS, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['page']['items_author']; ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        
                       <!--tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_SHOW_AUTHORS_PHOTO; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_SHOW_AUTHORS_PHOTO_DESC, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['author_photo']['show']; ?></td>
                            <td></td>
                            <td></td>
                        </tr-->
                        
                        
                            <!--*******    end add PageItems ************ -->
                            <!--********   begin add for show in category picture   **************-->
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_PICTURE_IN_CATEGORY; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_PICTURE_IN_CATEGORY_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['cat_pic']['show']; ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <!--***************   end add for show in category picture  *************-->
                        <!--********   begin add for show subcategory   **************-->
                        <tr>
                            <td colspan="6"><hr /></td>

                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_SUBCATEGORY_SHOW; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_SUBCATEGORY_SHOW_TT_BODY, '', 
                                JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['subcategory']['show']; ?></td>
                            <!--***************   end add for show subcategory *************-->
                            <!--********   begin add for view type   **************-->
                            <td>Single Category Layout:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_CONFIG_VIEW_TYPE_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['view_type']; ?></td>
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <tr>
                            <td>All Category Layout:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_CONFIG_VIEW_TYPE_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['all_categories']; ?></td>
                            <td>Search Layout:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_CONFIG_VIEW_TYPE_TT_BODY, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['search_lay']; ?></td>
                        </tr> 
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                                                <tr>
                            <td><h1>Price & Date Format Settings</h1></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                             <td><?php echo _BOOKLIBRARY_PRICE_FORMAT; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_PRICE_FORMAT_INFO, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['money_ditlimer'] ?></td>
                            <td>
                                <input id="patt" type="hidden" readonly="true" 
                                       value="<?php global $booklibrary_configuration;
                                       echo $booklibrary_configuration['price_format'] ?>" 
                                       name="patern" size="2">
                                    <?php echo _BOOKLIBRARY_PRICE_UNIT_SHOW; ?>:
                            </td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_PRICE_UNIT_SHOW_INFO, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['price_unit_show'] ?></td>
                        </tr>
                        <tr>
                            <td colspan="6"></td>
                        </tr>
                        <tr>
                            <td><?php echo _BOOKLIBRARY_DATE_TIME_FORMAT; ?>:</td>
                            <td><?php echo mosToolTip(
                                _BOOKLIBRARY_DATE_FORMAT, '', JURI::root() . 
                                '/components/com_booklibrary/images/circle-info.png');?>
                            </td>
                            <td><?php echo $lists['date_format'] ?> </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <!--<td><?php 
                            // echo mosToolTip(_BOOKLIBRARY_TIME_FORMAT, _BOOKLIBRARY_TIME);?></td>
                            <td><?php // echo $lists['datetime_format']?></td> -->
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="6"><hr /></td>
                        </tr>
                        <td colspan="6">
                            <h1>Format File Settings</h1>
                        </td>
                      <tr>
                            <td colspan="2"><?php echo _BOOKLIBRARY_ALLOWED_EXTS; ?>:</td>
                            <td><?php echo $lists['allowed_exts']; ?></td>
                            <td colspan="2" style="text-align:right"><?php echo _BOOKLIBRARY_ALLOWED_EXTS_IMG; ?>:</td>
                            <td><?php echo $lists['allowed_exts_img']; ?></td> 
                       </tr>
                       <tr>
                            <td colspan="2"><?php echo _BOOKLIBRARY_ALLOWED_EXTS_VIDEO; ?>:</td>
                            <td><?php echo $lists['allowed_exts_video']; ?></td>
                            <td colspan="2" style="text-align:right"><?php echo _BOOKLIBRARY_ALLOWED_EXTS_AUDIO; ?>:</td>
                            <td><?php echo $lists['allowed_exts_audio']; ?></td> 
                       </tr>
                       <tr>
                            <td colspan="2"><?php echo _BOOKLIBRARY_ALLOWED_EXTS_TRACK; ?>:</td>
                            <td><?php echo $lists['allowed_exts_track']; ?></td>
                        </tr>
                        <tr> 
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <!--***************   end add for show subcategory *************-->

                    </table>
                </div>
                <div></div>
            </div>

            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="config_save_frontend" />
        </form>

    <?php
    }
    static function showConfiguration_backend($lists, $option) {
        global $mosConfig_live_site, $act, $task, $mainframe, $doc; 
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='Config' /> " .
            _BOOKLIBRARY_ADMIN_CONFIG_BACKEND . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

    <h1><?php echo _BOOKLIBRARY_ADMIN_CONFIG_BACKEND; ?></h1>

        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>

        <form class="bl_admin_settings_backend_form_with_accordion" action="index.php?option=com_booklibrary" 
              method="post" name="adminForm" id="adminForm" 
              enctype="multipart/form-data">
            <ul class="my_accordion_menu">
                <li>
                    <input type="radio" name="odin" id="vkl7"/>
                    <label for="vkl7"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_SETTINGS_NAME_MEDIA_FILES; ?></label>
                    <div>
                        <table class="adminform bl_admin_settings_backend my_table" width="100%">
                            <tr>
                                <td colspan="6">
                                    <h2><?php echo _BOOKLIBRARY_ADMIN_CONFIG_SETTINGS_NAME_MEDIA_FILES; ?></h2>
                                </td>
                            </tr>
                            
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD; ?>:</td>
                                <td><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_TT_BODY, 
                                    '', JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['fetchImages']['boolean']; ?></td>
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_LOCATION; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_LOCATION_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['fetchImages']['location']; ?></td>
                            </tr>
                            <tr>
                                <td colspan="6"><hr /></td>
                            </tr>
                            
                            
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_TT_BODY, '',
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['ebooks']['allow']; ?></td>
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_LOCATION; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_LOCATION_TT_BODY, 
                                    '', JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['ebooks']['location']; ?></td>
                            </tr>
                           <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_VIDEO_TRACK_DOWNLOAD; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_VIDEO_DOWNLOAD_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['videos_tracks']['allow']; ?></td>
                                
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_VIDEOS_DOWNLOAD_LOCATION; ?>:</td>
                                    <td><?php echo mosToolTip(
                                        _BOOKLIBRARY_ADMIN_CONFIG_VIDEOS_DOWNLOAD_LOCATION_TT_BODY, '', 
                                        JURI::root() . 
                                        '/components/com_booklibrary/images/circle-info.png');?>
                                    </td>
                                <td><?php echo $lists['videos']['location']; ?></td>
                            </tr>
                            
                            <tr>
                                <td></td>
                                <td><?php //echo mosToolTip(
                                   /* _BOOKLIBRARY_ADMIN_CONFIG_VIDEO_DOWNLOAD_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td> */ ?>
                                <td><?php //echo $lists['ebooks']['allow'] ; ?></td>
                                
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_TRACKS_DOWNLOAD_LOCATION; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_TRACKS_DOWNLOAD_LOCATION_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['tracks']['location']; ?></td>
                            </tr>
                                       
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_AUDIO_DOWNLOAD; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_AUDIO_DOWNLOAD_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['audios']['allow']; ?></td>
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_AUDIOS_DOWNLOAD_LOCATION; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_AUDIOS_DOWNLOAD_LOCATION_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['audios']['location']; ?></td>
                            </tr>
                            <!-- start Online Read book from Article -->
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_ONLINE_BOOK_FROM_ARTICLE; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_ONLINE_BOOK_FROM_ARTICLE_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['online_book_from_article']['allow']; ?></td>
                            </tr>
                            <!-- end Online Read book from Article -->
                                                        
                            <!-- start Online read book flip -->
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_ONLINE_BOOK_FLIP; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_ONLINE_BOOK_FLIP_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['online_book_flip']['allow']; ?></td>
                            </tr>
                            <!-- end Online read book flip -->
                            
                        </table>
                    </div>
                </li>
                <li>
                    <input type="radio" name="odin" id="vkl8"/>
                    <label for="vkl8">Amazon Settings</label>
                    <div>
                        <table class="adminform bl_admin_settings_backend my_table" width="100%">
                            <tr>
                                <td colspan="6">
                                    <h2>Amazon Settings</h2>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_TAG; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_TAG_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['ws']['amazon']['tag']; ?></td>
                                <td colspan="3"></td>
                            </tr>
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_DEVTAG; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_DEVTAG_TT_BODY, '',
                                     JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['ws']['amazon']['devtag']; ?></td>
                                <td colspan="3"></td>
                            </tr>
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_SECRET_KEY; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_SECRET_KEY_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['ws']['amazon']['secret_key']; ?></td>
                                <td colspan="3"></td>
                            </tr>
                            <td colspan="3"></td>
                            </tr>
                        </table>
                    </div>
                </li>

                <li>
                    <input type="radio" name="odin" id="vkl10"/>
                    <label for="vkl10">Common Settings</label>
                    <div>
                        <table class="adminform bl_admin_settings_backend my_table" width="100%">
                            <tr>
                                <td colspan="6">
                                    <h2>Common Settings</h2>
                                </td>
                            </tr>
                            <tr>
                                <td ><?php 
                                    echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_CHECK_ISBN; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_CHECK_ISBN_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['editbook']['check']['isbn']; ?></td>
                                <td colspan="3"></td>

                            </tr>
                            
                            <!--tr>
                                <td><?php echo _BOOKLIBRARY_LENDREQUEST_ADMIN_ACCEPT_DECLINE; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_LENDREQUEST_ADMIN_ACCEPT_DECLINE_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['lendrequest_admin_decline_accept']; ?></td>
                                <td colspan="3"></td>
                            </tr-->
                            
                            
                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_BOOKID_AUTO_INCREMENT; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_BOOKID_AUTO_INCREMENT_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['bookid']['auto-increment']['boolean']; ?></td>
                                <td colspan="3"></td>
                            </tr>

                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_MERGE_USE; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_MERGE_USE_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['merge_description']['use']; ?></td>
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_MERGE_REGISTRATIONLEVEL; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_DESCRIPTION_MERGE_REGISTRATIONLEVEL_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['merge_description']['registrationlevel']; ?>
                                </td>
                            </tr>

                            <tr>
                                <td><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_DEFAULT_LANG; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_DEFAULT_LANG_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['editbook']['default']['lang']; ?></td>
                                <td colspan="3"></td>
                            </tr>
                            <tr>
                                <td style="text-align:right;">
                                    <?php echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_DEFAULT_HOST; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_DEFAULT_HOST_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['editbook']['default']['host']; ?></td>
                                <td colspan="3"></td>
                            </tr>
                            <!--YAZ-->
                            <!--tr>
                            <td colspan="3">
                            <hr />
                            </td>
                            </tr>
                            <tr>
                            <td width="185"><?php 
                                echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_PROXYSERVER; ?>:</td>
                            <td width="20"><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_PROXYSERVER__TT_BODY); ?></td>
                            <td><?php echo $lists['proxy_server']['address']; ?></td>
                            </tr>       
                            <tr>
                            <td width="185"><?php 
                                echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_PORT_PROXYSERVER; ?>:</td>
                            <td width="20"><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_PORT_PROXYSERVER__TT_BODY); ?></td>
                            <td><?php echo $lists['port_proxy_server']['address']; ?></td>
                            </tr>      
                            <tr>
                            <td width="185"><?php 
                                echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_LOGIN_PROXYSERVER; ?>:</td>
                            <td width="20"><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_LOGIN_PROXYSERVER__TT_BODY); ?></td>
                            <td><?php echo $lists['login_proxy_server']['address']; ?></td>
                            </tr>
                            <tr>
                            <td width="185"><?php 
                                echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_PASSWORD_PROXYSERVER; ?>:</td>
                            <td width="20"><?php echo mosToolTip(
                                _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_PASSWORD_PROXYSERVER__TT_BODY); ?></td>
                            <td><?php echo $lists['password_proxy_server']['address']; ?></td>
                            </tr-->

                          
                            <!--tr>
                                <td style="text-align:right;"><?php 
                                    echo _BOOKLIBRARY_ADMIN_CONFIG_UPDATE; ?>:</td>
                                <td><?php echo mosToolTip(
                                    _BOOKLIBRARY_ADMIN_CONFIG_UPDATE_TT_BODY, '', 
                                    JURI::root() . 
                                    '/components/com_booklibrary/images/circle-info.png');?>
                                </td>
                                <td><?php echo $lists['update']; ?></td>
                                <td colspan="3"></td>
                            </tr--> 
                            
                        </table>
                    </div>
                </li>


            </ul>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="config_save_backend" />
        </form>
    <?php
    }
    static function about() {
        global $mosConfig_live_site, $mainframe, $doc;
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='Config' /> " . 
            _BOOKLIBRARY_ADMIN_ABOUT . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>

        <form class="bl_admin_about" action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">
    <?php
        $options = Array();
        echo JHtml::_('bootstrap.startTabSet', 'aboutPane', array('active' => 'panel_1_id'));
        echo JHtml::_('bootstrap.addTab', 'aboutPane', 'panel_1_id', _BOOKLIBRARY_ADMIN_ABOUT_ABOUT);
    ?>

            <table class="adminform bl_admin_about_tab_about my_table">
                <tr>
                    <td width="80%">
                        <h3><?PHP echo _BOOKLIBRARY__HTML_ABOUT; ?></h3>
        <?PHP echo _BOOKLIBRARY__HTML_ABOUT_INTRO; ?>
                    </td>
                    <td width="20%">
                        <img src="../components/com_booklibrary/images/book.png" 
                             align="right" alt="Book" />
                    </td>             
                </tr>
            </table>

    <?php
        echo JHtml::_('bootstrap.endTab');
        echo JHtml::_('bootstrap.addTab', 'aboutPane', 'panel_2_id', _BOOKLIBRARY_ADMIN_ABOUT_RELEASENOTE);
            include_once ("./components/com_booklibrary/doc/releasenote.php");
        echo JHtml::_('bootstrap.endTab');
        echo JHtml::_('bootstrap.addTab', 'aboutPane', 'panel_3_id', _BOOKLIBRARY_ADMIN_ABOUT_CHANGELOG);
            include_once ("./components/com_booklibrary/doc/changelog.html");
        echo JHtml::_('bootstrap.endTab');
        echo JHtml::_('bootstrap.endTabSet');
        //***************************
        
    ?>
        </form>

    <?php
    }
    static function showImportResult($table, $option) {
        global $my, $mosConfig_live_site, $mainframe, $doc; 
        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='Config' /> " . 
            _BOOKLIBRARY_ADMIN_IMPEXP . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">

            <table class="admin33" cellpadding='4' cellspacing='0' border='1' width='100%'>
                <tr>
                    <td>#</td>
                    <td><?php echo _BOOKLIBRARY_LABEL_BOOKID; ?></td>
                    <td><?php echo _BOOKLIBRARY_LABEL_ISBN; ?></td>
                    <td><?php echo _BOOKLIBRARY_LABEL_TITLE; ?></td>
                    <td><?php echo _BOOKLIBRARY_LABEL_AUTHORS; ?></td>
                    <td><?php echo _BOOKLIBRARY_LABEL_MANUFACTURER; ?></td>
                    <td><?php echo _BOOKLIBRARY_LABEL_STATUS; ?></td>
                </tr>

                    <?php foreach($table as $entry) { ?>
                    <tr>
                        <td><?php echo $entry[0]; ?></td>
                        <td><?php echo $entry[1]; ?></td>
                        <td><?php echo $entry[2]; ?></td>
                        <td><?php echo $entry[3]; ?></td>
                        <td><?php echo $entry[4]; ?></td>
                        <td><?php echo $entry[5]; ?></td>
                        <td><?php echo $entry[6]; ?></td>
                    </tr>

    <?php } ?>

            </table>
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="cancel" />
        </form>    

    <?php
    }
    static function showExportResult($InformationArray, $option) {
        $html = "<div class='book_manager_caption' ><img 
                src='./components/com_booklibrary/images/cfg.png' alt ='Config' /> " . 
                _BOOKLIBRARY_SHOW_IMPEXP_RESULT . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>

        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">
            <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
        <?php echo _BOOKLIBRARY_SHOW_IMPEXP_RESULT_DOWNLOAD; ?>  <br />
            <a href="<?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?>" 
               target="blank">
            <?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?></a>
            <br />
        <?php echo _BOOKLIBRARY_SHOW_IMPEXP_RESULT_REMEMBER; ?>  <br />
            <input type="hidden" name="option" value="<?php echo $option; ?>" />
            <input type="hidden" name="task" value="cancel" />
        </form>    
    <?php
    }
    
    static function showLanguageManager($const_languages, $pageNav, $search) {
        global $my, $mosConfig_live_site, $mainframe, $templateDir;
        
        global $doc;
        $doc->addScript($mosConfig_live_site . 
            '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='book_manager_caption' ><img 
            src='./components/com_booklibrary/images/cfg.png' alt ='Config' /> " 
        . _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>
        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm">    

            <div class="wrapper-search-books wrapper-search-books-language-one adminlist adminlist_language ">
             <div class="wrapper-col-books wrapper-col-books-language">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible">
                    <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
                    <?php echo $pageNav->getLimitBox(); ?>
                </div>
                <div class="title">
                    <input class="loadLang" type="button" name="loadLang" 
                      value="Load languages" 
                      onclick="window.location.replace('index.php?option=com_booklibrary&section=language_manager&task=loadLang')"/>
                </div>
             </div>
            </div>
              
             <table cellpadding="4" cellspacing="0" border="0" width="80%" 
                   class="adminlist language_manager bl_admin_language_manager_table
                   my_table my_table_wd my_table-hover my_table-bordered">   
          
                <tr>
                    <th></th>
                    <th><?php echo _BOOKLIBRARY_SHOW_SEARCH; ?>&nbsp;<input type="text" placeholder="<?php
                     echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_CONST; ?>"
                      name="search_const" value="<?php echo $search['const']; ?>"
                       class="inputbox" onChange="document.adminForm.submit();" /></th>
                    <th><input type="text" placeholder="<?php
                     echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_VALUE_CONST; ?>"
                      name="search_const_value" value="<?php echo $search['const_value']; ?>"
                       class="inputbox" onChange="document.adminForm.submit();" /></th>
                    <th><?php echo $search['languages']; ?></th>
                    <th><?php echo $search['sys_type']; ?></th>
                </tr>                   
                <tr>
                    <th width="3%"></th>
                    <th align = "center" class="title" width="25%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_CONST; ?>
                    </th>
                    <th align = "center" class="title" width="25%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_VALUE_CONST; ?>
                    </th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
                        <?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?>
                    </th>
                    <th align = "center" class="title" width="10%" nowrap="nowrap">
        <?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_SYS_TYPE; ?>
                </tr>

        <?php $i = 0;
        foreach($const_languages as $const_language) {
        ?>
                    <tr>
                        <td align="center">
                            <?php echo mosHTML::idBox($i, $const_language->id, false, 'bid'); ?>
                        </td>
                        <td>
                            <a href="#edit" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit')">
                            <?php echo $const_language->const; ?>
                            </a>
                        </td>    
                        <td>
                            <a href="#edit" onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','edit')">
                            <?php echo $const_language->value_const; ?>
                            </a>
                        </td>
                        <td align="center">
                            <?php echo $const_language->title; ?>
                        </td>
                        <td align="center"><?php echo $const_language->sys_type; ?></td>
                    </tr>

            <?php $i++; } ?>

                <tr class="for_paginator">
                    <td colspan = "13"><?php echo $pageNav->getListFooter(); ?></td>
                </tr>
            </table>
            <input type="hidden" name="option" value="com_booklibrary" />
            <input type="hidden" name="section" value="language_manager" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" value="0" name="boxchecked">
        </form>
    <?php
    }
    
    static function editLanguageManager($row, $lists) {
        global $mosConfig_live_site;
        global $doc;

        os_hide_left_panel();

        $doc->addScript($mosConfig_live_site . '/components/com_booklibrary/includes/functions.js');
        $html = "<div class='booklibrary_caption' ><img 
            src='./components/com_booklbirary/images/building_icon.jpg' 
                alt ='Config' /> " . _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
    ?>    

        <form action="index.php?option=com_booklibrary" method="post" name="adminForm" id="adminForm" 
              enctype="multipart/form-data">

            <table width="100%" class="my_table bl_admin_language_manager_edit_constant">
                <tr>
                    <th colspan="2">
                <h1><?php echo $row->id ? _BOOKLIBRARY_HEADER_EDIT : _BOOKLIBRARY_HEADER_ADD; ?> 
        <?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_CONST; ?> 
                </h1>    
                </th>
                </tr>
                <tr>
                    <td width="10%">
                        <label><?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_CONST; ?>:</label>
                    </td>
                    <td colspan="2">
        <?php echo $lists['const']; ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_VALUE_CONST; ?>:</label>
                    </td>
                    <td colspan="2">
                        <textarea class="text_area" type="text" name="value_const">
                                <?php echo $row->value_const; ?></textarea>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_ADMIN_LANGUAGE_MANAGER_SYS_TYPE; ?>:</label>
                    </td>
                    <td colspan="2">
                        <?php echo $lists['sys_type']; ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label><?php echo _BOOKLIBRARY_LABEL_LANGUAGE; ?>:</label>
                    </td>
                    <td colspan="2">
                        <?php echo $lists['languages']; ?>
                    </td>
                </tr>
            </table>
            <input type="hidden" name="const" value="<?php echo $lists['const']; ?>"/>
            <input type="hidden" name="option" value="com_booklibrary" />
            <input type="hidden" name="section" value="language_manager" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
            <input type="hidden" name="sectionid" value="com_booklibrary" />
        </form>    

    <?php
    }


}
