<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
defined('_JEXEC') or die('Restricted access');

    class JFormFieldViewAuthorslayout extends JFormField {
        protected $type = 'authorslayout';
        protected function getInput() {
            $component_path = JPath::clean(JPATH_SITE . 
                '/components/com_booklibrary/views/all_authors/tmpl');
            $component_layouts = array();
            $options = array();
            if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
                    '^[^_]*\.php$', false, true))) {
                $options[] = JHtml::_('select.option', '', 'Use Global');
                foreach($component_layouts as $i => $file) {
                    $select_file_name = pathinfo($file);
                    $select_file_name = $select_file_name['filename'];
                    $options[] = JHtml::_('select.option', $select_file_name, $select_file_name);
                }
            }
            return JHtml::_('select.genericlist', $options, $this->name, 
                'class="inputbox form-select"', 'value', 'text', $this->value, $this->id);
        }
    }
