<?php
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');
/**
 *
 * @package simpleMembership
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Anton Getman(ljanton@mail.ru);
 * Homepage: http://www.ordasoft.com
 * @version: 7.0.0 FREE
 * @license GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007; see LICENSE.txt
 *
 */
use OrdaSoft\os_lib\os_libMain;
use OrdaSoft\os_lib\os_libPagination;

if( !class_exists("os_libMain") ){
    try{
        $ss = new os_libMain();
    }catch( Exception $e ){
        die("Please reinstall OrdaSoft Joomla Simplemembership Package!");
    }
} 

$GLOBALS['mainframe'] = $mainframe = JFactory::getApplication();
$GLOBALS['document'] = $document = JFactory::getDocument();
$GLOBALS['database'] = $database = JFactory::getDBO();
$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;


require_once ($mosConfig_absolute_path . "/components/com_simplemembership/compat.joomla1.5.php");

$conf = JFactory::getConfig();
$GLOBALS['mosConfig_mailfrom'] = $conf->get('mailfrom') ;
$mosConfig_live_site = $GLOBALS['mosConfig_live_site'] = substr( JURI::root(), 0, -1 ) ;

require_once ($mosConfig_absolute_path .
             "/administrator/components/com_simplemembership/admin.simplemembership.class.conf.php");
$GLOBALS['user_configuration'] = $user_configuration;

require_once ($mosConfig_absolute_path . '/components/com_simplemembership/openinviter/openinviter.php');
require_once ($mosConfig_absolute_path . "/components/com_simplemembership/captcha.php");
jimport('joomla.html.pagination');
jimport( 'joomla.filesystem.file' );


// load language
$lang_def_en = 0;
$lang = JFactory::getLanguage();
JFactory::getLanguage()->load('com_users', JPATH_SITE, $lang->getTag(), true); //add language for com_users

/** load the html drawing class */
// require_once($mainframe->getPath('front_html'));
// require_once($mainframe->getPath('class'));

require_once ($mosConfig_absolute_path .
             "/administrator/components/com_simplemembership/admin.simplemembership.class.others.php");
require_once ($mosConfig_absolute_path . "/components/com_simplemembership/functions.php");
require_once ($mosConfig_absolute_path . "/components/com_simplemembership/simplemembership.class.php");
require_once ($mosConfig_absolute_path . "/components/com_simplemembership/simplemembership.html.php");



//$mainframe->setPageTitle(  JText::_("COM_SIMPLEMEMBERSHIP_TITLE")  );
$doc = JFactory::getDocument();
$doc->addStyleSheet($mosConfig_live_site . '/components/com_simplemembership/includes/simplemembership.css');
if(checkJavaScriptIncludedSMS('jQuerOs-2.2.4.min.js') === false){
  $doc->addScript(JURI::base() . "/components/com_simplemembership/includes/jQuerOs-2.2.4.min.js");
  $doc->addScriptDeclaration("jQuerOs=jQuerOs.noConflict();");
}

$doc->addScript(JURI::base() . "/components/com_simplemembership/includes/simple-modal.js");

$jinput = JFactory::getApplication()->input;
$task = $jinput->getCmd('task', "");
$option = $jinput->getCmd('option', "com_simplemembership");


//$id = intval(mosGetParam($_REQUEST, 'id', 0));
$catid = intval(mosGetParam($_REQUEST, 'catid', 0));
$bids = mosGetParam($_REQUEST, 'bid', array(0));
//$uid = mosGetParam($_REQUEST, 'id', 0);
$GLOBALS['Itemid'] = $Itemid = trim(mosGetParam($_REQUEST, 'Itemid', ""));
$session = JFactory::getSession();
$userId = trim(mosGetParam($_REQUEST, 'userId', ""));
//add profile form
jimport('joomla.application.component.modelform');
//class Temp_class_for_profile_form extends JModelForm {


class UsersModelRegistration extends JModelForm {
  public function getForm($data = array(), $loadData = true) {
    // Get the form.
    $form = $this->loadForm('com_users.registration', 'registration',
                           array('control' => 'jform', 'load_data' => $loadData));
    if (empty($form)) {
      return false;
    }
    return $form;
  }
}
//add profile form


function josGetArrayIntsMy($name, $type = NULL) {
  $array = protectInjectionWithoutQuote($name, array(), 'default', 'array');
  return $array;
}

$cid = josGetArrayIntsMy('cid');
require_once ($mosConfig_absolute_path.'/components/com_simplemembership/syncexpire.php');
check_users();

if (isset($_REQUEST['view'])) 
  $view = mosGetParam($_REQUEST, 'view', '');
if ((!isset($task) OR $task == '') AND isset($view))
  $task = $view;

if ( (!isset($task) OR $task == '' ) && isset($Itemid) )  {
      $app = JFactory::getApplication();
      $menu = $app->getMenu();
      $menu_item = $menu->getItem($Itemid) ;
      if( isset($menu_item) ) $task = $view = $menu_item->query['view'] ;
}

 //print_r(":11111111111111111111111111:");print_r($task); exit;

switch ($task) {
  case 'before_end_notify':
    BeforeEndNotify($option);
    break;
  case 'getMail':
  //prolong user account
  case 'userprolong': 
    getMail();
    break;
  case 'buyLink':
    buyLink($option);
    break;
  case 'buyGroup':
    buyGroup();
    break;
  case 'advregister':
  case 'registration':
    if ($user_configuration['allow_registration'] != '0') {
        advregister();
    } else {
        mosRedirect(JURI::base(), JText::_("COM_SIMPLEMEMBERSHIP_REGISTRATION_FORBIDDEN"));
    }
    break;
  case 'login':
    mosRedirect(JRoute::_("index.php?option=com_users&view=login"));
    exit;
  case 'remindpassword':
    mosRedirect(JRoute::_("index.php?option=com_users&view=remind"));
    exit;
  case 'resetpassword':
    mosRedirect(JRoute::_("index.php?option=com_users&view=reset") );
    exit;
  case 'advexpire':
    advexpire();
    break;
  case 'activate':
    activate();
    break;
  case 'add_user':
    if ($user_configuration['allow_registration'] != '0') {
      add_user();
    }
    break;
  case 'user_prolong':
    user_prolong();
    break;
  case 'update_user':
    update_user();
    break;
  case "accdetail":
    accdetail($option);
    break;
  case 'show_invite':
    show_invite($option);
    break;
  case 'fetch':
    fetch($option);
    break;
  case 'invite':
    invite($cid, $option);
    break;
  case 'congretulation':
    congretulation($option);
    break;
  case 'show_users':
    show_users();
    break;
  case 'my_account':
    User_account();
    break;
  case 'showUsersProfile':
    ShowUsersProfile($userId);
    break;
  case 'secret_image':
    secretImageSMS();
    break;
  case 'checkLoginPass':
    checkLoginPass();
    break;
  case 'socialLogin':
    socialLogin();
    break;
  default:        
    User_account();
    break;
}


//display user's account
function User_account() {

  global $database, $my, $mosConfig_live_site, $mosConfig_absolute_path, $Itemid, $user_configuration;
  
  
  
  $user_id = $my->id;
  $doc = JFactory::getDocument();
  if ($user_id) {
?>
    <div id="mod_user_profile">
        <?php
    $joom_user = new JUser();
    $joom_user->load($user_id);
    if (version_compare(JVERSION, "4.0.0", "ge")) {
        
        JPluginHelper::importPlugin('user');
        JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
        $user_profile_form = JForm::getInstance('com_users.user', 'user');
        $results2 = JFactory::getApplication()->triggerEvent('onContentPrepareData', array('com_users.user', $joom_user));
        $results = JFactory::getApplication()->triggerEvent('onContentPrepareForm', array($user_profile_form, $joom_user));
    }else{
        $dispatcher = JDispatcher::getInstance();
        JPluginHelper::importPlugin('user');
        JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
        $user_profile_form = JForm::getInstance('com_users.user', 'user');
        $results2 = $dispatcher->trigger('onContentPrepareData', array('com_users.user', $joom_user));
        $results = $dispatcher->trigger('onContentPrepareForm', array($user_profile_form, $joom_user));
    }
    
    $user_profile_form->bind($joom_user);
    $fieldsets = $user_profile_form->getFieldsets();
    $profile_image = $user_profile_form->getValue('file', 'profile', '');

    HTML_simplemembership::ShowUserProfile($user_profile_form, $fieldsets,
                                            $profile_image,  $joom_user);
    $doc->setTitle( JText::_("COM_SIMPLEMEMBERSHIP_MY_ACCOUNT") );
    
  } else {
    //echo  JText::_("COM_SIMPLEMEMBERSHIP_LOGIN_PLEASE") ."!!!";
    JFactory::getApplication()->enqueueMessage(JText::_("COM_SIMPLEMEMBERSHIP_LOGIN_PLEASE"), 'warning');

  }

}


//display user's list
function show_users() {
  global $mosConfig_live_site, $database,$Itemid;
  $mainframe = JFactory::getApplication();
  // Params(menu)
  if (version_compare(JVERSION, '3.0', 'ge')) {
      $menu = new JTableMenu($database);
      $menu->load($Itemid);
      $params = new JRegistry;
      $params->loadString($menu->params);
  } else {
      $app = JFactory::getApplication();
      $menu = $app->getMenu();
      $params = new JRegistry;
      $params = $menu->getParams( $Itemid );
  }//end


  $where = '';
  $show_users_group = $params->get('show_users_group','-2');
  
  if(empty($show_users_group))$show_users_group = -2;
  if($show_users_group != -2)
    $where = " WHERE sm_grp.id IN ( " . implode(',',$show_users_group) . " ) ";
  
  $group_desc = array();
  if($show_users_group != -2 && is_array($show_users_group) && !empty($show_users_group) && count($show_users_group) == 1){
      $database->setQuery("SELECT name, description FROM #__simplemembership_groups 
          WHERE id=$show_users_group[0]");
      $group_desc = $database->loadObjectList();
  }
  
  $limit_text = '';
  // Get pagination request variables
  $limit = $params->get('usersOnPage', 'default');
  if($limit == 'default'){
    $limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit',
                                               $mainframe->getCfg('list_limit'), 'int');
  }
  
  if($limit != 'all'){
      $limitstart = protectInjectionWithoutQuote('limitstart', 0, 'int');
      if($limitstart == 0 )$limitstart = protectInjectionWithoutQuote('start', 0, 'int');

      $query = "SELECT count(*) FROM #__users as usrs
                  LEFT JOIN #__simplemembership_users as sm_usrs ON sm_usrs.fk_users_id = usrs.id
                  LEFT JOIN #__simplemembership_groups as sm_grp ON sm_grp.id = sm_usrs.current_gid"
                  .$where ;
      $database->setQuery($query);
      

      try {
          $total = $database->loadResult();
      } catch (Exception $ex) {
          echo $ex->getMessage();
      }
      //var_dump($where);
      $pageNav = new os_libPagination($total, $limitstart, $limit);
      $limit_text = " LIMIT $pageNav->limitstart, $pageNav->limit ";
  }else{
      $pageNav = false;
  }
  

//  $query = "SELECT usrs.*, prof.profile_value as prof_img FROM #__users as usrs"
//            ."\n LEFT JOIN #__simplemembership_users as sm_usrs ON sm_usrs.fk_users_id = usrs.id"
//            ."\n LEFT JOIN #__simplemembership_groups as sm_grp ON sm_grp.id = sm_usrs.current_gid"
//            ."\n LEFT JOIN #__user_profiles as prof ON prof.user_id = usrs.id"
//            .$where
//            ."\n ORDER BY usrs.name limit " . $pageNav->limitstart . " ," . $pageNav->limit;
  $query = "SELECT usrs.*, prof.profile_value as prof_img FROM #__users as usrs"
            ."\n LEFT JOIN #__simplemembership_users as sm_usrs ON sm_usrs.fk_users_id = usrs.id"
            ."\n LEFT JOIN #__simplemembership_groups as sm_grp ON sm_grp.id = sm_usrs.current_gid"
            ."\n LEFT JOIN #__user_profiles as prof ON prof.user_id = usrs.id and prof.profile_key='profile.file' "
            .$where
            ."\n  " . $limit_text;

  //echo $query; 
  $database->setQuery($query);
  
  try {
      $list = $database->loadObjectList();
  } catch (Exception $ex) {
      echo $ex->getMessage();
  }
  //print_r($list); exit;
  
  $query = "SELECT `userid`, `username` FROM #__session WHERE guest = 0 AND client_id = 0";
  $database->setQuery($query);
  $UsersL = array();
  $ListUsersOnline = $database->loadObjectList();
  foreach($ListUsersOnline as $ListUser) {
    $UsersL[] = $ListUser->userid;
  }
  $UsOffline = array();
  if (count($UsersL)>0) {
    $UsOnline[] = array_unique($UsersL);
    unset($UsersL);
    foreach($list as $user) {
      $UserL[] = $user->id;
      for ($i = 0;$i < count($UserL);$i++) {
        if (!in_array($UserL[$i], $UsOnline[0])) {
          $UsersL[] = $UserL[$i];
        }
      }
    }        
  } else {
    $UsOnline[0] = Array();
    $UsOffline[] = Array();
  }
  $HTML_simplemembership = new HTML_simplemembership();
  $HTML_simplemembership->UsersList($list, $pageNav, $UsOnline, $UsOffline, $group_desc);
}


//display user's profile
function ShowUsersProfile($userId) {
  global $database, $mosConfig_live_site, $mosConfig_absolute_path, $user_configuration;
  $doc = JFactory::getDocument();
  $doc->addStyleSheet($mosConfig_live_site . 
    '/components/com_simplemembership/includes/simplemembership.css');
  $database = JFactory::getDBO();
  $user = JFactory::getUser();
  $acl = new JAccess;
  if (!checkAccess_SM($user_configuration['other_profiles'], 'NORECURSE', userGID_SM($user->id), $acl)) {
    echo  JText::_("COM_SIMPLEMEMBERSHIP_HAVE_NOT_RIGHT") ;
    return;
  }
  $user_id = $userId;
  ?>
  <div id="mod_user_profile">
  <?php
  $joom_user = new JUser();
  $joom_user->load($user_id);
  if (version_compare(JVERSION, "4.0.0-alpha10", "ge")) {
      JPluginHelper::importPlugin('user');
      JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
      // $user_profile_form = JForm::getInstance('com_users.profile', 'registration');
      $user_profile_form = JForm::getInstance('com_users.user', 'profile');
      $results2 = JFactory::getApplication()->triggerEvent('onContentPrepareData', array('com_users.module', $joom_user));
      $results = JFactory::getApplication()->triggerEvent('onContentPrepareForm', array($user_profile_form, $joom_user));
  }else{
      $dispatcher = JDispatcher::getInstance();
      JPluginHelper::importPlugin('user');
      JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
      // $user_profile_form = JForm::getInstance('com_users.profile', 'registration');
      $user_profile_form = JForm::getInstance('com_users.user', 'profile');
      $results2 = $dispatcher->trigger('onContentPrepareData', array('com_users.module', $joom_user));
      $results = $dispatcher->trigger('onContentPrepareForm', array($user_profile_form, $joom_user));
  }
  
  $user_profile_form->bind($joom_user);
  $fieldsets = $user_profile_form->getFieldsets();
  $GLOBALS['fieldsets'] = $fieldsets;
  $GLOBALS['user_profile_form'] = $user_profile_form;
  $profile_image = $user_profile_form->getValue('file', 'profile', '');
  $HTML_simplemembership = new HTML_simplemembership();

  $HTML_simplemembership->ShowUserProfile($user_profile_form, 
                                          $fieldsets, $profile_image, $joom_user);
}


function ers($ers) {
  $contents = "<table cellspacing='0' cellpadding='0' 
                      style='border:1px solid red;' align='center' class='tbErrorMsgGrad'>
                <tr>
                  <td valign='middle' style='padding:3px' valign='middle' class='tbErrorMsg'>
                    <img src='/images/ers.gif'>
                  </td>
                  <td valign='middle' style='color:red;padding:5px;'>";
  foreach($ers as $key => $error) $contents.= "{$error}<br >";
  $contents.= "</td></tr></table><br >";
  return $contents;
}


function fetch($option) {
  global $database, $my, $mosConfig_absolute_path;
  //from openinviter
  $inviter = new OpenInviter();
  $email_providers = $inviter->getPlugins();
  set_time_limit(0);
  //From openinviter
  $ers = array();
  $import_ok = false;
  if (($_SERVER['REQUEST_METHOD'] == 'POST')) {
    $email_box = mosGetParam($_REQUEST, 'email_box', '');
    $password_box = mosGetParam($_REQUEST, 'password_box', '');
    $provider_box = mosGetParam($_REQUEST, 'provider_box', '');
    if (empty($email_box)) $ers['email'] =  JText::_("COM_SIMPLEMEMBERSHIP_EMAIL_MISSING") ;
    if (empty($password_box)) $ers['password'] =  JText::_("COM_SIMPLEMEMBERSHIP_PASSWORD_MISSING") ;
    if (empty($provider_box)) $ers['provider'] =  JText::_("COM_SIMPLEMEMBERSHIP_PROVIDER_MISSING") ;
    if (count($ers) == 0) {
      $inviter->startPlugin($provider_box);
      if (!isset($inviter)) $ers['inviter'] =  JText::_("COM_SIMPLEMEMBERSHIP_INVALID_EMAIL_PROVIDER") ;
      elseif (!$inviter->login($email_box, $password_box)) $ers['login'] =  JText::_("COM_SIMPLEMEMBERSHIP_INCORRECT_LOGIN") ;
      elseif (!$contacts = $inviter->getMyContacts()) $ers['contacts'] = _NO_CONTACTS_FETCHED;
      else {
        $inviter->logout();
        $import_ok = true;
      }
    }
  }
  $contents = (count($ers) != 0 ? ers($ers) : '');
  if (!$import_ok) {
    foreach($ers AS $error) $errmsg.= $error . ' ';
    mosRedirect("index.php?option=$option&task=show_invite", $errmsg);
  }
  $str = "";
  if ($import_ok) {
    if (count($contacts) == 0) $contents = _EMPTY_ARRAY;
    else {
      $msg = "";
      foreach($contacts as $email => $name) {
        $name = addslashes($name);
        $query = "INSERT IGNORE INTO #__simplememberships (`invitee_email`,`invitee_name`,
                                                            `invited_by_email`,`msg`) ".
         " VALUES ('" . $database->getEscaped($email) . "','" . $database->getEscaped($name) . "','" .
          $database->getEscaped($YOUR_EMAIL) . "','" . $database->getEscaped($msg) . "')";
        $database->setQuery($query);
        $database->execute();

      }
    }
    $query = "SELECT * from #__simplememberships WHERE `invited_by_email`= 
                                    '$YOUR_EMAIL' ORDER BY `invitee_name`";
    $database->setQuery($query);
    $rows = $database->loadObjectList();

    $name = '';
    if ($my->id) $name = $my->name;
    $HTML_simplemembership = new HTML_simplemembership();
    $HTML_simplemembership->display($option, $rows, $YOUR_EMAIL, $name, $contents);
  }
}
function invite($cid, $option) {
  global $database, $mosConfig_live_site, $mosConfig_mailfrom, $mosConfig_fromname;
  $query = "SELECT * FROM #__simplemembership_config";
  $database->setQuery($query);
  $database->loadObject($conf);

  josSpoofCheck();
  if (!is_array($cid) || count($cid) < 1) {
    echo "<script> alert('Select contact to invite'); window.history.go(-1);</script>\n";
    exit;
  }
  $from_email = mosGetParam($_REQUEST, 'from_email', '');
  $from_name = mosGetParam($_REQUEST, 'name', '');
  $msg = mosGetParam($_REQUEST, 'msg', '');
  $default_msg = mosGetParam($_REQUEST, 'default_mesg', '');
  $msg = $msg . '<br/><br/>' . $default_msg;
  $msgtosave = addslashes($msg);
  $n = 0;
  //Warning: Hardcoded text
  $admin_sub = "JoomInvites sent";
  $admin_msg = "Hi Admin,<br />$from_name ($from_email) has sent invitation to :-<br/><br />";
  mosArrayToInts($cid);
  foreach($cid AS $id) {
    $query = "UPDATE #__simplememberships " .
     " SET `invited_by_name`='$from_name', `to_be_invited`=1, `last_sent`=CURDATE(),
       `msg`='$msgtosave' WHERE `id`=$id";
    $database->setQuery($query);
    $database->execute();

    $query = "SELECT `invitee_name`, `invitee_email` FROM #__simplememberships WHERE `id`=$id";
    $database->setQuery($query);
    $result = $database->loadObjectList();

    $name = $result[0]->invitee_name;
    $to = $result[0]->invitee_email;
    $subject = $conf->custom_subject;
    $default_msg = $conf->msg;
    $subject = preg_replace('/{user}/', $from_name, $subject);
    $subject = preg_replace('/{my_site}/', $mosConfig_live_site, $subject);
    $body = "Hi $name,<br/>";
    $body.= stripslashes($msg);
    $body.= "<br/><br/>$default_msg";
    $mailfrom = ($conf->email_from_user ? $from_email : $mosConfig_mailfrom);
    $fromname = ($conf->email_from_user ? $from_name : $mosConfig_fromname);
    mosMail($mailfrom, $fromname, $to, $subject, $body, 1, NULL, NULL, null, $from_email, $from_name);
    $admin_msg.= "$name ($to).<br/>";
    $n++;
  }
  if ($conf->bcc_admin) {
    mosMail($mosConfig_mailfrom, $mosConfig_fromname, $mosConfig_mailfrom, $admin_sub, $admin_msg, 1);
  }
  //Warning: Hardcoded text
  mosRedirect("index.php?option=$option&task=congretulation",
               "Successfully invited $n contacts, invite more friends at any time.");
}
function show_invite($option) {
  $HTML_simplemembership = new HTML_simplemembership();
  $HTML_simplemembership->front($option);
}
function congretulation($option) {
  $HTML_simplemembership = new HTML_simplemembership();
  $HTML_simplemembership->congretulation($option);
}
function activate() {
  global $database, $user_configuration,$mainframe,$mosConfig_mailfrom;
  $error_msg = '';
  if(strip_tags($user_configuration['activationmsg']) == JText::_(strip_tags($user_configuration['activationmsg']))){
      $msg_body = $user_configuration['activationmsg'];
  }else{
      $msg_body = JText::_(strip_tags($user_configuration['activationmsg']));
  }
  
  if (array_key_exists('activation', $_GET)) {
    $activation =  protectInjectionWithoutQuote('activation');
    $query = "select * from #__users where activation='$activation'";
    //$query = "select * from #__users ";
    $database->setQuery($query);
    $user_res_tmp = $database->loadObjectList();
    if (array_key_exists(0, $user_res_tmp)) {
      $user_res = $user_res_tmp[0];
      $uid = $user_res->id;
      $query = "select * from #__simplemembership_users where fk_users_id='$uid'";
      $database->setQuery($query);
      $adv_user_tmp = $database->loadObjectList();
      $adv_user = $adv_user_tmp[0];
      $ug_id = $adv_user->want_gid;
      $query = "update #__users set block='0' where id='$uid'";
      $database->setQuery($query);
      $database->execute();
      // $query = "update #__users set activation='' where id='$uid'";
      // $database->setQuery($query);
      // $database->execute();
      $query = "update #__simplemembership_users set block='0' where fk_users_id='$uid'";
      $database->setQuery($query);
      $database->execute();
      $add_text = '';
      if ($ug_id != 0) {
      $query = "SELECT * FROM #__simplemembership_groups where id='$ug_id'";
        $database->setQuery($query);
        $group = $database->loadObjectList();
        $groupx = $group[0];
        if ($groupx && $groupx->auto_approve == 1) {

          $user = new JUser();
          $query = "SELECT ug.id FROM #__usergroups AS ug
                  LEFT JOIN #__simplemembership_group_joomgroup as sgj ON ug.id=sgj.jgroup_id 
                  WHERE sgj.mgroup_id=(SELECT want_gid FROM #__simplemembership_users WHERE id=" .
                     $adv_user->id . ")";
          $database->setQuery($query);
          if (version_compare(JVERSION, '3.0.0', 'ge')) {
            $want_groups = $database->loadColumn();
          } else {
            $want_groups = $database->loadResultArray();
          }
          $query = "SELECT ug.title FROM #__usergroups AS ug"
              . "\n LEFT JOIN #__simplemembership_group_joomgroup as sgj ON ug.id=sgj.jgroup_id "
              . "\n WHERE sgj.mgroup_id=(SELECT want_gid FROM #__simplemembership_users WHERE id=" .
                 $adv_user->id . ")";
          $database->setQuery($query);
          $want_groups_name = $database->loadColumn();
          $want_groups_name = implode(",", $want_groups_name);
          $want_groups = array_combine($want_groups, $want_groups);
          $user->load($adv_user->fk_users_id);
          // Get the dispatcher and load the users plugins.
          if (version_compare(JVERSION, "4.0.0", "lt")) $dispatcher = JDispatcher::getInstance();
          JPluginHelper::importPlugin('user');
          if (version_compare(JVERSION, "4.0.0", "lt")) $results2 = $dispatcher->trigger('onContentPrepareData', array('com_users.profile', $user));
          else $results2 = JFactory::getApplication()->triggerEvent('onContentPrepareData', array('com_users.profile', $user));
          $user->groups = $want_groups; 
          $user->usertype = $want_groups_name;
          $user->block = 0;
          $user->activation = 0;
          /*---------------------------------------start day_last in groups--------------------------*/
          $query = "SELECT * FROM #__simplemembership_groups AS sg
              WHERE sg.id=(SELECT want_gid FROM #__simplemembership_users WHERE id=" . $adv_user->id . ")";
          $database->setQuery($query);
          $usr_group = $database->loadObjectList();
          $usr_group=$usr_group['0'];
          $current_gid = $usr_group->id;
          /*---------------------------------------end day_last in groups----------------------------*/
          $user->save();
          $query="UPDATE #__simplemembership_users SET expire_date='".expireDate($usr_group)."',
                                                      current_gid='".$usr_group->id."',
                                                      current_gname='".$usr_group->name."',
                                                      approved = 1,
                                                      last_approved=now()
                  WHERE #__simplemembership_users.fk_users_id='".$adv_user->fk_users_id."'";
          $database->setQuery($query);
          $database->execute();
          $sql = "SELECT id FROM #__simplemembership_orders WHERE fk_sm_users_id = '".$adv_user->id."'";
          $database->setQuery($sql);
          $order_id = $database->loadResult();
          $txn_type = 'Approved by link';
          $order_id = (int)$order_id ;
          if( $order_id != 0 ) {
            //create order for new NOT Free user
            $sql = "INSERT INTO `#__simplemembership_orders_details`(fk_order_id, fk_sm_users_id, 
                                  fk_sm_users_name, fk_sm_users_email,
                                  order_date ,fk_group_id, txn_type,order_price)
                          VALUES ('".$order_id."',
                                  '".$adv_user->id."',
                                  '".$adv_user->name."',
                                  '".$adv_user->email."',
                                  now(),
                                  '".$current_gid."',
                                  '".$txn_type."',0)";
            $database->setQuery($sql);
            $database->execute();
          }

          if(strip_tags($user_configuration['user_approve_msg']) == JText::_(strip_tags($user_configuration['user_approve_msg']))){
              $user_approve_msg = $user_configuration['user_approve_msg'];
          }else{
              $user_approve_msg = JText::_(strip_tags($user_configuration['user_approve_msg']));
          }
          
            try {
              $a = JFactory::getMailer();
              $a->sendMail($mosConfig_mailfrom, $user_configuration['senders_email'], 
                $adv_user->email, JText::_('COM_SIMPLEMEMBERSHIP_MESSAGE_ACCOUNT_APPROVE_SUBJECT'), stripslashes($user_approve_msg), 1);
            } catch (Exception $ex) {
                JFactory::getApplication()->enqueueMessage(JText::_('COM_SIMPLEMEMBERSHIP_EMAIL_NOT_SEND_MSG') . ' ' . $ex->getMessage() );
            }    

          $add_text =  JText::_("COM_SIMPLEMEMBERSHIP_YOU_ACCOUNT_ACTIVATED") ;
        } else if ($groupx && $groupx->auto_approve == 2) {
          if ($groupx->product_name != '') {
            $add_text.= '<br />'. JText::_("COM_SIMPLEMEMBERSHIP_NEED_BUY_PRODUCR") .'(' . $groupx->product_name . ') ';
          }
          if ($groupx->link != '') {
            $add_text.=  JText::_("COM_SIMPLEMEMBERSHIP_AND_FOLLOW") .' <a href="' . $groupx->link .
               '"><strong>link</strong></a> ';
          }
        } else if ($groupx && $groupx->auto_approve == 0) {
          if ($groupx->product_name != '') {
            $add_text.= '<br />'. JText::_("COM_SIMPLEMEMBERSHIP_NEED_BUY_PRODUCR") .'(' . $groupx->product_name . ') ';
          }
          if ($groupx->link != '') {
            $add_text.=  JText::_("COM_SIMPLEMEMBERSHIP_AND_FOLLOW") .' <a href="' . $groupx->link . 
              '"><strong>link</strong></a> ';
          }
          $add_text.=  JText::_("COM_SIMPLEMEMBERSHIP_AFTER_CHECK_ADMIN_WILL_APPROVE_YOU") ;
        }
      } else{
          // Get the dispatcher and load the users plugins.
          if (version_compare(JVERSION, "4.0.0", "lt")) $dispatcher = JDispatcher::getInstance();
          JPluginHelper::importPlugin('user');
          $user = new JUser();
          $user->load($uid);
          if (version_compare(JVERSION, "4.0.0", "lt")) $results2 = $dispatcher->trigger('onContentPrepareData', array('com_users.profile', $user));
          else JFactory::getApplication()->triggerEvent('onContentPrepareData', array('com_users.profile', $user));
          $user->activation = 0;     
          $user->save();   
      }
      // $msg = '<div class="componentheading">'. JText::_("COM_SIMPLEMEMBERSHIP_ACTIVATION_COMPLETE") .
      //   '!</div><div class="message">' . $msg_body . $add_text . '</div>
      //   <br/>
      //   <a href="index.php?option=com_simplemembership&task=show_invite">'.
      //    JText::_("COM_SIMPLEMEMBERSHIP_INVATE_FRIENDS") .'</a>';
      $msg = '<div class="componentheading">'. JText::_("COM_SIMPLEMEMBERSHIP_ACTIVATION_COMPLETE") .
        '!</div><div class="message">' . $msg_body . $add_text . '</div>';
      } else $msg = '<div class="componentheading">'.
               JText::_("COM_SIMPLEMEMBERSHIP_ACTIVATION_NOT_COMPLETE") .'!</div><div class="message">'.
               JText::_("COM_SIMPLEMEMBERSHIP_INVALIDE_CODE") .'.</div>';
  } else $msg = '<div class="componentheading">'.
           JText::_("COM_SIMPLEMEMBERSHIP_ACTIVATION_NOT_COMPLETE") .'!</div><div class="message">'.
           JText::_("COM_SIMPLEMEMBERSHIP_INVALIDE_ACTIVATION_LINK") .'.</div>';
    JFactory::getApplication()->enqueueMessage($msg);
    mosRedirect("index.php");   
}


function update_user() {
    global $database, $my, $user_configuration, $mainframe, $mosConfig_live_site,$mosConfig_mailfrom,$Itemid;

    if(!sms_checkReferer()){
        JFactory::getApplication()->enqueueMessage(Jtext::_("COM_SIMPLEMEMBERSHIP_ERROR_REFERER_SECURITY"), 'warning');
        return;
    }
  if(protectInjectionWithoutQuote('password1')===protectInjectionWithoutQuote('password2')){
    $activate = md5(time());
    $activation_link = '<a href="' . $mosConfig_live_site .
    '/index.php?option=com_simplemembership&task=activate&activation=' . $activate . '">Activation link</a>';
    //// Default group
    $default_group = $user_configuration['default_group'];
    if (empty($default_group ) )
    {
      $default_group = array('2' => '2');
      $default_group_name = 'Registered';
    } else {
      $query = "SELECT ug.title FROM #__usergroups AS ug WHERE ug.id IN ( " . $default_group . " )";
      $database->setQuery($query);
      $dg=explode(",",$default_group);
      $default_group_name = $database->loadColumn();
      foreach($default_group_name as $key => $name){
          $default_group_name[$key] = JText::_($name);
      }
      $default_group_name = implode(",", $default_group_name);
      $default_group = array_combine($dg, $dg);
    }//// end Default group
    if ($_POST['name'] == '' || $_POST['email1'] == '' || $_POST['username'] == '') {
      JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_MUST_BE_FILLED") , 'error');
      mosRedirect("index.php?option=com_simplemembership");
    }
    $bid = $my->id;
    $want_gid = (int)$_POST['wanted_gid'];
    $user = new JUser();
    $query = "SELECT * from #__simplemembership_users where fk_users_id='$bid'";
    $database->setQuery($query);
    $sm_user = $database->loadObject();

    $user->load($sm_user->fk_users_id);

    if (version_compare(JVERSION, "4.0.0", "lt")) $dispatcher = JDispatcher::getInstance();
    JPluginHelper::importPlugin('user');

    if ($want_gid != -1 && $want_gid != -2) {
      $query = "select * from #__simplemembership_groups where id='$want_gid'";
      $database->setQuery($query);
      $group = $database->loadObjectList();
      $group = $group[0];
    }
    if (isset($_POST['password1'])) $_POST['password'] = $_POST['password1'];
    $user->bind($_POST);
    if (version_compare(JVERSION, "4.0.0", "lt"))  $results2 = $dispatcher->trigger( 'onUserBeforeSave', array($user->getProperties(),false, $user->getProperties() ) );
    else JFactory::getApplication()->triggerEvent('onUserBeforeSave', array($user->getProperties(),false, $user->getProperties()));

    if($want_gid != -3){
      if ($want_gid == -2 || $want_gid == -1) {
        $user->groups = $default_group;
        $user->usertype = $default_group_name;
      }else{
        $user->usertype = $group->acl_group;
      }
    }
    $user->name = $_POST['name'];
    $user->email = $_POST['email1'];
    $user->username = $_POST['username'];
    //$user->registerDate = date('Y-m-d h:i:s');
    $user->activation = $activate;
    if ($user->save()) {
      $result = true ;
      if (version_compare(JVERSION, "4.0.0", "lt"))  $results2 = $dispatcher->trigger( 'onUserAfterSave', array($user->getProperties(),false, $result, $error ) );
      else JFactory::getApplication()->triggerEvent('onUserAfterSave', array($user->getProperties(),false, $result, $error));

      $al_user = new mos_alUser($database);
      $al_user->load($sm_user->id);
      $al_user->bind($_POST);
      $al_user->fk_users_id = $user->id;
      $current_gid = $al_user->current_gid;
      if($want_gid != -3){
        if($current_gid == $want_gid){
            $al_user->current_gid = $want_gid;
            $al_user->current_gname = JText::_($group->name);
            $al_user->approved = 1;
        }else{
          if ($want_gid != -1) {
            $query = "select * from #__simplemembership_groups where id='$want_gid'";
            $database->setQuery($query);
            $group = $database->loadObjectList();
            $group = $group[0];
            $al_user->want_gid = $group->id;
            $al_user->want_gname = JText::_($group->name);
            //$al_user->expire_date = 0;
            $al_user->approved = 0;
          } else {
            $al_user->current_gid = -2;
            $al_user->current_gname = 'Default';
            //$al_user->expire_date = 0;
            $al_user->approved = 1;
            $al_user->last_approved = date("Y-m-d H:i:s");
          }
        }
      }else{
        //$al_user->expire_date = 0;
        $al_user->current_gid = -2;
        $al_user->current_gname = 'Default';
        $user->expire_date = 0;
        $al_user->approved = 1;
        $al_user->block = $user->block;
      }
      $is_created = $al_user->store();

      $query = "SELECT * FROM #__simplemembership_groups where published='1' 
                AND id ='".$want_gid."' ";
      $database->setQuery($query);
      $pr_lis = $database->loadObjectList();

      if($want_gid != -3  && !empty($pr_lis['0']->price) ){
        if ($want_gid != -1 && $want_gid != -2) {
          $order_id = checkOrder($al_user->id);//create order for new user
          $sql = "UPDATE  #__simplemembership_orders SET order_date = 'now()',
                                                        fk_group_id='".$al_user->want_gid."',
                                                        status = 'P',
                                                        order_price = 0
                  WHERE id = '".$order_id."'";
          $database->setQuery($sql);
          $database->execute();
          $sql = "INSERT INTO #__simplemembership_orders_details(fk_order_id,fk_sm_users_id,order_date, 
                                          fk_sm_users_name, fk_sm_users_email,status,fk_group_id,txn_type,order_price)
                  VALUES ('".$order_id."','".$al_user->id."',now(),'".$al_user->name."',
                          '".$al_user->email."','Pending',
                          '".$al_user->want_gid."','".'User updated.(Set group '.$al_user->want_gname.')'."',0)";
          $database->setQuery($sql);
          $database->execute();
        }
      }
      if($current_gid != $group->id || ($current_gid == -2 && $want_gid == -1) || $al_user->approved = 0){
        if ($is_created && isset($group) && $group->auto_approve == 1 ){
          $user_acc_create_msg = JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_LINK") . $activation_link . " .\n" . $add_text;
          
            try {
              $a = JFactory::getMailer();
              $a->sendMail($mosConfig_mailfrom, $user_configuration['senders_email'],
                        $al_user->email, 'account update', $user_acc_create_msg, 1);
            } catch (Exception $ex) {
                JFactory::getApplication()->enqueueMessage(JText::_('COM_SIMPLEMEMBERSHIP_EMAIL_NOT_SEND_MSG') . ' ' . $ex->getMessage() );
            }  

          
        }
        if ($is_created && isset($group) && $group->auto_approve == 0 )
          JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_UPDATE_ACTIVATE_MANUAL") );
        if ($is_created && isset($group) && $group->auto_approve == 1 )
          JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_UPDATE_ACTIVATE_BY_LINK") );
        if(!empty($group->price) && !empty($group->currency_code) 
            && $group->auto_approve == 2 || !empty($group->price) && $group->auto_approve == 0){
            mosRedirect(JRoute::_("index.php?option=com_simplemembership&Itemid=$Itemid&task=user_prolong&gid=".$group->id));
        }
      }else{
        JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_UPDATE_ALLREADY_IN_GROUP_MESSAGE") );
      }
      JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_USER_UPDATED") );
      mosRedirect(JRoute::_("index.php?option=com_simplemembership&task=accdetail"));
    }
  }else{
    echo"<script> alert('". JText::_("COM_SIMPLEMEMBERSHIP_PASSWORDS_DO_NOT_MATCH") ."'); window.history.go(-1);</script>\n";;
  }
}


function buyGroup($data) {
  return;
}
   

function user_prolong() {
    if(!sms_checkReferer()){
        JFactory::getApplication()->enqueueMessage(Jtext::_("COM_SIMPLEMEMBERSHIP_ERROR_REFERER_SECURITY"), 'warning');
        return;
    }

  global $database, $my, $user_configuration, $mainframe, $mosConfig_live_site, $mosConfig_mailfrom;
  $current_user = JFactory::getUser();
  
  if( empty($current_user->email)) {  
    header("Location: index.php?option=com_simplemembership&task=getMail&msg=".
       JText::_("COM_SIMPLEMEMBERSHIP_LOGIN_FIRST") ."!!!");
  }
  if( trim($current_user->email) != trim(protectInjectionWithoutQuote('email1'))  ) {  
    header("Location: index.php?option=com_simplemembership&task=getMail&msg=".
       JText::_("COM_SIMPLEMEMBERSHIP_TYPE_CORRECT_EMAIL") ."!!!!");
  }
  

  if($current_user->id){
    $query = "SELECT * FROM #__user_usergroup_map WHERE user_id=".$current_user->id.
        " AND (group_id = 8 OR group_id = 7)";
    $database->setQuery($query);
    $result = $database->loadObjectList();
  }
  $is_admin = false;
  if(isset($result['0']) && !empty($result['0'])){
    $is_admin = true;
    //for not reset armin user rights
    JFactory::getApplication()->enqueueMessage(Jtext::_("COM_SIMPLEMEMBERSHIP_CURRENT_ADMIN"), 'warning');
    return;
  }

  $em = (!empty($current_user->email))? $current_user->email : protectInjectionWithoutQuote('email1');
  if (isset($em)) {
    $sql = "SELECT * FROM #__simplemembership_users WHERE email='".$em."'";
    $database->setQuery($sql);
    $userId = $database->loadObjectList();


    if(!empty($userId[0]->id) ) {
      $req_group_selected = protectInjectionWithoutQuote('group_selected',"");
      if( $req_group_selected != "" ){
          $query = "SELECT id FROM #__simplemembership_groups where published='1' 
                AND name ='".$req_group_selected."' ";
          $database->setQuery($query);
          $gid = $database->loadResult();
      }else{
        $gid = protectInjectionWithoutQuote('gid',0);
      }

      $query = "SELECT * FROM #__simplemembership_groups where published='1' 
                AND id ='".$gid."' ";
      $database->setQuery($query);
      $pr_lis = $database->loadObjectList();

      if($current_user->id && $gid != 0 && !empty($pr_lis['0']->price) ){
          
        $order_id = checkOrder($userId[0]->id,$gid);
        $sql = "UPDATE #__simplemembership_orders SET order_date = now(),
                      fk_group_id = '".$gid."',
                      status = 'P'
                WHERE fk_sm_users_id = '".$userId[0]->id."'";
        $database->setQuery($sql);
        $database->execute();
        $data = array('userIdOrder'=>$userId[0]->id, 'OrderID'=>$order_id );
        $sql = "INSERT INTO #__simplemembership_orders_details(fk_order_id,fk_sm_users_id, order_date,
                                             fk_sm_users_name,fk_sm_users_email, fk_group_id, status,txn_type, order_price)"
            . "\n VALUES ('".$order_id."','".$userId[0]->id."',now(),'".$userId[0]->name."',
                          '".$userId[0]->email."', '".$gid."', 'Pending','Clicked buy link in acc. details', 0)";
        $database->setQuery($sql);
        $database->execute();
        
        buyGroup($data);
        echo '<input style="margin:10px 0;" class="btn btn-info" id="PREVIOUS" type="button" name="PREVIOUS" alt="subscribe PREVIOUS" value="'.JText::_("COM_SIMPLEMEMBERSHIP_PREVIOUS").'" onclick="javascript:window.history.go(-1)"> ';   
             
      }else{
      
        if ( $gid != 0 ) {
          $al_user = new mos_alUser($database);
          $al_user->want_gid = $want_gid = $gid;
            /////////////////////////////    start register user's to new group   //////////////////	
          global $database, $my, $user_configuration, $mainframe, $mosConfig_live_site;
          //// Default group
          $default_group = $user_configuration['default_group'];
          if (empty($default_group ) )
          {
            $default_group = array('2' => '2');
            $default_group_name = 'Registered';
          } else {
            $query = "SELECT ug.title FROM #__usergroups AS ug WHERE ug.id IN ( " . $default_group . " )";
            $database->setQuery($query);
            $dg=explode(",",$default_group);
            $default_group_name = $database->loadColumn();
            foreach($default_group_name as $key => $val){
                $default_group_name[$key] = JText::_($val);
            }
            $default_group_name = implode(",", $default_group_name);
            $default_group = array_combine($dg, $dg);
          }//// end Default group
          $bid = $my->id;
          if (version_compare(JVERSION, "4.0.0", "lt")) $dispatcher = JDispatcher::getInstance();
          JPluginHelper::importPlugin('user');
          $user = new JUser();
          $query = "SELECT * from #__simplemembership_users where email='".$em."'";
          $database->setQuery($query);
          $sm_user = $database->loadObject();
          $user->load($sm_user->fk_users_id);
          if (version_compare(JVERSION, "4.0.0", "lt"))  $results2 = $dispatcher->trigger('onContentPrepareData', array('com_users.profile', $user));
          else JFactory::getApplication()->triggerEvent('onContentPrepareData', array('com_users.profile', $user));
          if ($want_gid != -1 && $want_gid != -2) {
            $query = "select * from #__simplemembership_groups where id='$want_gid'";
            $database->setQuery($query);
            $group = $database->loadObjectList();
            $group = $group[0];
          }

          if(count($_POST) > 0 ) {
           //new user registration 
           $user->bind($_POST);

           $user->name = $_POST['name'];
           $user->email = $_POST['email1'];
           $user->username = $_POST['username'];
           $user->registerDate = date('Y-m-d h:i:s');
          }

          if ($want_gid == -2 || $want_gid == -1) {
            $user->usertype = $default_group_name;
          }else{
            $user->usertype = $group->acl_group;
          }
          if(isset($group) && $group->auto_approve == 1){
            $activate = md5(time());
            $activation_link = '<a href="' . $mosConfig_live_site .
             '/index.php?option=com_simplemembership&task=activate&activation=' . $activate 
             . '">Activation link</a>';
            $user->activation = $activate;
          }
          if ($user->save()) {
            $al_user->load($sm_user->id);
            $al_user->bind($_POST);
            $al_user->fk_users_id = $user->id;
            $current_gid = $al_user->current_gid;
            if($current_gid == $want_gid){
                $al_user->current_gid = $want_gid;
                $al_user->current_gname = JText::_($group->name);
                $al_user->approved = 1;
            }else{
              if ($want_gid != -1) {
                $query = "select * from #__simplemembership_groups where id='$want_gid'";
                $database->setQuery($query);
                $group = $database->loadObjectList();
                $group = $group[0];
                $al_user->want_gid = $group->id;
                $al_user->want_gname = JText::_($group->name);
                //$al_user->expire_date = 0;
                $al_user->approved = 0;
              } else {
                $default_group= implode(",", $default_group);
                $al_user->current_gid = -2;
                $al_user->current_gname = 'Default';
                //$al_user->expire_date = 0;
                $al_user->approved = 1;
                $al_user->last_approved = date("Y-m-d H:i:s");
              }
            }
            $al_user->store();

            if ($want_gid != -1 && $want_gid != -2 && !empty($pr_lis['0']->price)) {
              $order_id = checkOrder($al_user->id);//create order for new user
              $sql = "UPDATE  #__simplemembership_orders SET order_date = 'now()',
                                                            fk_group_id='".$al_user->want_gid."',
                                                            status = 'P'
                      WHERE id = '".$order_id."'";
              $database->setQuery($sql);
              $database->execute();
              $sql = "INSERT INTO #__simplemembership_orders_details(fk_order_id,fk_sm_users_id, 
                        fk_sm_users_name, fk_sm_users_email,order_date,status,fk_group_id,txn_type,order_price)
                      VALUES ('".$order_id."','".$al_user->id."','".$al_user->name."',
                              '".$al_user->email."', now(),'Pending',
                              '".$al_user->want_gid."','User updated.(Set not default group)',0)";
              $database->setQuery($sql);
              $database->execute();
            }

            if($current_gid == $want_gid || ($current_gid == -2 && $want_gid == -1)){
              JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_UPDATE_ALLREADY_IN_GROUP_MESSAGE") );  
              return;
            }            
            if (isset($group) && $group->auto_approve == 1 ){
              $user_msg =  JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_LINK") . $activation_link;
              
              try {
                $a = JFactory::getMailer();
                $a->sendMail($mosConfig_mailfrom, $user_configuration['senders_email'], 
                            $al_user->email, JText::_("COM_SIMPLEMEMBERSHIP_MESSAGE_ACCOUNT_CREATION_SUBJECT"), $user_msg, 1);
              } catch (Exception $ex) {
                  JFactory::getApplication()->enqueueMessage(JText::_('COM_SIMPLEMEMBERSHIP_EMAIL_NOT_SEND_MSG') . ' ' . $ex->getMessage() );
              }            
                
              
              JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_PROLONG_BY_LINK") );
            }
            JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_USER_UPDATED") );
          } else {
            JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_USER_CAN_NOT_UPDATED") );
          }
        }
////////////////////////////////////////////    end register user's new group   ///////////////////////		

        if ($want_gid != -1 && $want_gid != -2 && !empty($pr_lis['0']->price)) {
        $order_id = checkOrder($userId[0]->id,$gid);
        $sql = "UPDATE #__simplemembership_orders 
                SET order_date = now(),
                    fk_group_id = '".$gid."',
                    status = 'P'
                WHERE fk_sm_users_id = '".$userId[0]->id."'";
        $database->setQuery($sql);
        $database->execute();
        $data = array('userIdOrder'=>$userId[0]->id, 'OrderID'=>$order_id );
        $sql = "INSERT INTO #__simplemembership_orders_details(fk_order_id,
                    fk_sm_users_id,
                    fk_sm_users_name,
                    fk_sm_users_email,
                    order_date,
                    fk_group_id,
                    status,order_price)"
          ."\n VALUES ('".$order_id."',
                    '".$userId[0]->id."',
                    '".$userId[0]->name."',
                    '".$userId[0]->email."',
                    now(),
                    '".$gid."',
                    'Pending',0)";
        $database->setQuery($sql);
        $database->execute();
        buyGroup($data);
        }
      }        
    }      
  } else {
    JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_USER_NOT_REGISTERED") , 'error');
  }
}


function add_user() {
    if(!sms_checkReferer()){
        JFactory::getApplication()->enqueueMessage(Jtext::_("COM_SIMPLEMEMBERSHIP_ERROR_REFERER_SECURITY"), 'warning');
        return;
    }
    
    global $database, $my, $user_configuration, $mainframe, $mosConfig_live_site,
      $mosConfig_absolute_path, $mosConfig_mailfrom,$Itemid;

    $input = JFactory::getApplication()->input;
    $err_msg = "";

    if(isset($_REQUEST['g-recaptcha-response'])){
        $captcha = JCaptcha::getInstance('recaptcha', array('namespace' => 'recaptcha'));
        if($captcha){
            $get_answer = $_REQUEST['g-recaptcha-response'];
            try {
                $captcha->checkAnswer($get_answer);
            } catch (Exception $ex) {
                $err_msg =  JText::_("COM_SIMPLEMEMBERSHIP_CAPTCHA_ERROR") ;
                JFactory::getApplication()->enqueueMessage( $err_msg , 'error');
            }      
                
        }
    }
    
    if($_POST['password2'] != $_POST['password1']){
      $err_msg =  JText::_("COM_SIMPLEMEMBERSHIP_PASSWORD_MISMATCH") ;
      JFactory::getApplication()->enqueueMessage( $err_msg , 'error');
    }
    if (!version_compare(JVERSION, "4.0.0", "ge")) {
        if($_POST['email1'] != $_POST['email2']){
          $err_msg =  JText::_("COM_SIMPLEMEMBERSHIP_EMAIL_MISMATCH") ;
          JFactory::getApplication()->enqueueMessage( $err_msg , 'error');
        }
    }
    if($err_msg != "") {
      //if error in before registration
      
      //// Default group
      $default_group = $user_configuration['default_group'];
      if (empty($default_group)) {
          $default_group = '2';
          $default_group_name = 'Registered';
      } else {
          $query = "SELECT ug.title FROM #__usergroups AS ug WHERE ug.id IN ( $default_group )";
          $database->setQuery($query);
          if (version_compare(JVERSION, "4.0.0", "ge")) {
              if (version_compare(JVERSION, '3.0.0', 'ge')) {
                  $default_group_name = $database->loadColumn();
              } else {
                  $default_group_name = $database->loadResultArray();
              }
          }else{
              echo $ex->getMessage();
          }
          
          
          foreach($default_group_name as $key => $val){
              $default_group_name[$key] = Jtext::_($val);
          }
          $default_group_name = implode(",", $default_group_name);
          //$default_group=array_combine($default_group,$default_group);
          $f = array();
          $s = explode(',', $user_configuration['default_group']);
          for ($i = 0;$i < count($s);$i++) {
              $f[] = mosHTML::makeOption($s[$i]);
          }
          $default_group = $f;
      }
      $options = array();
      $query = "select * from #__simplemembership_groups where published='1'";
      $database->setQuery($query);
      $pr_lis = $database->loadObjectList();
      if(strip_tags($user_configuration['preregister']) == JText::_(strip_tags($user_configuration['preregister']))){
          $preregister = stripslashes($user_configuration['preregister']);
      }else{
          $preregister = stripslashes(JText::_(strip_tags($user_configuration['preregister'])));
      }
      if (array_key_exists(0, $pr_lis)) $options[] = mosHTML::makeOption(-1, $default_group_name .
         ' (Free user)');
      $group_selected = protectInjectionWithoutQuote('group_selected','');
      foreach($pr_lis as $item) {
          $details = (!empty($item->price) && !empty($item->currency_code))?
                          ' ('.JText::_("COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_COST").': '.$item->price.$item->currency_code.')':' ('.JText::_("COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_FREE").')' ;
          $options[] = mosHTML::makeOption($item->id, JText::_($item->name).$details);
          if($group_selected == $item->name)$group_selected = JText::_($item->id);
      }
      if (array_key_exists(0, $options)) $olist = mosHTML::selectList($options, 'gid', '',
         'value', 'text','');
      else $olist = '';    

      
      //add profile form
      // Get the dispatcher and load the users plugins.
      if (version_compare(JVERSION, "4.0.0", "ge")) {
          JPluginHelper::importPlugin('user');
          JForm::addFormPath($mosConfig_absolute_path . '/components/com_users/forms');
          $user_profile_form = JForm::getInstance('com_users.registration', 'registration');

          $results = JFactory::getApplication()->triggerEvent('onContentPrepareForm', array($user_profile_form, $_POST ));
          $user_profile_form->bind($_POST);
          $ToSLink = JFactory::getApplication()->triggerEvent('onTermsOfService');

      }else{
          $dispatcher = JDispatcher::getInstance();
          JPluginHelper::importPlugin('user');
          JForm::addFormPath($mosConfig_absolute_path . '/components/com_users/models/forms');
          $user_profile_form = JForm::getInstance('com_users.registration', 'registration');

          $results = $dispatcher->trigger('onContentPrepareForm', array($user_profile_form, $_POST ));
          $user_profile_form->bind($_POST);
          $ToSLink = $dispatcher->trigger('onTermsOfService');
      }
      
      $HTML_simplemembership = new HTML_simplemembership();
      $HTML_simplemembership->advregister_form($olist, $preregister, $user_profile_form, $ToSLink);
      return ;
    }else{   
  
  
      $activate = md5(time());
      jimport( 'joomla.application.component.helper' );
      $params = JComponentHelper::getParams("com_users") ;



      $is_self = $params->get("useractivation");

    //   print_r($params);exit;

      $activation_link = '<a href="' . $mosConfig_live_site .
       '/index.php?option=com_simplemembership&task=activate&Itemid=$Itemid&activation=' . $activate . '">'
        . JText::_("COM_SIMPLEMEMBERSHIP_ACTIVATION_LINK") .'</a>';
      if (!version_compare(JVERSION, "4.0.0", "ge")) {
          if($_POST['email1'] != $_POST['email2']){
            echo "<script> alert('". JText::_("COM_SIMPLEMEMBERSHIP_EMAIL_MISMATCH") .".'); window.history.go(-1);</script>\n";
            exit;
          }
      }
      //// Default group
      $default_group = $user_configuration['default_group'];
      if (empty($default_group ) )
      {
        $default_group = array('2' => '2');
        $default_group_name = 'Registered';
      } else {
        $query = "SELECT ug.title FROM #__usergroups AS ug WHERE ug.id IN ( " . $default_group . " )";
        $database->setQuery($query);
        $dg=explode(",",$default_group);
        $default_group_name = $database->loadColumn();
        foreach($default_group_name as $key => $val){
            $default_group_name[$key] = JText::_($val);
        }
        $default_group_name = implode(",", $default_group_name);
        $default_group = array_combine($dg, $dg);
      }

      $gid = $input->get('gid', '-1');

      $query = "SELECT * FROM #__simplemembership_groups WHERE id='" . $gid . "'";
      $database->setQuery($query);
      $group = $database->loadObjectList();

      if (isset($group) && !empty($group)) {
       $group = $group[0];
      }



      $user = new JUser();
      if (isset($_POST['password1']))  $_POST['password'] = $_POST['password1'];

      $cur_user_tmp = JFactory::getUser();
      if( isset($cur_user_tmp->id) && $cur_user_tmp->id != 0  ){
        $user->load($cur_user_tmp->id);
      }

  $user->bind($_POST);
  $user->name = $_POST['name'];
  $user->username = $_POST['username'];
  $user->email = $_POST['email1'];
  $user->groups = $default_group;
  $user->usertype = $default_group_name;
  if($gid == '-1' && $user_configuration['auto_enabled'])
  {
    $user->block = 0;
  }else{
    $user->block = 1;
  }
  $user->activation = $activate;
  $user->registerDate = date('Y-m-d h:i:s');
  $postregister_msg = '';

      if ($user->save()) {
        $al_user = new mos_alUser($database);
        if( isset($cur_user_tmp->id) && $cur_user_tmp->id != 0 ){
          $al_user->load_by_joomla_user_id($cur_user_tmp->id);
        }
        $al_user->bind($_POST);
        $al_user->email = $user->email;
        $al_user->fk_users_id = $user->id;
        if (array_key_exists('gid', $_POST) && $_POST['gid'] != -1) {

          $al_user->current_gid = -2;
          $al_user->current_gname = 'Default';
          $al_user->want_gid = protectInjectionWithoutQuote('gid') ;
          $al_user->want_gname = JText::_($group->name);
      //$al_user->expire_date = 0;
          $al_user->approved = 0;
      $add_text = ($group->link != '') ? 'And please buy "' .
          $group->product_name . '" from here: <a href"' . $group->link . '">Product</a>' : '';
          if(strip_tags($user_configuration['admin_created_msg']) == JText::_(strip_tags($user_configuration['admin_created_msg']))){
              $admin_created_msg = $user_configuration['admin_created_msg'];
          }else{
              $admin_created_msg = JText::_(strip_tags($user_configuration['admin_created_msg']));
          }
          $admin_acc_create_msg = stripslashes($admin_created_msg) . "<br>" .
                                   JText::_("COM_SIMPLEMEMBERSHIP_USEREDIT_USERNAME") . ': ' . protectInjectionWithoutQuote('username') . "<br>" .
                                   JText::_("COM_SIMPLEMEMBERSHIP_LABEL_SIMPLEMEMBERSHIPGROUP") . ':' . $al_user->want_gid;
          if(strip_tags($group->notes) == JText::_(strip_tags($group->notes))){
            $postregister_msg = $group->notes;
          }else{
            $postregister_msg = JText::_(strip_tags($group->notes));
          }
        } else {

          //$al_user->expire_date = 0;
          $al_user->current_gid = -2;
          $al_user->current_gname = 'Default';
          $user->expire_date = 0;
          $al_user->last_approved = date("Y-m-d H:i:s");
          //$al_user->approved = 1;
          $add_text = '';
          if(strip_tags($user_configuration['admin_created_msg']) == JText::_(strip_tags($user_configuration['admin_created_msg']))){
              $admin_created_msg = $user_configuration['admin_created_msg'];
          }else{
              $admin_created_msg = JText::_(strip_tags($user_configuration['admin_created_msg']));
          }

      $admin_acc_create_msg = stripslashes($admin_created_msg) . "<br>"
       .  JText::_("COM_SIMPLEMEMBERSHIP_USEREDIT_USERNAME")  . ': ' . protectInjectionWithoutQuote('username') . "<br>" .
         JText::_("COM_SIMPLEMEMBERSHIP_LABEL_SIMPLEMEMBERSHIPGROUP")  . ' ' . $default_group_name;
      $postregister_msg = '';
    }
    $al_user->block = 1;
    $is_created = $al_user->store();


    $query = "SELECT * FROM #__simplemembership_groups where published='1' 
              AND id ='".$gid."' ";
    $database->setQuery($query);
    $pr_lis = $database->loadObjectList();


    if (array_key_exists('gid', $_POST) && $_POST['gid'] != -1 && !empty($pr_lis['0']->price)) {
          $order_id = checkOrder($al_user->id);//create order for new user
          $sql = "UPDATE  #__simplemembership_orders SET order_date = now(),
                  fk_group_id='".$al_user->want_gid."',
                  status = 'P'
                  WHERE id = '".$order_id."'";
          $database->setQuery($sql);
          $database->execute();
          $sql = "INSERT INTO #__simplemembership_orders_details(fk_order_id,fk_sm_users_id, 
                      fk_sm_users_name, fk_sm_users_email,order_date,
                      status,fk_group_id,txn_type,order_price)
                  VALUES ('".$order_id."','".$al_user->id."',
                          '".$al_user->name."','".$al_user->email."',now(),
                          'Pending','".$al_user->want_gid."','User created.(Not default group)',0)";
          $database->setQuery($sql);
          $database->execute();
        }

        $user_acc_create_msg = '';
        if(strip_tags($user_configuration['user_created_msg']) == JText::_(strip_tags($user_configuration['user_created_msg']))){
            $user_created_msg = $user_configuration['user_created_msg'];
        } else {
            $user_created_msg = JText::_(strip_tags($user_configuration['user_created_msg']));
        }

        if ($is_created && isset($group->auto_approve) && $group->auto_approve == 0 )
          $user_acc_create_msg = stripslashes($user_created_msg) .
          "\n" . JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_MANUAL") ;
        if ($is_created && isset($group->auto_approve) && $group->auto_approve == 1 )
          $user_acc_create_msg = stripslashes($user_created_msg) .
          "\n" . JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_LINK") . $activation_link . " .\n" . $add_text;
        if ($is_created && isset($group->auto_approve) && $group->auto_approve == 2 ) {
          if ( stristr( ($user_configuration['release']['version']), 'pro' ) ) {
            $user_acc_create_msg = stripslashes($user_created_msg) .
            "\n" . JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BUY");
          } else {
            $user_acc_create_msg = stripslashes($user_created_msg) .
            "\n" . JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BUY") .
            ' <a href="' . $group->link . '" target="_blank">' . 
            JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BUY_LINK_BUY") . '</a>' ;
          }
        }

        
        if ($is_created && $user_acc_create_msg == ''){
            $user_acc_create_msg = stripslashes($user_created_msg) ;
            if($is_self ==1 )
              $user_acc_create_msg .= "\n" . JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_LINK") . $activation_link . " .\n";
        }

        // bch
        if($_POST['username'])
        {
            $user_acc_create_msg .= "<br />" . JText::_("COM_SIMPLEMEMBERSHIP_LABEL_USER") ." ". $_POST['username']. " .\n";
        }
        if($_POST['password1'] && $params['sendpassword'])
        {
            $user_acc_create_msg .= "<br />" . JText::_("COM_SIMPLEMEMBERSHIP_USEREDIT_PASSWORD") ." ". $_POST['password1']. " .\n";
        }

        
          try {
            $a = JFactory::getMailer();
            if ( $user_configuration['acl_group_set_email'] &&
              !empty($user_configuration['useradd_notification_email'])){
                $a->sendMail($mosConfig_mailfrom, $user_configuration['senders_email'], 
                            $user_configuration['useradd_notification_email'],
                            JText::_("COM_SIMPLEMEMBERSHIP_MESSAGE_ACCOUNT_CREATION_SUBJECT"), $admin_acc_create_msg, 1);
            }
            $a->sendMail($mosConfig_mailfrom, $user_configuration['senders_email'], 
                      $al_user->email, JText::_("COM_SIMPLEMEMBERSHIP_MESSAGE_ACCOUNT_CREATION_SUBJECT"), $user_acc_create_msg, 1);
          } catch (Exception $ex) {
              JFactory::getApplication()->enqueueMessage(JText::_('COM_SIMPLEMEMBERSHIP_EMAIL_NOT_SEND_MSG') . ' ' . $ex->getMessage() );
          }
          
        
    if ($is_created && $postregister_msg == '') {
          JFactory::getApplication()->enqueueMessage(stripslashes($user_created_msg));
    }
    elseif ($postregister_msg != '') {
      JFactory::getApplication()->enqueueMessage($postregister_msg);
    }

    if ($is_created && isset($group) && $group->auto_approve == 0 )
      JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_MANUAL") );
    else if ($is_created && isset($group) && $group->auto_approve == 1 )
      JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BY_LINK") );
    else if ($is_created && isset($group) && $group->auto_approve == 2 ){
          if ( stristr( ($user_configuration['release']['version']), 'pro' ) ) {
            JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BUY") );
            $data = array('userIdOrder'=>$al_user->id, 'OrderID'=>$order_id );
            buyGroup($data);
          } else {
            JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BUY") .
            ' <a href="' . $group->link . '" target="_blank">' . 
            JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BUY_LINK_BUY") . '</a>' );
          }
        }else if($is_self ==1 ) JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_ACC_ACTIVATE_BY_LINK") );
      } else {
        JFactory::getApplication()->enqueueMessage( JText::_("COM_SIMPLEMEMBERSHIP_USER_NOT_REGISTERED") . $user->getError(), 'error');
      }
    }
}

function accdetail($option) {

  global $database, $my, $user_configuration,$mosConfig_live_site, $mosConfig_absolute_path;
  
  
  $user_id = $my->id;
  if ($user_id) {
    $jom_id = $my->id;
    $query = "select id from #__simplemembership_users where fk_users_id='$jom_id'";
    $database->setQuery($query);
    $bid = $database->loadResult();
    // default group end
    $default_group = $user_configuration['default_group'];
    if (empty($default_group)) {
      $default_group = array('2' => '2');
      $default_group_name = 'Registered';
    } else {
      $query = "SELECT ug.title FROM #__usergroups AS ug WHERE ug.id IN ( " . $default_group . " )";
      $database->setQuery($query);
      if (version_compare(JVERSION, '3.0.0', 'ge')) {
        $default_group_name = $database->loadColumn();
      } else {
        $default_group_name = $database->loadResultArray();
      }
      foreach($default_group_name as $key => $val){
          $default_group_name[$key] = JText::_($val);
      }
      $default_group_name = implode(",", $default_group_name);
      //$default_group=array_combine($default_group,$default_group);
      $f = array();
      $s = explode(',', $user_configuration['default_group']);
      for ($i = 0;$i < count($s);$i++) {
        $f[] = mosHTML::makeOption($s[$i]);
      }
      $default_group = $f;
    }
    $user = new mos_alUser($database);
    $user->load(intval($bid));
    $options = array();
    $query = "SELECT * FROM #__simplemembership_groups WHERE published='1'";
    $database->setQuery($query);
    $pr_lis = $database->loadObjectList();
    $joom_user = new JUser();
    $joom_user->load($user->fk_users_id);
    //if($user->approved == 0)$user->expire_date = 0;
    $joom_user->params = json_decode($joom_user->params, true);
    if($user->fk_users_id){
      $query = "SELECT * FROM #__user_usergroup_map WHERE user_id=".$user->fk_users_id.
          " AND (group_id = 8 OR group_id = 7)";
      $database->setQuery($query);
      $result = $database->loadObjectList();
    }
    $is_admin = false;
    if(isset($result['0']) && !empty($result['0']) ){
      $is_admin = true;
      $options[] = mosHTML::makeOption(-3, JText::_("COM_SIMPLEMEMBERSHIP_CURRENT_ADMIN"));
    }
    $options[] = mosHTML::makeOption(-1, JText::_('COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_DEFAULT') . ' ('.$default_group_name.')');
    $group_selected = protectInjectionWithoutQuote('group_selected','');
    foreach($pr_lis as $item) {
      $details = (!empty($item->price) && !empty($item->currency_code))?
                      ' ('.JText::_("COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_COST").': '.$item->price.$item->currency_code.')':' ('.JText::_("COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_FREE").')' ;
      $options[] = mosHTML::makeOption($item->id, JText::_($item->name).$details);
      if($group_selected == $item->name)
        $group_selected = JText::_($item->id);
    }
    
    if($is_admin)
      $user->current_gid = -3;
    if (array_key_exists(0, $options)){
      $olist = mosHTML::selectList($options, 'wanted_gid', '', 'value', 'text',
      ( $user->approved==1)?$user->current_gid:'');
    }else{
      $olist = 'Default('.$default_group_name . ')';
    }
    $last_approved_date = strtotime($user->last_approved);
    $cur_date = date_create(date("Y-m-d H:i:s"));
    $exp_date = date_create($user->expire_date);
    $interval='';
    $want_group ='';
    if($user->want_gid > 0){
      $query = "SELECT * FROM #__simplemembership_groups WHERE id=".$user->want_gid."";
      $database->setQuery($query);
      $want_group = $database->loadObjectList();
      $want_group = $want_group['0'];
    }
    if($exp_date)
      $interval = date_diff($exp_date,$cur_date);
    ///if current user in default group
    if ((!is_object($interval) && empty($interval->invert) || is_object($interval) && $interval->invert == 0) 
      && !empty($want_group) ) {
      if ($user->approved == 0
        && $want_group->auto_approve == 2 && !empty($want_group->price)){
          $msg = '<br/>'. JText::_("COM_SIMPLEMEMBERSHIP_YOU_ARE_EXPIRED_FOR_GROUP") .' <b>' . $want_group->name .
           '</b>, '. JText::_("COM_SIMPLEMEMBERSHIP_PLEASE_BUY_THIS_PRODUCT") .' <a href="' . $mosConfig_live_site .
            '/index.php?option=com_simplemembership&task=buyLink'. '">link</a>';
      } elseif((isset($name_of_group) && $name_of_group != '' ) 
                  && $user->approved == 0 && $want_group->auto_approve == 1){
        $msg = '<br/><b>'. JText::_("COM_SIMPLEMEMBERSHIP_WE_SEND_ACTIVATION_LINK") .'!</b>';
      }else if($user->approved == 0 && $want_group->auto_approve == 0 && !empty($want_group->price)){
        $msg = '<br/>'. JText::_("COM_SIMPLEMEMBERSHIP_SELECTED_PAID_GROUP") .'('. JText::_($want_group->name).
          ') '. JText::_("COM_SIMPLEMEMBERSHIP_WITH_APPROVE_BY_ADMINISTRATOR") .' <a href="' . $mosConfig_live_site .
            '/index.php?option=com_simplemembership&task=buyLink'. '">link</a>'
            .' <br>'. JText::_("COM_SIMPLEMEMBERSHIP_WAIT_FOR_CONFIRMATION") ;
      }else if($user->approved == 0 && $want_group->auto_approve == 0){
        $msg = '<br/>'. JText::_("COM_SIMPLEMEMBERSHIP_SELECTED_GROUP") .'('. JText::_($want_group->name).
        ') '. JText::_("COM_SIMPLEMEMBERSHIP_WITH_APPROVE_BY_ADMINISTRATOR2") ;
      }else {
        $msg = '<br/>'. JText::_("COM_SIMPLEMEMBERSHIP_IN_ONE_OF_THESE_GROUPS") ;
      }
    }
    //if user in not default group and has expire range
    $msg='';
    if (is_object($interval) && $interval->invert == 1 && $user->approved == 1) {
      $msg = '<br/>'.  JText::_("COM_SIMPLEMEMBERSHIP_IN_ONE_OF_THESE_GROUPS_NEXT") ;
      if($interval->format('%y%')>0)
        $msg.=$interval->format('%y%').  JText::_("COM_SIMPLEMEMBERSHIP_YEARS") ;
      if($interval->format('%m%')>0)
        $msg.=$interval->format('%m%').  JText::_("COM_SIMPLEMEMBERSHIP_MONTHS") ;
      if($interval->format('%d%')>0)
        $msg.=$interval->format('%d%').  JText::_("COM_SIMPLEMEMBERSHIP_DAYS") ;
        $msg.=$interval->format('%H%'). JText::_("COM_SIMPLEMEMBERSHIP_HOURES") ;
    }

    // Get the dispatcher and load the users plugins.
    if (version_compare(JVERSION, "4.0.0", "ge")) {
        JPluginHelper::importPlugin('user');
        JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
        //JForm::addFormPath($mosConfig_absolute_path . '/components/com_users/forms');
        $user_profile_form = JForm::getInstance('com_users.profile', 'update_user');
//        $user_profile_form = JForm::getInstance('com_users.profile', 'profile');
        $results2 = JFactory::getApplication()->triggerEvent('onContentPrepareData', array('com_users.profile', $joom_user));
        $results = JFactory::getApplication()->triggerEvent('onContentPrepareForm', array($user_profile_form, $joom_user));
    }else{
        $dispatcher = JDispatcher::getInstance();
        JPluginHelper::importPlugin('user');
        JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
        $user_profile_form = JForm::getInstance('com_users.profile', 'update_user');
        $results2 = $dispatcher->trigger('onContentPrepareData', array('com_users.profile', $joom_user));
        $results = $dispatcher->trigger('onContentPrepareForm', array($user_profile_form, $joom_user));
    }
    
    $user_profile_form->bind($joom_user);
    if (version_compare(JVERSION, "4.0.0", "ge")) {
        $ToSLink = JFactory::getApplication()->triggerEvent('onTermsOfService');
    }else{
        $ToSLink = $dispatcher->trigger('onTermsOfService');
    }
    $HTML_simplemembership = new HTML_simplemembership();
    $HTML_simplemembership->accdetail($user, $olist, $option, $msg, $user_profile_form, $ToSLink);
  } else {
    header("Location:index.php");
  }
}

function buyLink($option) {
  global $database,$my,$Itemid;

  $userId = $my->id;
  $sql = "SELECT * FROM #__simplemembership_users WHERE fk_users_id = '".$userId."'";
  $database->setQuery($sql);
  $user= $database->loadObjectList();
  $user=$user['0'];
  mosRedirect("index.php?option=$option&Itemid=$Itemid&task=user_prolong&gid=".$user->want_gid.
              "&email1=".$user->email, $errmsg);
}

function getMail() { 
    global $user_configuration, $database,$Itemid;

  if(isset($_GET['msg'])) {
    $error = urldecode(protectInjectionWithoutQuote('msg'));
    echo "<p style='color:red;'>".$error."</p><br>";
  } 

  $user = JFactory::getUser();
  
  if( !isset($user->email) ){
    echo "<p style='color:red;'>Please login first</p><br>";
    return;
  }
    
  ?>
  <form action="<?php echo JRoute::_("index.php?option=com_simplemembership&Itemid=$Itemid&task=advregister");?>" method='get'>
    <?php if($user_configuration['active_account_information']){ ?>
      <div class="active_subscription_label">
          <label><?php echo  JText::_("COM_SIMPLEMEMBERSHIP_SUBSCRIPTION_ACTIVE_SUBSCRIPTION_LABEL") ; ?>:</label>
      </div>
      
      <?php
        $query = "SELECT * FROM #__simplemembership_users WHERE fk_users_id=".$user->id;
        $database->setQuery($query);
        $sms_user = $database->loadObjectList();
        $sms_user = ( is_array($sms_user) && count($sms_user)>0 )? ($sms_user[0]):(NULL);


        
        if($sms_user !==NULL && $sms_user->expire_date != '0000-00-00 00:00:00'){
            $account_inf = JText::_("COM_SIMPLEMEMBERSHIP_ACTIVE_ACCOUNT_INFORMATION_BODY");
            
          $query = "SELECT * FROM #__simplemembership_groups WHERE id=".$sms_user->current_gid;
          $database->setQuery($query);
          $group = $database->loadObjectList();
          $group = ( is_array($group) && count($group)>0 )? ($group[0]):(NULL);

          if($group !==NULL ){

            if($group->expire_units == 'Y'){
                $group->expire_units = JText::_('COM_SIMPLEMEMBERSHIP_YEAR_S');
            }elseif($group->expire_units == 'M'){
                $group->expire_units = JText::_('COM_SIMPLEMEMBERSHIP_MONTH_S');
            }elseif( $group->expire_units == 'W'){
                $group->expire_units = JText::_('COM_SIMPLEMEMBERSHIP_WEEK_S');
            }elseif( $group->expire_units == 'D'){
                $group->expire_units = JText::_('COM_SIMPLEMEMBERSHIP_DAY_S');
            }
            $expire_date = new DateTime($sms_user->expire_date);
            $account_inf = str_ireplace('{group-name}', JText::_($group->name), $account_inf);
            $account_inf = str_ireplace('{interval}', $group->expire_range . ' ' . $group->expire_units, $account_inf);
            $account_inf = str_ireplace('{price}', $group->price . ' ' . $group->currency_code, $account_inf);
            $account_inf = str_ireplace('{expired}', $expire_date->format(JText::_('DATE_FORMAT_LC6')), $account_inf);
        ?>
          <div class="active_subscription">
            <?php echo $account_inf; ?>
            
          </div>
        <?php 
          }
        }else{ ?>
          <div class="inactive_subscription">
            <label><?php echo  JText::_("COM_SIMPLEMEMBERSHIP_ACTIVE_ACCOUNT_INFORMATION_BODY_UNACTIVE") ; ?></label>
          </div>  
        <?php }
    } ?>
    <label><?php echo  JText::_("COM_SIMPLEMEMBERSHIP_SUBSCRIPTION_RENEWAL") ; ?>:</label><br />
    <input id='emailUser' type='text' name='email' value=""><br />
    <input id='emailSubmit' type='submit' value='<?php echo  JText::_("COM_SIMPLEMEMBERSHIP_SUBSCRIPTION_RENEWAL_CONTINUE_BUTTON") ; ?>'>
    <input type='hidden' name='prolong' value='p' >
    <input type='hidden' name='option' value='com_simplemembership' >
  </form>
  <script>

  window.onload = function(){
   var emailSubmit = document.getElementById('emailSubmit');
   if(emailSubmit){
    emailSubmit.onclick = function(event){
      event = event || window.event;
      var eMail = document.getElementById('emailUser').value;
        if(eMail == ""){
          event.preventDefault();
          alert("Write Your Email!!");
        }
      }
    }
  }
  </script>
  <?php
}


function advregister() {
  global $database, $user_configuration, $mosConfig_absolute_path,$mosConfig_live_site,$Itemid;

  
  $user = JFactory::getUser();

  if( isset($user->email) && (!isset($_GET['prolong']) && !isset($_POST['prolong']) )) {
    User_account();
    return;
  }
    
  {
    sync_users();
    //// Default group
    $default_group = $user_configuration['default_group'];
    if (empty($default_group)) {
      $default_group = '2';
      $default_group_name = 'Registered';
    } else {
      $query = "SELECT ug.title FROM #__usergroups AS ug WHERE ug.id IN ( $default_group )";
      $database->setQuery($query);
      
      try {
        if (version_compare(JVERSION, '3.0.0', 'ge')) {
            $default_group_name = $database->loadColumn();
          } else {
            $default_group_name = $database->loadResultArray();
          }
      } catch (Exception $ex) {
          echo $ex->getMessage();
      }
      
      $default_group_name = implode(",", $default_group_name);
      //$default_group=array_combine($default_group,$default_group);
      $f = array();
      $s = explode(',', $user_configuration['default_group']);
      for ($i = 0;$i < count($s);$i++) {
        $f[] = mosHTML::makeOption($s[$i]);
      }
      $default_group = $f;
    }
    $options = array();
    $query = "select * from #__simplemembership_groups where published='1'";
    $database->setQuery($query);
    $pr_lis = $database->loadObjectList();
    if(strip_tags($user_configuration['preregister']) == JText::_(strip_tags($user_configuration['preregister']))){
        $preregister = stripslashes($user_configuration['preregister']);
    }else{
        $preregister = stripslashes(JText::_(strip_tags($user_configuration['preregister'])));
    }
    if (array_key_exists(0, $pr_lis)) 
      if($user_configuration['show_def_jgroup'])
    {
      $options[] = mosHTML::makeOption(-1, JText::_('COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_DEFAULT') .' ('.$default_group_name.')');
    }

    $group_selected = protectInjectionWithoutQuote('group_selected','');
    foreach($pr_lis as $item) {
      $details = (!empty($item->price) && !empty($item->currency_code))?
                      ' ('.JText::_("COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_COST").': '.$item->price.$item->currency_code.')':' ('.JText::_("COM_SIMPLEMEMBERSHIP_SELECT_A_MEMBER_GROUP_FREE").')' ;
      $options[] = mosHTML::makeOption($item->id, JText::_($item->name).$details);
      if($group_selected == $item->name)$group_selected = $item->id;
    }
    if (array_key_exists(0, $options)) 
      $olist = mosHTML::selectList($options, 'gid', '', 'value', 'text','');
    else $olist = '';
    //add profile form
    // Get the dispatcher and load the users plugins.
    if (version_compare(JVERSION, "4.0.0", "ge")) {
        JPluginHelper::importPlugin('user');
        JForm::addFormPath($mosConfig_absolute_path . '/components/com_users/forms');
        $user_profile_form = JForm::getInstance('com_users.registration', 'registration');

        $results = JFactory::getApplication()->triggerEvent('onContentPrepareForm', array($user_profile_form, $data = array()));
        $ToSLink = JFactory::getApplication()->triggerEvent('onTermsOfService');
    }else{
        $dispatcher = JDispatcher::getInstance();
        JPluginHelper::importPlugin('user');
        JForm::addFormPath($mosConfig_absolute_path . '/components/com_users/models/forms');
        $user_profile_form = JForm::getInstance('com_users.registration', 'registration');

        $results = $dispatcher->trigger('onContentPrepareForm', array($user_profile_form, $data = array()));
        $ToSLink = $dispatcher->trigger('onTermsOfService');
    }


    // print_r($user_profile_form) ; exit ;    
    $HTML_simplemembership = new HTML_simplemembership();
    $HTML_simplemembership->advregister_form($olist, $preregister, $user_profile_form, $ToSLink);
  }
}
//*****************************************************************************


  function secretImageSMS() {
    $session = JFactory::getSession();
    $pas = $session->get('captcha_keystring', 'default');
    //var_dump($pas); exit;
    $new_img = new PWImageSMS();
    $new_img->set_show_string($pas);
    $new_img->get_show_image(2.2, array(mt_rand(0, 50), mt_rand(0, 50), mt_rand(0, 50)),
     array(mt_rand(200, 255), mt_rand(200, 255), mt_rand(200, 255)));
    exit();
  }



function checkFolderAcess($folder_list, $current_folder) {
  $pattern = "/^($current_folder,)|(,$current_folder,)|^($current_folder)$|(,$current_folder)$/";
  if (preg_match($pattern, $folder_list)) {
    return true;
  }
  return false;
}
function checkAccess_SM($accessgroupid, $recurse, $usersgroupid, $acl) {
  //parse usergroups
//  $tempArr = array();
//  $tempArr = explode(',', $accessgroupid);
//  for ($i = 0;$i < count($tempArr);$i++) {
//    if ($tempArr[$i] == $usersgroupid || $tempArr[$i] == -2) {
//      return 1;
//    } else if ($recurse == 'RECURSE') {
//      return 1;
//    }
//  }
//  return 0;
    
    if (!is_array($usersgroupid)) {
          $usersgroupid = explode(',', $usersgroupid);
      }
      //parse usergroups
      $tempArr = array();
      $tempArr = explode(',', $accessgroupid);
      for ($i = 0; $i < count($tempArr); $i++) {
          if (((!is_array($usersgroupid) && $tempArr[$i] == $usersgroupid) OR
                 (is_array($usersgroupid) && in_array($tempArr[$i], $usersgroupid))) || $tempArr[$i] == - 2) {
              //allow access
              return true;
          } else {
              if ($recurse == 'RECURSE') {
                  if (is_array($usersgroupid)) {
                      foreach ($usersgroupid as $j)
                          if (in_array($j, $tempArr))
                              return 1;
                  } else {
                      if (in_array($usersgroupid, $tempArr))
                          return 1;
                  }
              }
          }
      } // end for
      //deny access
      return 0;
}
function userGID_SM($oID) {
  $database = JFactory::getDBO();
  if ($oID > 0) {
    $query = "SELECT group_id FROM #__user_usergroup_map WHERE user_id  = '" . $oID . "'";
    $database->setQuery($query);
    $gids = $database->loadAssocList();
    if (count($gids) > 0) {
      $ret = '';
      foreach($gids as $gid) {
        if ($ret != "") $ret.= ',';
        $ret.= $gid['group_id'];
      }
      return $ret;
    } else return -2;
  } else return -2;
}


function BeforeEndNotify($option) {
  global $database, $user_configuration, $Itemid, $mosConfig_mailfrom;
  $message_to_owner = array();
  $send_email = 0;
  if (($user_configuration['before_end_notify']) 
        && (is_numeric($user_configuration['before_end_notify_days']) ) ) {
    $send_email = 1;
  }else if ( isset($user_configuration['before_end_notify_days']) && is_array( explode(",", $user_configuration['before_end_notify_days'] ) ) ) {
    $send_email = 1;
  }

  if ($send_email) {
    $mail_to_admin = explode(",", $user_configuration['before_end_notify_email']);
//    $mail_to_admin = $user_configuration['before_end_notify_email'];
    $query = "SELECT u.id, u.name, u.username, u.email, u.last_approved, "
      . " g.id AS groupId, g.price, g.name AS groupName, "
      . " o.id AS orderId  "
      . " FROM #__simplemembership_users AS u  "
      . " LEFT JOIN #__simplemembership_orders AS o ON  u.id = o.fk_sm_users_id" 
      . " LEFT JOIN #__simplemembership_groups AS g ON  g.id = o.fk_group_id" 
      . " WHERE "
      . "  (TIMESTAMPDIFF(DAY, now(),u.expire_date ) ) IN ( " . $user_configuration['before_end_notify_days'] . " ) ;";
    $database->setQuery($query);
    $items = $database->loadObjectList();

    $all_in_one_massageForAdmin = "";
    for($i = 0; $i < count($items); $i++) {

      if(strip_tags($user_configuration['admin_created_msg_for_admin']) == JText::_(strip_tags($user_configuration['admin_created_msg_for_admin']))){
          $massageForAdmin = $user_configuration['admin_created_msg_for_admin'];
      }else{
          $massageForAdmin = JText::_(strip_tags($user_configuration['admin_created_msg_for_admin']));
      }
      
      if(strip_tags($user_configuration['admin_created_msg_for_user']) == JText::_(strip_tags($user_configuration['admin_created_msg_for_user']))){
          $massageForUser = $user_configuration['admin_created_msg_for_user'];
      }else{
          $massageForUser = JText::_(strip_tags($user_configuration['admin_created_msg_for_user']));
      }
      
      
      $massageForUser = str_replace("{username}", $items[$i]->username, $massageForUser);
      $massageForUser = str_replace("{user_email}", $items[$i]->email, $massageForUser);
      $massageForUser = str_replace("{id}", $items[$i]->id, $massageForUser);
      $massageForUser = str_replace("{GroupName}", JText::_($items[$i]->groupName), $massageForUser);

      if ( trim($user_configuration['before_end_notify_email']) != "" ) {
          $massageForAdmin = str_replace("{username}", $items[$i]->username, $massageForAdmin);
          $massageForAdmin = str_replace("{user_email}", $items[$i]->email, $massageForAdmin);
          $massageForAdmin = str_replace("{id}", $items[$i]->id, $massageForAdmin);
          $massageForAdmin = str_replace("{GroupName}", JText::_($items[$i]->groupName), $massageForAdmin);
          $all_in_one_massageForAdmin .= "<br />" . $massageForAdmin ;
      }
      
      $mail_to_owner = $items[$i]->email;
      

      try {
        $a = JFactory::getMailer();
        $a->sendMail($mosConfig_mailfrom, JText::_("COM_SIMPLEMEMBERSHIP_SUBSCRIPTION_EXPIRE_NOTICE_ON") .
          " {" . JText::_($items[$i]->groupName) . "}",
        $mail_to_owner, JText::_("COM_SIMPLEMEMBERSHIP_USER_MESSAGE_ACCOUNT_EXPIRE_SUBJECT"). "{" . JText::_($items[$i]->groupName) . "}!", $massageForUser, 1);

      } catch (Exception $ex) {
          JFactory::getApplication()->enqueueMessage(JText::_('COM_SIMPLEMEMBERSHIP_EMAIL_NOT_SEND_MSG') . ' ' . $ex->getMessage() );
      }        
      
    }
    if ( trim($all_in_one_massageForAdmin) != "" ) {
        
      try {
          $a = JFactory::getMailer();
          $ret = $a->sendMail($mosConfig_mailfrom, JText::_("COM_SIMPLEMEMBERSHIP_SUBSCRIPTION_EXPIRE_NOTICE_FOR") ,
          $mail_to_admin, JText::_("COM_SIMPLEMEMBERSHIP_SUBSCRIPTION_EXPIRE_NOTICE_FOR") , $all_in_one_massageForAdmin, 1);
      } catch (Exception $ex) {
          JFactory::getApplication()->enqueueMessage(JText::_('COM_SIMPLEMEMBERSHIP_EMAIL_NOT_SEND_MSG') . ' ' . $ex->getMessage() );
      } 
       
    }   
  }
}

function checkLoginPass(){
    $database = JFactory::getDBO();
    $app = JFactory::getApplication();
    $input = $app->input;
    $login = $input->getVar('login');
    $pass = $input->getVar('pass');

    $query = "SELECT password FROM #__users WHERE username='" . $login . "'";
    $database->setQuery($query);
    
    $hash = $database->loadResult();
    
    if(!$hash){
        echo json_encode("error");
        return;
    }
    $veryfy = JUserHelper::verifyPassword($pass, $hash);
    
    if($veryfy){
        echo json_encode("success");
        return;
    }else{
        echo json_encode("error");
        return;
    }
    
    
}

function socialLogin(){
    global $user_configuration, $mosConfig_absolute_path;


    if (version_compare(JVERSION, "4.0.0", "ge")) {
        $app = JFactory::getApplication();
        $my = $app->getIdentity();
    } else {
        $my = JFactory::getUser(); 
    }
    if($my->id > 0 ) { 
      //we already logined
      return ;

    }

    
    $database = JFactory::getDBO();
    $app = JFactory::getApplication();
    $input = $app->input;
    
    $network = $input->getVar('network');
    $userInfo = $input->getVar('userInfo');
    
    

    if($network == 'google'){
        
        $user_email = $userInfo['U3'];
        $user_social_id = $userInfo['Eea'];
        $user_name = $userInfo['ofa'];
        $user_surname = $userInfo['wea'];
        $user_img_link = $userInfo['Paa'];
        
    }elseif($network == 'facebook'){
        $user_email = $userInfo['email'];
        $user_social_id = $userInfo['id'];
        $user_name = $userInfo['first_name'];
        $user_surname = $userInfo['last_name'];
        $user_img_link = $userInfo['picture']['data']['url'];
    }else{
      require_once(JPATH_SITE . '/components/com_simplemembership/includes/OsOAuth2.php');
      require_once(JPATH_SITE . '/components/com_simplemembership/includes/OsOpenID.php');
      require_once(JPATH_SITE . '/components/com_simplemembership/includes/OsOAuth2Client.php');
        // JLoader::register('OsOAuth2', JPATH_SITE . '/components/com_simplemembership/includes/OsOAuth2.php');
        // JLoader::register('OsOpenID', JPATH_SITE . '/components/com_simplemembership/includes/OsOpenID.php');
      $module = JModuleHelper::getModule('mod_simplemembership_login');
      $moduleParams = new JRegistry($module->params);
      $clientid = $moduleParams->get('gmail_client_id');
      $clientsecret = $moduleParams->get('gmail_client_secret');
      $return_url = getReturnURL_SM2_comp($moduleParams, 'login');
      // var_dump($return_url); var_dump($clientsecret); exit;
      // $clientid = '671006422302-511hn3e5elmeicsk62f64ioum8g7id3m.apps.googleusercontent.com';
      
        $options = [
          'authurl'       => 'https://accounts.google.com/o/oauth2/auth',
          'tokenurl'      => 'https://accounts.google.com/o/oauth2/token',
          'clientid'      => $clientid,
          'clientsecret'  => $clientsecret,
          'redirecturi'   => JURI::base() . 'index.php?option=com_simplemembership&task=socialLogin',
          // if this url - lot error with google login attemp many times, so we fix this with check user logined or not and change "return url" in module
          /**
           * Authorization scopes, space separated.
           *
           * @see https://developers.google.com/+/web/api/rest/oauth#authorization-scopes
           */
          'scope'         => 'profile email',
          'requestparams' => [
            'access_type'            => 'online',
            'include_granted_scopes' => 'true',
            'prompt'                 => 'select_account',
          ],
        ];
        $optionRegistry = new JRegistry($options);
        $httpClient         = JHttpFactory::getHttp($optionRegistry);
        
        $oAuth2Client = new OsOAuth2Client($options, $httpClient);
        $connector    = new OsOAuth2($options, $oAuth2Client);

        list($token, $connector) = getToken($connector);
        // echo '111111111111111'; exit;
        if($token === false) return;
        //getSocialNetworkProfileInformation
        $options       = new JRegistry();
        $googleUserApi = new OsOpenID($options, $connector);
        $userInfo = $googleUserApi->getOpenIDProfile();
        $user_email = $userInfo['email'];
        $user_social_id = $userInfo['sub'];
        $user_name = $userInfo['given_name'];
        $user_surname = $userInfo['family_name'];
        $user_img_link = $userInfo['picture'];
        $network = 'google';
        
    }
    
    
    $query = "SELECT COUNT(*) FROM #__simplemembership_users WHERE registration_type='$network' AND social_id=".$user_social_id;
    $database->setQuery($query);
    $user_count = $database->loadResult();
    // var_dump($network);
    // var_dump($user_count);
    if($user_count > 0){
        $query = "SELECT fk_users_id FROM #__simplemembership_users WHERE registration_type='$network' AND social_id=".$user_social_id;
        $database->setQuery($query);
        $user_id = $database->loadResult();
        
        $user = JFactory::getUser($user_id);
        $user_login = $user->username;
        $user_pass = sha1($user->registerDate . $user_email . 'OradaSoft');
    }else{
        $default_group = $user_configuration['default_group'];
        if($default_group == 0) $default_group = array(2);

        
        $query = "SELECT COUNT(*) FROM #__users WHERE email='" . $user_email . "'";
        $database->setQuery($query);
        $usrCount = $database->loadResult();
        
        $new_user = new Juser();
        $new_user->name = $user_name . ' ' . $user_surname;
        $new_user->username = $user_name . '-' . $user_surname . '-' . $network;
        if($usrCount > 0){
            $new_user->email = $network . '/' . $user_email;
        }else{
            $new_user->email = $user_email;
        }
        // $new_user->groups = $default_group;
        
        //$new_user->usertype = $default_group_name;
        $new_user->block = 0;
        $new_user->activation = 0;
        $new_user->registerDate = date('Y-m-d h:i:s');
        $new_user->password = JUserHelper::hashPassword(sha1($new_user->registerDate . $user_email . 'OradaSoft'));

        
        if (!$new_user->save()) {
            $error_msg = 'Error! User is not save!';
        }else{
        
            $query = "SELECT id FROM #__users WHERE email='$new_user->email'";
            $database->setQuery($query);
            $user_id = $database->loadResult();
            if(is_array($user_configuration['default_group'])){
              $default_group_array = explode(',', $user_configuration['default_group']);
            }else{
              $default_group_array = array(2);
            }
            
            foreach($default_group_array as $group){
                if($group == '') continue;
                $query = "INSERT INTO #__user_usergroup_map (user_id, group_id) "
                        . "VALUES ('$user_id', '$group')";
                $database->setQuery($query);
                $database->execute();
            }
            if($network == 'google'){
                $user_img_link_array = explode('/', $user_img_link);
                $user_img_link_array_count = count($user_img_link_array);
                $img_file_name = $user_img_link_array[$user_img_link_array_count - 1];
                $img_file_name = 'user-' . $user_id . '-' . $img_file_name;
                $new_img_path = '/images/' . $img_file_name;
            }elseif($network == 'facebook'){
                $img_file_name = rand() . 'user-' . $user_id;
                $new_img_path = '/images/' . $img_file_name;
            }
            copy($user_img_link, JPATH_SITE . $new_img_path);

            $user_profile = array();
            $user_profile['profile.file'] = $new_img_path;

            $query = "INSERT INTO #__user_profiles (user_id, profile_key, profile_value, ordering) "
                    . "VALUES('$user_id', 'profile.file', '$new_img_path', 1)";
            $database->setQuery($query);
            $database->execute();

            $user = new JUser();
            $user->load($user_id);
            $al_user = new mos_alUser($database);
            $al_user->bind($_POST);
            $al_user->email = $user->email;
            $al_user->name = $user->name;
            $al_user->username = $user->username;
            $al_user->fk_users_id = $user->id;
            //$al_user->expire_date = 0;
            $al_user->current_gid = -2;
            $al_user->current_gname = 'Default';
            $al_user->last_approved = date("Y-m-d H:i:s");
            $al_user->registration_type = $network;
            $al_user->social_id = $user_social_id;
            $al_user->block = 0;
            $al_user->store();

            $user_login = $user->username;
            $user_pass = sha1($user->registerDate . $user_email . 'OradaSoft');
        }
    }
    $session = JFactory::getSession();
    
    if($network == 'google'){
      $input->set('username', $user_login);
      $_POST[$session->getFormToken()] = 1;
      $_REQUEST['username'] = $user_login;
      $_REQUEST['password'] = $user_pass;
      // var_dump($user_login);
      // var_dump($user_pass);
      // exit;
      $data['return'] = $return_url;
      
      // Set the return URL in the user state to allow modification by plugins
      $app->setUserState('users.login.form.return', $data['return']);

      // Get the log in options.
      $options = array();
      $options['remember'] = $input->getBool('remember', false);
      $options['return']   = $data['return'];

      // Get the log in credentials.
      $credentials = array();
      $credentials['username']  = $user_login;
      $credentials['password']  = $user_pass;
      $credentials['secretkey'] = '';
      // var_dump($app->login($credentials, $options));
      if (true !== $app->login($credentials, $options))
      {
        // Login failed !
        // Clear user name, password and secret key before sending the login form back to the user.
        $data['remember'] = (int) $options['remember'];
        $data['username'] = '';
        $data['password'] = '';
        $data['secretkey'] = '';
        $app->setUserState('users.login.form.data', $data);
        var_dump(Route::_('index.php?option=com_users&view=login', false));
        $app->redirect(Route::_('index.php?option=com_users&view=login', false));
      }
      $app->redirect($data['return']);
      
    }
    

    echo json_encode(array("success"=>true, "user_login"=>$user_login, "user_pass"=>$user_pass));
    return;
}

function getToken($connector)
  {
    

    /**
     * I have to do this because Joomla's Google OAuth2 connector is buggy :@ The googlize() method assumes that
     * the requestparams option is an array. However, when you construct the object Joomla! will "helpfully" convert
     * your original array into an object. Therefore trying to later access it as an array causes a PHP Fatal Error
     * about trying to access an stdClass object as an array...!
     */
    $connector->setOption('requestparams', [
      'access_type'            => 'online',
      'include_granted_scopes' => 'true',
      'prompt'                 => 'select_account',
    ]);
    
    $token = $connector->getToken();
    if (!$token || !array_key_exists('access_token', $token))
    {
      //get data
      $ret_arr = array($connector->authenticate(), $connector) ;
    } else{
      $ret_arr = array($token, $connector) ;
    }

    return $ret_arr;
  }

  // if(!function_exists('getReturnURL_SM2')) {
  function getReturnURL_SM2_comp($params, $type)
  {
    $app  = JFactory::getApplication();
    $item = $app->getMenu()->getItem($params->get($type));
    if ($item)
    {
      $lang = '';

      if ($item->language !== '*' && JLanguageMultilang::isEnabled())
      {
        $lang = '&lang=' . $item->language;
      }

      $url = 'index.php?Itemid=' . $item->id . $lang;
    }
    else
    {
      // Stay on the same page
      $url = JUri::getInstance()->toString();
    }
    return  $url;
  }

// }
