<?php
 /**
   * The template for Blog.
   * Template Name: Blog
   *
   * @package   ospersonality WordPress Theme
   * @copyright  Copyright (C) 2016, OrdaSoft
   * @license      http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
*/
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

ospersonality_header_home();
?>
<div id="main" class="site-main">
    <div id="blog-sidebar" class="site-content">
    
    <?php the_title( '<h1 class="page-title">', '</h1>' ); ?>

        <div class="row">
            
            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar-left" class="sidebar">
                <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>


            <?php if($sidebar_left) :
                echo ('<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">');
                echo ('<div class="blog">');
            else :
                echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
                echo ('<div class="blog container">');
            endif; ?>
            <?php
                $published_posts = wp_count_posts()->publish;
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args=array(
                    'paged'=>$paged,
                );
                $ospersonality_query = null;
                $ospersonality_query = new WP_Query($args);
                    if( $ospersonality_query->have_posts() ) {
                    while( $ospersonality_query->have_posts() ){ $ospersonality_query->the_post();
                   
                            $image_id = get_post_thumbnail_id();
                            $image_url = wp_get_attachment_image_src($image_id,800,800);
                            $image_url = $image_url[0]; ?>
                            <section class="loop-item post-item">
                                <section class="post-block">
                                    <section class="img-block">
                                    <?php the_post_thumbnail(array(500,250)); ?>
                                    </section>
                                    <?php get_template_part( 'template-parts/content', get_post_format() ); ?>
                                </section>
                            </section>

                        <?php } ?>

                    <?php  wp_reset_postdata();
                        } else {
                            get_template_part( 'template-parts/content', 'none' );
                        } ?>

                    </div>
                </div>

        </div><!--row end-->

        <div class="pagination">
            <?php  ospersonality_pagenavi($published_posts,$posts_per_page); ?>
        </div>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>