<?php
/**
   * The template for Header.
   *
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<!--<![endif]-->

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>
    <div id="page-preloader">
        <div class="cssload-loader">Loading...</div>
    </div>

    

    <div id="site" class="hfeed site">

        <header id="header" class="header">


                <section class="row">
                    <section class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="theme menu-container">
                            <div id="navbar" class="navbar">
                                <nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
                                    <button class="menu-toggle"><i class="fa fa-navicon" aria-hidden="true"></i></button>
                                    <a class="screen-reader-text skip-link" href="#content"><?php _e( 'Skip to content', 'ospersonality' ); ?></a>
                                    <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
                                </nav><!-- #site-navigation -->
                            </div><!-- #navbar -->
                        </div>
                    </section>
                </section>

            <?php if ( get_header_image() ) : ?>
            <section class="header-top" style="background-image:url(<?php header_image(); ?>);">
                <section class="overlay-header">
                    <ul>
                        <li></li>
                        <li></li>
                        <li></li>
                        <li></li>
                        <li></li>
                    </ul>
                </section>
            <?php else : ?>
            <section class="header-top" style="background-image:url(<?php echo get_template_directory_uri(); ?>/images/header.jpg);">
                <section class="overlay-header">
                    <ul>
                        <li></li>
                        <li></li>
                        <li></li>
                        <li></li>
                        <li></li>
                    </ul>
                </section>
            <?php endif; ?>
                <section class="row for-menu">
                    <section class="col-lg-12 col-md-12 col-sm-12 col-xs-12 logo-img">
                    <?php
                     ospersonality_the_custom_logo();
                        if ( is_front_page() && is_home() ) : ?>
                        <h1 class="site-title">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo(  'name' ); ?></a>
                        </h1>
                        <?php else : ?>
                        <h1 class="site-title">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
                        </h1>
                        <?php endif;
                        $description = get_bloginfo( 'description', 'display' );
                        if ( $description || is_customize_preview() ) : ?>
                        <p class="site-description"><?php echo $description; ?></p>
                        <?php endif; ?>
                    </section>
                    
                </section>
                <section class="header-social">
                    <div class="container">
                    <?php get_template_part( 'template-parts/social' ); ?>
                    </div>
                </section>
            </section>

            

            

            

            

        </header><!-- header -->