<?php
/**
 * ospersonality functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 *
 * @package WordPress
 * @subpackage ospersonality
 * @since ospersonality 1.0
 *
 */
require_once get_template_directory() . '/plg/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'ospersonality_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
function ospersonality_register_required_plugins() {
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        // This is an example of how to include a plugin bundled with a theme.
        array(
            'name'               => 'Contact Form 7', // The plugin name.
            'slug'               => 'contact-form-7', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/contact-form-7.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Display Widgets', // The plugin name.
            'slug'               => 'display-widgets', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/display-widgets.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Newsletter widget', // The plugin name.
            'slug'               => 'newsletter-widget', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/newsletter-widget.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Responsive Lightbox', // The plugin name.
            'slug'               => 'responsive-lightbox', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/responsive-lightbox.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'SyntaxHighlighter Evolved', // The plugin name.
            'slug'               => 'syntaxhighlighter', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/syntaxhighlighter.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),


        array(
            'name'               => 'WooCommerce', // The plugin name.
            'slug'               => 'woocommerce', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/woocommerce.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Woocommerce products filter', // The plugin name.
            'slug'               => 'woocommerce-products-filter', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/woocommerce-products-filter.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'WP Google Maps', // The plugin name.
            'slug'               => 'wp-google-maps', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/wp-google-maps.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Wordpress importer', // The plugin name.
            'slug'               => 'wordpress-importer', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/wordpress-importer.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Widget Importer & Exporter', // The plugin name.
            'slug'               => 'widget-importer-exporter', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plg/plugins/widget-importer-exporter.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),


       /* This is an example of how to include a plugin from a GitHub repository in your theme.
        This presumes that the plugin code is based in the root of the GitHub repository
        and not in a subdirectory ('/src') of the repository.*/
       /* array(
            'name'      => 'Adminbar Link Comments to Pending',
            'slug'      => 'adminbar-link-comments-to-pending',
            'source'    => 'https://github.com/jrfnl/WP-adminbar-comments-to-pending/archive/master.zip',
        ),

        // This is an example of how to include a plugin from the WordPress Plugin Repository.
        array(
            'name'      => 'Contact Form 7',
            'slug'      => 'contact-form-7',
            'required'  => false,
        ),*/

    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     */
    $config = array(
        'id'           => 'ospersonality',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );
}


remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );
function ospersonality_customize_css() {
    ?>
    <style>
        body {
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_font_color', '#323943' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_body_font', 'Josefin Sans,sans-serif' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'ospersonality_font_size', '18' )); ?>px;
        }
        #navbar #primary-navigation #menu-menu li a,
        .nav-menu ul li a,
        ul.main_menu.nav.navbar-nav > li > a {
            font-size:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_font_size', '14' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_color', '#ffffff' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_font', 'Catamaran, sans-serif' )); ?>;
        }

         #navbar #primary-navigation #menu-menu li a:hover,
         .nav-menu ul li a:hover,
        ul#menu-menu > li > a:hover {
            text-decoration:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_underline_hover', 'underline;' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_hover_color', '#ff6700' )); ?>;
        }
        .children li a,
        #navbar #primary-navigation #menu-menu li .sub-menu li a {
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_submenu_color', '#fff' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_font', 'Catamaran, sans-serif' )); ?>;
        }
        .children li a:hover,
        #navbar #primary-navigation #menu-menu li .sub-menu li a:hover {
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_submenu_hover_color', '#ff6700' )); ?> !important;
             text-decoration:<?php echo esc_attr(get_theme_mod( 'ospersonality_menu_underline_hover', 'none;' )); ?>;
        }
        #primary-navigation .nav-menu ul li.page_item,
        #menu-menu li {
            margin: <?php echo esc_attr(get_theme_mod( 'ospersonality_menu_margin', '5' )); ?>px;
        }
        #copyright a,
        #copyright p {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_copyright_font', 'Josefin Sans,sans-serif' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'ospersonality_copyright_font_size', '18' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_copyright_color', '#fff' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'ospersonality_copyright_underline', 'none' )); ?>;
        }
        #copyright a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_copyright_hover_color', '' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'ospersonality_copyright_underline_hover', 'none' )); ?>;
        }
        .social-icons p,
        .social-icons a{
            font-size:<?php echo esc_attr(get_theme_mod( 'ospersonality_soc_size', '25' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_soc_color', '#323943' )); ?>;
        }
        #social a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_soc_color_hover', '#fff' )); ?>;
        }
        body h1 {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_h1_font', 'Catamaran, sans-serif' )); ?>;
            color:<?php echo get_theme_mod( 'ospersonality_h1_color', '#323943' ); ?>;
        }
        body h2 {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_h2_font', 'Catamaran, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_h2_color', '#ff8b3d' )); ?>;
        }
        body h3 {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_h3_font', 'Catamaran, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_h3_color', '#323943' )); ?>;
        }
        body h4 {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_h4_font', 'Catamaran, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_h4_color', '#323943' )); ?>;
        }
        body h5 {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_h5_font', 'Catamaran, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_h5_color', '#323943' )); ?>;
        }
        body h6 {
            font-family:<?php echo esc_attr(get_theme_mod( 'ospersonality_h6_font', 'Catamaran, sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'ospersonality_h6_color', '#323943' )); ?>;
        }
        .site-header {
            <?php if(!is_front_page()) echo "background:none;";?>
        }
        #header-1 {
            <?php if(is_front_page()) echo "padding-bottom:117px;";?>
        }
        .site-footer {
            background: <?php echo esc_attr(get_theme_mod( 'ospersonality_footer_background', '#323943' )); ?>;
        }
    </style>
<?php
}
add_action( 'wp_head', 'ospersonality_customize_css');

//----------------custom logo-------------------
function ospersonality_the_custom_logo() {
   if ( function_exists( 'the_custom_logo' ) ) {
      the_custom_logo();
   }
}


function add_googleanalytics() { ?>
    <script type="text/javascript">
    <?php echo esc_attr(get_theme_mod( 'ospersonality_add_googleanalytics', '' )); ?>
    </script>
<?php
}
add_action('wp_footer', 'add_googleanalytics');

function ospersonality_customize_preview_js() {
    wp_enqueue_script( 'ospersonality-customizer', get_template_directory_uri() . '/js/theme-customizer.js', array( 'customize-preview' ), '20120187', true );
}

function ospersonality_after_setup_theme() {
    add_action( 'customize_preview_init', 'ospersonality_customize_preview_js' );
}
add_action( 'after_setup_theme', 'ospersonality_after_setup_theme' );

function ospersonality_callback(){
    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'woocommerce' );
    add_theme_support( 'custom-logo', array(
       'header-text' => array( 'site-title', 'site-description' ),
    ) );
    $args = array(
        'flex-width'    => true,
        'width'         => 980,
        'flex-height'    => true,
        'height'        => 400,
    );
    add_theme_support( 'custom-header', $args );
    add_editor_style( get_template_directory_uri() . '/css/editor-style.css' );
    add_theme_support( 'post-formats', array( 'aside','link','gallery','image','quote','status','video','audio','chat' ) );
    load_theme_textdomain('ospersonality', get_template_directory() . '/languages');
}
add_action('after_setup_theme', 'ospersonality_callback');

//--------Settings themplate
//Add register Menu
register_nav_menu( 'primary', __( 'Navigation Menu', 'ospersonality' ) );


require get_template_directory() . '/inc/settings_template.php';

//--------IE-------
add_action( 'wp_head', 'ospersonality_head_callback' );
    function ospersonality_head_callback() {
        global $wp_styles;
        wp_enqueue_style( 'ospersonality-ie', get_template_directory_uri() . "/css/ie.css", array( 'ospersonality' )  );
        $wp_styles->add_data( 'ospersonality-ie', 'conditional', 'lt IE 8' ); ?>
        <!--[if IE]><script src="<?php echo get_template_directory_uri();
 ?>/js/html5.js"></script><!--[endif]-->
 <?php
 } // end wp_head callback

if ( ! isset( $content_width ) )
    $content_width = 604;


//--------Widgets

function ospersonality_sidebar_init() {
    register_sidebar(
        array(
            'name'          => __( 'SideBar Left', 'ospersonality' ),
            'id'            => 'sidebar_left',
            'description'   => __( 'Appears in the left column of the site.', 'ospersonality' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
            ) );

    register_sidebar(
        array(
            'name'          => __( 'SideBar Right', 'ospersonality' ),
            'id'            => 'sidebar_right',
            'description'   => __( 'Appears in the right column of the site.', 'ospersonality' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
            ) );

    register_sidebar(
        array(
            'id' => 'content_top',
            'name' => __( 'Content top', 'ospersonality'),
            'description' => __( 'Content top', 'ospersonality' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_content_top">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'subscribe_position',
            'name' => __( 'Subscribe Position', 'ospersonality'),
            'description' => __( 'Subscribe Position', 'ospersonality' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_subscribe_position">',
            'after_title' => '</h3>'
        ) );


    register_sidebar(
        array(
            'id' => 'content_bottom_left',
            'name' => __( 'Content bottom left', 'ospersonality'),
            'description' => __( 'Content bottom left', 'ospersonality' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'content_bottom_right',
            'name' => __( 'Content bottom right', 'ospersonality'),
            'description' => __( 'Content bottom right', 'ospersonality' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>'
        ) );
}
add_action( 'widgets_init', 'ospersonality_sidebar_init' );

//css styles connect to the admin

function ospersonality_style_backend() {
    wp_enqueue_script( 'customizer-pro', get_template_directory_uri() . '/js/customizer-pro.js', '1.0', 'jquery', true);
    wp_enqueue_style( 'admin_style', get_template_directory_uri()  .  '/css/admin_style.css' );
    wp_enqueue_style( 'font-awesomes', get_template_directory_uri()  .  "/css/font-awesome.min.css" );

}
add_action( 'admin_enqueue_scripts', 'ospersonality_style_backend' );


//styles and scripts

function ospersonality_rigistre_scripts() {

    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/bootstrap/js/bootstrap.js', array( 'jquery' ), false);

    wp_enqueue_script( 'functions', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '1.0.0', true );

     wp_enqueue_script('swiper',   get_template_directory_uri() . '/js/swiper.min.js','','3.1.7' , array( 'jquery' ), false);

      if(is_front_page()) :
     wp_enqueue_script('jquery-custom-home',   get_template_directory_uri() . '/js/custom-home.js','1.0', array( 'jquery' ), true);
     endif;

     wp_enqueue_script('jquery-custom',   get_template_directory_uri() . '/js/custom.js','1.0', array( 'jquery' ), true);

    wp_enqueue_script('viewportchecker',   get_template_directory_uri() . '/js/jquery.viewportchecker.min.js','1.0', array( 'jquery' ), true);

    wp_enqueue_style('style-bootstrap', get_template_directory_uri() . '/bootstrap/css/bootstrap.css', array(), '3.3.4', 'all');

    wp_enqueue_style('style-main',   get_stylesheet_uri(), array() );

    wp_enqueue_style('style-swiper',   get_template_directory_uri() . '/css/swiper.min.css', array(), '3.1.7', 'all');
    wp_enqueue_style('style-animate',   get_template_directory_uri() . '/css/animate.css', array(), '3.1.7', 'all');

    wp_enqueue_style('font-awesome',  get_template_directory_uri() . '/css/font-awesome.min.css', array(), '4.4.0', 'all');

    wp_enqueue_style('ionicons',   get_template_directory_uri() . '/css/ionicons.min.css', array(), '2.0.0', 'all');

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
    }

    wp_enqueue_style('fonts','//fonts.googleapis.com/css?family=Rubik:400,300,300italic,400italic,900italic,900,700italic,700,500italic,500|Cuprum:700italic,400,400italic,700|Josefin+Sans:100,300,400,600,700,100italic,300italic,400italic,600italic,700italic|Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic|Orbitron:400,500,700,900|Alegreya+SC:400,400italic,700,700italic,900,900italic|Comfortaa:400,300,700|Abel|Dosis:400,200,300,500,600,700,800|Droid+Sans:400,700|Francois+One|Exo:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic|Tangerine:400,700|Lato:400,100,300,400italic,300italic,100italic,700,700italic,900,900italic|Lobster|Lora:400,400italic,700,700italic|Cabin:400,500,600,700|Catamaran:400,900,700,500,600,100|Oswald:300,400,700|Open+Sans+Condensed:300,300italic,700|Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800italic,800|Oswald:400,300,700|Oxygen:400,300,700|Philosopher:400,700,400italic,700italic|Playfair+Display+SC:400,400italic,700,700italic,900,900italic|PT+Sans+Narrow:400,700|PT+Sans:400,400italic,700,700italic|Prosto+One|Quicksand:400,300,700|Roboto+Condensed:400,300,300italic,400italic,700,700italic|Share:400,400italic,700,700italic|Source+Sans+Pro:400,200,200italic,300,300italic,400italic,600,600italic,700,700italic,900,900italic|Montserrat:400,700|Merriweather:400,300italic,300,400italic,700,700italic,900,900italic|Ubuntu+Condensed|Ubuntu:400,300,300italic,400italic,500,500italic,700,700italic&subset=latin,cyrillic-ext,latin-ext,cyrillic');
}
add_action( 'wp_enqueue_scripts', 'ospersonality_rigistre_scripts' );

//excerpt
function ospersonality_excerpt($num) {
    $limit = $num+1;
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
    echo $excerpt;
}

function ospersonality_post_nav() {
    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous ) {
        return;
    }
    ?>
    <nav class="navigation post-navigation" role="navigation">
        <h1 class="screen-reader-text"><?php _e( 'Post navigation', 'ospersonality' ); ?></h1>
        <div class="nav-links">
            <?php
            if ( is_attachment() ) :
                previous_post_link( '%link', __( '<span class="meta-nav">Published In</span>%title', 'ospersonality' ) );
            else :
                previous_post_link( '%link', __( '<span class="meta-nav">Previous Post: </span>%title', 'ospersonality' ) );
                next_post_link( '%link', __( '<span class="meta-nav">Next Post: </span>%title', 'ospersonality' ) );
            endif;
            ?>
        </div><!-- .nav-links -->
    </nav><!-- .navigation -->
    <?php
}

function ospersonality_entry_meta() {
    if ( is_sticky() && is_home() && ! is_paged() )
        echo '<span class="featured-post">' . __( 'Sticky', 'ospersonality' ) . '</span>';

    // Translators: used between list items, there is a space after the comma.
    $categories_list = get_the_category_list( __( ', ', 'ospersonality' ) );
    if ( $categories_list ) {
        echo '<span class="categories-links"><i class="fa fa-folder-open" aria-hidden="true"></i>' . $categories_list . '</span>';
    }

    // Translators: used between list items, there is a space after the comma.
    $tag_list = get_the_tag_list( '', __( ', ', 'ospersonality' ) );
    if ( $tag_list ) {
        echo '<span class="tags-links"><i class="fa fa-tags" aria-hidden="true"></i>' . $tag_list . '</span>';
    }

    // Post author
    if ( 'post' == get_post_type() ) {
        printf( '<span class="author vcard"><i class="fa fa-user-plus" aria-hidden="true"></i><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
        esc_attr( sprintf( __( 'View all posts by %s', 'ospersonality' ), get_the_author() ) ),
        get_the_author()
        );
    }
};

function ospersonality_entry_date( $echo = true ) {
    $date = sprintf( '<span class="date"><i class="fa fa-calendar-o" aria-hidden="true"></i><a href="%s" title="%s" rel="bookmark"><time class="entry-date" datetime="%s"><span class="date--day">%s</span> <span class="date--month">%s</span> <span class="date--year">%s</span></time></a></span>',
    esc_url( get_permalink() ),
    esc_attr( sprintf( __( 'Permalink to %s', 'ospersonality' ), the_title_attribute( 'echo=0' ) ) ),
    esc_attr( get_the_date( 'c' ) ),
    esc_attr( get_the_date( 'd' ) ),
    esc_attr( get_the_date( 'M' ) ),
    esc_attr( get_the_date( 'Y' ) )
);

    if ( $echo )
        echo $date;

    return $date;
};

function ospersonality_the_attached_image() {
    /**
    * Filter the image attachment size to use.
    * @param array $size {
    *  @type int The attachment height in pixels.
    *  @type int The attachment width in pixels.
    * }
    */
    $attachment_size = apply_filters( 'ospersonality_attachment_size', array( 724, 724 ) );
    $next_attachment_url = wp_get_attachment_url();
    $post  = get_post();

    /*
    * Grab the IDs of all the image attachments in a gallery so we can get the URL
    * of the next adjacent image in a gallery, or the first image (if we're
    * looking at the last image in a gallery), or, in a gallery of one, just the
    * link to that image file.
    */
    $attachment_ids = get_posts( array(
        'post_parent'    => $post->post_parent,
        'fields'         => 'ids',
        'numberposts'    => -1,
        'post_status'    => 'inherit',
        'post_type'      => 'attachment',
        'post_mime_type' => 'image',
        'order'          => 'ASC',
        'orderby'        => 'menu_order ID'
    ) );

    // If there is more than 1 attachment in a gallery...
    if ( count( $attachment_ids ) > 1 ) {
        foreach ( $attachment_ids as $attachment_id ) {
        if ( $attachment_id == $post->ID ) {
            $next_id = current( $attachment_ids );
        break;
        }
    }

    // get the URL of the next image attachment...
    if ( $next_id )
        $next_attachment_url = get_attachment_link( $next_id );

    // or get the URL of the first image attachment.
    else
        $next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
    }

    printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>',
    esc_url( $next_attachment_url ),
    the_title_attribute( array( 'echo' => false ) ),
    wp_get_attachment_image( $post->ID, $attachment_size )
    );
}

function ospersonality_pagenavi($post_type ='',$posts_per_page = '') {

   $count_posts = wp_count_posts();


    $big = 999999999;
    $args = array(
        'ospersonality' => str_replace( $big, '%#%', get_pagenum_link( $big, false ) )
        ,'fobsat' => ''
        ,'current' => max( 1, get_query_var('paged') )
        ,'total' => ceil($count_posts->publish/$posts_per_page  )

    );
    $result = paginate_links( $args );
    $result = str_replace( '/page/1"', '"', $result );

    echo $result;
}


function get_my_widgets() {
    foreach ($GLOBALS['wp_registered_sidebars'] as $sidebar)
    {
        $sidebar_options[$sidebar['id']] = $sidebar['name'];
        //print_r($sidebar);exit();
    }
}

add_action('init','get_my_widgets');

/*-------gallery---------*/

add_action('init', 'gallery');
function gallery() {
    register_post_type('gallery', array(
    'public' => true,
    'supports' => array('title','thumbnail'),
    'menu_icon' => 'dashicons-images-alt',
    'labels' => array(
        'name' => 'Gallery',
        'add_new' => 'Add new',
        'all_items' => 'All',
        'add_new_item' => 'Add new'
        )
    ));
}
/*-------services---------*/

add_action('init', 'services');
function services() {
    register_post_type('services', array(
    'public' => true,
    'supports' => array('title','editor','thumbnail'),
    'menu_icon' => 'dashicons-share-alt',
    'labels' => array(
        'name' => 'Services',
        'add_new' => 'Add new',
        'all_items' => 'All',
        'add_new_item' => 'Add new'
        )
    ));
}

/*-------osslider---------*/

// add_action('init', 'osslider');
// function osslider() {
//     register_post_type('osslider', array(
//     'public' => true,
//     'supports' => array('title','editor','thumbnail'),
//     'menu_icon' => 'dashicons-share-alt',
//     'labels' => array(
//         'name' => 'Slider',
//         'add_new' => 'Add new',
//         'all_items' => 'All',
//         'add_new_item' => 'Add new'
//         )
//     ));
// }
/*-----------------------include header-----------------------------*/
function ospersonality_header() {
    if ((get_theme_mod('ospersonality_header_layout_other')) === 'header' ) :
        get_header();
    elseif ((get_theme_mod('ospersonality_header_layout_other')) === 'header-main' ) :
        get_header('main');
    else :
        get_header('main');
    endif;
}
/*-----------------------include header home page-----------------------------*/
function ospersonality_header_home() {
    if ((get_theme_mod('ospersonality_header_layout_home')) === 'header' ) :
        get_header();
    elseif ((get_theme_mod('ospersonality_header_layout_home')) === 'header-main' ) :
        get_header('main');
    else :
        get_header();
    endif;
}


if ( ! function_exists( 'ospersonality_the_custom_logo' ) ) :
function ospersonality_the_custom_logo() {
    if ( function_exists( 'the_custom_logo' ) ) {
        the_custom_logo();
    }
}
endif;

function ospersonality_customize_blogdescription() {
    bloginfo( 'description' );
}

function ospersonality_customize_blogname() {
    bloginfo( 'name' );
}


function ospersonality_header_style() {
    ?>
    <style type="text/css" id="ospersonality-header-css">
    <?php
        if ( ! display_header_text() ) :
    ?>
        .site-title,
        .site-description {
            display: none;
        }
    <?php endif; ?>
    </style>
    <?php
}
add_action( 'wp_enqueue_scripts', 'ospersonality_header_style', 11 );