<?php
 /**
   * The template for Home page.
   * Template Name: Home
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
   */
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}

$content_top = false;
if (is_active_sidebar( 'content_top' ) ) {
    $content_top = true;
}

ospersonality_header_home()
?>

<div id="main" class="site-main">

    

        <!--  Widget top content -->

        <section class="row">
            <?php if (is_active_sidebar( 'content_top' ) ) : ?>
            <section class="col-lg-12">
                <article id="content-top">
                    <?php  dynamic_sidebar('content_top'); ?>
                </article>
            </section>
            <?php endif; ?>
        </section>

       <!--  Home page content -->


          


        <!--  Last post on home page -->

        <section class="blog-content">
            <section class="blog-title container">
                <h1 class="block-title">
                <?php echo esc_attr(get_theme_mod( 'ospersonality_home_blog_title', 'Personal Blog' )); ?>  </h1>
                <p class="block-desc">
                <?php echo esc_attr(get_theme_mod( 'ospersonality_home_blog_desc', 'I am a traveler and photographer, and this is my vision of everything!' )); ?>
                </p>
            </section>
            <?php get_template_part( 'template-parts/loop' ); ?>
        </section>

        <!--  services -->

        <div id="services" class="services">
            <div class="services-overlay"></div>
            <section class="services-title container">
                <h1 class="block-title"><?php _e('I suggest','ospersonality'); ?></h1>
                <p class="block-desc"><?php _e('Services are available at the moment!','ospersonality'); ?></p>
            </section>

            <?php get_template_part( 'template-parts/services' ); ?>
        </div>

        <!--  shop -->

        <div id="shop-section" class="" style="<?php echo esc_attr(get_theme_mod( 'ospersonality_shop_show', 'display:none' )); ?>;">
            <div class="gradient-block"></div>
            <section class="shop-title container">
                <h1 class="block-title">
                <?php echo esc_attr(get_theme_mod( 'ospersonality_home_shop_title', 'My shop' )); ?>
                </h1>
                <p class="block-desc">
                <?php echo esc_attr(get_theme_mod( 'ospersonality_home_shop_desk', 'Tourist routes and trips all inclusive!' )); ?>
                </p>
            </section>
            <div class="store">
                <?php get_template_part( 'template-parts/products' ); ?>
            </div>
        </div>

        

        <?php
        
        $content_bottom_right = false;
        if (is_active_sidebar( 'content_bottom_right' ) ) {
        $content_bottom_right = true;
        }
        $content_bottom_left = false;
        if (is_active_sidebar( 'content_bottom_left' ) ) {
        $content_bottom_left = true;
        } ?>
        <section id="info-block" class="info-block">

            <section class="info-title container">
                <h1 class="block-title">
                <?php _e('INFORMATION','ospersonality'); ?>
                </h1>
                <p class="block-desc"><?php _e('Info block','ospersonality'); ?></p>
            </section>

            <div class="row info-bg">
                <?php if ( $content_bottom_left ) : ?>
                <div class="<?php if ( $content_bottom_right && $content_bottom_left) :
                        echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12 widgets');
                        else :
                        echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12 widgets');
                        endif; ?>">
                    <?php  dynamic_sidebar( 'content_bottom_left' ); ?>
                </div>
                <?php endif; ?>
                <?php if ( $content_bottom_right ) : ?>
                <div class="<?php if ( $content_bottom_right && $content_bottom_left) :
                        echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12 widgets');
                        else :
                        echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12 widgets');
                        endif; ?>">
                    <?php dynamic_sidebar('content_bottom_right'); ?>
                </div>
                <?php endif; ?>
            </div>
            
        </section>

        <section class="row">
            <section class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
            <?php get_template_part( 'template-parts/slider' ); ?>
            </section>
            <section class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
            <?php  $home_query = new WP_Query( 'pagename=home' );
              if ( $home_query->have_posts() ) {
                while ( $home_query->have_posts() ) : $home_query->the_post(); ?>
                <div id="home-content" class="home-content" style="<?php echo esc_attr(get_theme_mod( 'ospersonality_content_show' )); ?>">
                <div class="gradient-block"></div>
                <div class="content-block">
                    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
            <?php endwhile;
             wp_reset_postdata();
             } else { ?>

            <?php } ?>
            <?php $subscribe_position = false;
                if (is_active_sidebar( 'subscribe_position' ) ) {
                $subscribe_position = true;
                } ?>
                <?php if (is_active_sidebar( 'subscribe_position' ) ) : ?>
                <article id="subscribe-position">
                    <?php  dynamic_sidebar('subscribe_position'); ?>
                </article>
                <?php endif; ?>
            </section>
        </section>

        <div id="any-section" style="<?php echo esc_attr(get_theme_mod( 'ospersonality_any_section_show', 'display:none' )); ?>;">
            <section class="any-title container">
                <h1 class="block-title">
                <?php echo esc_attr(get_theme_mod( 'ospersonality_any_section_title', 'Contact me' )); ?>  
                </h1>
                <p class="block-desc">
                <?php echo esc_attr(get_theme_mod( 'ospersonality_any_section_desc', 'Contact form' )); ?>
                </p>
            </section>
            <section class="contact-bg">
            <section class="overlay">
                <ul>
                    <li></li>
                    <li></li>
                    <li></li>
                    <li></li>
                    <li></li>
                </ul>
            </section>   
            <?php echo do_shortcode(get_theme_mod( 'ospersonality_any_shortcode')); ?>
            </section>     
        </div>

        
</div>
<?php get_footer(); ?>