<?php
 /**
   * The Customize  Page.
   *
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license  www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
   */

function ospersonality_customize_register( $wp_customize ) {

/*****************************Customize Control***************/
    class WP_Slider_Customize_Control extends WP_Customize_Control {
        public $type = 'range';

        public function render_content() { ?>

        <label>
            <?php if ( ! empty( $this->label ) ) : ?>
                <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
            <?php endif;
            if ( ! empty( $this->description ) ) : ?>
                <span class="description customize-control-description"><?php echo $this->description; ?></span>
            <?php endif; ?>
            <form onsubmit="return false" oninput="level.value = flevel.valueAsNumber">
              <input name="flevel" id="slider-range" type="range" min="0" max="100" step="1" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); checked( $this->value() ); ?> />
              <output for="slider-range" name="level"><?php echo esc_attr( $this->value() ); ?></output>px
            </form>
        </label>

        <?php
        }
    };



    /****************Remove Standart Section***************/



    $wp_customize->remove_section('colors');
    // $wp_customize->remove_section('background_image');

    $wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

    if ( isset( $wp_customize->selective_refresh ) ) {
        $wp_customize->selective_refresh->add_partial( 'blogname', array(
            'selector' => '.site-title a',
            'container_inclusive' => false,
            'render_callback' => 'osbase_customize_blogname',
        ) );
        $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
            'selector' => '.site-description',
            'container_inclusive' => false,
            'render_callback' => 'osbase_customize_blogdescription',
        ) );
    }


    /***********************General****************************/

    $wp_customize->add_section( 'ospersonality_general_settings' , array(
        'title'      => __( 'General Settings','ospersonality' ),
        'priority'   => 35,
        'capability'     => 'edit_theme_options',
        'description' => __('General settings for <b style="text-transform:uppercase">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
    ) );


        /*--------------Background Colour------------------*/

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'background_color',array(
                'label' => __('Background Color','ospersonality'),
                'section' => 'ospersonality_general_settings',
                'priority'=>10
                )
        ) );

        /*----------Background image------------------*/

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,'background_image',array(
                'label' => __('Background image','ospersonality'),
                'section' => 'ospersonality_general_settings',
                'priority'=>11
                )
        ) );

        /*----------------Background repeat-----------------*/

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_repeat',array(
                'label' => __('Background repeat','ospersonality'),
                'section' => 'ospersonality_general_settings',
                 'type' => 'radio',
                    'priority' => 12,
                    'choices' => array(
                        'no-repeat' => 'No Repeat',
                        'repeat' => 'Tile',
                        'repeat-x' => 'Tile Horizontally',
                        'repeat-y' => 'Tile Vertically',
                ))
        ) );

        /*-----------Background position---------------*/

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_position_x',array(
                'label' => __('Background position','ospersonality'),
                'section' => 'ospersonality_general_settings',
                 'type' => 'radio',
                    'priority' => 13,
                    'choices' => array(
                        'left' => 'Left',
                        'center' => 'Center',
                        'right' => 'Right',
                ))
        ) );

        /*-----------------Background attachment-----------------*/

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_attachment',array(
                'label'=>__('Background attachment','ospersonality'),
                'section'=>'ospersonality_general_settings',
                 'type'=>'radio',
                    'priority'=>14,
                    'choices'=>array(
                        'scroll'=>'Scroll',
                        'fixed'=>'Fixed',
                ))
        ) );

        /*----------------Body font------------------*/

        $wp_customize->add_setting( 'ospersonality_body_font' , array(
            'default' => 'Rubik, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize, 'body_font',array(
                    'label' => __( 'Body Font','ospersonality' ),
                    'settings' => 'ospersonality_body_font',
                    'priority' => 30,
                    'section' =>'ospersonality_general_settings',
                    'type'=>'select',
                    'choices'=>array(
                        "Abel,sans-serif"=>"Abel",
                        "Arial,sans-serif"=>"Arial",
                        "Cuprum"=>"Cuprum",
                        "Comfortaa"=>"Comfortaa",
                        "Catamaran, sans-serif" => "Catamaran",
                        "Cabin, sans-serif" => "Cabin",
                        "Rubik, sans-serif" => "Rubik",
                        "Dosis,sans-serif"=>"Dosis",
                        "Droid Sans,sans-serif"=>"Droid Sans",
                        "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Francois One,sans-serif"=>"Francois One",
                        "Georgia,serif"=>"Georgia",
                        "Helvetica,sans-serif"=>"Helvetica",
                        "Josefin Sans,sans-serif"=>"Josefin Sans",
                        "Lato,sans-serif"=>"Lato",
                        "Lobster,sans-serif"=>"Lobster",
                        "Lora,sans-serif"=>"Lora",
                        "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                        "Open Sans,sans-serif"=>"Open Sans",
                        "Oswald,sans-serif"=>"Oswald",
                        "Oxygen,sans-serif"=>"Oxygen",
                        "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                        "Philosopher"=>"Philosopher",
                        "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                        "PT Sans"=>"PT Sans",
                        "Prosto One,cursive"=>"Prosto One",
                        "Quicksand,sans-serif"=>"Quicksand",
                        "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                        "Roboto,sans-serif"=>"Roboto",
                        "Share,cursive"=>"Share",
                        "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                        "Merriweather,sans-serif"=>"Merriweather",
                        "Times New Roman,sans-serif"=>"Times New Roman",
                        "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                        "Ubuntu,sans-serif"=>"Ubuntu",
                        "Verdana,sans-serif"=>"Verdana"))
            )
        );

        /*----------------Body Font Size-----------------*/

        $wp_customize->add_setting( 'ospersonality_font_size' , array(
            'default'     => '16',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize, 'font_size',array(
                 'label' => __('Body font size','ospersonality'),
                 'section' => 'ospersonality_general_settings',
                 'settings'=> 'ospersonality_font_size',
                 'priority'=>31
                 )
         ) );

        /*-----------------Body font color-----------------*/

        $wp_customize->add_setting('ospersonality_font_color',array(
            'default'=>'#5e5e5e',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize, 'font_color',array(
                'label'=>__('Body font color','ospersonality'),
                'section'=>'ospersonality_general_settings',
                'settings'=>'ospersonality_font_color',
                'priority'=>32
             )
         ) );


        /*--------Read more button text------------------*/

        $wp_customize->add_setting('ospersonality_more_button',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'more_button',array(
                'label'=>__('Replace text in button "Read Now"','ospersonality'),
                'settings' => 'ospersonality_more_button',
                'section' => 'ospersonality_general_settings',
                'priority' => 41,
            )
        ) );

        /*-------------Googleanalytics-----------------*/

        $wp_customize->add_setting('ospersonality_add_googleanalytics',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'add_googleanalytics',array(
                'label'=>__('You can paste your Google Analytics or other tracking code in this box. This will be automatically added to the footer.','ospersonality'),
                'settings' => 'ospersonality_add_googleanalytics',
                'section' => 'ospersonality_general_settings',
                'type' => 'textarea',
                'priority' => 70,
            )
        ) );




    /**************HOME PAGE SETTINGS*********/

    $wp_customize->add_panel( 'ospersonality_home_page' , array(
        'title'      => __( 'Home page','ospersonality' ),
        'priority'   => 40,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Home page blocks and sections settins', 'ospersonality'),
    ) );



                /*-----------------------HEADER------------------*/


        $wp_customize->add_section( 'ospersonality_header_settings' , array(
                'title'      => __( 'Header Settings','ospersonality' ),
                'priority'   => 1,
                'panel' => 'ospersonality_home_page',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'description' => __('Header settings for <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
            ) );

            /*----------------Header Layout-----------*/

            $wp_customize->add_setting( 'ospersonality_header_layout_home',array(
                'default'=>'header',
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage', ) 
            );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'header_layout_home',array(
                    'label'=>__('Header layout for Home page','ospersonality'),
                    'settings'=>'ospersonality_header_layout_home',
                    'section'=>'ospersonality_header_settings',
                    'type'=>'radio',
                    'priority'=>10,
                    'choices'=>array(
                        'header'=>__('Header image','ospersonality'),
                        'header-main'=>__('no header image','ospersonality'),
                    )
                )
            ) );




            // $wp_customize->add_setting( 'ospersonality_header_layout_other',array(
            //     'default'=>'main',
            //     'sanitize_callback' => 'sanitize_text_field',
            //     'type' => 'theme_mod',
            //     'capability'     => 'edit_theme_options',
            //     'transport' => 'postMessage',
            // ) );


            // $wp_customize->add_control(new WP_Customize_Control(
            //     $wp_customize,'header_layout_other',array(
            //         'label'=>__('Header layout for Other page','ospersonality'),
            //         'settings'=>'ospersonality_header_layout_other',
            //         'section'=>'ospersonality_header_settings',
            //         'type'=>'radio',
            //         'priority'=>11,
            //         'choices'=>array(
            //             'header'=>__('Header image','ospersonality'),
            //             'header-main'=>__('no header image','ospersonality'),
            //         )
            //     )
            // ) );
            

            // /*-------------Header title---------------*/
            
            // $wp_customize->add_setting( 'ospersonality_header_title_top' , array(
            //     'default'     => __('Your', 'ospersonality'),
            //     'sanitize_callback' => 'sanitize_text_field',
            //     'type' => 'theme_mod',
            //     'capability'     => 'edit_theme_options',
            //     'transport' => 'postMessage',
            // ) );

            // $wp_customize->add_control(new WP_Customize_Control(
            //     $wp_customize,'header_title_top',array(
            //         'label'=>__('Header title','ospersonality'),
            //         'settings'=> 'ospersonality_header_title_top',
            //         'section'=> 'ospersonality_header_settings',
            //         'type'=>'text',
            //         'priority'=>20,
            //        )
            // ) );

            // $wp_customize->add_setting( 'ospersonality_header_title_center' , array(
            //     'default'     => __('Life', 'ospersonality'),
            //     'sanitize_callback' => 'sanitize_text_field',
            //     'type' => 'theme_mod',
            //     'capability'     => 'edit_theme_options',
            //     'transport' => 'postMessage',
            // ) );

            // $wp_customize->add_control(new WP_Customize_Control(
            //     $wp_customize,'header_title_center',array(
            //         'label'=>__('','ospersonality'),
            //         'settings'=> 'ospersonality_header_title_center',
            //         'section'=> 'ospersonality_header_settings',
            //         'type'=>'text',
            //         'priority'=>21,
            //        )
            // ) );

            // $wp_customize->add_setting( 'ospersonality_header_title_bottom' , array(
            //         'default'     => __('in Focus', 'ospersonality'),
            //         'sanitize_callback' => 'sanitize_text_field',
            //         'type' => 'theme_mod',
            //         'capability'     => 'edit_theme_options',
            //         'transport' => 'postMessage',
            // ) );

            // $wp_customize->add_control(new WP_Customize_Control(
            //     $wp_customize,'header_title_bottom',array(
            //         'label'=>__('','ospersonality'),
            //         'settings'=> 'ospersonality_header_title_bottom',
            //         'section'=> 'ospersonality_header_settings',
            //         'type'=>'text',
            //         'priority'=>22,
            //        )
            // ) );





        $wp_customize->add_section( 'header_image' , array(
            'title'      => __( 'Header Image','ospersonality' ),
            'priority'   => 5,
            'panel' => 'ospersonality_home_page',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Header Image for <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
        ) );



        /*-------------Home page section------------------*/

        $wp_customize->add_section( 'ospersonality_blog_settings',array(
            'title'=>__('Home blog settings','ospersonality'),
            'panel' => 'ospersonality_home_page',
            'priority'=>10,
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Home page settings <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
          ) );

            /*-----------Home blog title----------*/

            $wp_customize->add_setting( 'ospersonality_home_blog_title' , array(
                'default'     => __('Your personal Blog', 'ospersonality'),
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'home_blog_title',array(
                    'label'=>__('Home page blog title','ospersonality'),
                    'settings'=> 'ospersonality_home_blog_title',
                    'section'=> 'ospersonality_blog_settings',
                    'priority'=>10,
                   )
            ) );
            
            /*-----------Home blog description----------*/

            $wp_customize->add_setting( 'ospersonality_home_blog_desc' , array(
                'default'     => __('Blog description', 'ospersonality'),
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'home_blog_desc',array(
                    'label'=>__('Home page blog title','ospersonality'),
                    'settings'=> 'ospersonality_home_blog_desc',
                    'section'=> 'ospersonality_blog_settings',
                    'type' => 'textarea',
                    'priority'=>11,
                   )
            ) );

            /*-----------Home blog num----------*/

            $wp_customize->add_setting( 'ospersonality_home_blog_posts' , array(
                'default'     => __('5', 'ospersonality'),
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'home_blog_posts',array(
                    'label'=>__('Home page posts','ospersonality'),
                    'settings'=> 'ospersonality_home_blog_posts',
                    'section'=> 'ospersonality_blog_settings',
                    'type' => 'number',
                    'priority'=>12,
                   )
            ) );



        /*-----------Home section shop-----------------*/

        $wp_customize->add_section( 'ospersonality_shop_section' , array(
            'title'      => __( 'Shop settings','ospersonality' ),
            'priority'   => 20,
            'panel' => 'ospersonality_home_page',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Shop section settings', 'ospersonality'),
        ) );

            $wp_customize->add_setting( 'ospersonality_shop_show' , array(
                'default'     => 'display:none',
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'shop_show',array(
                    'label'=>__('Shop section on home page show or hide','ospersonality'),
                    'settings'=> 'ospersonality_shop_show',
                    'section'=> 'ospersonality_shop_section',
                    'type'=>'radio',
                    'priority'=>1,
                    'choices'=>array(
                            'display:block'=>'show',
                            'display:none'=>'hide'))
            ) );

            /*----------------Home shop title-------------------------*/

            $wp_customize->add_setting( 'ospersonality_home_shop_title' , array(
                'default'     => __('My shop', 'ospersonality'),
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'home_shop_title',array(
                    'label' => __('Home page shop section title','ospersonality'),
                    'settings' => 'ospersonality_home_shop_title',
                    'section' => 'ospersonality_shop_section',
                    'type' => 'textarea',
                    'priority' => 10,
                   )
            ) );

            /*----------------Home shop desc-------------------------*/

            $wp_customize->add_setting( 'ospersonality_home_shop_desc' , array(
                'default'     => __('Shop description', 'ospersonality'),
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'home_shop_desc',array(
                    'label' => __('Home page shop section description','ospersonality'),
                    'settings' => 'ospersonality_home_shop_desc',
                    'section' => 'ospersonality_shop_section',
                    'type' => 'textarea',
                    'priority' => 11,
                   )
            ) );


            /*--------------Home shop section show products---------------*/

            $wp_customize->add_setting( 'ospersonality_products_show' , array(
                'default'     => '12',
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'products_show',array(
                    'label'=>__('Shop section show products','ospersonality'),
                    'settings'=> 'ospersonality_products_show',
                    'section'=> 'ospersonality_shop_section',
                    'priority'=>20,
                   )
            ) );

            /*----------------Home shop section products column------------------*/

            $wp_customize->add_section( 'any_section' , array(
                'title'      => __( 'Any section settings','ospersonality' ),
                'priority'   => 30,
                'panel' => 'ospersonality_home_page',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'description' => __('Shop section settings', 'ospersonality'),
            ) );

            $wp_customize->add_setting( 'ospersonality_products_column' , array(
                'default'     => '4',
                'sanitize_callback' => 'sanitize_text_field',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'products_column',array(
                    'label'=>__('Products column','ospersonality'),
                    'settings'=> 'ospersonality_products_column',
                    'section'=> 'ospersonality_shop_section',
                    'type'=>'select',
                    'priority'=>30,
                    'choices'=>array(
                        '2'=>'2 column',
                        '3'=>'3 column',
                        '4'=>'4 column',
                        '5'=>'5 column',
                        '6'=>'6 column',
                    ))
            ) );
        



        /*------------Home content section show--------------*/

        // $wp_customize->add_section( 'ospersonality_content_settings',array(
        //     'title'=>__('Home content settings','ospersonality'),
        //     'panel' => 'ospersonality_home_page',
        //     'priority'=>30,
        //     'type' => 'theme_mod',
        //     'capability'     => 'edit_theme_options',
        //     'description' => __('Home page settings <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
        //   ) );

        //     $wp_customize->add_setting( 'ospersonality_content_show' , array(
        //         'default'     => 'display:none',
        //         'sanitize_callback' => 'sanitize_text_field',
        //         'type' => 'theme_mod',
        //         'capability'     => 'edit_theme_options',
        //         'transport' => 'postMessage',
        //     ) );

        //     $wp_customize->add_control(new WP_Customize_Control(
        //         $wp_customize,'content_show',array(
        //             'label'=>__('Content section on home page show or hide','ospersonality'),
        //             'settings'=> 'ospersonality_content_show',
        //             'section'=> 'ospersonality_content_settings',
        //             'type'=>'radio',
        //             'priority'=>35,
        //             'choices'=>array(
        //                     'display:block'=>'show',
        //                     'display:none'=>'hide'))
        //     ) );
        


        /*-----Home any section show----------*/

        $wp_customize->add_section( 'ospersonality_any_section',array(
            'title'=>__('Any section settings','ospersonality'),
            'panel' => 'ospersonality_home_page',
            'priority'=>40,
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Home page settings <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
        ) );

        $wp_customize->add_setting( 'ospersonality_any_section_show' , array(
            'default'     => 'display:block',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_show',array(
                'label'=>__('Any section on home page show or hide','ospersonality'),
                'settings'=> 'ospersonality_any_section_show',
                'section'=> 'ospersonality_any_section',
                'type'=>'radio',
                'priority'=>10,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );

        /*-----------Home any title----------------*/

        $wp_customize->add_setting( 'ospersonality_any_section_title' , array(
            'default'     => __('Testimonial', 'ospersonality'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_title',array(
                'label'=>__('Home page any section title','ospersonality'),
                'settings'=> 'ospersonality_any_section_title',
                'section'=> 'ospersonality_any_section',
                'priority'=>41,
               )
        ) );
        /*-----------Home any desc----------------*/

        $wp_customize->add_setting( 'ospersonality_any_section_desc' , array(
            'default'     => __('Contact form', 'ospersonality'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_desc',array(
                'label'=>__('Home page any section desc','ospersonality'),
                'settings'=> 'ospersonality_any_section_desc',
                'section'=> 'ospersonality_any_section',
                'priority'=>42,
               )
        ) );

        /*------------Home any shortcode-----------------*/

        $wp_customize->add_setting( 'ospersonality_any_shortcode' , array(
            'default'     => '[testimonial_sc  id="213" ]',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_shortcode',array(
                'label'=>__('Home page any section insert shortcode','ospersonality'),
                'settings'=> 'ospersonality_any_shortcode',
                'section'=> 'ospersonality_any_section',
                'priority'=>43,
               )
        ) );



    /************Footer Settings********************/

    $wp_customize->add_section( 'ospersonality_footer_settings' , array(
          'title'      => __( 'Footer Settings','ospersonality' ),
          'priority'   => 50,
          'panel' => 'ospersonality_home_page',
          'type' => 'theme_mod',
          'capability' => 'edit_theme_options',
          'description' => __('Footer settings for <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
    ) );

        /*-------------Footer Background color--------------*/

        $wp_customize->add_setting( 'ospersonality_footer_background',array(
            'default'=>'#222222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

      $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize, 'footer_background',array(
                'label'=>__('Footer background color','ospersonality'),
                'section'=> 'ospersonality_footer_settings',
                'settings'=> 'ospersonality_footer_background',
                'priority'=>1
            )
        ) );

//-------------------------------------Copyright text-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_text' , array(
            'default'     => '',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
             $wp_customize,'copyright_text',array(
                   'label'=>__('Copyright text','ospersonality'),
                   'section'=>'ospersonality_footer_settings',
                   'settings'=>'ospersonality_copyright_text',
                   'priority'=>10
                   )
           ) );

//-------------------------------------Copyright link-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_link' , array(
            'default'     => '',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
             $wp_customize,'copyright_link',array(
                   'label'=>__('Copyright link','ospersonality'),
                   'section'=> 'ospersonality_footer_settings',
                   'settings'=> 'ospersonality_copyright_link',
                   'priority'=>11
                   )
           ) );

//-------------------------------------Copyright font-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_font' , array(
            'default' => 'Cabin, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_font',array(
                'label'=>__( 'Copyright font','ospersonality' ),
                'settings'=> 'ospersonality_copyright_font',
                'priority'=>12,
                'section'=> 'ospersonality_footer_settings',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                        "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

//-------------------------------------Copyright font size-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_font_size' , array(
            'default'     => '16',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
             $wp_customize,'copyright_font_size',array(
                'label'=>__('Copyright font size','ospersonality'),
                'section'=> 'ospersonality_footer_settings',
                'settings'=> 'ospersonality_copyright_font_size',
                'priority'=>13
                )
        ) );

//-------------------------------------Copyright font color-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'copyright_color',array(
                'label'=>__('Copyright font color','ospersonality'),
                'section'=> 'ospersonality_footer_settings',
                'settings'=> 'ospersonality_copyright_color',
                'priority'=>14
            )
        ) );

//-------------------------------------Copyright font color hover-----------------------------

       $wp_customize->add_setting( 'ospersonality_copyright_hover_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'copyright_hover_color',array(
                'label'=>__('Copyright font color hover','ospersonality'),
                'section'=> 'ospersonality_footer_settings',
                'settings'=> 'ospersonality_copyright_hover_color',
                'priority'=>15
            )
        ) );

//-------------------------------------Copyright link Underline-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_underline',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_underline',array(
                'label'=>__('Copyright link underline','ospersonality'),
                'settings'=> 'ospersonality_copyright_underline',
                'section'=> 'ospersonality_footer_settings',
                'type'=>'radio',
                'priority'=>16,
                'choices'=>array(
                    'none'=>'no',
                    'underline'=>'yes'
                ))
        ) );

//-------------------------------------Copyright link Underline hover-----------------------------

        $wp_customize->add_setting( 'ospersonality_copyright_underline_hover',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_underline_hover',array(
                'label'=>__('Copyright link underline hover','ospersonality'),
                'settings'=> 'ospersonality_copyright_underline_hover',
                'section'=> 'ospersonality_footer_settings',
                'type'=>'radio',
                'priority'=>17,
                'choices'=>array(
                    'none'=>'no',
                    'underline'=>'yes'
                ))
        ) );


    /******Menu Settings*******************/

    $wp_customize->add_section( 'ospersonality_menu_settings' , array(
        'title'      => __( 'Menu Settings','ospersonality' ),
        'priority'   =>1,
        'panel' => 'nav_menus',
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Menu settings for <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
    ) );

    /*-------------Menu  Font-----------------*/

        $wp_customize->add_setting( 'ospersonality_menu_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'menu_font',array(
                    'label'=>__( 'Menu Font','ospersonality' ),
                    'settings'=> 'ospersonality_menu_font',
                    'priority'=>1,
                    'section'=> 'ospersonality_menu_settings',
                    'type'=>'select','choices'=>array(
                        "Abel,sans-serif"=>"Abel",
                        "Arial,sans-serif"=>"Arial",
                        "Cuprum"=>"Cuprum",
                        "Comfortaa"=>"Comfortaa",
                        "Catamaran, sans-serif" => "Catamaran",
                        "Cabin, sans-serif" => "Cabin",
                        "Rubik, sans-serif" => "Rubik",
                        "Dosis,sans-serif"=>"Dosis",
                        "Droid Sans,sans-serif"=>"Droid Sans",
                        "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Francois One,sans-serif"=>"Francois One",
                        "Georgia,serif"=>"Georgia",
                        "Helvetica,sans-serif"=>"Helvetica",
                        "Josefin Sans,sans-serif"=>"Josefin Sans",
                        "Lato,sans-serif"=>"Lato",
                        "Lobster,sans-serif"=>"Lobster",
                        "Lora,sans-serif"=>"Lora",
                        "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                        "Open Sans,sans-serif"=>"Open Sans",
                        "Oswald,sans-serif"=>"Oswald",
                        "Oxygen,sans-serif"=>"Oxygen",
                        "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                        "Philosopher"=>"Philosopher",
                        "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                        "PT Sans"=>"PT Sans",
                        "Prosto One,cursive"=>"Prosto One",
                        "Quicksand,sans-serif"=>"Quicksand",
                        "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                        "Roboto,sans-serif"=>"Roboto",
                        "Share,cursive"=>"Share",
                        "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                      "Merriweather,sans-serif"=>"Merriweather",
                        "Times New Roman,sans-serif"=>"Times New Roman",
                        "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                        "Ubuntu,sans-serif"=>"Ubuntu",
                        "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        /*----------Menu Font Size----------------*/

        $wp_customize->add_setting( 'ospersonality_menu_font_size' , array(
            'default'     => '14',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize,'menu_font_size',array(
                 'label'=>__('Font size','ospersonality'),
                 'section'=> 'ospersonality_menu_settings',
                 'settings'=> 'ospersonality_menu_font_size',
                 'priority'=>20
                 )
         ) );



        /*----------------Menu Item margin------------------*/

        $wp_customize->add_setting( 'ospersonality_menu_margin' , array(
            'default'     => '5',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize,'menu_margin',array(
                 'label'=>__('Margin menu item ','ospersonality'),
                 'section'=> 'ospersonality_menu_settings',
                 'settings'=> 'ospersonality_menu_margin',
                 'priority'=>21
                 )
         ) );

        /*----------Menu Font Color--------------*/

        $wp_customize->add_setting( 'ospersonality_menu_color',array(
            'default'=>'#ffffff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_color',array(
                 'label'=>__('Font Color','ospersonality'),
                 'section'=> 'ospersonality_menu_settings',
                 'settings'=> 'ospersonality_menu_color',
                 'priority'=>30
                 )
        ) );

        /*------------Menu Font Color Hover----------------*/

        $wp_customize->add_setting( 'ospersonality_menu_hover_color',array(
            'default'=>'#666',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_hover_color',array(
                 'label'=>__('Hover Color','ospersonality'),
                 'section'=> 'ospersonality_menu_settings',
                 'settings'=> 'ospersonality_menu_hover_color',
                 'priority'=>31
                 )
        ) );



        /*-----------SUB Menu Font Color-----------*/

        $wp_customize->add_setting( 'ospersonality_submenu_color',array(
            'default'=>'#444',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_color',array(
                 'label'=>__('Sub menu font Color','ospersonality'),
                 'section'=> 'ospersonality_menu_settings',
                 'settings'=> 'ospersonality_submenu_color',
                 'priority'=>32
                 )
        ) );

        /*---------------SUB Menu Font Color Hover----------------*/

        $wp_customize->add_setting( 'ospersonality_submenu_hover_color',array(
            'default'=>'#0a0a0a',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_hover_color',array(
                 'label'=>__('Sub menu hover color','ospersonality'),
                 'section'=> 'ospersonality_menu_settings',
                 'settings'=> 'ospersonality_submenu_hover_color',
                 'priority'=>33
                 )
        ) );
        
        /*--------------Menu link underline----------------*/

        $wp_customize->add_setting( 'ospersonality_menu_underline',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline',array(
                'label'=>__('Menu link underline','ospersonality'),
                'settings'=> 'ospersonality_menu_underline',
                'section'=> 'ospersonality_menu_settings',
                'type'=>'radio',
                'priority'=>50,
                'choices'=>array(
                        'none'=>'no',
                        'underline'=>'yes'))
        ) );

        /*-----------Menu Link underline hover----------------*/

         $wp_customize->add_setting( 'ospersonality_menu_underline_hover',array(
            'default'=>'underline',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline_hover',array(
                'label'=>__('links underline hover','ospersonality'),
                'settings'=> 'ospersonality_menu_underline_hover',
                'section'=> 'ospersonality_menu_settings',
                'type'=>'radio',
                'priority'=>60,
                'choices'=>array(
                        'none'=>'no',
                        'underline'=>'yes'))
        ) );



    /*------------------Typography---------------------------*/

    $wp_customize->add_section( 'ospersonality_typography',array(
        'title'=>__('Typography','ospersonality'),
        'priority'=>60,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Typography settings for <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
    ) );

        /*-------------H1---------------------*/

        $wp_customize->add_setting( 'ospersonality_h1_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
              $wp_customize,'h1_font',array(
                'label'=>__( 'h1','ospersonality' ),
                'settings'=> 'ospersonality_h1_font',
                'priority'=>1,
                'section'=> 'ospersonality_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                    "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                    ))
            )
        );

        $wp_customize->add_setting('ospersonality_h1_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h1_color',array(
                 'label'=>__('h1 color','ospersonality'),
                 'section'=>'ospersonality_typography',
                 'settings'=>'ospersonality_h1_color',
                 'priority'=>2
                 )
         ) );

        /*---------H2---------------*/

        $wp_customize->add_setting( 'ospersonality_h2_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h2_font',array(
                'label'=>__( 'h2','ospersonality' ),
                'settings'=> 'ospersonality_h2_font',
                'priority'=>20,
                'section'=> 'ospersonality_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                    "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('ospersonality_h2_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h2_color',array(
                 'label'=>__('h2 color','ospersonality'),
                 'section'=>'ospersonality_typography',
                 'settings'=>'ospersonality_h2_color',
                 'priority'=>21
                 )
        ) );

        /*------------H3-------------*/

        $wp_customize->add_setting( 'ospersonality_h3_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h3_font',array(
                'label'=>__( 'h3','ospersonality' ),
                'settings'=> 'ospersonality_h3_font',
                'priority'=>30,
                'section'=> 'ospersonality_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                    "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                    ))
            )
        );

        $wp_customize->add_setting('ospersonality_h3_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h3_color',array(
                 'label'=>__('h3 color','ospersonality'),
                 'section'=>'ospersonality_typography',
                 'settings'=>'ospersonality_h3_color',
                 'priority'=>31
                 )
        ) );

        /*----------------H4------------*/

        $wp_customize->add_setting( 'ospersonality_h4_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h4_font',array(
                'label'=>__( 'h4','ospersonality' ),
                'settings'=> 'ospersonality_h4_font',
                'priority'=>40,
                'section'=> 'ospersonality_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                    "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('ospersonality_h4_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h4_color',array(
                 'label'=>__('h4 color','ospersonality'),
                 'section'=>'ospersonality_typography',
                 'settings'=>'ospersonality_h4_color',
                 'priority'=>41
                 )
        ) );

        /*-------------------H5----------------*/

        $wp_customize->add_setting( 'ospersonality_h5_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h5_font',array(
                'label'=>__( 'h5','ospersonality' ),
                'settings'=> 'ospersonality_h5_font',
                'priority'=>50,
                'section'=> 'ospersonality_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                    "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('ospersonality_h5_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h5_color',array(
                 'label'=>__('h5 color','ospersonality'),
                 'section'=>'ospersonality_typography',
                 'settings'=>'ospersonality_h5_color',
                 'priority'=>51
                 )
        ) );

        /*-------------H6---------------*/

        $wp_customize->add_setting( 'ospersonality_h6_font' , array(
            'default' => 'Catamaran, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h6_font',array(
                'label'=>__( 'h6','ospersonality' ),
                'settings'=> 'ospersonality_h6_font',
                'priority'=>60,
                'section'=> 'ospersonality_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Catamaran, sans-serif" => "Catamaran",
                    "Cabin, sans-serif" => "Cabin",
                    "Rubik, sans-serif" => "Rubik",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('ospersonality_h6_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h6_color',array(
                 'label'=>__('h6 color','ospersonality'),
                 'section'=>'ospersonality_typography',
                 'settings'=>'ospersonality_h6_color',
                 'priority'=>61
                 )
        ) );





    /*------------------Social icons--------------------*/

    $wp_customize->add_section( 'ospersonality_social_settings',array(
        'title'=>__('Social Icons','ospersonality'),
        'priority'=>70,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
         'description' => __('Sociasl Icons for <b style="color:#E9323B">"ospersonality"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'ospersonality'),
    ) );

        /*------------Social Icons Font Size-------------*/

        $wp_customize->add_setting( 'ospersonality_soc_size' , array(
            'default'     => '20',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
             $wp_customize,'ospersonality_soc_size',array(
                   'label'=>__('Social icon size','ospersonality'),
                   'section'=> 'ospersonality_social_settings',
                   'settings'=> 'ospersonality_soc_size',
                   'priority'=>1
                   )
        ) );

        /*----------Socil Icons Color--------------------*/

        $wp_customize->add_setting( 'ospersonality_soc_color',array(
            'default'=>'#faa54b',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_color',array(
                'label'=>__('Social Icons Color','ospersonality'),
                'settings'=> 'ospersonality_soc_color',
                'section'=> 'ospersonality_social_settings',
                'priority'=>2
            )
        ) );

        /*-------Social Icons Color Hover----------*/

        $wp_customize->add_setting( 'ospersonality_soc_color_hover',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_color_hover',array(
                'label'=>__('Social Icons Color Hover','ospersonality'),
                'settings'=> 'ospersonality_soc_color_hover',
                'section'=> 'ospersonality_social_settings',
                'priority'=>3
            )
        ) );

        /*---------Facebook---------------*/

        $wp_customize->add_setting( 'ospersonality_soc_facebook',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_facebook',array(
                'label'=>__('Facebook','ospersonality'),
                'settings'=> 'ospersonality_soc_facebook',
                'section'=> 'ospersonality_social_settings',
                'priority'=>4
            )
        ) );

        /*------Twitter----------------*/

        $wp_customize->add_setting( 'ospersonality_soc_twitter',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_twitter',array(
                'label'=>__('Twitter','ospersonality'),
                'settings'=> 'ospersonality_soc_twitter',
                'section'=> 'ospersonality_social_settings',
                'priority'=>5
            )
        ) );

        /*-------Skype----------------*/

        $wp_customize->add_setting( 'ospersonality_soc_skype',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_skype',array(
                'label'=>__('Skype','ospersonality'),
                'settings'=> 'ospersonality_soc_skype',
                'section'=> 'ospersonality_social_settings',
                'priority'=>6
            )
        ) );

        /*---------Soundcloud-------------*/

        $wp_customize->add_setting( 'ospersonality_soc_soundcloud',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_soundcloud',array(
                    'label'=>__('Soundcloud','ospersonality'),
                    'settings'=> 'ospersonality_soc_soundcloud',
                    'section'=> 'ospersonality_social_settings',
                    'priority'=>7
                )
        ) );

        /*---------Dribbble--------------*/

        $wp_customize->add_setting( 'ospersonality_soc_dribbble',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_dribbble',array(
                'label'=>__('Dribbble','ospersonality'),
                'settings'=> 'ospersonality_soc_dribbble',
                'section'=> 'ospersonality_social_settings',
                'priority'=>8
            )
        ) );

        /*--------Google------------*/

        $wp_customize->add_setting( 'ospersonality_soc_google',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_google',array(
                'label'=>__('Google','ospersonality'),
                'settings'=> 'ospersonality_soc_google',
                'section'=> 'ospersonality_social_settings',
                'priority'=>9
            )
        ) );

        /*--------Vimeo------------*/

        $wp_customize->add_setting('ospersonality_soc_vimeo',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_vimeo',array(
                    'label'=>__('Vimeo','ospersonality'),
                    'settings'=> 'ospersonality_soc_vimeo',
                    'section'=> 'ospersonality_social_settings',
                    'priority'=>10
                )
        ) );

        /*-------Flickr--------------*/

        $wp_customize->add_setting( 'ospersonality_soc_flickr',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_flickr',array(
                'label'=>__('Flickr','ospersonality'),
                'settings'=> 'ospersonality_soc_flickr',
                'section'=> 'ospersonality_social_settings',
                'priority'=>11
            )
        ) );

        /*---------Youtube Play---------*/

        $wp_customize->add_setting( 'ospersonality_soc_youtube_play',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_youtube_play',array(
                    'label'=>__('Youtube','ospersonality'),
                    'settings'=> 'ospersonality_soc_youtube_play',
                    'section'=> 'ospersonality_social_settings',
                    'priority'=>12
                )
        ) );

        /*-------Instagram----------*/

        $wp_customize->add_setting( 'ospersonality_soc_instagram',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_instagram',array(
                    'label'=>__('Instagram','ospersonality'),
                    'settings'=> 'ospersonality_soc_instagram',
                    'section'=> 'ospersonality_social_settings',
                    'priority'=>13
                )
        ) );

        /*-------Linkedin----------------*/

        $wp_customize->add_setting( 'ospersonality_soc_linkedin',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_linkedin',array(
                'label'=>__('Linkedin','ospersonality'),
                'settings'=> 'ospersonality_soc_linkedin',
                'section'=> 'ospersonality_social_settings',
                'priority'=>14
            )
        ) );

        


}
add_action( 'customize_register', 'ospersonality_customize_register' );