/**
 * @file
 * Control locate.
 */

(function ($, Drupal) {

  'use strict';

  /**
   * Locate control.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches common map locate functionality to relevant elements.
   */
  Drupal.behaviors.leafletControlLocate = {
    attach: function (context, drupalSettings) {
      Drupal.geolocation.executeFeatureOnAllMaps(
        'leaflet_control_locate',

        /**
         * @param {GeolocationLeafletMap} map - Current map.
         * @param {GeolocationMapFeatureSettings} featureSettings - Settings for current feature.
         */
        function (map, featureSettings) {
          map.addInitializedCallback(function (map) {
            var locateButton = $('.geolocation-map-control .locate', map.wrapper);
            if (navigator.geolocation && window.location.protocol === 'https:') {
              locateButton.click(function (e) {
                navigator.geolocation.getCurrentPosition(function (currentPosition) {
                  var currentLocation = new L.LatLng(currentPosition.coords.latitude, currentPosition.coords.longitude);
                  map.setCenterByCoordinates(currentLocation, currentPosition.coords.accuracy, 'leaflet_control_locate');
                });
                e.preventDefault();
              });
            }
            else {
              locateButton.remove();
            }
          });

          return true;
        },
        drupalSettings
      );
    },
    detach: function (context, drupalSettings) {}
  };

})(jQuery, Drupal);
