/**
 * @file
 * A Backbone Model for a single container of the Simple hierarchical select
 * widget.
 *
 * @see Drupal.shs.ContainerView
 */

(function (Backbone, Drupal) {

  'use strict';

  /**
   * @constructor
   *
   * @augments Backbone.Model
   */
  Drupal.shs.ContainerModel = Backbone.Model.extend(/** @lends Drupal.shs.ContainerModel# */{

    /**
     * @type {object}
     *
     */
    defaults: /** @lends Drupal.shs.ContainerModel# */{

      /**
       * The container delta (position).
       *
       * @type {integer}
       */
      delta: 0,

      /**
       * List of parent items.
       *
       * @type {array}
       */
      parents: [],

      /**
       * The current value within the container.
       */
      value: null

    }

  });

}(Backbone, Drupal));
