<?php

/**
 * @file
 * Lists available colors and color schemes for the hostel theme.
 */

$info = array(
  // Available colors and color labels used in theme.
  'fields' => array(
    'top' => t('Header background top'),
    'bg' => t('Main background'),
    'menu_hover' => t('Main menu hover'),
    'elements_color' => t('Elements color'),
    'color_button' => t('Color buttons'),
    'color_button_hover' => t('Color buttons hover'),
    'titleslogan' => t('Title and slogan'),
    'text' => t('Caption color'),
    'link' => t('Link color'),
    'sidebar' => t('Sidebar background'),
  ),
  // Pre-defined color schemes.
  'schemes' => array(
    'default' => array(
      'title' => t('White'),
      'colors' => array(
        'top' => '#333333',
        'bg' => '#f8f8f8',
        'menu_hover' => '#abc9f2',
        'elements_color' => '#d50124',
        'color_button' => '#ffffff',
        'color_button_hover' => '#72a5eb',
        'titleslogan' => '#fffeff',
        'text' => '#333332',
        'link' => '#a7e331',
        'sidebar' => '#ffffff',
      ),
    ),
    'blue' => array(
      'title' => t('Blue'),
      'colors' => array(
        'top' => '#398cf2',
        'bg' => '#066490',
        'menu_hover' => '#000000',
        'elements_color' => '#12abf1',
        'color_button' => '#000001',
        'color_button_hover' => '#202020',
        'titleslogan' => '#fffeff',
        'text' => '#fffff1',
        'link' => '#fffff2',
        'sidebar' => '#12abf2',
      ),
    ),
    
    'firehouse' => array(
      'title' => t('Red'),
      'colors' => array(
        'top' => '#e40028',
        'bg' => '#942205',
        'menu_hover' => '#000000',
        'elements_color' => '#d14242',
        'color_button' => '#000000',
        'color_button_hover' => '#202020',
        'titleslogan' => '#fffeff',
        'text' => '#ffffff',
        'link' => '#ffffff',
        'sidebar' => '#e40028',
      ),
    ),
    'ice' => array(
      'title' => t('Green'),
      'colors' => array(
        'top' => '#029f25',
        'bg' => '#03b72e',
        'menu_hover' => '#000000',
        'elements_color' => '#03b72d',
        'color_button' => '#000001',
        'color_button_hover' => '#202020',
        'titleslogan' => '#000002',
        'text' => '#ffffff',
        'link' => '#fffff1',
        'sidebar' => '#029f26',
      ),
    ),
    'plum' => array(
      'title' => t('Light Green'),
      'colors' => array(
        'top' => '#7cd01b',
        'bg' => '#579c06',
        'menu_hover' => '#000000',
        'elements_color' => '#8bc34a',
        'color_button' => '#000000',
        'color_button_hover' => '#202020',
        'titleslogan' => '#ffffff',
        'text' => '#ffffff',
        'link' => '#ffffff',
        'sidebar' => '#7cd01b',
      ),
    ),
    'slate' => array(
      'title' => t('Orange'),
      'colors' => array(
        'top' => '#ff7b15',
        'bg' => '#ad4b00',
        'menu_hover' => '#000000',
        'elements_color' => '#ff7b15',
        'color_button' => '#000000',
        'color_button_hover' => '#202020',
        'titleslogan' => '#ffffff',
        'text' => '#ffffff',
        'link' => '#ffffff',
        'sidebar' => '#ff7b15',
      ),
    ),
    

  ),

  // CSS files (excluding @import) to rewrite with new color scheme.
  'css' => array(
    'css/os-colors.css',
  ),

  // Files to copy.
  'copy' => array(
    'logo.svg',
  ),

  // Gradient definitions.
  'gradients' => array(
    array(
      // (x, y, width, height).
      'dimension' => array(0, 0, 0, 0),
      // Direction of gradient ('vertical' or 'horizontal').
      'direction' => 'vertical',
      // Keys of colors to use for the gradient.
      'colors' => array('top', 'bottom'),
    ),
  ),

  // Preview files.
  'preview_library' => 'hostel/os-color.preview',
  'preview_html' => 'color/preview.html',

  // Attachments.
  '#attached' => [
  'drupalSettings' => [
  'color' => [
        // Put the logo path into JavaScript for the live preview.
  'logo' => theme_get_setting('logo.url', 'hostel'),
  ],
  ],
  ],
);
