/**
 * @file
 * A Backbone Model for widget item options in SHS.
 */

(function (Backbone, Drupal) {

  'use strict';


  /**
   * Backbone model for widget item options in SHS.
   *
   * @constructor
   *
   * @augments Backbone.Model
   */
  Drupal.shs.WidgetItemOptionModel = Backbone.Model.extend(/** @lends Drupal.shs.WidgetItemOptionModel# */{

    /**
     * @type {object}
     *
     * @prop {string} label
     * @prop {string} value
     * @prop {boolean} hasChildren
     */
    defaults: /** @lends Drupal.shs.WidgetItemOptionModel# */{

      /**
       * Represents the option label.
       *
       * @type {string}
       */
      label: '',

      /**
       * The option value.
       *
       * @type {string}
       */
      value: undefined,

      /**
       * Indicator whether the item has children.
       *
       * @type {boolean}
       */
      hasChildren: false
    },

    /**
     * {@inheritdoc}
     */
    initialize: function () {}
  });

}(Backbone, Drupal));
