<?php
/**
   * The template for Comments.
   *
   *
   * @package   serenity WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license  http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * serenity is distributed under the terms of the GNU GPL
*/
?>
<?php if ( post_password_required() ) return; ?>
<div class="row comments">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <?php if ( have_comments() ) : ?>
        <h2 class="comments-title">
        <?php
            printf( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'serenity' ),
                number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
        ?>
        </h2>

        <ul class="comment-list">
            <?php
            wp_list_comments( array(
                'style'       => 'ul',
                'short_ping'  => true,
                'avatar_size' => 74,
            ) );
            ?>
          </ul><!-- .comment-list -->

          <?php
            // Are there comments to navigate through?
            if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
          ?>
            <nav class="navigation comment-navigation" role="navigation">
                <h1 class="screen-reader-text section-heading"><?php _e( 'Comment navigation', 'serenity' ); ?></h1>
                <div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'serenity' ) ); ?></div>
                <div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'serenity' ) ); ?></div>
            </nav><!-- .comment-navigation -->
            <?php endif; // Check for comment navigation ?>

            <?php if ( ! comments_open() && get_comments_number() ) : ?>
                <p class="no-comments"><?php _e( 'Comments are closed.' , 'serenity' ); ?></p>
            <?php endif; ?>

            <?php endif; // have_comments() ?>

            <?php $commenter = wp_get_current_commenter();
                $req = get_option( 'require_name_email' );
                $aria_req = ( $req ? " aria-required='true'" : '' );
                $fields =  array(
                    'author' => '<p class="comment-form-author">' . ( $req ? '<span class="required"></span>' : '' ) .
                    '<input id="author" name="author" type="text" placeholder="Name*" value="' . esc_attr( $commenter['comment_author'] ) . '" size="50"' . $aria_req . ' /></p>',
                    'email'  => '<p class="comment-form-email">' . ( $req ? '<span class="required"></span>' : '' ) .
                    '<input id="email" name="email" type="text" placeholder="Email*" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="50"' . $aria_req . ' /></p>'
                );

                $comments_args = array(
                    'fields' =>  $fields,
                    'comment_field' =>  '<p class="comment-form-comment"><textarea id="comment" name="comment"  placeholder="Comment" cols="49" rows="8" aria-required="true"></textarea></p>',
                    'label_submit' => __('Comment', 'serenity')

                );

                comment_form($comments_args); ?>
    </div>
</div><!-- #comments -->