<?php
/**
    * The template for Functions.
    *
    *
    * @package  serenity WordPress Theme
    * @copyright    Copyright (C) 2015, OrdaSoft
    * @license  http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
    * @author   AUTHOR <www.ordasoft.com>
    * serenity is distributed under the tebss of the GNU GPL
*/
remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );


function serenity_customize_css() {
    ?>
    <style>
        body {
            color:<?php echo esc_attr(get_theme_mod( 'serenity_font_color', '#444444' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_body_font', 'Exo,sans-serif' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'serenity_font_size', '14' )); ?>px;
        }
        #navbar #primary-navigation #menu-menu li a,
        .nav-menu ul li a,
        ul.main_menu.nav.navbar-nav > li > a {
            font-size:<?php echo esc_attr(get_theme_mod( 'serenity_menu_font_size', '14' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_menu_color', '#333' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'serenity_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_menu_font', 'Exo,sans-serif' )); ?>;
        }

         #navbar #primary-navigation #menu-menu li a:hover,
         .nav-menu ul li a:hover,
        ul#menu-menu > li > a:hover {
            text-decoration:<?php echo esc_attr(get_theme_mod( 'serenity_menu_underline_hover', 'underline;' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_menu_hover_color', '#666' )); ?>;
        }
        .children li a,
        #navbar #primary-navigation #menu-menu li .sub-menu li a {
            color:<?php echo esc_attr(get_theme_mod( 'serenity_submenu_color', '#444' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'serenity_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_menu_font', 'Exo,sans-serif' )); ?>;
        }
        .children li a:hover,
        #navbar #primary-navigation #menu-menu li .sub-menu li a:hover {
            color:<?php echo esc_attr(get_theme_mod( 'serenity_submenu_hover_color', '#0a0a0a' )); ?> !important;
             text-decoration:<?php echo esc_attr(get_theme_mod( 'serenity_menu_underline_hover', 'none;' )); ?>;
        }
        #primary-navigation .nav-menu ul li.page_item,
        #menu-menu li {
            margin: <?php echo esc_attr(get_theme_mod( 'serenity_menu_margin', '15' )); ?>px;
        }
        #copyright a,
        #copyright p {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_copyright_font', 'Exo,sans-serif' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'serenity_copyright_font_size', '14' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_copyright_color', '#92999e' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'serenity_copyright_underline', 'none' )); ?>;
        }
        #copyright a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'serenity_copyright_hover_color', '' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'serenity_copyright_underline_hover', 'none' )); ?>;
        }
        #social a{
            font-size:<?php echo esc_attr(get_theme_mod( 'serenity_soc_size', '17' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_soc_color', '#4f4f4f' )); ?>;
        }
        #social a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'serenity_soc_color_hover', '#fff' )); ?>;
        }
        body h1 {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_h1_font', 'Exo,sans-serif' )); ?>;
            color:<?php echo get_theme_mod( 'serenity_h1_color', '#222' ); ?>;
        }
        body h2 {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_h2_font', 'Exo,sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_h2_color', '#222' )); ?>;
        }
        body h3 {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_h3_font', 'Exo,sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_h3_color', '#222' )); ?>;
        }
        body h4 {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_h4_font', 'Exo,sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_h4_color', '#222' )); ?>;
        }
        body h5 {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_h5_font', 'Exo,sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_h5_color', '#222' )); ?>;
        }
        body h6 {
            font-family:<?php echo esc_attr(get_theme_mod( 'serenity_h6_font', 'Exo,sans-serif' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'serenity_h6_color', '#222' )); ?>;
        }
        .site-header {
            <?php if(!is_front_page()) echo "background:none;";?>
        }
        #header-1 {
            <?php if(is_front_page()) echo "padding-bottom:117px;";?>
        }
        .page-numbers,
        .onsale,
        #wp-calendar caption,
        .widget_title,
        .theme-color {
            background-color: <?php echo esc_attr(get_theme_mod( 'serenity_theme_color', '#4f4f4f' )); ?>;
        }
        .menu-toggle i {
            color: <?php echo esc_attr(get_theme_mod( 'serenity_theme_color', '#4f4f4f' )); ?>;
        }
        .single #content-shop .product .onsale {
            background-color: <?php echo esc_attr(get_theme_mod( 'serenity_theme_color', '#4f4f4f' )); ?> !important;
        }
        .site-footer {
            background: <?php echo esc_attr(get_theme_mod( 'serenity_footer_background', '#222222' )); ?>;
        }
        #testimonial-container-220 .element.thumbnail img {
            height: 80px;
        }
        .widget_text .tab-content > .active {
            opacity: 1;
        }
    </style>
<?php
}
add_action( 'wp_head', 'serenity_customize_css');

function serenity_custom_css() {
    echo '<style type="text/css" id="serenity-custom-css">' .
    get_theme_mod( 'serenity_custom_css', '' ) . '</style>';
}
add_action( 'wp_head', 'serenity_custom_css');


function add_googleanalytics() { ?>
    <script type="text/javascript">
    <?php echo esc_attr(get_theme_mod( 'serenity_add_googleanalytics', '' )); ?>
    </script>
<?php
}
add_action('wp_footer', 'add_googleanalytics');

function serenity_customize_preview_js() {
    wp_enqueue_script( 'serenity-customizer', get_template_directory_uri() . '/js/theme-customizer.js', array( 'customize-preview' ), '20120187', true );
}

function serenity_after_setup_theme() {
    add_action( 'customize_preview_init', 'serenity_customize_preview_js' );
}
add_action( 'after_setup_theme', 'serenity_after_setup_theme' );

function serenity_callback(){
    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'woocommerce' );
    $args = array(
        'flex-width'    => true,
        'width'         => 980,
        'flex-height'    => true,
        'height'        => 400,
    );
    add_theme_support( 'custom-header', $args );
    add_editor_style( get_template_directory_uri() . '/css/editor-style.css' );
    add_theme_support( 'post-formats', array( 'aside','link','gallery','image','quote','status','video','audio','chat' ) );
    load_theme_textdomain('serenity', get_template_directory() . '/languages');
}
add_action('after_setup_theme', 'serenity_callback');

//--------Settings themplate
//Add register Menu
register_nav_menu( 'primary', __( 'Navigation Menu', 'serenity' ) );


require get_template_directory() . '/inc/settings_template.php';

//--------IE-------
add_action( 'wp_head', 'serenity_head_callback' );
    function serenity_head_callback() {
        global $wp_styles;
        wp_enqueue_style( 'serenity-ie', get_template_directory_uri() . "/css/ie.css", array( 'serenity' )  );
        $wp_styles->add_data( 'serenity-ie', 'conditional', 'lt IE 8' ); ?>
        <!--[if IE]><script src="<?php echo get_template_directory_uri();
 ?>/js/html5.js"></script><![endif]-->
 <?php
 } // end wp_head callback

if ( ! isset( $content_width ) )
    $content_width = 604;

if (is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) wp_enqueue_script('comment-reply');

//--------Widgets

function serenity_sidebar_init() {
    register_sidebar(
        array(
            'name'          => __( 'SideBar Left', 'serenity' ),
            'id'            => 'sidebar_left',
            'description'   => __( 'Appears in the left column of the site.', 'serenity' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
            ) );

    register_sidebar(
        array(
            'name'          => __( 'SideBar Right', 'serenity' ),
            'id'            => 'sidebar_right',
            'description'   => __( 'Appears in the right column of the site.', 'serenity' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
            ) );

    register_sidebar(
        array(
            'id' => 'content_top',
            'name' => __( 'Content top', 'serenity'),
            'description' => __( 'Content top', 'serenity' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_content_top">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'content_bottom',
            'name' => __( 'Content bottom', 'serenity'),
            'description' => __( 'Content bottom', 'serenity' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_content_bottom">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'footer_left',
            'name' => __( 'Footer left', 'serenity'),
            'description' => __( 'Footer left', 'serenity' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_footer_left">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'footer_right',
            'name' => __( 'Footer right', 'serenity'),
            'description' => __( 'Footer right', 'serenity' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_footer_right">',
            'after_title' => '</h3>'
        ) );
}
add_action( 'widgets_init', 'serenity_sidebar_init' );

//css styles connect to the admin

function serenity_style_backend() {
    wp_enqueue_style( 'admin_style', get_template_directory_uri()  .  '/css/admin_style.css' );
    wp_enqueue_style( 'font-awesomes', get_template_directory_uri()  .  "/css/font-awesome.min.css" );

}
add_action( 'admin_enqueue_scripts', 'serenity_style_backend' );


//styles and scripts

function serenity_rigistre_scripts() {
    $serenity_uri = get_template_directory_uri();

    wp_enqueue_script('serenity_bootstrap_script', $serenity_uri . '/bootstrap/js/bootstrap.js', array( 'jquery' ), false);

    //wp_enqueue_script('serenity_viewportchecker_script', $serenity_uri . '/js/jquery.viewportchecker.js', array( 'jquery' ), false);

    wp_enqueue_script( 'serenity_script', $serenity_uri . '/js/functions.js', array( 'jquery' ), '20140319', true );

     //wp_enqueue_script('serenity_masonry_script',   $serenity_uri . '/js/masonry.pkgd.js','','3.3.2' , array( 'jquery' ), true);

     wp_enqueue_script('serenity_modernizr_script',   $serenity_uri . '/js/modernizr.js','','2.7.1' , array( 'jquery' ), true);

     //wp_enqueue_script('serenity_freewall_script',   $serenity_uri . '/js/freewall.min.js','','1.0', array( 'jquery' ), false);

     wp_enqueue_script('serenity_custom_script',   $serenity_uri . '/js/custom.js','','1.0', array( 'jquery' ), false);

    wp_enqueue_style('serenity_bootstrap_style', get_template_directory_uri() . '/bootstrap/css/bootstrap.css');

    wp_enqueue_style('serenity_style_main',   get_stylesheet_uri(), array() );

    //wp_enqueue_style('serenity_style_animate',   $serenity_uri . '/css/animate.css');

    wp_enqueue_style('serenity_style_font-awesome',  $serenity_uri . '/css/font-awesome.min.css');


    wp_enqueue_style('serenity_style_ionicons',   $serenity_uri . '/css/ionicons.min.css');

    //wp_enqueue_style('serenity_style_diamonds',   $serenity_uri . '/css/diamonds.css');

    wp_enqueue_style('fonts','http://fonts.googleapis.com/css?family=Cuprum:700italic,400,400italic,700|Josefin+Slab:100,300,400,600,700,100italic,300italic,400italic,600italic,700italic|Special+Elite|Orbitron:400,500,700,900|Alegreya+SC:400,400italic,700,700italic,900,900italic|Comfortaa:400,300,700|Abel|Dosis:400,200,300,500,600,700,800|Droid+Sans:400,700|Francois+One|Exo:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic|Tangerine:400,700|Josefin+Sans:100,300,400,600,700,100italic,300italic,400italic,600italic,700italic|Lato:400,100,300,400italic,300italic,100italic,700,700italic,900,900italic|Lobster|Lora:400,400italic,700,700italic|Oswald:300,400,700|Open+Sans+Condensed:300,300italic,700|Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800italic,800|Oswald:400,300,700|Oxygen:400,300,700|Philosopher:400,700,400italic,700italic|Playfair+Display+SC:400,400italic,700,700italic,900,900italic|PT+Sans+Narrow:400,700|PT+Sans:400,400italic,700,700italic|Prosto+One|Quicksand:400,300,700|Roboto+Condensed:400,300,300italic,400italic,700,700italic|Share:400,400italic,700,700italic|Source+Sans+Pro:400,200,200italic,300,300italic,400italic,600,600italic,700,700italic,900,900italic|Montserrat:400,700|Merriweather:400,300italic,300,400italic,700,700italic,900,900italic|Ubuntu+Condensed|Ubuntu:400,300,300italic,400italic,500,500italic,700,700italic|Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic&subset=latin,cyrillic-ext,latin-ext,cyrillic');
}
add_action( 'wp_enqueue_scripts', 'serenity_rigistre_scripts' );

//excerpt
function serenity_excerpt_length($length) {
    return 50;
}
add_filter('excerpt_length', 'serenity_excerpt_length');

//content limit
function serenity_content($limit) {
    $content = explode(' ', get_the_content(), $limit);
    if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).'...';
    } else {
        $content = implode(" ",$content);
    }
    $content = preg_replace('/\[.+\]/','', $content);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    return $content;
}

function serenity_post_nav() {
    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous ) {
        return;
    }
    ?>
    <nav class="navigation post-navigation" role="navigation">
        <h1 class="screen-reader-text"><?php _e( 'Post navigation', 'serenity' ); ?></h1>
        <div class="nav-links">
            <?php
            if ( is_attachment() ) :
                previous_post_link( '%link', __( '<span class="meta-nav">Published In</span>%title', 'serenity' ) );
            else :
                previous_post_link( '%link', __( '<span class="meta-nav">Previous Post: </span>%title', 'serenity' ) );
                next_post_link( '%link', __( '<span class="meta-nav">Next Post: </span>%title', 'serenity' ) );
            endif;
            ?>
        </div><!-- .nav-links -->
    </nav><!-- .navigation -->
    <?php
}

function serenity_entry_meta() {
    if ( is_sticky() && is_home() && ! is_paged() )
        echo '<span class="featured-post">' . __( 'Sticky', 'serenity' ) . '</span>';

    // Translators: used between list items, there is a space after the comma.
    $categories_list = get_the_category_list( __( ', ', 'serenity' ) );
    if ( $categories_list ) {
        echo '<span class="categories-links"><i class="ion-ios-list-outline"></i>' . $categories_list . '</span>';
    }

    // Translators: used between list items, there is a space after the comma.
    $tag_list = get_the_tag_list( '', __( ', ', 'serenity' ) );
    if ( $tag_list ) {
        echo '<span class="tags-links"><i class="ion-ios-pricetag-outline"></i>' . $tag_list . '</span>';
    }

    // Post author
    if ( 'post' == get_post_type() ) {
        printf( '<span class="author vcard"><i class="ion-ios-person-outline"></i><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
        esc_attr( sprintf( __( 'View all posts by %s', 'serenity' ), get_the_author() ) ),
        get_the_author()
        );
    }
};

function serenity_entry_date( $echo = true ) {
    $date = sprintf( '<span class="date"><i class="fa fa-calendar-check-o"></i><a href="%s" title="%s" rel="bookmark"><time class="entry-date" datetime="%s"><span class="date--day">%s</span> <span class="date--month">%s</span> <span class="date--year">%s</span></time></a></span>',
    esc_url( get_permalink() ),
    esc_attr( sprintf( __( 'Permalink to %s', 'serenity' ), the_title_attribute( 'echo=0' ) ) ),
    esc_attr( get_the_date( 'c' ) ),
    esc_attr( get_the_date( 'd' ) ),
    esc_attr( get_the_date( 'M' ) ),
    esc_attr( get_the_date( 'Y' ) )
);

    if ( $echo )
        echo $date;

    return $date;
};

function serenity_the_attached_image() {
    /**
    * Filter the image attachment size to use.
    * @param array $size {
    *  @type int The attachment height in pixels.
    *  @type int The attachment width in pixels.
    * }
    */
    $attachment_size = apply_filters( 'serenity_attachment_size', array( 724, 724 ) );
    $next_attachment_url = wp_get_attachment_url();
    $post  = get_post();

    /*
    * Grab the IDs of all the image attachments in a gallery so we can get the URL
    * of the next adjacent image in a gallery, or the first image (if we're
    * looking at the last image in a gallery), or, in a gallery of one, just the
    * link to that image file.
    */
    $attachment_ids = get_posts( array(
        'post_parent'    => $post->post_parent,
        'fields'         => 'ids',
        'numberposts'    => -1,
        'post_status'    => 'inherit',
        'post_type'      => 'attachment',
        'post_mime_type' => 'image',
        'order'          => 'ASC',
        'orderby'        => 'menu_order ID'
    ) );

    // If there is more than 1 attachment in a gallery...
    if ( count( $attachment_ids ) > 1 ) {
        foreach ( $attachment_ids as $attachment_id ) {
        if ( $attachment_id == $post->ID ) {
            $next_id = current( $attachment_ids );
        break;
        }
    }

    // get the URL of the next image attachment...
    if ( $next_id )
        $next_attachment_url = get_attachment_link( $next_id );

    // or get the URL of the first image attachment.
    else
        $next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
    }

    printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>',
    esc_url( $next_attachment_url ),
    the_title_attribute( array( 'echo' => false ) ),
    wp_get_attachment_image( $post->ID, $attachment_size )
    );
}

function serenity_pagenavi($post_type ='',$posts_per_page = '') {

   $count_posts = wp_count_posts();


    $big = 999999999;
    $args = array(
        'serenity' => str_replace( $big, '%#%', get_pagenum_link( $big, false ) )
        ,'fobsat' => ''
        ,'current' => max( 1, get_query_var('paged') )
        ,'total' => ceil($count_posts->publish/$posts_per_page  )

    );
    $result = paginate_links( $args );
    $result = str_replace( '/page/1"', '"', $result );

    echo $result;
}


/*-------team---------*/

add_action('init', 'team');
function team() {
    register_post_type('team', array(
    'public' => true,
    'supports' => array('title','thumbnail','editor'),
    'labels' => array(
        'name' => 'Team',
        'add_new' => 'Add new',
        'all_items' => 'All',
        'add_new_item' => 'Add new'
        )
    ));
}