<?php
/**
   * The template for Header.
   *
   *
   * @package   serenity WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * serenity is distributed under the terms of the GNU GPL
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
    <?php if (get_theme_mod("serenity_favicon_img")) : ?>
        <link href="<?php echo esc_url(get_theme_mod("serenity_favicon_img")); ?>" rel="icon" type="image/x-icon" />
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <div id="site" class="hfeed site">
    <?php if ( get_header_image() ) : ?>
        <header id="header" class="header">
            <div class="header-top" style="background-image:url(<?php header_image(); ?>);">
    <?php else : ?>
        <header id="header" class="header">
            <div class="header-top" style="background-image:url(<?php echo get_template_directory_uri(); ?>/images/header.png);">
    <?php endif; ?>
                <div class="overlay"></div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 logo-img">
                    <?php if ((get_theme_mod("serenity_logo_img"))&&(get_theme_mod('serenity_logo_link'))) : ?>
                        <a class="logo_link" href="<?php echo esc_url(get_theme_mod('serenity_logo_link')); ?>">
                            <img id="logo" src="<?php echo esc_url(get_theme_mod("serenity_logo_img")); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                        </a>
                    <?php endif; ?>
                    <?php if ((get_theme_mod("serenity_logo_img"))&&(!get_theme_mod('serenity_logo_link'))) : ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                            <img id="logo" src="<?php echo esc_url(get_theme_mod("serenity_logo_img")); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                        </a>
                    <?php endif; ?>
                    <?php if ((!get_theme_mod("serenity_logo_img"))&&(get_theme_mod('serenity_logo_link'))) : ?>
                        <a class="logo_link" href="<?php echo esc_url(get_theme_mod('serenity_logo_link')); ?>">
                            <h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
                        </a>
                    <?php endif; ?>
                    <?php if ((!get_theme_mod("serenity_logo_img"))&&(!get_theme_mod('serenity_logo_link'))) : ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                           <img id="logo" src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                        </a>
                    <?php endif; ?>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 for-modal">
                        <a href="#aboutus" class="button-about">
                            <?php if (get_theme_mod( 'serenity_button_text' )) :
                                    echo esc_attr(get_theme_mod( 'serenity_button_text' ));
                                else :
                                    _e( 'About Us', 'serenity' );
                                endif; ?></a>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 soc-ico">
                    <?php get_template_part( 'social' ); ?>
                    </div>
                </div>

        </div>
        <div class="theme menu-container">
            <div  class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div id="navbar" class="navbar">
                        <nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
                            <button class="menu-toggle"><i class="fa fa-bars"></i></button>
                            <a class="screen-reader-text skip-link" href="#content" title="<?php esc_attr_e( 'Skip to content', 'serenity' ); ?>"><?php _e( 'Skip to content', 'serenity' ); ?></a>
                            <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
                        </nav><!-- #site-navigation -->
                    </div><!-- #navbar -->
                </div>
            </div>
        </div>

    </header><!-- header -->
    <a href="#modal-css" class="overlay" id="aboutus"></a>
   <div class="popup">
   <?php if (get_theme_mod( 'serenity_modal_text' )) :
            echo esc_attr(get_theme_mod( 'serenity_modal_text' ));
        else :
            echo __('Please past text to modal in Customize->Header Settings', 'serenity');
        endif; ?>
    <a class="close" title="Close" href="#close"></a>
    </div>