<?php
/**
   * The template for Footer.
   *
   *
   * @package   fcast WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * fcast is distributed under the terms of the GNU GPL
*/
$footer_left = false;
if (is_active_sidebar( 'footer_left' ) ) {
    $footer_left = true;
}

$footer_right = false;
if (is_active_sidebar( 'footer_right' ) ) {
    $footer_right = true;
}
?>
    <footer id="footer" class="site-footer">
        <div class="container">
            <div class="row">
                <?php if(is_active_sidebar( 'footer_left' ) ): ?>
                    <div class="<?php if($footer_left && $footer_right): echo 'col-lg-6 col-md-6 col-sm-6 col-xs-12';
                    else : echo 'col-lg-12 col-md-12 col-sm-12 col-xs-12'; endif; ?> widgets">
                        <?php  dynamic_sidebar('footer_left'); ?>
                    </div>
                <?php endif; ?>
                <?php if(is_active_sidebar( 'footer_right' ) ): ?>
                    <div class="<?php if($footer_left && $footer_right): echo 'col-lg-6 col-md-6 col-sm-6 col-xs-12';
                    else : echo 'col-lg-12 col-md-12 col-sm-12 col-xs-12'; endif; ?> widgets">
                        <?php  dynamic_sidebar('footer_right'); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="row footer-bottom">
                <div class="col-md-6 col-sm-6 col-lg-6 col-xs-12">
                    <div id="copyright">
                        <?php if ((get_theme_mod("fcast_copyright_link"))&&(get_theme_mod("fcast_copyright_text"))) : ?>
                            <a target="blank" class="copyright" href='<?php echo esc_url(get_theme_mod("fcast_copyright_link"));?>'>
                            <?php echo esc_attr(get_theme_mod('fcast_copyright_text')) . date('Y');?>
                            </a>
                        <?php endif; ?>
                        <?php if ((!get_theme_mod("fcast_copyright_link"))&&(get_theme_mod("fcast_copyright_text"))) : ?>
                            <p><?php echo esc_attr(get_theme_mod('fcast_copyright_text')) . date('Y');?></p>
                        <?php endif; ?>
                        <?php if ((get_theme_mod("fcast_copyright_link"))&&(!get_theme_mod("fcast_copyright_text"))) : ?>
                            <a target="blank" class="copyright" href='<?php echo esc_url(get_theme_mod("fcast_copyright_link"));?>'></a>
                        <?php endif; ?>
                        <?php if ((!get_theme_mod("fcast_copyright_link"))&&(!get_theme_mod("fcast_copyright_text"))) : ?>
                            <a target="_blank" class="copyright" href='http://ordasoft.com/'>
                            <?php _e('Theme Design &copy; WordPress Theme OrdaSoft. All rights reserved.', 'fcast'); ?></a>
                        <?php endif; ?>
                      </div>
                </div>
                <div class="col-md-6 col-sm-6 col-lg-6 col-xs-12">
                    <?php get_template_part( 'social' ); ?>
                </div>
            </div>
    </footer>
</div><!-- #page -->
<?php wp_footer(); ?>
</body>
</html>