<?php
/**
   * The template for Arhive.
   *
   *
   * @package   personnew WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license  http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * personnew is distributed under the terms of the GNU GPL
*/
  $sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}


if ((get_theme_mod('personnew_header_layout_other')) === 'header' ) :
    get_header();
elseif ((get_theme_mod('personnew_header_layout_other')) === 'header-main' ) :
    get_header('main');
else :
    get_header('main');
endif;
?>
<div id="main" class="site-main">
    <div id="archive" class="site-content">

        <div class="row">
            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                    <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>

            <?php if($sidebar_right && $sidebar_left) :
                echo ('<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">');
                echo ('<div class="archive">');
            elseif($sidebar_right || $sidebar_left) :
                echo ('<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">');
                echo ('<div class="archive">');
            else :
                echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
                echo ('<div class="archive container">');
            endif; ?>
                   <div class="archive-header">
                    <h1 class="archive-title"><?php
                    if ( is_day() ) :
                        printf( __( 'Daily Archives %s', 'personnew' ), '<span>' . get_the_date() . '</span>' );
                    elseif ( is_month() ) :
                        printf( __( 'Monthly Archives %s', 'personnew' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'personnew' ) ) . '</span>' );
                    elseif ( is_year() ) :
                        printf( __( 'Yearly Archives %s', 'personnew' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'personnew' ) ) . '</span>' );
                    else :
                        _e( 'Archives', 'personnew' );
                    endif; ?>
                    </h1>
                </div><!-- .archive-header -->
                <?php $position = 0; ?>
                <?php if ( have_posts() ) : ?>
                    <?php while ( have_posts() ) : the_post();
                        $position++ ?>
                    <div class="<?php if ($position != 0 && $position%2==0) echo 'right-post'; else echo 'left-post'; ?>">
                    <?php get_template_part( 'content', $format = get_post_format() ); ?>
                    </div>

                   <?php endwhile; ?>

                <?php  the_posts_pagination();

                 else :

                    get_template_part( 'content', 'none' );

                 endif; ?>
            </div>
            </div>
            <?php if (is_active_sidebar( 'sidebar_right' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                    <?php dynamic_sidebar('sidebar_right'); ?>
                </article>
            </div>
            <?php endif; ?>
            </div>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>