<?php
/**
    * The template for Functions.
    *
    *
    * @package  personnew WordPress Theme
    * @copyright    Copyright (C) 2015, OrdaSoft
    * @license  http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
    * @author   AUTHOR <www.ordasoft.com>
    * personnew is distributed under the tebss of the GNU GPL
*/
remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );


function personnew_customize_css() {
    ?>
    <style>
        body {
            color:<?php echo esc_attr(get_theme_mod( 'personnew_font_color', '#0a0a0a' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_body_font', 'Indie Flower' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'personnew_font_size', '16' )); ?>px;
        }
        #navbar #primary-navigation #menu-menu li a,
        .nav-menu ul li a,
        ul.main_menu.nav.navbar-nav > li > a {
            font-size:<?php echo esc_attr(get_theme_mod( 'personnew_menu_font_size', '14' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_menu_color', '#fff' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'personnew_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_menu_font', 'Exo,sans-serif' )); ?>;
        }

         #navbar #primary-navigation #menu-menu li a:hover,
         .nav-menu ul li a:hover,
        ul#menu-menu > li > a:hover {
            text-decoration:<?php echo esc_attr(get_theme_mod( 'personnew_menu_underline_hover', 'underline;' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_menu_hover_color', '#D39B45' )); ?>;
        }
        .children li a,
        #navbar #primary-navigation #menu-menu li .sub-menu li a {
            color:<?php echo esc_attr(get_theme_mod( 'personnew_submenu_color', '#fff' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'personnew_menu_underline', 'none;' )); ?>;
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_menu_font', 'Exo,sans-serif' )); ?>;
        }
        .children li a:hover,
        #navbar #primary-navigation #menu-menu li .sub-menu li a:hover {
            color:<?php echo esc_attr(get_theme_mod( 'personnew_submenu_hover_color', '#D39B45' )); ?> !important;
             text-decoration:<?php echo esc_attr(get_theme_mod( 'personnew_menu_underline_hover', 'none;' )); ?>;
        }
        #primary-navigation .nav-menu ul li.page_item,
        #menu-menu li {
            margin: <?php echo esc_attr(get_theme_mod( 'personnew_menu_margin', '15' )); ?>px;
        }
        #copyright a,
        #copyright p {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_copyright_font', 'Indie Flower, cursive' )); ?>;
            font-size:<?php echo esc_attr(get_theme_mod( 'personnew_copyright_font_size', '16' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_copyright_color', '#5a2b59' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'personnew_copyright_underline', 'none' )); ?>;
        }
        #copyright a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'personnew_copyright_hover_color', '' )); ?>;
            text-decoration:<?php echo esc_attr(get_theme_mod( 'personnew_copyright_underline_hover', 'none' )); ?>;
        }
        #social p,
        #social a{
            font-size:<?php echo esc_attr(get_theme_mod( 'personnew_soc_size', '13' )); ?>px;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_soc_color', '#fff' )); ?>;
        }
        #social a:hover{
            color:<?php echo esc_attr(get_theme_mod( 'personnew_soc_color_hover', '#D39B45' )); ?>;
        }
        body h1 {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_h1_font', 'Shadows Into Light Two, cursive' )); ?>;
            color:<?php echo get_theme_mod( 'personnew_h1_color', '#222' ); ?>;
        }
        body h2 {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_h2_font', 'Shadows Into Light Two, cursive' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_h2_color', '#fff' )); ?>;
        }
        body h3 {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_h3_font', 'Shadows Into Light Two, cursive' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_h3_color', '#fff' )); ?>;
        }
        body h4 {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_h4_font', 'Indie Flower, cursive' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_h4_color', '#222' )); ?>;
        }
        body h5 {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_h5_font', 'Indie Flower, cursive' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_h5_color', '#222' )); ?>;
        }
        body h6 {
            font-family:<?php echo esc_attr(get_theme_mod( 'personnew_h6_font', 'Indie Flower, cursive' )); ?>;
            color:<?php echo esc_attr(get_theme_mod( 'personnew_h6_color', '#222' )); ?>;
        }
        .site-header {
            <?php if(!is_front_page()) echo "background:none;";?>
        }
        #header-1 {
            <?php if(is_front_page()) echo "padding-bottom:117px;";?>
        }


        .heading--scroll-effect:after,
        .heading--scroll-effect:before{
            border-color: <?php echo esc_attr(get_theme_mod( 'personnew_theme_color', '#D39B45' )); ?> !important;
        }
        .store .product:hover .footer-product,
        .heading--scroll-effect:hover:after,
        .heading--scroll-effect:hover:before{
         border-color: <?php echo esc_attr(get_theme_mod( 'personnew_theme_color', '#D39B45' )); ?> !important;
        }
        .button:hover:before,
        .button:hover:after,
        .link-blog a:hover:before,
        .button > input[type="submit"]:hover:before,
        #post .more-button:hover:before,
        .link-blog a:hover:after,
        .button > input[type="submit"]:hover:after,
        #post .more-button:hover:after,
        .top-up:hover,
        .onsale {
            background: <?php echo esc_attr(get_theme_mod( 'personnew_theme_color', '#D39B45' )); ?> !important;
        }
        .store .product:hover .footer-product a h3,
        .top-up i,
        #blog .page-title,
        #blog-sidebar .page-title,
        #page .entry-title,
        #myTab a,
        .product-category  h3 {
            color: <?php echo esc_attr(get_theme_mod( 'personnew_theme_color', '#D39B45' )); ?> !important;
        }

        .site-footer {
            background: <?php echo esc_attr(get_theme_mod( 'personnew_footer_background', '#222222' )); ?>;
        }
    </style>
<?php
}
add_action( 'wp_head', 'personnew_customize_css');

function personnew_custom_css() {
    echo '<style type="text/css" id="personnew-custom-css">' .
    get_theme_mod( 'personnew_custom_css', '' ) . '</style>';
}
add_action( 'wp_head', 'personnew_custom_css');


function add_googleanalytics() { ?>
    <script type="text/javascript">
    <?php echo esc_attr(get_theme_mod( 'personnew_add_googleanalytics', '' )); ?>
    </script>
<?php
}
add_action('wp_footer', 'add_googleanalytics');

function personnew_customize_preview_js() {
    wp_enqueue_script( 'personnew-customizer', get_template_directory_uri() . '/js/theme-customizer.js', array( 'customize-preview' ), '20120187', true );
}

function personnew_after_setup_theme() {
    add_action( 'customize_preview_init', 'personnew_customize_preview_js' );
}
add_action( 'after_setup_theme', 'personnew_after_setup_theme' );

function personnew_callback(){
    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'woocommerce' );
    $args = array(
        'flex-width'    => true,
        'width'         => 980,
        'flex-height'    => true,
        'height'        => 400,
    );
    add_theme_support( 'custom-header', $args );
    add_editor_style( get_template_directory_uri() . '/css/editor-style.css' );
    add_theme_support( 'post-formats', array( 'aside','link','gallery','image','quote','status','video','audio','chat' ) );
    load_theme_textdomain('personnew', get_template_directory() . '/languages');
}
add_action('after_setup_theme', 'personnew_callback');

//--------Settings themplate
//Add register Menu
register_nav_menu( 'primary', __( 'Navigation Menu', 'personnew' ) );


require get_template_directory() . '/inc/settings_template.php';

//--------IE-------
add_action( 'wp_head', 'personnew_head_callback' );
    function personnew_head_callback() {
        global $wp_styles;
        wp_enqueue_style( 'personnew-ie', get_template_directory_uri() . "/css/ie.css", array( 'personnew' )  );
        $wp_styles->add_data( 'personnew-ie', 'conditional', 'lt IE 8' ); ?>
        <!--[if IE]><script src="<?php echo get_template_directory_uri();
 ?>/js/html5.js"></script><![endif]-->
 <?php
 } // end wp_head callback

if ( ! isset( $content_width ) )
    $content_width = 604;

if (is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) wp_enqueue_script('comment-reply');

//--------Widgets

function personnew_sidebar_init() {
    register_sidebar(
        array(
            'name'          => __( 'SideBar Left', 'personnew' ),
            'id'            => 'sidebar_left',
            'description'   => __( 'Appears in the left column of the site.', 'personnew' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
            ) );

    register_sidebar(
        array(
            'name'          => __( 'SideBar Right', 'personnew' ),
            'id'            => 'sidebar_right',
            'description'   => __( 'Appears in the right column of the site.', 'personnew' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
            ) );

    register_sidebar(
        array(
            'id' => 'content_top',
            'name' => __( 'Content top', 'personnew'),
            'description' => __( 'Content top', 'personnew' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_content_top">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'content_bottom',
            'name' => __( 'Content bottom', 'personnew'),
            'description' => __( 'Content bottom', 'personnew' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_content_bottom">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'footer_left',
            'name' => __( 'Footer left', 'personnew'),
            'description' => __( 'Footer left', 'personnew' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_footer_left">',
            'after_title' => '</h3>'
        ) );

    register_sidebar(
        array(
            'id' => 'footer_right',
            'name' => __( 'Footer right', 'personnew'),
            'description' => __( 'Footer right', 'personnew' ),
            'before_widget' => '<div id="%1$s" class="%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title_footer_right">',
            'after_title' => '</h3>'
        ) );
}
add_action( 'widgets_init', 'personnew_sidebar_init' );

//css styles connect to the admin

function personnew_style_backend() {
    wp_enqueue_style( 'admin_style', get_template_directory_uri()  .  '/css/admin_style.css' );
    wp_enqueue_style( 'font-awesomes', get_template_directory_uri()  .  "/css/font-awesome.min.css" );

}
add_action( 'admin_enqueue_scripts', 'personnew_style_backend' );


//styles and scripts

function personnew_rigistre_scripts() {
    $personnew_uri = get_template_directory_uri();

    wp_enqueue_script('personnew_bootstrap_script', $personnew_uri . '/bootstrap/js/bootstrap.js', array( 'jquery' ), false);

    wp_enqueue_script('personnew_viewportchecker_script', $personnew_uri . '/js/jquery.viewportchecker.js', array( 'jquery' ), false);

    wp_enqueue_script( 'personnew_script', $personnew_uri . '/js/functions.js', array( 'jquery' ), '20140319', true );

     //wp_enqueue_script('personnew_masonry_script',   $personnew_uri . '/js/masonry.pkgd.js','','3.3.2' , array( 'jquery' ), true);

     wp_enqueue_script('personnew_modernizr_script',   $personnew_uri . '/js/modernizr.js','','2.7.1' , array( 'jquery' ), true);

     wp_enqueue_script('personnew_swiper_script',   $personnew_uri . '/js/swiper.min.js','','3.1.7' , array( 'jquery' ), false);

     wp_enqueue_script('personnew_hc-sticky_script',   $personnew_uri . '/js/jquery-hc-sticky.js','1.2', array( 'jquery' ), false);

     wp_enqueue_script('personnew_custom_script',   $personnew_uri . '/js/custom.js','','1.0', array( 'jquery' ), true);


    wp_enqueue_style('personnew_bootstrap_style', get_template_directory_uri() . '/bootstrap/css/bootstrap.css');

    wp_enqueue_style('personnew_style_main',   get_stylesheet_uri(), array() );

    //wp_enqueue_style('personnew_style_animate',   $personnew_uri . '/css/animate.css');

    wp_enqueue_style('personnew_style_swiper',   $personnew_uri . '/css/swiper.min.css');

    wp_enqueue_style('personnew_style_font-awesome',  $personnew_uri . '/css/font-awesome.min.css');

    wp_enqueue_style('personnew_style_ionicons',   $personnew_uri . '/css/ionicons.min.css');

    wp_enqueue_style('fonts','http://fonts.googleapis.com/css?family=Indie+Flower|Rock+Salt|Shadows+Into+Light+Two|Cuprum:700italic,400,400italic,700|Josefin+Slab:100,300,400,600,700,100italic,300italic,400italic,600italic,700italic|Special+Elite|Orbitron:400,500,700,900|Alegreya+SC:400,400italic,700,700italic,900,900italic|Comfortaa:400,300,700|Abel|Dosis:400,200,300,500,600,700,800|Droid+Sans:400,700|Francois+One|Exo:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic|Tangerine:400,700|Josefin+Sans:100,300,400,600,700,100italic,300italic,400italic,600italic,700italic|Lato:400,100,300,400italic,300italic,100italic,700,700italic,900,900italic|Lobster|Lora:400,400italic,700,700italic|Oswald:300,400,700|Open+Sans+Condensed:300,300italic,700|Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800italic,800|Oswald:400,300,700|Oxygen:400,300,700|Philosopher:400,700,400italic,700italic|Playfair+Display+SC:400,400italic,700,700italic,900,900italic|PT+Sans+Narrow:400,700|PT+Sans:400,400italic,700,700italic|Prosto+One|Quicksand:400,300,700|Roboto+Condensed:400,300,300italic,400italic,700,700italic|Share:400,400italic,700,700italic|Poiret+One|Source+Sans+Pro:400,200,200italic,300,300italic,400italic,600,600italic,700,700italic,900,900italic|Montserrat:400,700|Merriweather:400,300italic,300,400italic,700,700italic,900,900italic|Ubuntu+Condensed|Ubuntu:400,300,300italic,400italic,500,500italic,700,700italic|Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic&subset=latin,cyrillic-ext,latin-ext,cyrillic');
}
add_action( 'wp_enqueue_scripts', 'personnew_rigistre_scripts' );

//excerpt
function personnew_excerpt($num) {
    $limit = $num+1;
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
    echo $excerpt;
}

function personnew_post_nav() {
    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous ) {
        return;
    }
    ?>
    <nav class="navigation post-navigation" role="navigation">
        <h1 class="screen-reader-text"><?php _e( 'Post navigation', 'personnew' ); ?></h1>
        <div class="nav-links">
            <?php
            if ( is_attachment() ) :
                previous_post_link( '%link', __( '<span class="meta-nav">Published In</span>%title', 'personnew' ) );
            else :
                previous_post_link( '%link', __( '<span class="meta-nav">Previous Post: </span>%title', 'personnew' ) );
                next_post_link( '%link', __( '<span class="meta-nav">Next Post: </span>%title', 'personnew' ) );
            endif;
            ?>
        </div><!-- .nav-links -->
    </nav><!-- .navigation -->
    <?php
}

function personnew_entry_meta() {
    if ( is_sticky() && is_home() && ! is_paged() )
        echo '<span class="featured-post">' . __( 'Sticky', 'personnew' ) . '</span>';

    // Translators: used between list items, there is a space after the comma.
    $categories_list = get_the_category_list( __( ', ', 'personnew' ) );
    if ( $categories_list ) {
        echo '<span class="categories-links"><i class="ion-ios-list-outline"></i>' . $categories_list . '</span>';
    }

    // Translators: used between list items, there is a space after the comma.
    $tag_list = get_the_tag_list( '', __( ', ', 'personnew' ) );
    if ( $tag_list ) {
        echo '<span class="tags-links"><i class="ion-ios-pricetag-outline"></i>' . $tag_list . '</span>';
    }

    // Post author
    if ( 'post' == get_post_type() ) {
        printf( '<span class="author vcard"><i class="ion-ios-person-outline"></i><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
        esc_attr( sprintf( __( 'View all posts by %s', 'personnew' ), get_the_author() ) ),
        get_the_author()
        );
    }
};

function personnew_entry_date( $echo = true ) {
    $date = sprintf( '<span class="date"><i class="fa fa-calendar-check-o"></i><a href="%s" title="%s" rel="bookmark"><time class="entry-date" datetime="%s"><span class="date--day">%s</span> <span class="date--month">%s</span> <span class="date--year">%s</span></time></a></span>',
    esc_url( get_permalink() ),
    esc_attr( sprintf( __( 'Permalink to %s', 'personnew' ), the_title_attribute( 'echo=0' ) ) ),
    esc_attr( get_the_date( 'c' ) ),
    esc_attr( get_the_date( 'd' ) ),
    esc_attr( get_the_date( 'M' ) ),
    esc_attr( get_the_date( 'Y' ) )
);

    if ( $echo )
        echo $date;

    return $date;
};

function personnew_the_attached_image() {
    /**
    * Filter the image attachment size to use.
    * @param array $size {
    *  @type int The attachment height in pixels.
    *  @type int The attachment width in pixels.
    * }
    */
    $attachment_size = apply_filters( 'personnew_attachment_size', array( 724, 724 ) );
    $next_attachment_url = wp_get_attachment_url();
    $post  = get_post();

    /*
    * Grab the IDs of all the image attachments in a gallery so we can get the URL
    * of the next adjacent image in a gallery, or the first image (if we're
    * looking at the last image in a gallery), or, in a gallery of one, just the
    * link to that image file.
    */
    $attachment_ids = get_posts( array(
        'post_parent'    => $post->post_parent,
        'fields'         => 'ids',
        'numberposts'    => -1,
        'post_status'    => 'inherit',
        'post_type'      => 'attachment',
        'post_mime_type' => 'image',
        'order'          => 'ASC',
        'orderby'        => 'menu_order ID'
    ) );

    // If there is more than 1 attachment in a gallery...
    if ( count( $attachment_ids ) > 1 ) {
        foreach ( $attachment_ids as $attachment_id ) {
        if ( $attachment_id == $post->ID ) {
            $next_id = current( $attachment_ids );
        break;
        }
    }

    // get the URL of the next image attachment...
    if ( $next_id )
        $next_attachment_url = get_attachment_link( $next_id );

    // or get the URL of the first image attachment.
    else
        $next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
    }

    printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>',
    esc_url( $next_attachment_url ),
    the_title_attribute( array( 'echo' => false ) ),
    wp_get_attachment_image( $post->ID, $attachment_size )
    );
}

function personnew_pagenavi($post_type ='',$posts_per_page = '') {

   $count_posts = wp_count_posts();


    $big = 999999999;
    $args = array(
        'personnew' => str_replace( $big, '%#%', get_pagenum_link( $big, false ) )
        ,'fobsat' => ''
        ,'current' => max( 1, get_query_var('paged') )
        ,'total' => ceil($count_posts->publish/$posts_per_page  )

    );
    $result = paginate_links( $args );
    $result = str_replace( '/page/1"', '"', $result );

    echo $result;
}


/*-------team---------*/

add_action('init', 'team');
function team() {
    register_post_type('team', array(
    'public' => true,
    'supports' => array('title','thumbnail','editor'),
    'labels' => array(
        'name' => 'Team',
        'add_new' => 'Add new',
        'all_items' => 'All',
        'add_new_item' => 'Add new'
        )
    ));
}

/*-------text slider---------*/

add_action('init', 'text_slider');
function text_slider() {
    register_post_type('text_slider', array(
    'public' => true,
    'supports' => array('title','editor'),
    'labels' => array(
        'name' => 'Text Slider',
        'add_new' => 'Add new',
        'all_items' => 'All',
        'add_new_item' => 'Add new'
        )
    ));
}