<?php
 /**
   * The template for Home page.
   * Template Name: Home
   *
   * @package   personnew WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * personnew is distributed under the terms of the GNU GPL
   */
  $sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}

$content_top = false;
if (is_active_sidebar( 'content_top' ) ) {
    $content_top = true;
}

$content_bottom = false;
if (is_active_sidebar( 'content_bottom' ) ) {
    $content_bottom = true;
}


if ((get_theme_mod('personnew_header_layout_home')) === 'header' ) :
    get_header();
elseif ((get_theme_mod('personnew_header_layout_home')) === 'header-main' ) :
    get_header('main');
else :
    get_header();
endif;
?>

<div id="main" class="site-main">

    <?php //Full or 1170px width
        if ((get_theme_mod('personnew_home_width')) === 'container' ) :
        echo '<div id="content" class="site-content container">';
        else :
        echo '<div id="content" class="site-content">';
        endif; ?>

        <div class="row">
            <?php if (is_active_sidebar( 'content_top' ) ) : ?>
            <div class="col-lg-12">
                <article id="content-top">
                    <?php  dynamic_sidebar('content_top'); ?>
                </article>
            </div>
            <?php endif; ?>
        </div>
        <div class="page-content" style="<?php echo esc_attr(get_theme_mod( 'personnew_content_show' )); ?>">
            <?php the_title( '<h2 class="title-home-page">', '</h2>' ); ?>

                <?php while ( have_posts() ) : the_post(); ?>
                    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <?php if (has_post_thumbnail( $post->ID ) ): ?>
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
                        <div id="bg-content">
                            <div class="content-overlay"></div>
                            <div class="content-box">
                            <?php endif; ?>
                                <div class="entry-content row">
                                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 col-lg-offset-2
                                    col-md-offset-2 col-sm-offset-2">
                                    <?php the_content(); ?>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 col-lg-offset-1 col-md-offset-1 col-sm-offset-1 post_image-block">
                                    <?php the_post_thumbnail(array(900,900)); ?>
                                    </div>

                                </div><!-- .entry-content -->
                            </div>
                        </div><!-- end #category-name -->
                <?php endwhile; ?>
            </div>
        </div>

        <div class="row">
            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                    <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>
        <div class="blog-content">
            <div class="title-block row">
                <div class="col-lg-3 col-md-3 col-sm-5 col-xs-12 col-lg-offset-2 col-md-offset-2 col-sm-offset-2">
                    <h2 class="title">
                    <?php if(get_theme_mod( 'personnew_home_blog_title')) :
                        echo  esc_attr(get_theme_mod( 'personnew_home_blog_title'));
                    else :
                        _e('Ours fresh news', 'personnew');
                    endif; ?>
                    </h2>
                </div>
            </div>
            <div class="<?php if($sidebar_right && $sidebar_left) :
                    echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                    elseif($sidebar_right || $sidebar_left) :
                    echo ('col-lg-9 col-md-9 col-sm-9 col-xs-12');
                    else :
                    echo('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                    endif; ?>">
                     <div class="row">

                        <?php get_template_part( 'loop' ); ?>
                    </div>
            </div>
            <?php if (is_active_sidebar( 'sidebar_right' ) ) : ?>
                <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                    <?php dynamic_sidebar('sidebar_right'); ?>
                </article>
                </div>
            <?php endif; ?>
        </div>
        </div>

<!--         <div id="any-section" style="<?php echo esc_attr(get_theme_mod( 'personnew_any_section_show', 'display:none' )); ?>;">
            <div class="title-block row">
                <div class="col-lg-3 col-md-3 col-sm-5 col-xs-12 col-lg-offset-2 col-md-offset-2 col-sm-offset-2">
                    <h2 class="title"><?php echo esc_attr(get_theme_mod( 'personnew_any_section_title', '' )); ?></h2>
                </div>
            </div>
        <?php echo do_shortcode(get_theme_mod( 'personnew_any_shortcode')); ?>
        </div> -->

        <div class="row">
            <?php if (is_active_sidebar( 'content_bottom' ) ) : ?>
            <div class="col-lg-12">
                <article id="content-bottom">
                    <?php  dynamic_sidebar('content_bottom'); ?>
                </article>
            </div>
            <?php endif; ?>
        </div>

        <div id="shop-section" style="<?php echo esc_attr(get_theme_mod( 'personnew_shop_show', 'display:none' )); ?>;">
                <div class="title-block row">
                    <div class="col-lg-4 col-md-4 col-sm-5 col-xs-12 col-lg-offset-2 col-md-offset-2 col-sm-offset-2">
                        <h2 class="title"><?php if (get_theme_mod( 'personnew_home_shop_title' )) :
                            echo esc_attr(get_theme_mod( 'personnew_home_shop_title' ));
                            else :
                            echo __('Last Products', 'personnew');
                            endif; ?>
                        </h2>
                    </div>
                </div>
                <div class="store">
                    <div class="row">
                    <?php $posts_per_page = get_theme_mod( 'personnew_products_show', '8' );
                        $args=array(
                            'post_type' => 'product',
                            'post_status' => 'publish',
                            'posts_per_page' => $posts_per_page,
                        );
                    $my_products = null;
                    $my_products = new WP_Query($args);
                        if( $my_products->have_posts() ) {
                        while( $my_products->have_posts() ){ $my_products->the_post();
                            get_template_part( 'products' );
                        }
                        wp_reset_query();
                        } else {
                            get_template_part( 'content', 'none' );
                    } ?>
                </div>
            </div>
        </div>

        <div id="about-us">
           <div class="row container-fixed-block ">
                <div class="fixed-block col-lg-6 col-md-6 col-sm-6 col-xs-12" style="background:url(<?php echo esc_attr(get_theme_mod( 'personnew_about_img')); ?>)">
                    <div class="title-block row">
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 col-lg-offset-2">
                            <h2 class="title"><?php if (get_theme_mod( 'personnew_about_title' )) :
                                echo esc_attr(get_theme_mod( 'personnew_about_title' ));
                                else :
                                echo __('About us', 'personnew');
                                endif; ?>
                            </h2>
                        </div>
                    </div>
                </div>

                <div id="forms" class="col-lg-6 col-md-6 col-sm-6 col-xs-12" >
                    <div class="title-block row">
                        <div class="col-lg-6 col-md-6 col-sm-8 col-xs-12 col-lg-offset-4 col-md-offset-3 col-sm-offset-3">
                            <h4 class="title"><?php if (get_theme_mod( 'personnew_about_right_title1' )) :
                                echo esc_attr(get_theme_mod( 'personnew_about_right_title1' ));
                                else :
                                echo __('Contact form', 'personnew');
                                endif; ?>
                            </h4>
                        </div>
                    </div>

                   <?php echo do_shortcode(get_theme_mod( 'personnew_about_shortcode_top')); ?>

                </div>

                <div id="adress" class="col-lg-6 col-md-6 col-sm-6 col-xs-12 col-lg-offset-6 col-md-offset-6 col-sm-offset-6" >

                    <div class="title-block row">
                            <div class="col-lg-6 col-md-6 col-sm-8 col-xs-12 col-lg-offset-4 col-md-offset-3 col-sm-offset-3">
                                <h4 class="title"><?php if (get_theme_mod( 'personnew_about_right_title2' )) :
                                    echo esc_attr(get_theme_mod( 'personnew_about_right_title2' ));
                                    else :
                                    echo __('Adress', 'personnew');
                                    endif; ?>
                                </h4>
                            </div>
                    </div>

                   <div class="row">

                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <h3>Adress</h3>
                            <span>790</span>
                            <span>7th Avenue</span>
                            <span>at 51st Street</span>
                            <span>New York city</span>
                            <span>NY 10019</span>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <h3>Phone</h3>
                            <span>+00 (777)-777-77</span>
                            <span>+00 (555)-555-55</span>
                            <span>+00 (999)-355-55</span>
                            <span>+00 (525)-777-55</span>
                            <span>+00 (555)-555-22</span>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <h3>E-mail</h3>
                            <span>admin@f-cast.com</span>
                            <span>shop@f-cast.com</span>
                            <span>info@f-cast.com</span>
                            <span>support@f-cast.com</span>
                            <span>www.f-cast.com</span>
                        </div>
                    </div>

                </div>

                <div id="map" class="col-lg-6 col-md-6 col-sm-6 col-xs-12 col-lg-offset-6 col-md-offset-6 col-sm-offset-6" >

                    <div class="title-block row">
                            <div class="col-lg-6 col-md-6 col-sm-8 col-xs-12 col-lg-offset-4 col-md-offset-3 col-sm-offset-3">
                                <h4 class="title"><?php if (get_theme_mod( 'personnew_about_right_title3' )) :
                                    echo esc_attr(get_theme_mod( 'personnew_about_right_title3' ));
                                    else :
                                    echo __('Find Us', 'personnew');
                                    endif; ?>
                                </h4>
                            </div>
                    </div>

                    <?php echo do_shortcode(get_theme_mod( 'personnew_about_shortcode_bottom')); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>