<?php
 /**
   * The loop Page.
   *
   *
   * @package   personnew WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license  www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * personnew is distributed under the terms of the GNU GPL
   */
?>
<article class="last_category">
    <div class="accordion">
        <?php query_posts(
            array( 'showposts' => -1,
                        'tax_query' => array(
                        array(
                            'taxonomy' => 'post_format',
                            'field' => 'slug',
                            'terms' => array('post-format-audio','post-format-video','post-format-gallery','post-format-image','post-format-aside'),
                            'operator' => 'NOT IN'
                        )
                    )
                ));
                if( have_posts() ){ while( have_posts() ) {  the_post(); ?>
        <?php
            $image_id = get_post_thumbnail_id();
            $image_url = wp_get_attachment_image_src($image_id,500,500);
            $image_url = $image_url[0];
        ?>
        <section class="col-md-12 col-sm-12 col-xs-12 accordion-body" style="background: url(<?php echo "$image_url"; ?>)">
            <div class="accord-header">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-8">
                    <h3 class="cat-title">
                        <span class="accordion-title"><?php the_title();  ?></span>
                    </h3>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-4 date">
                    <div class="date-body">
                        <?php $date = the_date('d M Y', '<h2>', '</h5>', $echo = false); echo (str_replace(" ", '</h2><h5>', $date));?>
                    </div>
                </div>
            </div>
            <div class="accord-content">
                <div class="cat-body">
                    <?php the_excerpt(); ?>
                </div>
                <span class="link-blog">
                    <a class="more-button" href="<?php the_permalink(); ?>" rel="bookmark">
                            <?php if (get_theme_mod( 'personnew_more_button' )) :
                                    echo esc_attr(get_theme_mod( 'personnew_more_button' ));
                                else :
                                    _e('Read Now', 'personnew');
                                endif; ?></a>
                </span>
            </div>
        </section>
        <span class="overlayed"></span>
        <?php }
                wp_reset_query();
                } else { ?>
                    <h2><?php  _e('News not found', 'personnew'); ?></h2>
                <?php  } ?>
    </div>
</article>