<?php
/**
   * The template for Footer.
   *
   *
   * @package   cuisine WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * cuisine is distributed under the terms of the GNU GPL
*/
$footer_left = false;
if (is_active_sidebar( 'footer_left' ) ) {
    $footer_left = true;
}
$footer_left_center = false;
if (is_active_sidebar( 'footer_left_center' ) ) {
    $footer_left_center = true;
}

$footer_right_center = false;
if (is_active_sidebar( 'footer_right_center' ) ) {
    $footer_right_center = true;
}

$footer_right = false;
if (is_active_sidebar( 'footer_right' ) ) {
    $footer_right = true;
}

?>
<?php if (get_theme_mod('cuisine_footer_bg')) : ?>
    <footer id="footer" class="site-footer" style="background-image:url(<?php echo esc_attr(get_theme_mod('cuisine_footer_bg'))?>);">
     <?php else : ?>
    <footer id="footer" class="site-footer" style="background-image:url(<?php echo get_template_directory_uri(); ?>/images/footer_cuisine-min.png);">
    <?php endif; ?>
        <div class="footer-top">
            <div class="row">
                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 footer_logo">
                    <?php if ((get_theme_mod("cuisine_logo_img"))&&(get_theme_mod('cuisine_logo_link'))) : ?>
                        <a class="logo_link" href="<?php echo esc_url(get_theme_mod('cuisine_logo_link')); ?>">
                            <img id="logo" src="<?php echo esc_url(get_theme_mod("cuisine_logo_img")); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                        </a>
                    <?php endif; ?>
                    <?php if ((get_theme_mod("cuisine_logo_img"))&&(!get_theme_mod('cuisine_logo_link'))) : ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                            <img id="logo" src="<?php echo esc_url(get_theme_mod("cuisine_logo_img")); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                        </a>
                    <?php endif; ?>
                    <?php if ((!get_theme_mod("cuisine_logo_img"))&&(get_theme_mod('cuisine_logo_link'))) : ?>
                        <a class="logo_link" href="<?php echo esc_url(get_theme_mod('cuisine_logo_link')); ?>">
                            <h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
                        </a>
                    <?php endif; ?>
                    <?php if ((!get_theme_mod("cuisine_logo_img"))&&(!get_theme_mod('cuisine_logo_link'))) : ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                           <img id="logo" src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                        </a>
                    <?php endif; ?>
                </div>
                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                    <div class="row">
                    <?php if (is_active_sidebar( 'footer_left' ) ) : ?>
                        <div class="<?php if($footer_left_center && $footer_right_center && $footer_right ) :
                            echo 'col-lg-3 col-md-3 col-sm-3 col-xs-12';
                          elseif ($footer_left_center && $footer_right_center || $footer_left_center && $footer_right || $footer_right_center && $footer_right ) :
                            echo ('col-lg-4 col-md-4 col-sm-4 col-xs-12');
                        elseif ($footer_left_center || $footer_right_center || $footer_right ) :
                            echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                        else :
                            echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                          endif; ?>">
                            <?php  dynamic_sidebar('footer_left'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (is_active_sidebar( 'footer_left_center' ) ) : ?>
                        <div class="<?php if($footer_left && $footer_right_center && $footer_right ) :
                            echo 'col-lg-3 col-md-3 col-sm-3 col-xs-12';
                          elseif ($footer_left && $footer_right_center || $footer_left && $footer_right || $footer_right_center && $footer_right ) :
                            echo ('col-lg-4 col-md-4 col-sm-4 col-xs-12');
                        elseif ($footer_left || $footer_right_center || $footer_right ) :
                            echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                        else :
                            echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                          endif; ?>">
                            <?php  dynamic_sidebar('footer_left_center'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (is_active_sidebar( 'footer_right_center' ) ) : ?>
                        <div class="<?php if($footer_left && $footer_left_center && $footer_right ) :
                            echo 'col-lg-3 col-md-3 col-sm-3 col-xs-12';
                          elseif ($footer_left && $footer_left_center || $footer_left && $footer_right || $footer_left_center && $footer_right ) :
                            echo ('col-lg-4 col-md-4 col-sm-4 col-xs-12');
                        elseif ($footer_left || $footer_left_center || $footer_right ) :
                            echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                        else :
                            echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                          endif; ?>">
                            <?php  dynamic_sidebar('footer_right_center'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (is_active_sidebar( 'footer_right' ) ) : ?>
                        <div class="<?php if($footer_left && $footer_left_center && $footer_right_center ) :
                            echo 'col-lg-3 col-md-3 col-sm-3 col-xs-12';
                          elseif ($footer_left && $footer_left_center || $footer_left && $footer_right_center || $footer_left_center && $footer_right_center ) :
                            echo ('col-lg-4 col-md-4 col-sm-4 col-xs-12');
                        elseif ($footer_left || $footer_left_center || $footer_right_center ) :
                            echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                        else :
                            echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                          endif; ?>">
                            <?php  dynamic_sidebar('footer_right'); ?>
                        </div>
                    <?php endif; ?>
                   </div>
                </div>
            </div>


        </div>
        <div class="row footer-bottom">
                <div class="col- md-12 col-sm-12 col-lg-12 col-xs-12">
                    <div id="copyright">
                        <?php if ((get_theme_mod("cuisine_copyright_link"))&&(get_theme_mod("cuisine_copyright_text"))) : ?>
                            <a target="blank" class="copyright" href='<?php echo esc_url(get_theme_mod("cuisine_copyright_link"));?>'>
                            <?php echo esc_attr(get_theme_mod('cuisine_copyright_text')) . date('Y');?>
                            </a>
                        <?php endif; ?>
                        <?php if ((!get_theme_mod("cuisine_copyright_link"))&&(get_theme_mod("cuisine_copyright_text"))) : ?>
                            <p><?php echo esc_attr(get_theme_mod('cuisine_copyright_text')) . date('Y');?></p>
                        <?php endif; ?>
                        <?php if ((get_theme_mod("cuisine_copyright_link"))&&(!get_theme_mod("cuisine_copyright_text"))) : ?>
                            <a target="blank" class="copyright" href='<?php echo esc_url(get_theme_mod("cuisine_copyright_link"));?>'></a>
                        <?php endif; ?>
                        <?php if ((!get_theme_mod("cuisine_copyright_link"))&&(!get_theme_mod("cuisine_copyright_text"))) : ?>
                            <a target="_blank" class="copyright" href='http://ordasoft.com/'>
                            <?php _e('Theme Design &copy; WordPress Theme OrdaSoft. All rights reserved.', 'cuisine'); ?></a>
                        <?php endif; ?>
                      </div>
                </div>
            </div>
    </footer>
</div><!-- #page -->

<?php wp_footer(); ?>
</body>
</html>