<?php
/**
   * The template for Single page.
   *
   *
   * @package   cuisine WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * cuisine is distributed under the terms of the GNU GPL
*/
  $sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}


if ((get_theme_mod('cuisine_header_layout_other')) === 'header' ) :
    get_header();
elseif ((get_theme_mod('cuisine_header_layout_other')) === 'header-main' ) :
    get_header('main');
else :
    get_header('main');
endif;
?>
<div id="single" class="single-main">
    <div id="content" class="single-content container">

        <div class="row">
            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                    <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>

            <div class="<?php if($sidebar_right && $sidebar_left) :
                echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                elseif($sidebar_right || $sidebar_left) :
                echo ('col-lg-9 col-md-9 col-sm-9 col-xs-12');
                else :
                echo('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                endif; ?>">
                    <?php if ( have_posts() ) : ?>
                    <?php while ( have_posts() ) : the_post();  ?>
                        <?php   get_template_part( 'content', $format = get_post_format() );

                        endwhile; ?>
                    <?php if ( comments_open() || get_comments_number() ) {
                        comments_template();
                            } ?>
                    <?php cuisine_post_nav();

                     else :

                        get_template_part( 'content', 'none' );

                     endif; ?>
            </div>
            <?php if (is_active_sidebar( 'sidebar_right' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                    <?php dynamic_sidebar('sidebar_right'); ?>
                </article>
                </div>
            <?php endif; ?>
        </div>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>