 <?php
  /**
   * The template for Content Video.
   *
   *
   * @package   cuisine WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * cuisine is distributed under the terms of the GNU GPL
   */
 ?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
    <div id="post" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
<?php endif; ?>

    <article class="content-video">
        <header class="entry-header">
            <?php if ( is_single() ) : ?>
                <h1 class="entry-title"><?php the_title(); ?></h1>
            <?php endif; // is_single() ?>
        </header><!-- .entry-header -->

        <div class="entry-content">
            <?php if ( is_single() ) : ?>
                <div class="video">
                    <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'cuisine' ) ); ?>
                    <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'cuisine' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
                </div>
            <?php else : ?>
                <div class="video">
                    <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'cuisine' ) ); ?>
                </div>
                <div class="entry-summary">
                    <a href="<?php the_permalink(); ?>" rel="bookmark">
                            <h2 class="entry-title">
                                <?php the_title(); ?>
                            </h2>
                        </a>
                        <p><?php the_excerpt(); ?></p>
                    </div><!-- .entry-summary -->
            <?php endif; ?>
        </div><!-- .entry-content -->

        <footer class="entry-meta">
            <?php if ( is_single() ) :
                cuisine_entry_meta();
                cuisine_entry_date();
            else : ?>
                <a class="more-button theme-color" href="<?php the_permalink(); ?>" rel="bookmark"><?php _e('Watch video', 'cuisine') ?></a>
            <?php  endif;
         if ( is_single() && comments_open() ) : ?>
            <div class="comments-link">
            <i class="fa fa-commenting-o"></i>
                <?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a comment', 'cuisine' ) . '</span>', __( 'One comment so far', 'cuisine' ), __( 'View all % comments', 'cuisine' ) ); ?>
            </div><!-- .comments-link -->
        <?php endif; // comments_open() ?>

            <?php if ( is_single() && get_the_author_meta( 'description' ) && is_multi_author() ) : ?>
                <?php get_template_part( 'author-bio' ); ?>
            <?php endif; ?>
        </footer><!-- .entry-meta -->
    </article><!-- #post -->
</div>
