<?php
 /**
   * The template for Blog.
   * Template Name: Blog
   *
   * @package   bpm128 WordPress Theme
   * @copyright  Copyright (C) 2016, OrdaSoft
   * @license      http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * bpm128 is distributed under the terms of the GNU GPL
*/
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

get_header('main');
?>
<div id="main" class="site-main">
    <div id="blog-sidebar" class="site-content">
    
    <?php the_title( '<h1 class="page-title">', '</h1>' ); ?>

        <div class="row">
            
            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar-left" class="sidebar">
                <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>


            <?php if($sidebar_left) :
                echo ('<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">');
                echo ('<div class="blog">');
            else :
                echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
                echo ('<div class="blog">');
            endif; ?>
            <section class="loop-item">
            <?php
                $published_posts = wp_count_posts()->publish;
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args=array(
                    'paged' => $paged,
                    'posts_per_page' => $posts_per_page,
                );
                $bpm128_query = null;
                $bpm128_query = new WP_Query($args);
                    if( $bpm128_query->have_posts() ) {
                    while( $bpm128_query->have_posts() ){ $bpm128_query->the_post(); ?>
                   
                            
                         
                                    <?php get_template_part( 'template-parts/post/content', 'loop' ); ?>
                            
                            

                        <?php } ?>

                    <?php  wp_reset_postdata(); ?>
            </section>
                  <?php  } else {
                        get_template_part( 'template-parts/post/content', 'none' );
                    } ?>

                </div>
            </div>

    </div><!--row end-->
<div class="pagination">
            <?php  
            bpm128_pagenavi($published_posts,$posts_per_page); ?>
        </div>
        

    </div>
</div><!-- #main -->
<?php get_footer(); ?>