<?php
/**
 * bpm128 back compat functionality
 *
 * Prevents bpm128 from running on WordPress versions prior to 4.7,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.7.
 *
 * @package WordPress
 * @subpackage bpm128
 * @since bpm128 1.0
 */

/**
 * Prevent switching to bpm128 on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since bpm128 1.0
 */
function bpm128_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'bpm128_upgrade_notice' );
}
add_action( 'after_switch_theme', 'bpm128_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * bpm128 on WordPress versions prior to 4.7.
 *
 * @since bpm128 1.0
 *
 * @global string $wp_version WordPress version.
 */
function bpm128_upgrade_notice() {
	$message = sprintf( __( 'bpm128 requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'bpm128' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.7.
 *
 * @since bpm128 1.0
 *
 * @global string $wp_version WordPress version.
 */
function bpm128_customize() {
	wp_die( sprintf( __( 'bpm128 requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'bpm128' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'bpm128_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.7.
 *
 * @since bpm128 1.0
 *
 * @global string $wp_version WordPress version.
 */
function bpm128_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( __( 'bpm128 requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'bpm128' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'bpm128_preview' );
