/**
 * File customize-preview.js.
 *
 * Instantly live-update customizer settings in the preview for improved user experience.
 */

(function( $ ) {

	// Collect information from customize-controls.js about which panels are opening.
	wp.customize.bind( 'preview-ready', function() {

		// Initially hide the theme option placeholders on load
		$( '.panel-placeholder' ).hide();

		wp.customize.preview.bind( 'section-highlight', function( data ) {

			// Only on the front page.
			if ( ! $( 'body' ).hasClass( 'bpm128-front-page' ) ) {
				return;
			}

			// When the section is expanded, show and scroll to the content placeholders, exposing the edit links.
			if ( true === data.expanded ) {
				$( 'body' ).addClass( 'highlight-front-sections' );
				$( '.panel-placeholder' ).slideDown( 200, function() {
					$.scrollTo( $( '#panel1' ), {
						duration: 600,
						offset: { 'top': -70 } // Account for sticky menu.
					});
				});

			// If we've left the panel, hide the placeholders and scroll back to the top.
			} else {
				$( 'body' ).removeClass( 'highlight-front-sections' );
				// Don't change scroll when leaving - it's likely to have unintended consequences.
				$( '.panel-placeholder' ).slideUp( 200 );
			}
		});
	});

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		});
	});
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		});
	});

	

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css({
					clip: 'rect(1px, 1px, 1px, 1px)',
					position: 'absolute'
				});
				// Add class for different logo styles if title and description are hidden.
				$( 'body' ).addClass( 'title-tagline-hidden' );
			} else {

				// Check if the text color has been removed and use default colors in theme stylesheet.
				if ( ! to.length ) {
					$( '#bpm128-custom-header-styles' ).remove();
				}
				$( '.site-title, .site-description' ).css({
					clip: 'auto',
					position: 'relative'
				});
				$( '.site-branding, .site-branding a, .site-description, .site-description a' ).css({
					color: to
				});
				// Add class for different logo styles if title and description are visible.
				$( 'body' ).removeClass( 'title-tagline-hidden' );
			}
		});
	});

	// Color scheme.
	wp.customize( 'colorscheme', function( value ) {
		value.bind( function( to ) {

			// Update color body class.
			$( 'body' )
				.removeClass( 'colors-light colors-dark colors-custom' )
				.addClass( 'colors-' + to );
		});
	});

	// Custom color hue.
	wp.customize( 'colorscheme_hue', function( value ) {
		value.bind( function( to ) {

			// Update custom color CSS.
			var style = $( '#custom-theme-colors' ),
				hue = style.data( 'hue' ),
				css = style.html();

			// Equivalent to css.replaceAll, with hue followed by comma to prevent values with units from being changed.
			css = css.split( hue + ',' ).join( to + ',' );
			style.html( css ).data( 'hue', to );
		});
	});

	// Page layouts.
	wp.customize( 'page_layout', function( value ) {
		value.bind( function( to ) {
			if ( 'one-column' === to ) {
				$( 'body' ).addClass( 'page-one-column' ).removeClass( 'page-two-column' );
			} else {
				$( 'body' ).removeClass( 'page-one-column' ).addClass( 'page-two-column' );
			}
		} );
	} );

	// Whether a header image is available.
	function hasHeaderImage() {
		var image = wp.customize( 'header_image' )();
		return '' !== image && 'remove-header' !== image;
	}

	// Whether a header video is available.
	function hasHeaderVideo() {
		var externalVideo = wp.customize( 'external_header_video' )(),
			video = wp.customize( 'header_video' )();

		return '' !== externalVideo || ( 0 !== video && '' !== video );
	}

	// Toggle a body class if a custom header exists.
	$.each( [ 'external_header_video', 'header_image', 'header_video' ], function( index, settingId ) {
		wp.customize( settingId, function( setting ) {
			setting.bind(function() {
				if ( hasHeaderImage() ) {
					$( document.body ).addClass( 'has-header-image' );
				} else {
					$( document.body ).removeClass( 'has-header-image' );
				}

				if ( ! hasHeaderVideo() ) {
					$( document.body ).removeClass( 'has-header-video' );
				}
			} );
		} );
	} );


	// Main menu settings
	wp.customize( 'bpm128_menu_font_size', function( value ) {
        value.bind( function( to ) {            
            $( '.menu li a' ).css({
				'font-size': to+'px'
			});
        } );
    } );

	wp.customize( 'bpm128_menu_font', function( value ) {
        value.bind( function( to ) {
            $('.menu li a').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_menu_color', function( value ) {
        value.bind( function( to ) {
            $('.menu li a').css({
            	'color': to
            });
        } );
    } );

    wp.customize( 'bpm128_menu_color_hover', function( value ) {
        value.bind( function( to ) {
            $('.menu li a').hover(function() {
				$('.menu li a').css({
            		'color': to
	            });
			});
        } );
    } );

    wp.customize( 'bpm128_menu_underline', function( value ) {
        value.bind( function( to ) {
            $('.menu li a').css({
            	'text-decoration': to
            });
        } );
    } );

    wp.customize( 'bpm128_menu_underline_hover', function( value ) {
        value.bind( function( to ) {
            $('.menu li a').hover(function() {
				$('.menu li a').css({
            		'text-decoration': to
	            });
			});
        } );
    } );


    wp.customize( 'bpm128_submenu_color', function( value ) {
        value.bind( function( to ) {
            $('.subn-menu li a').css({
                'color': to
            });
        } );
    } ); 

    wp.customize( 'bpm128_soc_icons_color', function( value ) {
        value.bind( function( to ) {
            $('#menu-social-links-menu li a').css({
            	'fill': to
            });
        } );
    } );

    wp.customize( 'bpm128_submenu_hover_color', function( value ) {
        value.bind( function( to ) {
            $('.sub-menu li a').hover(function() {
				$('.sub-menu li a').css({
            		'color': to
	            });
			});
        } );
    } );

    //Typography
	wp.customize( 'bpm128_font_size', function( value ) {
        value.bind( function( to ) {            
            $( 'body' ).css({
				'font-size': to+'px'
			});
        } );
    } );

	wp.customize( 'bpm128_body_font', function( value ) {
        value.bind( function( to ) {
            $('body').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_font_color', function( value ) {
        value.bind( function( to ) {
            $('body').css({
            	'color': to
            });
        } );
    } );

    //------------H1
    wp.customize( 'bpm128_h1_font', function( value ) {
        value.bind( function( to ) {
            $('body h1').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_h1_color', function( value ) {
        value.bind( function( to ) {
            $('body h1').css({
            	'color': to
            });
        } );
    } );

    //------------H2
    wp.customize( 'bpm128_h2_font', function( value ) {
        value.bind( function( to ) {
            $('body h2').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_h2_color', function( value ) {
        value.bind( function( to ) {
            $('body h2').css({
            	'color': to
            });
        } );
    } );

    //------------H3
    wp.customize( 'bpm128_h3_font', function( value ) {
        value.bind( function( to ) {
            $('body h3').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_h3_color', function( value ) {
        value.bind( function( to ) {
            $('body h3').css({
            	'color': to
            });
        } );
    } );

    //------------H4
    wp.customize( 'bpm128_h4_font', function( value ) {
        value.bind( function( to ) {
            $('body h4').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_h4_color', function( value ) {
        value.bind( function( to ) {
            $('body h4').css({
            	'color': to
            });
        } );
    } );

    //------------H5
    wp.customize( 'bpm128_h5_font', function( value ) {
        value.bind( function( to ) {
            $('body h5').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_h5_color', function( value ) {
        value.bind( function( to ) {
            $('body h5').css({
            	'color': to
            });
        } );
    } );

    //------------H6
    wp.customize( 'bpm128_h6_font', function( value ) {
        value.bind( function( to ) {
            $('body h6').css({
            	'font-family': to
            });
        } );
    } );

    wp.customize( 'bpm128_h6_color', function( value ) {
        value.bind( function( to ) {
            $('body h6').css({
            	'color': to
            });
        } );
    } );

} )( jQuery );
