<?php
/**
 * The template for displaying the footer
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 * @version 1.0
 */

?>

		</div><!-- #content -->

		<footer id="footer" class="site-footer">
			<div class="wrap">
				<?php
				get_template_part( 'template-parts/footer/footer', 'widgets' );

				?>
				
				<div class="row footer-bottom">
				<div class="container">
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
					<?php
					get_template_part( 'template-parts/footer/site', 'info' );
					?>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
						<?php
						if ( has_nav_menu( 'social' ) ) : ?>
						<nav class="social-navigation" role="navigation" aria-label="<?php _e( 'Footer Social Links Menu', 'bpm128' ); ?>">
								<?php
									wp_nav_menu( array(
										'theme_location' => 'social',
										'menu_class'     => 'social-links-menu',
										'depth'          => 1,
										'link_before'    => '<span class="screen-reader-text">',
										'link_after'     => '</span>' . bpm128_get_svg( array( 'icon' => 'chain' ) ),
									) );
								?>
						</nav><!-- .social-navigation -->
					</div>
				<?php endif; ?>
			</div><!-- .wrap -->
			</div>
		</footer><!-- #colophon -->
	</div><!-- .site-content-contain -->
</div><!-- #page -->
<?php wp_footer(); ?>

</body>
</html>
