<?php
/**
 * Template part for displaying posts on front page
 *
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 * @version 1.0
 */

$image_id = get_post_thumbnail_id();
$image_url = wp_get_attachment_image_src($image_id,800,800);
$image_url = $image_url[0]; 
?>

<div class="post-item" style="background: url(<?php echo "$image_url"; ?>)" >

    <div class="date-body">
        <span class="date-content">
        <?php $date = the_date('d M Y', '<h2>', '</h5>', $echo = false); echo (str_replace(" ", '</h2><h5>', $date));?>
        </span>
    </div>

    <h3 class="post-title">
        <span class="accordion-title"><?php the_title();  ?></span>
    </h3>

    <div class="post-body">
    <?php bpm128_excerpt(15); ?>
    </div>

    <span class="link-blog">
        <a class="more-button" href="<?php the_permalink(); ?>" rel="bookmark">
                <?php if (get_theme_mod( 'personnew_more_button' )) :
                        echo esc_attr(get_theme_mod( 'personnew_more_button' ));
                    else :
                        _e('Read Now', 'personnew');
                    endif; ?></a>
    </span>
    
</div>
                