<?php
/**
 * wp-it-courses WordPress Theme, ordasvit.com
 * wp-it-courses is distributed under the terms of the GNU GPL
 * Copyright: 2023 OrdaSvit, Andrey Kvasnevskiy, ordasvit.com
 */


//define('FS_METHOD', 'direct');

/**
 * Add support for a custom header imageHeader Text Color.
 */
//require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/inc/sanitization-callbacks.php';
require get_template_directory() . '/inc/settings-template.php';
//require get_template_directory() . '/inc/example.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-positions.php';
require get_template_directory() . '/inc/woocommerce.php';


// show the template file being used in the footer area - user must have admin bar showing and be logged in
// add_action( 'admin_bar_menu', 'show_template' );

// function show_template() {

// global $template;

// echo ":111111111:";
// print_r(  $template );

// }



/**
 * wp-it-courses only works in WordPress 3.6 or later.
 */
if (version_compare($GLOBALS['wp_version'], '3.6-alpha', '<'))
	require get_template_directory() . '/inc/back-compat.php';




if (!function_exists('wp_it_courses_entry_meta')) {
	/**
	 * Print HTML with meta information for current post: categories, tags, permalink, author, and date.
	 * Create your own wp_it_courses_entry_meta() to override in a child theme.
	 * @return void
	 */
	function wp_it_courses_entry_meta()
	{
		if (is_sticky() && is_home() && !is_paged())
			echo '<span class="featured-post">' . __('Sticky', 'wp-it-courses') . '</span>';

		if (!has_post_format('link') && 'post' == get_post_type())
			wp_it_courses_entry_date();

		// Translators: used between list items, there is a space after the comma.
		$categories_list = get_the_category_list(__(', ', 'wp-it-courses'));
		if ($categories_list) {
			echo '<span class="categories-links">' . $categories_list . '</span>';
		}

		// Translators: used between list items, there is a space after the comma.
		$tag_list = get_the_tag_list('', __(', ', 'wp-it-courses'));
		if ($tag_list) {
			echo '<span class="tags-links">' . $tag_list . '</span>';
		}

		// Post author
		if ('post' == get_post_type()) {
			printf(
				'<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
				esc_url(get_author_posts_url(get_the_author_meta('ID'))),
				esc_attr(sprintf(__('View all posts by %s', 'wp-it-courses'), get_the_author())),
				get_the_author()
			);
		}
	}
}


if (!function_exists('wp_it_courses_entry_date')) {
	/**
	 * Print HTML with date information for current post.
	 * Create your own wp_it_courses_entry_date() to override in a child theme.
	 * @param boolean $echo (optional) Whether to echo the date. Default true.
	 * @return string The HTML-formatted post date.
	 */
	function wp_it_courses_entry_date($echo = true)
	{
		if (has_post_format(array('chat', 'status')))
			$format_prefix = _x('%1$s on %2$s', '1: post format name. 2: date', 'wp-it-courses');
		else
			$format_prefix = '%2$s';

		$date = sprintf(
			'<span class="date"><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>',
			esc_url(get_permalink()),
			esc_attr(sprintf(__('Permalink to %s', 'wp-it-courses'), the_title_attribute('echo=0'))),
			esc_attr(get_the_date('c')),
			esc_html(sprintf($format_prefix, get_post_format_string(get_post_format()), get_the_date()))
		);

		if ($echo)
			echo $date;

		return $date;
	}
}
;



/**
 * Return the post URL.
 * @uses get_url_in_content() to get the URL in the post meta (if it exists) or
 * the first link found in the post content.
 * Falls back to the post permalink if no URL is found in the post.
 * @return string The Link format URL.
 */

// Add Toolbar Menus
//function custom_toolbar() {global $wp_admin_bar;}

// function tr_post_include($atts) {
//     $thepostid = intval($atts[id]);
//     $output = '';
//     query_posts("p=$thepostid");
//     if (have_posts()) : while (have_posts()) : the_post();
//         $output .= get_the_post_thumbnail($post->ID);
//         $output .= get_the_content($post->ID);
//     endwhile; else:
//         // not out
//     endif;
//     wp_reset_query();
//     return $output;
// }
// add_shortcode("pst_inc", "tr_post_include");
//[pst_inc id="449"]



//Disable Theme Updates wp-3+, comment andrew 2023_10_09
//remove_action('load-update-core.php', 'wp_update_themes');
////add_filter( 'pre_site_transient_update_themes', create_function( '$a', "return null;" ) );
//wp_clear_scheduled_hook('wp_update_themes');


//excluding these categories widget start
// function ext_widget_categories($args){
//     $exclude = "1,8"; 
//     $args["exclude"] = $exclude;
//     return $args;
// }
// add_filter("widget_categories_args","ext_widget_categories");
//excluding these categories widget end

//remove <br> and <p></p>, , comment andrew 2023_10_09
//remove_filter('the_content', 'wpautop');
//remove_filter('the_excerpt', 'wpautop');



//Add register Menu
register_nav_menus(
	array(
		'primary' => esc_html__('Primary menu', 'wp-it-courses'),
		'top_menu' => esc_html__('Top menu', 'wp-it-courses'),
		'footer_menu' => esc_html__('Footer menu', 'wp-it-courses'),
	)
);

if (function_exists('register_block_style')) {
	register_block_style(
		'core/quote',
		array(
			'name' => 'blue-quote',
			'label' => __('Blue Quote', 'wp-it-courses'),
			'is_default' => true,
			'inline_style' => '.wp-block-quote.is-style-blue-quote { color: blue; }',
		)
	);
}


require get_template_directory() . '/inc/enqueue-styles.php';
require get_template_directory() . '/inc/enqueue-scripts.php';


function wp_it_courses_new_excerpt_length($length)
{
	if ( is_admin() ) return $length;

	return 30;
}
add_filter('excerpt_length', 'wp_it_courses_new_excerpt_length');


// function wp_it_courses_new_excerpt_more($more) {
// 		global $post;
//     return '...<a href="'. get_permalink($post->ID) . '"></a>';
// }
function wp_it_courses_new_excerpt_more($more)
{
	global $post;
	
	if ( is_admin() ) return $more;

	return get_template_part('templates/single', 'post');
}


add_filter('excerpt_more', 'wp_it_courses_new_excerpt_more');


// //Paginator Post Blog
// if (!function_exists('os_pagenavi_blog')) {
// 	function os_pagenavi_blog($post_type = '', $posts_per_page = 6)
// 	{

// 		if ($post_type == "")
// 			$count_posts = wp_count_posts();
// 		else
// 			$count_posts = wp_count_posts($post_type);

// 		if ( $count_posts && isset($count_posts->publish) ) {
// 			$published_posts = $count_posts->publish;
// 		} else return ;

// 		$big = 999999999;
// 		$args = array(
// 			'base' => str_replace($big, '%#%', get_pagenum_link($big))
// 			,
// 			'format' => ''
// 			,
// 			'current' => max(1, get_query_var('paged'))
// 			,
// 			'total' => ceil($published_posts / $posts_per_page)

// 		);
// 		$result = paginate_links($args);
// 		$result = str_replace('/page/1"', '"', $result);

// 		echo $result;
// 	}
// }

if ( ! function_exists( 'wp_it_courses_the_posts_navigation' ) ) {
	function wp_it_courses_the_posts_navigation() {
		the_posts_pagination(
			array(
				'before_page_number' => esc_html__( '', 'wp-it-courses' ) . ' ',
				'mid_size'           => 1,
				'prev_text'          => sprintf(
					'%s <span class="nav-prev-text">%s</span>',
					is_rtl() ? ( '<i class="fas fa-angle-double-right"></i>' ) : ( '<i class="fas fa-angle-double-left"></i>' ),
					wp_kses(
						'<span class="nav-short">'.__( 'Prev', 'wp-it-courses' ).'</span>',
						array(
							'span' => array(
								'class' => array(),
							),
						)
					)
				),
				'next_text'          => sprintf(
					'<span class="nav-next-text">%s</span> %s',
					wp_kses(
						'<span class="nav-short">'.__( 'Next', 'wp-it-courses' ).'</span>',
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					is_rtl() ? ( '<i class="fas fa-angle-double-left"></i>' ) : ( '<i class="fas fa-angle-double-right"></i>' )
				),
			)
		);
	}
}

//Paginator Post Caregory  andrew comment 2023_09_18
// if (!function_exists('os_pagenavi_category')) {
// 	function os_pagenavi_category($posts_all, $posts_page_cat = 1)
// 	{

// 		$big = 999999989;
// 		$args = array(
// 			'base' => str_replace($big, '%#%', get_pagenum_link($big))
// 			,
// 			'format' => ''
// 			,
// 			'current' => max(1, get_query_var('paged'))
// 			,
// 			'total' => ceil($posts_all / $posts_page_cat)

// 		);

// 		$result = paginate_links($args);
// 		$result = str_replace('/page/1"', '"', $result);

// 		echo $result;
// 	}
// }
//Add Post Thumbnails
add_theme_support('post-thumbnails');

/*
 * Let WordPress manage the document title.
 * This theme does not use a hard-coded <title> tag in the document head,
 * WordPress will provide it for us.
 */
add_theme_support('title-tag');

add_theme_support('automatic-feed-links');
add_theme_support("wp-block-styles");
add_theme_support("responsive-embeds");
add_theme_support('html5', array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script'));

//Add Сustom Background
 $wp_it_courses_defaults = array(
	'default-image'          => '',
	'default-preset'         => 'default', // 'default', 'fill', 'fit', 'repeat', 'custom'
	'default-position-x'     => 'left',    // 'left', 'center', 'right'
	'default-position-y'     => 'top',     // 'top', 'center', 'bottom'
	'default-size'           => 'auto',    // 'auto', 'contain', 'cover'
	'default-repeat'         => 'repeat',  // 'repeat-x', 'repeat-y', 'repeat', 'no-repeat'
	'default-attachment'     => 'scroll',  // 'scroll', 'fixed'
	'default-color'          => '',
	'wp-head-callback'       => '_custom_background_cb',
	'admin-head-callback'    => '',
	'admin-preview-callback' => '',
);
add_theme_support( 'custom-background', $wp_it_courses_defaults );

//Add Сustom Logo
function wp_it_courses_custom_logo_setup() {
	$defaults = array(
		'height'               => 100,
		'width'                => 400,
		'flex-height'          => true,
		'flex-width'           => true,
		'header-text'          => array( 'site-title', 'site-description' ),
		'unlink-homepage-logo' => false, 
	);
	add_theme_support( 'custom-logo', $defaults );
}
add_action( 'after_setup_theme', 'wp_it_courses_custom_logo_setup' );

// Add support for full and wide align images.
add_theme_support( 'align-wide' );

// Add support for editor styles.
add_theme_support( 'editor-styles' );

$editor_stylesheet_path = './css/style-editor.css';

// Note, the is_IE global variable is defined by WordPress and is used
// to detect if the current browser is internet explorer.
global $is_IE;
if ( $is_IE ) {
	$editor_stylesheet_path = './css/ie-editor.css';
}

// Enqueue editor styles.
add_editor_style( $editor_stylesheet_path );


//widgets
class wp_it_courses_Custom_Title_Widget extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
			'title_block',
			__('Title block', 'wp-it-courses'),
			array(
				'description' => __('widget for title and text', 'wp-it-courses'),
			)
		);
	}
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = ($new_instance['title']);
		$instance['text'] = ($new_instance['text']);
		return $instance;
	}
	public function form($instance)
	{
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php echo __('Title', 'wp-it-courses'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
				name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />

			<label for="<?php echo $this->get_field_id('text'); ?>"><?php echo __('Text', 'wp-it-courses'); ?></label>
			<input class="widefat" rows="5" cols="20" id="<?php echo $this->get_field_id('text'); ?>"
				name="<?php echo $this->get_field_name('text'); ?>" type="textarea" value="<?php echo $instance['text']; ?>" />
		</p>
		<?php
	}
	public function widget($args, $instance)
	{
		?>

		<div class="title in_up">
			<span class="title_top">
				<?php echo $instance['title']; ?>
			</span>
			<p>
				<?php echo $instance['text']; ?>
			</p>

		</div>
		<?php
	}
}
add_action('widgets_init', function () {
	register_widget('wp_it_courses_Custom_Title_Widget');
});


//statistic 
class wp_it_courses_Custom_Statistic_Widget extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
			'widget_statistic',
			__('Widget Statistic', 'wp-it-courses'),
			array(
				'description' => __('widget Statistic', 'wp-it-courses'),
			)
		);
		add_action('admin_enqueue_scripts', array(&$this, 'admin_enqueue_scripts'));
	}

	public function admin_enqueue_scripts($hook_suffix)
	{
		if ($hook_suffix != 'widgets.php')
			return;

		wp_enqueue_style('wp-color-picker');
		wp_enqueue_script('wp-color-picker');
	}

	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['color'] = ($new_instance['color']);
		$instance['sizing'] = ($new_instance['sizing']);
		$instance['title'] = ($new_instance['title']);
		$instance['number'] = ($new_instance['number']);
		return $instance;
	}
	public function form($instance)
	{
		?>
		<p>
			<label for="<?php echo $this->get_field_id('color'); ?>"><?php echo __('Select color', 'wp-it-courses'); ?>:</label><br />
			<input type="text" id="<?php echo $this->get_field_id('color'); ?>"
				name="<?php echo $this->get_field_name('color'); ?>" value="<?php echo $instance['color']; ?>" /><br />

			<label for="<?php echo $this->get_field_id('sizing'); ?>"><?php echo __('Size (px)', 'wp-it-courses'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('sizing'); ?>"
				name="<?php echo $this->get_field_name('sizing'); ?>" type="text" value="<?php echo $instance['sizing']; ?>" />

			<label for="<?php echo $this->get_field_id('title'); ?>"><?php echo __('Title', 'wp-it-courses'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
				name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />

			<label for="<?php echo $this->get_field_id('number'); ?>"><?php echo __('Number', 'wp-it-courses'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('number'); ?>"
				name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $instance['number']; ?>" />
		</p>
		<script type="text/javascript">
			jQuery(document).ready(function (jQuery) {
				jQuery('#<?php echo $this->get_field_id('color'); ?>').wpColorPicker();
			});
		</script>
		<?php
	}
	public function widget($args, $instance)
	{
		?>
		<div class="statistic">
			<span class="counter"
				style="font-size:<?php echo $instance['sizing']; ?>px;color:<?php echo $instance['color']; ?>"><?php echo $instance['number']; ?></span>
			<h4>
				<?php echo $instance['title']; ?>
			</h4>
		</div>

		<?php
	}

}
add_action('widgets_init', function () {
	register_widget('wp_it_courses_Custom_Statistic_Widget');
});

if (!function_exists('wp_it_courses_show_position_preview')) {
	function wp_it_courses_show_position_preview($position_name, $css_class = "")
	{
		if (isset($_REQUEST['tp']) && $_REQUEST['tp']) {
			echo "<div class='" . $css_class . "'>";
			echo "<div class='show_theme_position'>" . $position_name . "</div>";

			if (function_exists('dynamic_sidebar'))
				dynamic_sidebar($position_name);

			echo "</div>";

			return true;
		}

		return false;
	}
}

//need for cirrect show theme positions
if (!function_exists('wp_it_courses_is_active_sidebar')) {
	function wp_it_courses_is_active_sidebar($position_name)
	{
		if (isset($_REQUEST['tp']) && $_REQUEST['tp']) {
			return true;
		}else{
			return is_active_sidebar($position_name) ;
		}

	}
}


/*-----comment tags-----*/
function wp_it_courses_theme_init()
{
	add_filter('comment_form_defaults', 'wp_it_courses_theme_comments_form_defaults');
}
add_action('after_setup_theme', 'wp_it_courses_theme_init');
function wp_it_courses_theme_comments_form_defaults($default)
{
	unset($default['comment_notes_after']);
	return $default;
}



