<?php
/**
 * wp-it-courses WordPress Theme, ordasvit.com
 * wp-it-courses is distributed under the terms of the GNU GPL
 * Copyright: 2023 OrdaSvit, Andrey Kvasnevskiy, ordasvit.com
 */

/**
 * Header scripts for this theme
 *
 * @package WordPress
 * @subpackage wp_it_courses
 */

//file js connect to the admin
function wp_it_courses_true_include_in_admin()
{
	wp_enqueue_script('wp_it_courses_js_admin', get_stylesheet_directory_uri() . '/js/js_admin.js');
}
add_action('admin_enqueue_scripts', 'wp_it_courses_true_include_in_admin');
//file js connect to the admin


function wp_it_courses_rigistre_scripts()
{
	$os_uri = get_template_directory_uri();

	wp_register_script('wp_it_courses_jquery_script', $os_uri . '/js/custom.js', array('jquery') , false);
	wp_enqueue_script('wp_it_courses_jquery_script');

	wp_register_script('wp_it_courses_bootstrap_script', $os_uri . '/bootstrap/js/bootstrap.js', false);
	wp_enqueue_script('wp_it_courses_bootstrap_script');

	wp_register_script('wp_it_courses_viewportchecker_script', $os_uri . '/js/viewportchecker.js', false);
	wp_enqueue_script('wp_it_courses_viewportchecker_script');

	wp_register_script('wp_it_courses_swiper_js', $os_uri . '/js/swiper.min.js', false);
	wp_enqueue_script('wp_it_courses_swiper_js');

	wp_register_script('wp_it_courses_animate_script', $os_uri . '/js/animate.js', false);
	wp_enqueue_script('wp_it_courses_animate_script');

	wp_register_script('wp_it_courses_waypoints_script', $os_uri . '/js/waypoints.min.js', false);
	wp_enqueue_script('wp_it_courses_waypoints_script');

	// Threaded comment reply styles.
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

}
add_action('wp_enqueue_scripts', 'wp_it_courses_rigistre_scripts');


add_action('wp_enqueue_scripts', 'wp_it_courses_theme_enqueue_scripts');

function wp_it_courses_theme_enqueue_scripts()
{
	wp_enqueue_style('animate', get_stylesheet_directory_uri() . '/css/animate.css');
	wp_enqueue_script('wow', get_stylesheet_directory_uri() . '/js/wow.min.js', array(), '', true);
}

add_action('wp_enqueue_scripts', 'wp_it_courses_theme_wow_init_in_footer');
function wp_it_courses_theme_wow_init_in_footer()
{
	add_action('print_footer_scripts', 'wp_it_courses_wow_init');
}
function wp_it_courses_wow_init()
{ ?>
	<script type='text/javascript'>
		new WOW().init();


	</script>

<?php 
}

add_action('wp_enqueue_scripts', 'wp_it_courses_theme_slider_init_in_footer');
function wp_it_courses_theme_slider_init_in_footer()
{
	add_action('print_footer_scripts', 'wp_it_courses_slider_init');
}
function wp_it_courses_slider_init()
{ ?>

	<script  type='text/javascript'>
		const swiper = new Swiper('.swiper', {
			slidesPerView: 5,
			breakpoints: {
				320: {
					slidesPerView: 1,
				},
				768: {
					slidesPerView: 2,
				},
				1024: {
					slidesPerView: 3,
				},
				1200: {
					slidesPerView: 5,
				},
			},
			// loop: true,

			// Navigation arrows
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			on: {
				init() {
					// ...
				},
			},
		});
	</script>	

<?php }