<?php
/**
 * wp-it-courses WordPress Theme, ordasvit.com
 * wp-it-courses is distributed under the terms of the GNU GPL
  * Copyright: 2023 OrdaSvit, Andrey Kvasnevskiy, ordasvit.com
 */

if (!function_exists('wp_it_courses_posted_on')) {
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 *
	 * @return void
	 */
	function wp_it_courses_posted_on()
	{
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

		$time_string = sprintf(
			$time_string,
			esc_attr(get_the_date(DATE_W3C)),
			esc_html(get_the_date())
		);
		echo '<span class="posted-on">';
		printf(
			/* translators: %s: Publish date. */
			esc_html__('Published %s', 'wp-it-courses'),
			$time_string // phpcs:ignore WordPress.Security.EscapeOutput
		);
		echo '</span>';
	}
}

if (!function_exists('wp_it_courses_posted_by')) {
/**
 * Custom template tags for this theme
 *
 * @package WordPress
 * @subpackage wp_it_courses
 */

	function wp_it_courses_posted_by()
	{
		if (!get_the_author_meta('description') && post_type_supports(get_post_type(), 'author')) {
			echo '<span class="byline">';
			printf(
				/* translators: %s: Author name. */
				esc_html__('By %s', 'wp-it-courses'),
				'<a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '" rel="author">' . esc_html(get_the_author()) . '</a>'
			);
			echo '</span>';
		}
	}
}

if (!function_exists('wp_it_courses_entry_meta_footer')) {
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 * Footer entry meta is displayed differently in archives and single posts.
	 *
	 *
	 * @return void
	 */
	function wp_it_courses_entry_meta_footer()
	{

		// Early exit if not a post.
		if ('post' !== get_post_type()) {
			return;
		}

		// Hide meta information on pages.
		if (!is_single()) {

			if (is_sticky()) {
				echo '<p>' . esc_html_x('Featured post', 'Label for sticky posts', 'wp-it-courses') . '</p>';
			}

			$post_format = get_post_format();
			if ('aside' === $post_format || 'status' === $post_format) {
				echo '<p><a href="' . esc_url(get_permalink()) . '">' . wp_it_courses_continue_reading_text() . '</a></p>'; // phpcs:ignore WordPress.Security.EscapeOutput
			}

			// Posted on.
			wp_it_courses_posted_on();

			// Edit post link.
			edit_post_link(
				sprintf(
					/* translators: %s: Post title. Only visible to screen readers. */
					esc_html__('Edit %s', 'wp-it-courses'),
					'<span class="screen-reader-text">' . get_the_title() . '</span>'
				),
				'<span class="edit-link">',
				'</span><br>'
			);

			if (has_category() || has_tag()) {

				echo '<div class="post-taxonomies">';

				$categories_list = get_the_category_list(wp_get_list_item_separator());
				if ($categories_list) {
					printf(
						/* translators: %s: List of categories. */
						'<span class="cat-links">' . esc_html__('Categorized as %s', 'wp-it-courses') . ' </span>',
						$categories_list // phpcs:ignore WordPress.Security.EscapeOutput
					);
				}

				$tags_list = get_the_tag_list('', wp_get_list_item_separator());
				if ($tags_list) {
					printf(
						/* translators: %s: List of tags. */
						'<span class="tags-links">' . esc_html__('Tagged %s', 'wp-it-courses') . '</span>',
						$tags_list // phpcs:ignore WordPress.Security.EscapeOutput
					);
				}
				echo '</div>';
			}
		} else {

			echo '<div class="posted-by">';
			// Posted on.
			wp_it_courses_posted_on();
			// Posted by.
			wp_it_courses_posted_by();
			// Edit post link.
			edit_post_link(
				sprintf(
					/* translators: %s: Post title. Only visible to screen readers. */
					esc_html__('Edit %s', 'wp-it-courses'),
					'<span class="screen-reader-text">' . get_the_title() . '</span>'
				),
				'<span class="edit-link">',
				'</span>'
			);
			echo '</div>';

			if (has_category() || has_tag()) {

				echo '<div class="post-taxonomies">';

				if (function_exists('wp_get_list_item_separator'))
					$delimiter = wp_get_list_item_separator();
				else
					$delimiter = ', ';

				$categories_list = get_the_category_list($delimiter);
				if ($categories_list) {
					printf(
						/* translators: %s: List of categories. */
						'<span class="cat-links">' . esc_html('Categorized as %s', 'wp-it-courses') . ' </span>',
						$categories_list // phpcs:ignore WordPress.Security.EscapeOutput
					);
				}

				$tags_list = get_the_tag_list('', $delimiter);
				if ($tags_list) {
					printf(
						/* translators: %s: List of tags. */
						'<span class="tags-links">' . esc_html__('Tagged %s', 'wp-it-courses') . '</span>',
						$tags_list // phpcs:ignore WordPress.Security.EscapeOutput
					);
				}
				echo '</div>';
			}
		}
	}
}

if ( ! function_exists( 'wp_it_courses_the_posts_navigation' ) ) {
	function wp_it_courses_the_posts_navigation() {
		the_posts_pagination(
			array(
				'before_page_number' => esc_html__( '', 'wp-it-courses' ) . ' ',
				'mid_size'           => 1,
				'prev_text'          => sprintf(
					'%s <span class="nav-prev-text">%s</span>',
					is_rtl() ? ( '<i class="fas fa-angle-double-right"></i>' ) : ( '<i class="fas fa-angle-double-left"></i>' ),
					wp_kses(
						__( '<span class="nav-short">Prev</span>', 'wp-it-courses' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					)
				),
				'next_text'          => sprintf(
					'<span class="nav-next-text">%s</span> %s',
					wp_kses(
						__( '<span class="nav-short">Next</span>', 'wp-it-courses' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					is_rtl() ? ( '<i class="fas fa-angle-double-left"></i>' ) : ( '<i class="fas fa-angle-double-right"></i>' )
				),
			)
		);
	}
}
