<?php
/**
 * wp-it-courses WordPress Theme, ordasvit.com
 * wp-it-courses is distributed under the terms of the GNU GPL
 * Copyright: 2023 OrdaSvit, Andrey Kvasnevskiy, ordasvit.com
 */
?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>

	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

	<?php wp_head(); ?>

</head>


<body <?php body_class(); ?>>
	<?php
	if ($wp_version >= 5.2)
		wp_body_open();
	?>

	<a href="#wrapper-content" class="skip-to-main-content">skip to main content</a>

	<a class="top_up">
		<i class="fas fa-angle-double-up"></i>
	</a>
	<div class="header">

		<div class="wrapper-container-top-header">
			<div class="container">
				<div class="row">

					<?php
					if (!wp_it_courses_show_position_preview("header_position_top_left", 'col-lg-3 col-sm-12 col-xs-12') && wp_it_courses_is_active_sidebar("header_position_top_left")) { ?>
						<div class="col-lg-9 col-md-12 col-sm-12 col-xs-12">
							<?php if (function_exists('dynamic_sidebar'))
								dynamic_sidebar('header_position_top_left'); ?>
						</div>
					<?php }
					?>

					<div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
						<div class="soc_links">
							<ul>
								<?php if (get_theme_mod("tcx_social_links_facebook")) { ?>
									<li><a target=_blank class="facebook fab fa-facebook"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_facebook")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_twitter")) { ?>
									<li><a target=_blank class="twitter fab fa-twitter"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_twitter")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_skype")) { ?>
									<li><a target=_blank class="skype fab fa-skype"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_skype")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_dribbble")) { ?>
									<li><a target=_blank class="dribbble fab fa-dribbble"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_dribbble")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_vimeo")) { ?>
									<li><a target=_blank class="vimeo fab fa-vimeo-square"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_vimeo")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_flickr")) { ?>
									<li><a target=_blank class="vimeo fab fa-flickr"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_flickr")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_youtube_play")) { ?>
									<li><a target=_blank class="vimeo fab fa-youtube"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_youtube_play")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_instagram")) { ?>
									<li><a target=_blank class="vimeo fab fa-instagram"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_instagram")); ?>'></a>
									</li>
								<?php } ?>
								<?php if (get_theme_mod("tcx_social_links_linkedin")) { ?>
									<li><a target=_blank class="vimeo fab fa-linkedin"
											href='<?php echo sanitize_text_field(get_theme_mod("tcx_social_links_linkedin")); ?>'></a>
									</li>
								<?php } ?>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="wrapper-container-menu">
			<div class="container">
				<div class="row">
					<div class="wrapper-menu col-lg-12 col-md-12 col-sm-12 col-xs-12">

						<div class="row">

							<div class="col-lg-2 col-md-12 col-sm-12 col-xs-12 wrapper-custom-logo-link">
								<?php

								if (function_exists('the_custom_logo')) {
									the_custom_logo();
								}

								?>
							</div>

							<div class="col-lg-8 col-sm-12 col-xs-12">


								<nav id="site-navigation"
									class="navbar navbar-expand-lg bg-body-tertiary main-navigation" role="navigation">
									<div class="container-fluid">
										<button class="navbar-toggler" type="button" data-bs-toggle="collapse"
											data-bs-target="#navbarSupportedContent"
											aria-controls="navbarSupportedContent" aria-expanded="false"
											aria-label="Toggle navigation">
											<span class="navbar-toggler-icon"></span>
										</button>


										<?php
										wp_nav_menu(
											array(
												'theme_location' => 'primary',
												'container' => 'div',
												'container_class' => 'collapse navbar-collapse',
												'container_id' => 'navbarSupportedContent',
												'menu_class' => 'navbar-nav',
												'menu_id' => '',
												'echo' => true,
												'fallback_cb' => 'wp_page_menu',
												'before' => '',
												'after' => '',
												'link_before' => '',
												'link_after' => '',
												'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
												'depth' => 0,
												'walker' => ''
											)
										);
										?>
									</div>
								</nav><!-- #site-navigation -->

							</div>

							<?php
							if (!wp_it_courses_show_position_preview("header_position_cart", 'col-lg-3 col-sm-12 col-xs-12') && wp_it_courses_is_active_sidebar("header_position_cart")) { ?>
								<div class="col-lg-2 col-md-12 col-sm-12 col-xs-12">
									<?php if (function_exists('dynamic_sidebar'))
										dynamic_sidebar('header_position_cart'); ?>
								</div>
							<?php }
							?>
						</div>

					</div>
				</div>
			</div>
		</div>

		<div class="row">

			<?php
			if (!wp_it_courses_show_position_preview("position_left_header", 'col-md-3 col-sm-3 col-xs-12') && wp_it_courses_is_active_sidebar("position_left_header")) { ?>
				<div class="<?php if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_center_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo 'col-md-3 col-sm-3 col-xs-12';
				} else if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_center_left_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_center_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_center_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_center_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_center_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else {
					echo ('col-lg-12');
				} ?>">
					<?php if (function_exists('dynamic_sidebar'))
						dynamic_sidebar('position_left_header'); ?>
				</div>
			<?php }
			; ?>

			<?php
			if (!wp_it_courses_show_position_preview("position_center_left_header", 'col-md-3 col-sm-3 col-xs-12') && wp_it_courses_is_active_sidebar("position_center_left_header")) { ?>
				<div class="<?php if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo 'col-md-3 col-sm-3 col-xs-12';
				} else if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else {
					echo ('col-lg-12');
				} ?>">
					<?php if (function_exists('dynamic_sidebar'))
						dynamic_sidebar('position_center_left_header'); ?>
				</div>
			<?php }
			; ?>

			<?php
			if (!wp_it_courses_show_position_preview("position_center_right_header", 'col-md-3 col-sm-3 col-xs-12') && wp_it_courses_is_active_sidebar("position_center_right_header")) { ?>
				<div class="<?php if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_center_left_header") && wp_it_courses_is_active_sidebar("position_left_header")) {
					echo 'col-md-3 col-sm-3 col-xs-12';
				} else if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_center_left_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") && wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_center_left_header") && wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_center_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_center_left_header") || wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_right_header") || wp_it_courses_is_active_sidebar("position_center_left_header") || wp_it_courses_is_active_sidebar("position_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else {
					echo ('col-lg-12');
				} ?>">
					<?php if (function_exists('dynamic_sidebar'))
						dynamic_sidebar('position_center_right_header'); ?>
				</div>
			<?php }
			; ?>

			<?php
			if (!wp_it_courses_show_position_preview("position_right_header", 'col-md-3 col-sm-3 col-xs-12') && wp_it_courses_is_active_sidebar("position_right_header")) { ?>
				<div class="<?php if (wp_it_courses_is_active_sidebar("position_left_header") && wp_it_courses_is_active_sidebar("position_center_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo 'col-md-3 col-sm-3 col-xs-12';
				} else if (wp_it_courses_is_active_sidebar("position_left_header") && wp_it_courses_is_active_sidebar("position_center_left_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_center_left_header") && wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-4 col-sm-4 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_left_header") || wp_it_courses_is_active_sidebar("position_center_left_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_center_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else if (wp_it_courses_is_active_sidebar("position_left_header") || wp_it_courses_is_active_sidebar("position_center_left_header") || wp_it_courses_is_active_sidebar("position_center_right_header")) {
					echo ('col-md-6 col-sm-6 col-xs-12');
				} else {
					echo ('col-lg-12');
				} ?>">
					<?php if (function_exists('dynamic_sidebar'))
						dynamic_sidebar('position_right_header'); ?>
				</div>
			<?php }
			; ?>

		</div>

	</div>