<?php
/**
   * The template for Content Quote.
   *
   *
   * @package   igor WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * igor is distributed under the terms of the GNU GPL
*/
?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
<div id="post" class="<?php echo esc_attr(get_theme_mod("igor_columns_posts"));?>">
<?php endif; ?>
<article class="content">
    <div class="entry-content">
        <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'igor' ) ); ?>
        <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'igor' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
    </div><!-- .entry-content -->
    <footer class="entry-meta">
        <?php if ( is_single() ) :
        igor_entry_meta();
          else :
          igor_entry_date();
          endif;

         if ( comments_open() && ! is_single() ) : ?>
        <span class="comments-link">
        <i class="fa fa-commenting-o"></i>
            <?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a comment', 'igor' ) . '</span>', __( 'One comment so far', 'igor' ), __( 'View all % comments', 'igor' ) ); ?>
        </span><!-- .comments-link -->
        <?php endif; // comments_open() ?>
        <?php edit_post_link( __( 'Edit', 'igor' ), '<span class="edit-link">', '</span>' ); ?>
    </footer><!-- .entry-meta -->
</article><!-- #post -->
</div>